/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.DeviceImpl;
import com.android.ddmlib.internal.MonitorThread;
import com.android.ddmlib.internal.ProcessorStream;
import com.android.ddmlib.internal.ProfileableClientImpl;
import com.android.server.adb.protos.AppProcessesProto;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class DeviceClientMonitorTask
implements Runnable {
    private final ByteBuffer mBuffer = ByteBuffer.allocate(65536);
    private volatile boolean mQuit;
    private final Selector mSelector;
    private final ConcurrentHashMap<SocketChannel, TrackServiceProcessor> mChannelsToRegister = new ConcurrentHashMap();
    private final Set<ClientImpl> mClientsToReopen = new HashSet<ClientImpl>();

    DeviceClientMonitorTask() throws IOException {
        this.mSelector = Selector.open();
    }

    boolean register(DeviceImpl device) {
        SocketChannel socketChannel;
        try {
            socketChannel = AndroidDebugBridge.openConnection();
        }
        catch (IOException exception) {
            Log.e("DeviceClientMonitorTask", "Unable to open connection to ADB server: " + exception);
            return false;
        }
        if (socketChannel != null) {
            try {
                TrackServiceProcessor processor = DeviceClientMonitorTask.isDeviceVersionAtLeastS(device) ? new TrackAppProcessor(device) : new TrackJdwpProcessor(device);
                boolean result = this.sendDeviceMonitoringRequest(socketChannel, processor);
                if (result) {
                    device.setClientMonitoringSocket(socketChannel);
                    socketChannel.configureBlocking(false);
                    this.mChannelsToRegister.put(socketChannel, processor);
                    this.mSelector.wakeup();
                    return true;
                }
            }
            catch (TimeoutException e11) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Connection Failure when starting to monitor device '" + device + "' : timeout");
            }
            catch (AdbCommandRejectedException e12) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Adb refused to start monitoring device '" + device + "' : " + e12.getMessage());
            }
            catch (IOException e13) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Connection Failure when starting to monitor device '" + device + "' : " + e13.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerClientToDropAndReopen(ClientImpl client) {
        Set<ClientImpl> set = this.mClientsToReopen;
        synchronized (set) {
            Log.d("DeviceClientMonitorTask", "Adding " + client + " to list of client to reopen (" + client.getDebuggerListenPort() + ").");
            this.mClientsToReopen.add(client);
        }
        this.mSelector.wakeup();
    }

    void free(ClientImpl client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDropAndReopenClients() {
        Set<ClientImpl> set = this.mClientsToReopen;
        synchronized (set) {
            MonitorThread monitorThread = MonitorThread.getInstance();
            for (ClientImpl client : this.mClientsToReopen) {
                DeviceImpl device = (DeviceImpl)client.getDevice();
                int pid = client.getClientData().getPid();
                monitorThread.dropClient(client, false);
                Uninterruptibles.sleepUninterruptibly(1L, TimeUnit.SECONDS);
                Log.d("DeviceClientMonitorTask", "Reopening " + client);
                DeviceClientMonitorTask.openClient(device, pid, monitorThread);
                device.update(2);
            }
            this.mClientsToReopen.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelsToRegister() {
        ArrayList<SocketChannel> channels = Collections.list(this.mChannelsToRegister.keys());
        for (SocketChannel channel : channels) {
            try {
                channel.register(this.mSelector, 1, this.mChannelsToRegister.get(channel));
            }
            catch (ClosedChannelException e11) {
                Log.w("DeviceClientMonitorTask", "Cannot register already-closed channel.");
            }
            finally {
                ((ConcurrentHashMap.KeySetView)this.mChannelsToRegister.keySet()).remove(channel);
            }
        }
    }

    void disconnectClient(ClientImpl client) {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (monitorThread != null) {
            monitorThread.dropClient(client, true);
        }
    }

    @Override
    public void run() {
        do {
            int count = 0;
            try {
                count = this.mSelector.select();
            }
            catch (IOException e11) {
                Log.e("DeviceClientMonitorTask", "Connection error while monitoring clients.");
                Log.d("DeviceClientMonitorTask", e11);
                return;
            }
            if (this.mQuit) {
                return;
            }
            this.processChannelsToRegister();
            this.processDropAndReopenClients();
            if (count == 0) continue;
            Set<SelectionKey> keys2 = this.mSelector.selectedKeys();
            Iterator<SelectionKey> iter = keys2.iterator();
            while (iter.hasNext()) {
                Object attachment;
                SelectionKey key = iter.next();
                iter.remove();
                if (!key.isValid() || !key.isReadable() || !((attachment = key.attachment()) instanceof Processor)) continue;
                Processor processor = (Processor)attachment;
                SocketChannel socket = (SocketChannel)key.channel();
                if (socket == null) continue;
                try {
                    this.mBuffer.clear();
                    int read = socket.read(this.mBuffer);
                    if (read == -1) {
                        this.closeProcessor(processor, socket);
                        continue;
                    }
                    this.mBuffer.flip();
                    processor.onBytesReceived(this.mBuffer);
                }
                catch (IOException ioe) {
                    Log.d("DeviceClientMonitorTask", "Error reading incoming data: " + ioe.getMessage());
                    this.closeProcessor(processor, socket);
                }
            }
        } while (!this.mQuit);
        Log.d("DeviceClientMonitorTask", "Exiting loop");
    }

    public void closeProcessor(Processor processor, SocketChannel socket) {
        try (Processor p112 = processor;){
            SocketChannel c11 = socket;
            if (c11 != null) {
                c11.close();
            }
        }
        catch (IOException p112) {
            // empty catch block
        }
        if (processor instanceof TrackServiceProcessor) {
            this.mChannelsToRegister.remove(socket);
            DeviceImpl device = processor.getDevice();
            device.getClientTracker().trackDeviceToDropAndReopen(device);
        }
    }

    public void stop() {
        this.mQuit = true;
        this.mSelector.wakeup();
    }

    private boolean sendDeviceMonitoringRequest(SocketChannel socket, TrackServiceProcessor processor) throws TimeoutException, AdbCommandRejectedException, IOException {
        try {
            AdbHelper.setDevice(socket, processor.getDevice());
            AdbHelper.write(socket, AdbHelper.formAdbRequest(processor.getCommand()));
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(socket, false);
            if (!resp.okay) {
                Log.e("DeviceClientMonitorTask", "adb refused request: " + resp.message);
            }
            return resp.okay;
        }
        catch (TimeoutException e11) {
            Log.e("DeviceClientMonitorTask", "Sending jdwp tracking request timed out!");
            throw e11;
        }
        catch (IOException e12) {
            Log.e("DeviceClientMonitorTask", "Sending jdwp tracking request failed!");
            throw e12;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJdwpClients(DeviceImpl device, Set<Integer> newPids) {
        MonitorThread monitorThread = MonitorThread.getInstance();
        List<ClientImpl> clients = device.getClientList();
        HashMap<Integer, ClientImpl> existingClients = new HashMap<Integer, ClientImpl>();
        List<ClientImpl> list2 = clients;
        synchronized (list2) {
            for (ClientImpl c11 : clients) {
                existingClients.put(c11.getClientData().getPid(), c11);
            }
        }
        HashSet<ClientImpl> clientsToRemove = new HashSet<ClientImpl>();
        for (Integer pid : existingClients.keySet()) {
            if (newPids.contains(pid)) continue;
            clientsToRemove.add((ClientImpl)existingClients.get(pid));
        }
        HashSet<Integer> pidsToAdd = new HashSet<Integer>(newPids);
        pidsToAdd.removeAll(existingClients.keySet());
        monitorThread.dropClients(clientsToRemove, false);
        Iterator iterator2 = pidsToAdd.iterator();
        while (iterator2.hasNext()) {
            int newPid = (Integer)iterator2.next();
            DeviceClientMonitorTask.openClient(device, newPid, monitorThread);
        }
        if (!pidsToAdd.isEmpty() || !clientsToRemove.isEmpty()) {
            AndroidDebugBridge.deviceChanged(device, 2);
        }
    }

    private static void openClient(DeviceImpl device, int pid, MonitorThread monitorThread) {
        SocketChannel clientSocket;
        try {
            clientSocket = DdmPreferences.isJdwpProxyEnabled() ? AdbHelper.createPassThroughConnection(new InetSocketAddress("localhost", DdmPreferences.getJdwpProxyPort()), device.getSerialNumber(), pid) : AdbHelper.createPassThroughConnection(AndroidDebugBridge.getSocketAddress(), device.getSerialNumber(), pid);
            clientSocket.configureBlocking(false);
        }
        catch (UnknownHostException uhe) {
            Log.d("DeviceClientMonitorTask", "Unknown Jdwp pid: " + pid);
            return;
        }
        catch (TimeoutException e11) {
            Log.w("DeviceClientMonitorTask", "Failed to connect to client '" + pid + "': timeout");
            return;
        }
        catch (AdbCommandRejectedException e12) {
            Log.d("DeviceClientMonitorTask", "Adb rejected connection to client '" + pid + "': " + e12.getMessage());
            return;
        }
        catch (IOException ioe) {
            Log.w("DeviceClientMonitorTask", "Failed to connect to client '" + pid + "': " + ioe.getMessage());
            return;
        }
        DeviceClientMonitorTask.createClient(device, pid, clientSocket, monitorThread);
    }

    private static void createClient(DeviceImpl device, int pid, SocketChannel socket, MonitorThread monitorThread) {
        ClientImpl client = new ClientImpl(device, socket, pid);
        if (client.sendHandshake()) {
            try {
                if (AndroidDebugBridge.getClientSupport()) {
                    client.listenForDebugger();
                    String msg = String.format(Locale.US, "Opening a debugger listener at port %1$d for client with pid %2$d", client.getDebuggerListenPort(), pid);
                    Log.d("ddms", msg);
                }
            }
            catch (IOException ioe) {
                client.getClientData().setDebuggerConnectionStatus(ClientData.DebuggerStatus.ERROR);
                Log.e("ddms", "Can't bind to local " + client.getDebuggerListenPort() + " for debugger");
            }
            client.requestAllocationStatus();
        } else {
            Log.e("ddms", "Handshake with " + client + " failed!");
        }
        if (client.isValid()) {
            device.addClient(client);
            monitorThread.addClient(client);
        }
    }

    private static boolean isDeviceVersionAtLeastS(DeviceImpl device) {
        return device.getVersion().getFeatureLevel() >= 31;
    }

    private class TrackAppProcessor
    extends TrackServiceProcessor {
        TrackAppProcessor(DeviceImpl device) {
            super(device);
        }

        @Override
        protected String getCommand() {
            return "track-app";
        }

        @Override
        protected void onMessage(ByteBuffer message2) throws IOException {
            AppProcessesProto.AppProcesses processes;
            try {
                processes = AppProcessesProto.AppProcesses.parseFrom(message2);
            }
            catch (InvalidProtocolBufferException e11) {
                throw new IOException(e11);
            }
            HashSet<Integer> newJdwpPids = new HashSet<Integer>();
            HashMap<Integer, ProfileableClientImpl> newProfileable = new HashMap<Integer, ProfileableClientImpl>();
            for (AppProcessesProto.ProcessEntry process : processes.getProcessList()) {
                if (process.getDebuggable()) {
                    newJdwpPids.add((int)process.getPid());
                }
                if (!process.getProfileable() && !process.getDebuggable()) continue;
                ProfileableClientImpl client = new ProfileableClientImpl((int)process.getPid(), "", process.getArchitecture());
                newProfileable.put((int)process.getPid(), client);
            }
            DeviceClientMonitorTask.this.updateJdwpClients(this.getDevice(), newJdwpPids);
            this.updateProfileableClients(this.getDevice(), newProfileable);
        }

        void updateProfileableClients(DeviceImpl device, Map<Integer, ProfileableClientImpl> currentProfileable) {
            HashMap<Integer, ProfileableClientImpl> previousProfileable = new HashMap<Integer, ProfileableClientImpl>();
            for (ProfileableClientImpl client2 : device.getProfileableClientImpls()) {
                previousProfileable.put(client2.getProfileableClientData().getPid(), client2);
            }
            Sets.SetView<Integer> addPids = Sets.difference(currentProfileable.keySet(), previousProfileable.keySet());
            Sets.SetView removePids = Sets.difference(previousProfileable.keySet(), currentProfileable.keySet());
            if (addPids.isEmpty() && removePids.isEmpty()) {
                return;
            }
            TreeSet<Integer> pidsWithoutNames = Sets.newTreeSet(addPids);
            previousProfileable.forEach((pid, client) -> {
                if (!currentProfileable.containsKey(pid)) {
                    return;
                }
                String name = client.getProfileableClientData().getProcessName();
                if (name != null && !name.isEmpty()) {
                    ((ProfileableClientImpl)currentProfileable.get(pid)).getProfileableClientData().setProcessName(name);
                } else {
                    pidsWithoutNames.add((Integer)pid);
                }
            });
            this.findProcessJdwpNames(device, currentProfileable, pidsWithoutNames);
            device.updateProfileableClientList(Lists.newArrayList(currentProfileable.values()));
            AndroidDebugBridge.deviceChanged(device, 8);
            for (Integer pid2 : pidsWithoutNames) {
                new CmdlineFileProcessor(device, pid2).connect();
            }
        }

        private void findProcessJdwpNames(DeviceImpl device, Map<Integer, ProfileableClientImpl> pidClientMap, Set<Integer> pidsWithoutNames) {
            HashMap<Integer, String> jdwpClientNames = new HashMap<Integer, String>();
            for (Client client : device.getClients()) {
                ClientData clientData = client.getClientData();
                jdwpClientNames.put(clientData.getPid(), clientData.getPackageName());
            }
            for (Integer pid : Sets.newTreeSet(pidsWithoutNames)) {
                String name = (String)jdwpClientNames.get(pid);
                if (name == null || name.isEmpty()) continue;
                pidClientMap.get(pid).getProfileableClientData().setProcessName(name);
                pidsWithoutNames.remove(pid);
            }
        }
    }

    private class TrackJdwpProcessor
    extends TrackServiceProcessor {
        TrackJdwpProcessor(DeviceImpl device) {
            super(device);
        }

        @Override
        protected String getCommand() {
            return "track-jdwp";
        }

        @Override
        protected void onMessage(ByteBuffer message2) throws IOException {
            String[] pids;
            HashSet<Integer> newPids = new HashSet<Integer>();
            String result = new String(message2.array(), message2.position(), message2.remaining(), AdbHelper.DEFAULT_CHARSET);
            for (String pid : pids = result.split("\n")) {
                try {
                    newPids.add(Integer.valueOf(pid));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            DeviceClientMonitorTask.this.updateJdwpClients(this.getDevice(), newPids);
        }
    }

    static abstract class TrackServiceProcessor
    extends Processor {
        private static final int HEADER_SIZE = 4;

        TrackServiceProcessor(DeviceImpl device) {
            super(device);
        }

        @Override
        protected Optional<ByteBuffer> parseMessage() throws IOException {
            int paydloadSize;
            if (this.mStream.size() < 4) {
                return Optional.empty();
            }
            String textSize = new String(this.mStream.buf(), 0, 4, AdbHelper.DEFAULT_CHARSET);
            try {
                paydloadSize = Integer.parseInt(textSize, 16);
            }
            catch (NumberFormatException e11) {
                throw new IOException("Bad message size =" + textSize, e11);
            }
            if (this.mStream.size() < 4 + paydloadSize) {
                return Optional.empty();
            }
            ByteBuffer message2 = ByteBuffer.wrap(this.mStream.buf(), 0, paydloadSize + 4);
            message2.getInt();
            return Optional.of(message2);
        }

        @Override
        SocketChannel getSocket() {
            return this.getDevice().getClientMonitoringSocket();
        }

        protected abstract String getCommand();

        @Override
        public void close() {
        }
    }

    private static abstract class Processor
    implements AutoCloseable {
        ProcessorStream mStream;
        final DeviceImpl mDevice;

        Processor(DeviceImpl device) {
            this.mDevice = device;
            this.mStream = new ProcessorStream();
        }

        public void onBytesReceived(ByteBuffer buffer) throws IOException {
            this.mStream.append(buffer);
            Optional<ByteBuffer> message2 = this.parseMessage();
            while (message2.isPresent()) {
                this.onMessage(message2.get());
                this.mStream.consume(message2.get().limit());
                message2 = this.parseMessage();
            }
        }

        protected abstract Optional<ByteBuffer> parseMessage() throws IOException;

        protected abstract void onMessage(ByteBuffer var1) throws IOException;

        DeviceImpl getDevice() {
            return this.mDevice;
        }

        abstract SocketChannel getSocket();

        @Override
        public abstract void close() throws IOException;
    }

    private class CmdlineFileProcessor
    extends Processor {
        private boolean messageReceived;
        private final int mPid;
        private int mRetryCount;
        SocketChannel mSocket;
        boolean mSocketConnected;

        CmdlineFileProcessor(DeviceImpl device, int pid) {
            this(device, pid, 5);
        }

        CmdlineFileProcessor(DeviceImpl device, int pid, int retryCount) {
            super(device);
            this.messageReceived = false;
            this.mSocketConnected = true;
            this.mPid = pid;
            this.mRetryCount = retryCount;
        }

        @Override
        protected Optional<ByteBuffer> parseMessage() {
            if (this.mSocketConnected || this.messageReceived) {
                return Optional.empty();
            }
            this.messageReceived = true;
            return Optional.of(ByteBuffer.wrap(this.mStream.buf(), 0, this.mStream.size()));
        }

        void connect() {
            if (this.mRetryCount <= 0) {
                Log.w("DeviceClientMonitorTask", "Unexpected cmdline file for PID " + this.mPid);
                return;
            }
            String[] parameters = new String[]{"/proc/" + this.mPid + "/cmdline"};
            try {
                this.mSocket = this.getDevice().rawExec("cat", parameters);
            }
            catch (AdbCommandRejectedException | TimeoutException | IOException exception) {
                // empty catch block
            }
            try {
                this.mSocket.register(DeviceClientMonitorTask.this.mSelector, 1, this);
            }
            catch (ClosedChannelException e11) {
                Log.w("DeviceClientMonitorTask", "Cannot register already-closed channel to read the name for PID " + this.mPid);
            }
        }

        @Override
        SocketChannel getSocket() {
            return this.mSocket;
        }

        @Override
        protected void onMessage(ByteBuffer message2) throws IOException {
            String name = new String(message2.array(), message2.position(), message2.remaining(), AdbHelper.DEFAULT_CHARSET);
            message2.position(message2.remaining());
            name = name.trim();
            if (name.isEmpty()) {
                return;
            }
            if (name.equals("<pre-initialized>")) {
                new CmdlineFileProcessor(this.getDevice(), this.mPid, --this.mRetryCount).connect();
                return;
            }
            if (name.contains("No such file or directory")) {
                return;
            }
            this.getDevice().updateProfileableClientName(this.mPid, name);
            AndroidDebugBridge.deviceChanged(this.getDevice(), 8);
        }

        @Override
        public void close() throws IOException {
            this.mSocketConnected = false;
            this.onBytesReceived(ByteBuffer.wrap(new byte[0]));
        }
    }
}

