/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.androidtools.P7ZipCommand;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.io.Aapt2ResourceConverter;
import com.android.tools.build.bundletool.io.ApkDescriptionHelper;
import com.android.tools.build.bundletool.io.ApkSerializer;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.ApkSerializerModule;
import com.android.tools.build.bundletool.io.ApkSigner;
import com.android.tools.build.bundletool.io.CacheablePathMatcher;
import com.android.tools.build.bundletool.io.ConcurrencyUtils;
import com.android.tools.build.bundletool.io.ModuleEntriesPack;
import com.android.tools.build.bundletool.io.ModuleEntriesPacker;
import com.android.tools.build.bundletool.io.SerializationFilesManager;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.Zipper;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.PathMatcher;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.zipflinger.Entry;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class ModuleSplitSerializer
extends ApkSerializer {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final Pattern NATIVE_LIBRARIES_PATTERN = Pattern.compile("lib/[^/]+/[^/]+\\.so");
    private final Aapt2ResourceConverter aapt2ResourceConverter;
    private final ApkSigner apkSigner;
    private final CacheablePathMatcher uncompressedPathMatchers;
    private final Version bundletoolVersion;
    private final ListeningExecutorService executorService;
    private final boolean use7ZipCompression;
    private final Optional<P7ZipCommand> p7ZipCommand;
    private final int nativeLibraryAlignment;

    @Inject
    ModuleSplitSerializer(Optional<ApkListener> apkListener, @BuildApksModule.VerboseLogs boolean verbose, Aapt2ResourceConverter aapt2ResourceConverterFactory, ApkSigner apkSigner, Config.BundleConfig bundleConfig, Version bundletoolVersion, ListeningExecutorService executorService, Optional<P7ZipCommand> p7ZipCommand, @ApkSerializerModule.NativeLibrariesAlignmentInBytes int nativeLibrariesAlignment) {
        super(apkListener, verbose);
        this.aapt2ResourceConverter = aapt2ResourceConverterFactory;
        this.apkSigner = apkSigner;
        this.uncompressedPathMatchers = new CacheablePathMatcher(bundleConfig.getCompression().getUncompressedGlobList().stream().map(PathMatcher::createFromGlob).collect(ImmutableList.toImmutableList()));
        this.use7ZipCompression = bundleConfig.getCompression().getApkCompressionAlgorithm().equals(Config.Compression.ApkCompressionAlgorithm.P7ZIP);
        this.bundletoolVersion = bundletoolVersion;
        this.executorService = executorService;
        this.p7ZipCommand = p7ZipCommand;
        this.nativeLibraryAlignment = nativeLibrariesAlignment;
    }

    @Override
    public ImmutableMap<ZipPath, Commands.ApkDescription> serialize(Path outputDirectory, ImmutableMap<ZipPath, ModuleSplit> splitsByRelativePath) {
        ImmutableMap<ZipPath, Commands.ApkDescription> immutableMap;
        ImmutableList<ModuleSplit> preparedSplits = splitsByRelativePath.values().stream().map(this.apkSigner::signEmbeddedApks).map(ModuleSplitSerializer::injectManifestAndResourceTableAsEntries).collect(ImmutableList.toImmutableList());
        SerializationFilesManager filesManager = new SerializationFilesManager();
        try {
            ImmutableList<ModuleSplit> binarySplits = this.aapt2ResourceConverter.convert(preparedSplits, filesManager).stream().map(this::applyUncompressedGlobsAndUncompressedNativeLibraries).collect(ImmutableList.toImmutableList());
            ModuleEntriesPack maybeCompressedEntriesPack = this.buildCompressedEntriesPack(filesManager, binarySplits);
            ModuleEntriesPack uncompressedEntriesPack = this.buildUncompressedEntriesPack(filesManager.getUncompressedEntriesPackPath(), binarySplits, maybeCompressedEntriesPack);
            filesManager.closeAndRemoveBinaryApks();
            ModuleEntriesPack allEntriesPack = maybeCompressedEntriesPack.mergeWith(uncompressedEntriesPack);
            ImmutableList apkDescriptions = Streams.zip(splitsByRelativePath.keySet().stream(), binarySplits.stream(), (relativePath, split) -> this.executorService.submit(() -> this.serializeAndSignSplit(outputDirectory, (ZipPath)relativePath, (ModuleSplit)split, allEntriesPack, uncompressedEntriesPack))).collect(ImmutableList.toImmutableList());
            immutableMap = ConcurrencyUtils.waitForAll(apkDescriptions).stream().collect(ImmutableMap.toImmutableMap(apk -> ZipPath.create(apk.getPath()), Function.identity()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    filesManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e11) {
                throw new UncheckedIOException(e11);
            }
        }
        filesManager.close();
        return immutableMap;
    }

    private ModuleEntriesPack buildCompressedEntriesPack(SerializationFilesManager filesManager, Collection<ModuleSplit> splits) {
        return this.use7ZipCompression ? this.build7ZipCompressedEntriesPack(filesManager, splits) : this.buildDeflateCompressedEntriesPack(filesManager, splits);
    }

    private ModuleEntriesPack build7ZipCompressedEntriesPack(SerializationFilesManager filesManager, Collection<ModuleSplit> splits) {
        Preconditions.checkState(this.p7ZipCommand.isPresent(), "'p7ZipCommand' is required when 7zip compression is used.");
        ModuleEntriesPacker entriesPacker = new ModuleEntriesPacker(filesManager.getCompressedEntriesPackPath(), "c_");
        splits.stream().flatMap(split -> split.getEntries().stream()).filter(entry -> !entry.getForceUncompressed()).forEach(entriesPacker::add);
        try (TempDirectory tempDirectory = new TempDirectory();){
            ModuleEntriesPack moduleEntriesPack = entriesPacker.pack(Zipper.compressedZip(this.p7ZipCommand.get(), tempDirectory.getPath()));
            return moduleEntriesPack;
        }
    }

    private ModuleEntriesPack buildDeflateCompressedEntriesPack(SerializationFilesManager filesManager, Collection<ModuleSplit> splits) {
        ModuleEntriesPacker otherEntriesPacker = new ModuleEntriesPacker(filesManager.getCompressedEntriesPackPath(), "c_");
        ModuleEntriesPacker resourceEntriesPacker = new ModuleEntriesPacker(filesManager.getCompressedResourceEntriesPackPath(), "r_");
        splits.stream().flatMap(split -> split.getEntries().stream()).filter(entry -> !entry.getForceUncompressed()).forEach(entry -> {
            if (ApkSerializerHelper.requiresAapt2Conversion(ApkSerializerHelper.toApkEntryPath(entry.getPath()))) {
                resourceEntriesPacker.add((ModuleEntry)entry);
            } else {
                otherEntriesPacker.add((ModuleEntry)entry);
            }
        });
        ModuleEntriesPack resourceEntriesPack = resourceEntriesPacker.pack(Zipper.compressedZip(this.executorService, 9));
        ModuleEntriesPack otherEntriesPack = otherEntriesPacker.pack(Zipper.compressedZip(this.executorService, -1));
        return resourceEntriesPack.mergeWith(otherEntriesPack);
    }

    private ModuleEntriesPack buildUncompressedEntriesPack(Path outputPath, Collection<ModuleSplit> splits, ModuleEntriesPack compressedPack) {
        ModuleEntriesPacker entriesPacker = new ModuleEntriesPacker(outputPath, "u_");
        splits.stream().flatMap(split -> split.getEntries().stream()).filter(entry -> entry.getForceUncompressed() || this.shouldUncompressBecauseOfLowRatio((ModuleEntry)entry, compressedPack)).forEach(entriesPacker::add);
        return entriesPacker.pack(Zipper.uncompressedZip());
    }

    private Commands.ApkDescription serializeAndSignSplit(Path outputDirectory, ZipPath apkRelativePath, ModuleSplit split, ModuleEntriesPack allEntriesPack, ModuleEntriesPack uncompressedEntriesPack) {
        Path outputPath = outputDirectory.resolve(apkRelativePath.toString());
        this.serializeSplit(outputPath, split, allEntriesPack, uncompressedEntriesPack);
        Optional<Commands.SigningDescription> signingDescription = this.apkSigner.signApk(outputPath, split);
        Commands.ApkDescription apkDescription = ApkDescriptionHelper.createApkDescription(apkRelativePath, split, signingDescription);
        this.notifyApkSerialized(apkDescription, split.getSplitType());
        return apkDescription;
    }

    private void serializeSplit(Path outputPath, ModuleSplit split, ModuleEntriesPack allEntriesPack, ModuleEntriesPack uncompressedEntriesPack) {
        FileUtils.createDirectories(outputPath.getParent());
        try (ZipArchive archive = new ZipArchive(outputPath);){
            ImmutableMap<ZipPath, ModuleEntry> moduleEntriesByName = split.getEntries().stream().collect(ImmutableMap.toImmutableMap(entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath()), entry -> entry, (a11, b11) -> b11));
            ImmutableList<ModuleEntry> sortedEntries = ImmutableList.sortedCopyOf(Comparator.comparing(e11 -> ApkSerializerHelper.toApkEntryPath(e11.getPath())), moduleEntriesByName.values());
            ZipSource zipSource = allEntriesPack.select(sortedEntries, entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath(), true).toString(), entry -> this.alignmentForEntry((ModuleEntry)entry, uncompressedEntriesPack));
            archive.add(zipSource);
        }
        catch (IOException e12) {
            throw new UncheckedIOException(e12);
        }
    }

    private long alignmentForEntry(ModuleEntry entry, ModuleEntriesPack uncompressedEntriesPack) {
        if (!uncompressedEntriesPack.hasEntry(entry)) {
            return 0L;
        }
        return entry.getPath().toString().endsWith(NATIVE_LIBRARIES_SUFFIX) ? (long)this.nativeLibraryAlignment : 4L;
    }

    private static ModuleSplit injectManifestAndResourceTableAsEntries(ModuleSplit split) {
        ImmutableList.Builder splitEntries = ImmutableList.builder();
        splitEntries.add(ModuleEntry.builder().setForceUncompressed(false).setContent(ByteSource.wrap(split.getAndroidManifest().getManifestRoot().getProto().toByteArray())).setPath(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()).build());
        if (split.getResourceTable().isPresent()) {
            splitEntries.add(ModuleEntry.builder().setForceUncompressed(true).setContent(ByteSource.wrap(split.getResourceTable().get().toByteArray())).setPath(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()).build());
        }
        split.getEntries().stream().filter(entry -> !BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath().equals(entry.getPath())).filter(entry -> !BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath().equals(entry.getPath())).forEach(splitEntries::add);
        return split.toBuilder().setEntries((List<ModuleEntry>)((Object)splitEntries.build())).build();
    }

    private ModuleSplit applyUncompressedGlobsAndUncompressedNativeLibraries(ModuleSplit split) {
        boolean uncompressNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true) == false;
        return split.toBuilder().setEntries(split.getEntries().stream().map(entry -> this.shouldUncompressEntry((ModuleEntry)entry, uncompressNativeLibs) ? entry.toBuilder().setForceUncompressed(true).build() : entry).collect(ImmutableList.toImmutableList())).build();
    }

    private boolean shouldUncompressEntry(ModuleEntry entry, boolean uncompressNativeLibs) {
        if (entry.getForceUncompressed()) {
            return false;
        }
        return this.matchesForceUncompressedPath(entry) || this.matchesUncompressedNativeLib(entry, uncompressNativeLibs);
    }

    private boolean matchesUncompressedNativeLib(ModuleEntry entry, boolean uncompressNativeLibs) {
        return uncompressNativeLibs && NATIVE_LIBRARIES_PATTERN.matcher(entry.getPath().toString()).matches();
    }

    private boolean matchesForceUncompressedPath(ModuleEntry entry) {
        if (entry.getPath().equals(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath())) {
            return false;
        }
        String path = ApkSerializerHelper.toApkEntryPath(entry.getPath()).toString();
        if (this.uncompressedPathMatchers.matches(path)) {
            return true;
        }
        return !VersionGuardedFeature.NO_DEFAULT_UNCOMPRESS_EXTENSIONS.enabledForVersion(this.bundletoolVersion) && ApkSerializerHelper.NO_COMPRESSION_EXTENSIONS.contains(FileUtils.getFileExtension(ZipPath.create(path)));
    }

    private boolean shouldUncompressBecauseOfLowRatio(ModuleEntry moduleEntry, ModuleEntriesPack compressedPack) {
        Entry entry = compressedPack.getZipEntry(moduleEntry);
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getUncompressedSize();
        if (moduleEntry.getPath().startsWith("res")) {
            return uncompressedSize == 0L || compressedSize + compressedSize / 10L > uncompressedSize;
        }
        return compressedSize >= uncompressedSize;
    }
}

