/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\b\u0006\u001a.\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a:\u0010\u0005\u001a\u00020\f\"\u0004\b\u0000\u0010\u00072\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u001a\u0010\u0019\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a#\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0016\"\u00020\u0006\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u0012\u0010 \u001a\u00020\u0006*\u00020\u00062\u0006\u0010!\u001a\u00020\u0006\u001a\u0010\u0010\u0005\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060\"\u001a\n\u0010#\u001a\u00020\u0006*\u00020\u0006\u001a\u0010\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\n\u0010&\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010'\u001a\u00020\u0006*\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"CR", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "LF", "Ljava/util/regex/Pattern;", "combineAsCamelCase", "", "T", "objectList", "", "mapFunction", "Lkotlin/Function1;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toLineSeparator", "separator", "input", "toStrings", "", "objects", "", "", "([Ljava/lang/Object;)Ljava/util/List;", "appendCamelCase", "word", "appendCapitalized", "words", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "word1", "word2", "capitalizeAndAppend", "suffix", "", "toSystemLineSeparator", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "usLocaleCapitalize", "usLocaleDecapitalize", "common"})
@JvmName(name="StringHelper")
public final class StringHelper {
    private static final CharMatcher CR = CharMatcher.is('\r');
    private static final Pattern LF = Pattern.compile("\n", 16);

    @NotNull
    public static final StringBuilder appendCapitalized(@NotNull StringBuilder $this$appendCapitalized, @NotNull String word) {
        Intrinsics.checkNotNullParameter($this$appendCapitalized, "<this>");
        Intrinsics.checkNotNullParameter(word, "word");
        if (((CharSequence)word).length() == 0) {
            return $this$appendCapitalized;
        }
        int c11 = word.charAt(0);
        if (c11 >= 55296 && c11 <= 56319) {
            c11 = word.codePointAt(0);
            int charCount = Character.charCount(c11);
            String string = word.substring(0, charCount);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue(locale, "US");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            String upperString = string3;
            $this$appendCapitalized.append(upperString);
            $this$appendCapitalized.append(word, charCount, word.length());
        } else {
            char c12;
            int result = Character.toUpperCase(c11);
            char upperChar = '\u0000';
            if (result != -1) {
                c12 = (char)result;
            } else {
                String string = word.substring(0, 1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                String string4 = string;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                String string5 = string4.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string5, "toUpperCase(...)");
                c12 = string5.charAt(0);
            }
            upperChar = c12;
            $this$appendCapitalized.append(upperChar);
            $this$appendCapitalized.append(word, 1, word.length());
        }
        return $this$appendCapitalized;
    }

    @NotNull
    public static final String usLocaleCapitalize(@NotNull String $this$usLocaleCapitalize) {
        Intrinsics.checkNotNullParameter($this$usLocaleCapitalize, "<this>");
        StringBuilder sb2 = new StringBuilder($this$usLocaleCapitalize.length());
        StringHelper.appendCapitalized(sb2, $this$usLocaleCapitalize);
        String string = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String usLocaleDecapitalize(@NotNull String $this$usLocaleDecapitalize) {
        Intrinsics.checkNotNullParameter($this$usLocaleDecapitalize, "<this>");
        if (((CharSequence)$this$usLocaleDecapitalize).length() == 0) {
            return $this$usLocaleDecapitalize;
        }
        StringBuilder sb2 = new StringBuilder($this$usLocaleDecapitalize.length());
        String string = $this$usLocaleDecapitalize.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String string2 = string;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue(locale, "US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        sb2.append(string3);
        String string4 = $this$usLocaleDecapitalize.substring(1);
        Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        sb2.append(string4);
        String string5 = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "sb.toString()");
        return string5;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, @NotNull String word) {
        Intrinsics.checkNotNullParameter($this$appendCapitalized, "<this>");
        Intrinsics.checkNotNullParameter(word, "word");
        StringBuilder sb2 = new StringBuilder($this$appendCapitalized.length() + word.length());
        sb2.append($this$appendCapitalized);
        StringHelper.appendCapitalized(sb2, word);
        String string = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, @NotNull String word1, @NotNull String word2) {
        Intrinsics.checkNotNullParameter($this$appendCapitalized, "<this>");
        Intrinsics.checkNotNullParameter(word1, "word1");
        Intrinsics.checkNotNullParameter(word2, "word2");
        StringBuilder sb2 = new StringBuilder($this$appendCapitalized.length() + word1.length() + word2.length());
        sb2.append($this$appendCapitalized);
        StringHelper.appendCapitalized(sb2, word1);
        StringHelper.appendCapitalized(sb2, word2);
        String string = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, String ... words) {
        Intrinsics.checkNotNullParameter($this$appendCapitalized, "<this>");
        Intrinsics.checkNotNullParameter(words, "words");
        int length = $this$appendCapitalized.length();
        int max = words.length;
        for (int i11 = 0; i11 < max; ++i11) {
            length += words[i11].length();
        }
        StringBuilder sb2 = new StringBuilder(length);
        sb2.append($this$appendCapitalized);
        for (String word : words) {
            StringHelper.appendCapitalized(sb2, word);
        }
        String string = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String capitalizeAndAppend(@NotNull String $this$capitalizeAndAppend, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter($this$capitalizeAndAppend, "<this>");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        StringBuilder sb2 = new StringBuilder($this$capitalizeAndAppend.length() + suffix.length());
        StringHelper.appendCapitalized(sb2, $this$capitalizeAndAppend);
        sb2.append(suffix);
        String string = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final StringBuilder appendCamelCase(@NotNull StringBuilder $this$appendCamelCase, @NotNull String word) {
        Intrinsics.checkNotNullParameter($this$appendCamelCase, "<this>");
        Intrinsics.checkNotNullParameter(word, "word");
        if (((CharSequence)$this$appendCamelCase).length() == 0) {
            $this$appendCamelCase.append(word);
        } else {
            StringHelper.appendCapitalized($this$appendCamelCase, word);
        }
        return $this$appendCamelCase;
    }

    @NotNull
    public static final String combineAsCamelCase(@NotNull Iterable<String> $this$combineAsCamelCase) {
        Intrinsics.checkNotNullParameter($this$combineAsCamelCase, "<this>");
        int count = 0;
        for (String s11 : $this$combineAsCamelCase) {
            count += s11.length();
        }
        StringBuilder sb2 = new StringBuilder(count);
        boolean first = true;
        for (String str : $this$combineAsCamelCase) {
            if (first) {
                sb2.append(str);
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb2, str);
        }
        String string = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final <T> String combineAsCamelCase(@NotNull Collection<? extends T> objectList, @NotNull Function1<? super T, String> mapFunction) {
        Intrinsics.checkNotNullParameter(objectList, "objectList");
        Intrinsics.checkNotNullParameter(mapFunction, "mapFunction");
        StringBuilder sb2 = new StringBuilder(objectList.size() * 20);
        StringHelper.combineAsCamelCase(sb2, objectList, mapFunction);
        String string = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    public static final <T> void combineAsCamelCase(@NotNull StringBuilder sb2, @NotNull Collection<? extends T> objectList, @NotNull Function1<? super T, String> mapFunction) {
        Intrinsics.checkNotNullParameter(sb2, "sb");
        Intrinsics.checkNotNullParameter(objectList, "objectList");
        Intrinsics.checkNotNullParameter(mapFunction, "mapFunction");
        boolean first = true;
        for (T obj : objectList) {
            if (first) {
                sb2.append(mapFunction.invoke(obj));
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb2, mapFunction.invoke(obj));
        }
    }

    @NotNull
    public static final List<String> toStrings(Object ... objects) {
        Intrinsics.checkNotNullParameter(objects, "objects");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object path : objects) {
            if (path instanceof String) {
                builder.add(path);
                continue;
            }
            if (path instanceof Collection) {
                for (Object item : (Collection)path) {
                    if (item instanceof String) {
                        builder.add(item);
                        continue;
                    }
                    builder.add(path.toString());
                }
                continue;
            }
            builder.add(path.toString());
        }
        ImmutableCollection immutableCollection = builder.build();
        Intrinsics.checkNotNullExpressionValue(immutableCollection, "builder.build()");
        return (List)((Object)immutableCollection);
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String $this$tokenizeCommandLineToEscaped) {
        Intrinsics.checkNotNullParameter($this$tokenizeCommandLineToEscaped, "<this>");
        return new TokenizedCommandLine($this$tokenizeCommandLineToEscaped, false, 0, null, 12, null).toTokenList();
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String $this$tokenizeCommandLineToRaw) {
        Intrinsics.checkNotNullParameter($this$tokenizeCommandLineToRaw, "<this>");
        return new TokenizedCommandLine($this$tokenizeCommandLineToRaw, true, 0, null, 12, null).toTokenList();
    }

    @NotNull
    public static final String toSystemLineSeparator(@NotNull String $this$toSystemLineSeparator) {
        Intrinsics.checkNotNullParameter($this$toSystemLineSeparator, "<this>");
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "lineSeparator()");
        return StringHelper.toLineSeparator(string, $this$toSystemLineSeparator);
    }

    private static final String toLineSeparator(String separator, String input) {
        String string;
        String unixStyle;
        String string2 = unixStyle = CR.matchesAnyOf(input) ? CR.removeFrom(input) : input;
        if (Intrinsics.areEqual(separator, "\n")) {
            Intrinsics.checkNotNullExpressionValue(unixStyle, "unixStyle");
            string = unixStyle;
        } else {
            String string3 = LF.matcher(unixStyle).replaceAll("\r\n");
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "LF.matcher(unixStyle).replaceAll(\"\\r\\n\")");
        }
        return string;
    }
}

