/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable;

import com.android.tools.smali.dexlib2.HiddenApiRestriction;
import com.android.tools.smali.dexlib2.base.reference.BaseMethodReference;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.MethodParameter;
import com.android.tools.smali.dexlib2.immutable.ImmutableAnnotation;
import com.android.tools.smali.dexlib2.immutable.ImmutableMethodImplementation;
import com.android.tools.smali.dexlib2.immutable.ImmutableMethodParameter;
import com.android.tools.smali.util.CollectionUtils;
import com.android.tools.smali.util.ImmutableConverter;
import com.android.tools.smali.util.ImmutableUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableMethod
extends BaseMethodReference
implements Method {
    @Nonnull
    protected final String definingClass;
    @Nonnull
    protected final String name;
    @Nonnull
    protected final List<? extends ImmutableMethodParameter> parameters;
    @Nonnull
    protected final String returnType;
    protected final int accessFlags;
    @Nonnull
    protected final Set<? extends ImmutableAnnotation> annotations;
    @Nonnull
    protected final Set<HiddenApiRestriction> hiddenApiRestrictions;
    @Nullable
    protected final ImmutableMethodImplementation methodImplementation;
    private static final ImmutableConverter<ImmutableMethod, Method> CONVERTER = new ImmutableConverter<ImmutableMethod, Method>(){

        @Override
        protected boolean isImmutable(@Nonnull Method item) {
            return item instanceof ImmutableMethod;
        }

        @Override
        @Nonnull
        protected ImmutableMethod makeImmutable(@Nonnull Method item) {
            return ImmutableMethod.of(item);
        }
    };

    public ImmutableMethod(@Nonnull String definingClass, @Nonnull String name, @Nullable Iterable<? extends MethodParameter> parameters, @Nonnull String returnType, int accessFlags, @Nullable Set<? extends Annotation> annotations, @Nullable Set<HiddenApiRestriction> hiddenApiRestrictions, @Nullable MethodImplementation methodImplementation) {
        this.definingClass = definingClass;
        this.name = name;
        this.parameters = ImmutableMethodParameter.immutableListOf(parameters);
        this.returnType = returnType;
        this.accessFlags = accessFlags;
        this.annotations = ImmutableAnnotation.immutableSetOf(annotations);
        this.hiddenApiRestrictions = hiddenApiRestrictions == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<HiddenApiRestriction>(hiddenApiRestrictions));
        this.methodImplementation = ImmutableMethodImplementation.of(methodImplementation);
    }

    public ImmutableMethod(@Nonnull String definingClass, @Nonnull String name, @Nullable List<? extends ImmutableMethodParameter> parameters, @Nonnull String returnType, int accessFlags, @Nullable Set<? extends ImmutableAnnotation> annotations, @Nullable Set<HiddenApiRestriction> hiddenApiRestrictions, @Nullable ImmutableMethodImplementation methodImplementation) {
        this.definingClass = definingClass;
        this.name = name;
        this.parameters = ImmutableUtils.nullToEmptyList(parameters);
        this.returnType = returnType;
        this.accessFlags = accessFlags;
        this.annotations = ImmutableUtils.nullToEmptySet(annotations);
        this.hiddenApiRestrictions = ImmutableUtils.nullToEmptySet(hiddenApiRestrictions);
        this.methodImplementation = methodImplementation;
    }

    public static ImmutableMethod of(Method method) {
        if (method instanceof ImmutableMethod) {
            return (ImmutableMethod)method;
        }
        return new ImmutableMethod(method.getDefiningClass(), method.getName(), method.getParameters(), method.getReturnType(), method.getAccessFlags(), method.getAnnotations(), method.getHiddenApiRestrictions(), method.getImplementation());
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        return this.definingClass;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public List<? extends CharSequence> getParameterTypes() {
        return this.parameters;
    }

    @Nonnull
    public List<? extends ImmutableMethodParameter> getParameters() {
        return this.parameters;
    }

    @Override
    @Nonnull
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Nonnull
    public Set<? extends ImmutableAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nonnull
    public Set<HiddenApiRestriction> getHiddenApiRestrictions() {
        return this.hiddenApiRestrictions;
    }

    @Override
    @Nullable
    public ImmutableMethodImplementation getImplementation() {
        return this.methodImplementation;
    }

    @Nonnull
    public static SortedSet<ImmutableMethod> immutableSetOf(@Nullable Iterable<? extends Method> list) {
        return CONVERTER.toSortedSet(CollectionUtils.naturalOrdering(), list);
    }
}

