#ifndef LIB_PAKETTO
#define LIB_PAKETTO

/* --- Prevent glibc <netinet/in.h> vs kernel <linux/in.h> conflicts --- */
#include <netinet/in.h>
#define _LINUX_IN_H
#define _LINUX_IN6_H
/* -------------------------------------------------------------------- */

#include "config.h"

#include <arpa/inet.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

#include <pthread.h>
#include <pcap.h>
#include <pcap/pcap.h>
#include <libnet.h>
#include <libnet/libnet-headers.h>
#include <libnetfilter_queue/libnetfilter_queue.h>
#include <linux/netfilter.h>
#include <netdb.h>

/* ---- libnet 1.2+/1.3 compatibility shims ---- */
#ifndef LIBNET_IP_H
#define LIBNET_IP_H LIBNET_IPV4_H
#endif

#ifndef LIBNET_ICMP_H
#define LIBNET_ICMP_H LIBNET_ICMPV4_H
#endif

#ifndef LIBNET_ARP_H
#define LIBNET_ARP_H LIBNET_ARP_H /* usually already exists; keep if needed */
#endif

#include <tomcrypt.h>
#include <ght_hash_table.h>

#include "pk_scan.h"
#include "base64.h"

#if defined(WIN32) && !defined(__MINGW32__) && 1
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

/* UNIX ONLY INCLUDES */
#ifndef WIN32

#ifdef HAVE_SYS_SOCKIO_H
#include <sys/sockio.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <netinet/in.h>
#include <netinet/tcp.h>

#include <unistd.h>   /* usleep */
#include <sys/ioctl.h> /* ioctl */

#define MX_B 8192
#define HEX_WIDTH 76
#define TCPDUMP_MAGIC 0xa1b2c3d4
#define PATCHED_TCPDUMP_MAGIC 0xa1b2cd34

#ifndef IPV4_ADDR_LEN
#define IPV4_ADDR_LEN 4
#endif

#ifndef MAGIC
#define MAGIC 12341212
#endif

#endif /* !WIN32 */

#ifndef MX_B
#define MX_B 8192
#endif

#ifndef LIBNET_DNS_H
#define LIBNET_DNS_H 12
#endif

/* Global error buffer used in a couple of places */
extern char global_error[MX_B];

struct pk_dns_hdr {
    uint16_t id;
    uint16_t flags;
    uint16_t num_q;
    uint16_t num_answ_rr;
    uint16_t num_auth_rr;
    uint16_t num_addi_rr;
} __attribute__((packed));

struct pk_ipopt
{
    unsigned char type;
    struct {
        unsigned char length;
        unsigned char pointer;
#if (LIBNET_LIL_ENDIAN)
        unsigned char overflow:4, flag:4;
#endif
#if (LIBNET_BIG_ENDIAN)
        unsigned char flag:4, overflow:4;
#endif
        unsigned int data[8];
    };
} __attribute__ ((packed));

struct frame
{
    struct libnet_ethernet_hdr *eth;
    struct libnet_ipv4_hdr       *ip;
    struct pk_ipopt            *ipopt;
    struct libnet_tcp_hdr      *tcp;
    struct libnet_arp_hdr      *arp;
    struct libnet_icmpv4_hdr      *icmp;
    struct libnet_udp_hdr      *udp;
    struct libnet_dnsv4_hdr *dns;

    char   *packet;
    int     len;
    int     caplen;
    struct timeval ts;
    int     forcelen;
    int     l2_offset;
} __attribute__ ((packed));

struct link
{
    char dev[MX_B];
    char tracefile[MX_B];
    char error[MX_B];

    int self_malloc;
    int flag;

    /* PCAP SNIFFER COMPONENTS */
    pcap_t *pcap;
    u_char *packet;
    struct pcap_pkthdr pkthdr;
    struct bpf_program fp;
    char pfprogram[MX_B];
    char pfprogram_loaded[MX_B];
    pcap_dumper_t *dump;
    int datalink;

    /* LIBNET SPOOFER COMPONENTS (modern libnet context API) */
    char buf[2048];

    libnet_t *ln_l2;  /* LIBNET_LINK context */
    libnet_t *ln_l3;  /* LIBNET_RAW4 context */

    int auto_checksums;
    int auto_frame;
    struct frame x;

    /* RATE LIMIT COMPONENTS */
    int sleepcount;
    int packetsleep;
    int sleepinterval;
    char bandwidth[MX_B];
    struct timeval bench_pre, bench_post;
};

struct session_key {
    struct in_addr ip_src;
    struct in_addr ip_dst;
    unsigned int th_sport;
    unsigned int th_dport;
};

struct session_state {
    unsigned int th_seq_isn;
    unsigned int th_ack_isn;
    unsigned int th_seq_max;
    unsigned int th_ack_max;
    struct timeval last_seen;
    struct timeval then;
    struct timeval start;
    struct timeval last_monitor;
    unsigned int counter_in;
    unsigned int counter_out;
    struct session_key key;
};

struct pk_ackmon_state
{
    ght_hash_table_t *session_table;
    struct timeval clean, report;
};

/* Prototypes */
int pk_parse_layers(char *packet, int length, struct frame *x,
                    int input_layer, int datalink, int allow_short_tcp);

int pk_sniff_dispatch(struct link *link, float timeout, pcap_handler handler, void *params);
char* pk_lookupdev(char *error);
void pk_print_ip(void *target);
void pk_print_tcp(void *target, int short_tcp);
void pk_link_sleep(struct link *link);
struct link *pk_link_preinit(struct link *link);
struct link *pk_link_init(struct link *link);
int pk_sr_parse_options(int argc, char **argv, struct pk_sr_conf *conf);

/* Functions referenced in libpaketto.c but declared elsewhere in your project */
int pk_link_filter(struct link *link, char *filter, int length);
int pk_fastnet(pcap_t *foo);
int pk_timeval_subtract(struct timeval *result, struct timeval *x, struct timeval *y);

/* from libpaketto.c */
int pk_initrng(prng_state *prng);
int pk_hmac(u_char *hash, u_char *key, u_char *message, int size);
int pk_sha1(u_char *hash, u_char *message, int size);
char* pk_lookupdev_ip(char *dev, long *source_ip);
long pk_bake_syncookie(u_char *ipp, u_char *key);
int pk_estimate_hopcount(int ttl);
int pk_spoof_framed(struct link *link, int layer, struct frame *x);
int pk_sniff_getnext(struct link *link);
const char *pk_host_lookup_ipv4(struct in_addr addr, int resolve, char *buf, size_t buflen);
int pk_recalc_checksums_libnet(libnet_t *ln, void *ip_hdr_void);

struct pk_ackmon_state;
struct pk_ackmon_state *pk_ackmon_init(struct pk_ackmon_state *s);
int pk_ackmon(struct pk_ackmon_state *s, struct frame *x, int dir, int timeout);


#endif /* LIB_PAKETTO */
