---
title: "interface.duplicateEnumCase"
ignorable: false
---

## Code example

```php
<?php declare(strict_types = 1);

// This identifier is produced by the DuplicateDeclarationRule which uses the
// class type description as prefix. In practice, interfaces cannot have enum
// cases, so this identifier is unlikely to be encountered in valid PHP code.
// The rule applies uniformly to all class-like declarations.

enum Status
{
	case Active;
	case Active;
}
```

## Why is it reported?

The declaration contains the same enum case name more than once. PHP does not allow redeclaring an enum case within the same body. This will cause a fatal error at runtime.

While the `interface.` prefix suggests this applies to interfaces, this identifier is generated by a generic rule that prefixes the error with the class-like type description. Interfaces cannot have enum cases in valid PHP, so this error is primarily relevant to enums themselves (where the identifier would be `enum.duplicateEnumCase`).

## How to fix it

Remove the duplicate enum case or rename it:

```diff-php
 <?php declare(strict_types = 1);

 enum Status
 {
 	case Active;
-	case Active;
+	case Inactive;
 }
```
