"""Python code for putting together information about a finding generated by Principal Mapper data."""

#  Copyright (c) NCC Group and Erik Steringer 2019. This file is part of Principal Mapper.
#
#      Principal Mapper is free software: you can redistribute it and/or modify
#      it under the terms of the GNU Affero General Public License as published by
#      the Free Software Foundation, either version 3 of the License, or
#      (at your option) any later version.
#
#      Principal Mapper is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU Affero General Public License for more details.
#
#      You should have received a copy of the GNU Affero General Public License
#      along with Principal Mapper.  If not, see <https://www.gnu.org/licenses/>.


class Finding:
    """Finding holds information about a potential risk in an AWS account, as identified by Principal Mapper."""

    def __init__(self, title: str, severity: str, impact: str, description: str, recommendation: str):
        self.title = title
        self.severity = severity
        self.impact = impact
        self.description = description
        self.recommendation = recommendation

    def as_dictionary(self) -> dict:
        """Returns a dictionary representation of this Finding."""
        return {
            'title': self.title,
            'severity': self.severity,
            'impact': self.impact,
            'description': self.description,
            'recommendation': self.recommendation
        }
