# Generated by Django 5.1.10 on 2025-06-12 12:45

import uuid

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0029_findings_check_index_parent"),
    ]

    operations = [
        migrations.CreateModel(
            name="LighthouseConfiguration",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the configuration",
                        max_length=100,
                        validators=[django.core.validators.MinLengthValidator(3)],
                    ),
                ),
                (
                    "api_key",
                    models.BinaryField(
                        help_text="Encrypted API key for the LLM service"
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        choices=[
                            ("gpt-4o-2024-11-20", "GPT-4o v2024-11-20"),
                            ("gpt-4o-2024-08-06", "GPT-4o v2024-08-06"),
                            ("gpt-4o-2024-05-13", "GPT-4o v2024-05-13"),
                            ("gpt-4o", "GPT-4o Default"),
                            ("gpt-4o-mini-2024-07-18", "GPT-4o Mini v2024-07-18"),
                            ("gpt-4o-mini", "GPT-4o Mini Default"),
                        ],
                        default="gpt-4o-2024-08-06",
                        help_text="Must be one of the supported model names",
                        max_length=50,
                    ),
                ),
                (
                    "temperature",
                    models.FloatField(default=0, help_text="Must be between 0 and 1"),
                ),
                (
                    "max_tokens",
                    models.IntegerField(
                        default=4000, help_text="Must be between 500 and 5000"
                    ),
                ),
                (
                    "business_context",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Additional business context for this AI model configuration",
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "lighthouse_configurations",
                "abstract": False,
                "constraints": [
                    models.UniqueConstraint(
                        fields=("tenant_id",),
                        name="unique_lighthouse_config_per_tenant",
                    ),
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="lighthouseconfiguration",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_lighthouseconfiguration",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
    ]
