# Generated by Django 5.1.5 on 2025-03-26 13:04

import uuid

import django.db.models.deletion
from django.db import migrations, models

import api.db_utils
import api.rls
from api.rls import RowLevelSecurityConstraint


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0033_processors_enum"),
    ]

    operations = [
        migrations.CreateModel(
            name="Processor",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "processor_type",
                    api.db_utils.ProcessorTypeEnumField(
                        choices=[("mutelist", "Mutelist")]
                    ),
                ),
                ("configuration", models.JSONField(default=dict)),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "processors",
                "abstract": False,
                "indexes": [
                    models.Index(
                        fields=["tenant_id", "id"], name="processor_tenant_id_idx"
                    ),
                    models.Index(
                        fields=["tenant_id", "processor_type"],
                        name="processor_tenant_type_idx",
                    ),
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="processor",
            constraint=models.UniqueConstraint(
                fields=("tenant_id", "processor_type"),
                name="unique_processor_types_tenant",
            ),
        ),
        migrations.AddConstraint(
            model_name="processor",
            constraint=RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_processor",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.AddField(
            model_name="scan",
            name="processor",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="scans",
                related_query_name="scan",
                to="api.processor",
            ),
        ),
    ]
