# Generated by Django 5.1.12 on 2025-09-30 13:10

import uuid

import django.core.validators
import django.db.models.deletion
import drf_simple_apikey.models
from django.conf import settings
from django.db import migrations, models

import api.db_utils
import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0047_remove_integration_unique_configuration_per_tenant"),
    ]

    operations = [
        migrations.CreateModel(
            name="TenantAPIKey",
            fields=[
                (
                    "name",
                    models.CharField(
                        max_length=255,
                        validators=[django.core.validators.MinLengthValidator(3)],
                    ),
                ),
                (
                    "expiry_date",
                    models.DateTimeField(
                        default=drf_simple_apikey.models._expiry_date,
                        help_text="Once API key expires, entities cannot use it anymore.",
                        verbose_name="Expires",
                    ),
                ),
                (
                    "revoked",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="If the API key is revoked, entities cannot use it anymore. (This cannot be undone.)",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, editable=False)),
                (
                    "whitelisted_ips",
                    models.JSONField(
                        blank=True,
                        help_text="List of allowed IP addresses for this API key.",
                        null=True,
                    ),
                ),
                (
                    "blacklisted_ips",
                    models.JSONField(
                        blank=True,
                        help_text="List of denied IP addresses for this API key.",
                        null=True,
                    ),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "prefix",
                    models.CharField(
                        default=api.db_utils.generate_api_key_prefix,
                        editable=False,
                        help_text="Unique prefix to identify the API key",
                        max_length=11,
                        unique=True,
                    ),
                ),
                (
                    "last_used_at",
                    models.DateTimeField(
                        blank=True,
                        help_text="Last time this API key was used for authentication",
                        null=True,
                    ),
                ),
                (
                    "entity",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="user_api_keys",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "api_keys",
                "abstract": False,
                "indexes": [
                    models.Index(
                        fields=["tenant_id", "prefix"],
                        name="api_keys_tenant_prefix_idx",
                    )
                ],
                "constraints": [
                    models.UniqueConstraint(
                        fields=("tenant_id", "prefix"), name="unique_api_key_prefixes"
                    ),
                    models.UniqueConstraint(
                        fields=("tenant_id", "name"),
                        name="unique_api_key_name_per_tenant",
                    ),
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="tenantapikey",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_tenantapikey",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
    ]
