# Generated by Django 5.1.15 on 2026-01-26

import uuid

import django.db.models.deletion
from django.contrib.postgres.indexes import GinIndex, OpClass
from django.db import migrations, models
from django.db.models.functions import Upper
from django.utils import timezone

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0080_backfill_attack_paths_graph_data_ready"),
    ]

    operations = [
        migrations.CreateModel(
            name="FindingGroupDailySummary",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "inserted_at",
                    models.DateTimeField(default=timezone.now, editable=False),
                ),
                ("updated_at", models.DateTimeField(auto_now=True, editable=False)),
                ("check_id", models.CharField(db_index=True, max_length=255)),
                (
                    "check_title",
                    models.CharField(blank=True, max_length=500, null=True),
                ),
                ("check_description", models.TextField(blank=True, null=True)),
                ("severity_order", models.SmallIntegerField(default=1)),
                ("pass_count", models.IntegerField(default=0)),
                ("fail_count", models.IntegerField(default=0)),
                ("muted_count", models.IntegerField(default=0)),
                ("new_count", models.IntegerField(default=0)),
                ("changed_count", models.IntegerField(default=0)),
                ("resources_fail", models.IntegerField(default=0)),
                ("resources_total", models.IntegerField(default=0)),
                ("first_seen_at", models.DateTimeField(blank=True, null=True)),
                ("last_seen_at", models.DateTimeField(blank=True, null=True)),
                ("failing_since", models.DateTimeField(blank=True, null=True)),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="api.tenant",
                    ),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="finding_group_summaries",
                        to="api.provider",
                    ),
                ),
            ],
            options={
                "db_table": "finding_group_daily_summaries",
                "abstract": False,
            },
        ),
        migrations.AddIndex(
            model_name="findinggroupdailysummary",
            index=models.Index(
                fields=["tenant_id", "inserted_at"],
                name="fgds_tenant_inserted_at_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="findinggroupdailysummary",
            index=models.Index(
                fields=["tenant_id", "provider", "inserted_at"],
                name="fgds_tenant_prov_ins_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="findinggroupdailysummary",
            index=models.Index(
                fields=["tenant_id", "check_id", "inserted_at"],
                name="fgds_tenant_chk_ins_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="resource",
            index=GinIndex(
                OpClass(Upper("uid"), name="gin_trgm_ops"),
                name="res_uid_trgm_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="resource",
            index=GinIndex(
                OpClass(Upper("name"), name="gin_trgm_ops"),
                name="res_name_trgm_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="findinggroupdailysummary",
            constraint=models.UniqueConstraint(
                fields=("tenant_id", "provider", "check_id", "inserted_at"),
                name="unique_finding_group_daily_summary",
            ),
        ),
        migrations.AddConstraint(
            model_name="findinggroupdailysummary",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_findinggroupdailysummary",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.AddIndex(
            model_name="finding",
            index=models.Index(
                fields=["tenant_id", "check_id", "inserted_at"],
                name="find_tenant_check_ins_idx",
            ),
        ),
    ]
