# Generated by Django 5.1.14 on 2026-02-02

from django.db import migrations
from tasks.tasks import backfill_finding_group_summaries_task

from api.db_router import MainRouter
from api.rls import Tenant


def trigger_backfill_task(apps, schema_editor):
    """
    Trigger the backfill task for all tenants.

    This dispatches backfill_finding_group_summaries_task for each tenant
    in the system to populate FindingGroupDailySummary records from historical scans.
    """
    tenant_ids = Tenant.objects.using(MainRouter.admin_db).values_list("id", flat=True)

    for tenant_id in tenant_ids:
        backfill_finding_group_summaries_task.delay(tenant_id=str(tenant_id), days=30)


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0081_finding_group_daily_summary"),
    ]

    operations = [
        migrations.RunPython(trigger_backfill_task, migrations.RunPython.noop),
    ]
