# GitHub Agentic Workflows Documentation

## Local Examples

Working workflow and agent files in this repo:

- `.github/workflows/issue-triage.md` - Workflow frontmatter + context dispatcher (LabelOps pattern)
- `.github/agents/issue-triage.md` - Full triage agent persona with output format
- `.github/workflows/issue-triage.lock.yml` - Compiled lock file (auto-generated)
- `.github/aw/actions-lock.json` - Action SHA pinning
- `.gitattributes` - Lock file merge strategy

## Official Documentation

- gh-aw docs: https://github.github.com/gh-aw/
- Frontmatter reference: https://github.github.com/gh-aw/reference/frontmatter/
- Safe outputs: https://github.github.com/gh-aw/reference/safe-outputs/
- Triggers: https://github.github.com/gh-aw/reference/triggers/
- Tools: https://github.github.com/gh-aw/reference/tools/
- MCP servers: https://github.github.com/gh-aw/guides/mcps/
- Imports: https://github.github.com/gh-aw/reference/imports/
- Network access: https://github.github.com/gh-aw/reference/network/
- Security architecture: https://github.github.com/gh-aw/introduction/architecture/
- Threat detection: https://github.github.com/gh-aw/reference/threat-detection/
- Compilation process: https://github.github.com/gh-aw/reference/compilation-process/
- Lockdown mode: https://github.github.com/gh-aw/reference/lockdown-mode/
- Concurrency: https://github.github.com/gh-aw/reference/concurrency/
- Design patterns: https://github.github.com/gh-aw/patterns/
- Copilot Custom Agents: https://github.github.com/gh-aw/reference/copilot-custom-agents/
