"use client";

import { updateCredentialsProvider } from "@/actions/providers/providers";
import { ProviderType } from "@/types";

import { BaseCredentialsForm } from "./base-credentials-form";

export const UpdateViaRoleForm = ({
  searchParams,
  providerUid,
  via,
  onSuccess,
  onBack,
  formId,
  hideActions,
  onLoadingChange,
  onValidityChange,
}: {
  searchParams: { type: string; id: string; secretId?: string };
  providerUid?: string;
  via?: string | null;
  onSuccess?: () => void;
  onBack?: () => void;
  formId?: string;
  hideActions?: boolean;
  onLoadingChange?: (isLoading: boolean) => void;
  onValidityChange?: (isValid: boolean) => void;
}) => {
  const providerType = searchParams.type as ProviderType;
  const providerId = searchParams.id;
  const providerSecretId = searchParams.secretId || "";

  const handleUpdateCredentials = async (formData: FormData) => {
    return await updateCredentialsProvider(providerSecretId, formData);
  };

  const successNavigationUrl = "/providers";

  return (
    <BaseCredentialsForm
      providerType={providerType}
      providerId={providerId}
      providerUid={providerUid}
      onSubmit={handleUpdateCredentials}
      successNavigationUrl={successNavigationUrl}
      via={via}
      onSuccess={onSuccess}
      onBack={onBack}
      formId={formId}
      hideActions={hideActions}
      onLoadingChange={onLoadingChange}
      onValidityChange={onValidityChange}
      submitButtonText="Next"
    />
  );
};
