# PyADRecon

Python3 implementation of an improved [ADRecon](https://github.com/sense-of-security/ADRecon)

> ADRecon is a tool which gathers information about MS Active Directory and generates an XSLX report to provide a holistic picture of the current state of the target AD environment.

## Table of Contents

- [Installation](#installation)
- [Usage](#usage)
- [Docker](#docker)
- [Collection Modules](#collection-modules)
- [Acknowledgements](#acknowledgements)
- [License](#license)

## Installation

Generic:

````bash
# clone the repo
git clone https://github.com/l4rm4nd/PyADRecon && cd PyADRecon

# create virtual environment
virtualenv venv && source venv/bin/activate

# install dependencies
pip install -r requirements.txt
````

[BlackArch Linux](https://blackarch.org/):

```bash
pacman -Syu pyadrecon
```

## Usage

````py
usage: pyadrecon.py [-h] [--generate-excel-from CSV_DIR] [-dc DOMAIN_CONTROLLER] [-u USERNAME] [-p [PASSWORD]] [-d DOMAIN] [--auth {ntlm,kerberos}] [--tgt-file TGT_FILE] [--tgt-base64 TGT_BASE64]
                    [--ssl] [--port PORT] [-o OUTPUT] [--page-size PAGE_SIZE] [--threads THREADS] [--dormant-days DORMANT_DAYS] [--password-age PASSWORD_AGE] [--only-enabled] [--collect COLLECT]
                    [--no-excel] [-v]

PyADRecon - Python Active Directory Reconnaissance Tool

options:
  -h, --help            show this help message and exit
  --generate-excel-from CSV_DIR
                        Generate Excel report from CSV directory (standalone mode, no AD connection needed)
  -dc, --domain-controller DOMAIN_CONTROLLER
                        Domain Controller IP or hostname
  -u, --username USERNAME
                        Username for authentication
  -p, --password [PASSWORD]
                        Password for authentication (optional if using TGT)
  -d, --domain DOMAIN   Domain name (e.g., DOMAIN.LOCAL) - Required for Kerberos auth
  --auth {ntlm,kerberos}
                        Authentication method (default: ntlm)
  --tgt-file TGT_FILE   Path to Kerberos TGT ccache file (for Kerberos auth)
  --tgt-base64 TGT_BASE64
                        Base64-encoded Kerberos TGT ccache (for Kerberos auth)
  --ssl                 Force SSL/TLS (LDAPS). No LDAP fallback allowed.
  --port PORT           LDAP port (default: 389, use 636 for LDAPS)
  -o, --output OUTPUT   Output directory (default: PyADRecon-Report-<timestamp>)
  --page-size PAGE_SIZE
                        LDAP page size (default: 500)
  --dormant-days DORMANT_DAYS
                        Days for dormant account threshold (default: 90)
  --password-age PASSWORD_AGE
                        Days for password age threshold (default: 180)
  --only-enabled        Only collect enabled objects
  --collect COLLECT     Comma-separated modules to collect (default: all)
  --workstation WORKSTATION
                        Explicitly spoof workstation name for NTLM authentication (default: empty string, bypasses userWorkstations restrictions)  
  --no-excel            Skip Excel report generation
  -v, --verbose         Verbose output

Examples:
  # Basic usage with NTLM authentication
  pyadrecon.py -dc 192.168.1.1 -u admin -p password123 -d DOMAIN.LOCAL

  # With Kerberos authentication (bypasses channel binding)
  pyadrecon.py -dc dc01.domain.local -u admin -p password123 -d DOMAIN.LOCAL --auth kerberos

  # With Kerberos using TGT from file (bypasses channel binding)
  pyadrecon.py -dc dc01.domain.local -u admin -d DOMAIN.LOCAL --auth kerberos --tgt-file /tmp/admin.ccache

  # With Kerberos using TGT from base64 string (bypasses channel binding)
  pyadrecon.py -dc dc01.domain.local -u admin -d DOMAIN.LOCAL --auth kerberos --tgt-base64 BQQAAAw...

  # Only collect specific modules
  pyadrecon.py -dc 192.168.1.1 -u admin -p pass -d DOMAIN.LOCAL --collect users,groups,computers

  # Output to specific directory
  pyadrecon.py -dc 192.168.1.1 -u admin -p pass -d DOMAIN.LOCAL -o /tmp/adrecon_output

  # Generate Excel report from existing CSV files (standalone mode)
  pyadrecon.py --generate-excel-from /path/to/CSV-Files -o report.xlsx
````

>[!TIP]
>PyADRecon always tries LDAPS on TCP/636 first.
>
>If flag `--ssl` is not used, LDAP on TCP/389 may be tried as fallback.

>[!WARNING]
>If LDAP channel binding is enabled, this script will fail with `automatic bind not successful - strongerAuthRequired`, as ldap3 does not support it (see [here](https://github.com/cannatag/ldap3/issues/1049#issuecomment-1222826803)). You must use Kerberos authentication instead.
>
>If you use Kerberos auth, please create a valid `/etc/krb5.conf` and DC hostname entry in `/etc/hosts`. May read [this](https://cwiki.apache.org/confluence/pages/viewpage.action?pageId=32628#KerberosClientConfiguration-*NIX/etc/krb5.confConfiguration).
>
>Note that you can provide an already existing TGT ticket to the script via `--tgt-file` or `--tgt-base64`. For example, obtained by Netexec via `netexec smb <TARGET> <ARGS> --generate-tgt <FILEMAME>`.

>[!NOTE]
>PyADRecon uses an **empty workstation name by default** (like Impacket/NetExec), which bypasses `userWorkstations` restrictions automatically. This means accounts restricted to specific computers will work without any special flags!
>
>If needed, you can explicitly spoof a workstation name using `--workstation <name>` flag during NTLM authentication.

## Docker

There is also a Docker image available on GHCR.IO.

````
docker run --rm -v /etc/krb5.conf:/etc/krb5.conf:ro -v /etc/hosts:/etc/hosts:ro -v ./:/tmp/pyadrecon_output ghcr.io/l4rm4nd/pyadrecon:latest -dc dc01.domain.local -u admin -p password123 -d DOMAIN.LOCAL -o /tmp/pyadrecon_output
````

## Collection Modules

As default, PyADRecon runs all collection modules. They are referenced to as `default` or `all`.

Though, you can freely select your own collection of modules to run:

**Forest & Domain**
- `forest`
- `domain`
- `trusts`
- `sites`
- `subnets`
- `schema` or `schemahistory`

**Domain Controllers**
- `dcs` or `domaincontrollers`

**Users & Groups**
- `users`
- `userspns`
- `groups`
- `groupmembers`

**Computers & Printers**
- `computers`
- `computerspns`
- `printers`

**OUs & Group Policy**
- `ous`
- `gpos`
- `gplinks`

**Passwords & Credentials**
- `passwordpolicy`
- `fgpp` or `finegrainedpasswordpolicy`
- `laps`
- `bitlocker`

**Managed Service Accounts**
- `gmsa` or `groupmanagedserviceaccounts` (beta)
- `dmsa` or `delegatedmanagedserviceaccounts` (beta)

**Certificates**
- `adcs` or `certificates` (beta)

**DNS**
- `dnszones`
- `dnsrecords`

## Acknowledgements

Many thanks to the following folks:
 - [S3cur3Th1sSh1t](https://github.com/S3cur3Th1sSh1t) for a first Claude draft of this Python3 port 
- [Sense-of-Security](https://github.com/sense-of-security) for the original ADRecon script in PowerShell
- [cannatag](https://github.com/cannatag) for the awesome ldap3 Python client
- [Forta](https://github.com/fortra) for the awesome impacket suite
- [Anthropic](https://github.com/anthropics) for Claude LLMs

## License

**PyADRecon** is released under the **MIT License**.

The following third-party libraries are used:

| Library     | License        |
|-------------|----------------|
| ldap3       | LGPL v3        |
| openpyxl    | MIT            |
| gssapi      | MIT            |
| impacket    | Apache 2.0     |
| winkerberos | Apache 2.0     |

Please refer to the respective licenses of these libraries when using or redistributing this software.
