# This file is generated by target-build-magic
# Do not edit manually, for overrides see 'overrides.py'
#
# Generated on:         2025-12-11 14:04:45.855209+00:00
# Source SHA1 hash:     0958d7277efbfc952775ffc423adcd3e1596883d
# Number of types:      766
# References:           http://www.freedesktop.org/standards/shared-mime-info
#                       https://gitlab.freedesktop.org/xdg/shared-mime-info/-/blob/master/data/freedesktop.org.xml.in

TYPES = [
    {"type": "application/x-atari-2600-rom", "name": "Atari 2600 ROM", "pattern": ["*.a26"], "magic": []},
    {
        "type": "application/x-atari-7800-rom",
        "name": "Atari 7800 ROM",
        "pattern": ["*.a78"],
        "magic": [{"offset": 1, "value": b"ATARI7800"}],
    },
    {
        "type": "application/x-atari-lynx-rom",
        "name": "Atari Lynx ROM",
        "pattern": ["*.lnx"],
        "magic": [{"offset": 0, "value": b"LYNX"}],
    },
    {"type": "application/andrew-inset", "name": "ATK inset", "pattern": ["*.ez"], "magic": []},
    {
        "type": "application/vnd.amazon.mobi8-ebook",
        "name": "Kindle book document",
        "pattern": ["*.azw3", "*.kfx"],
        "magic": [],
    },
    {"type": "application/illustrator", "name": "Adobe Illustrator document", "pattern": ["*.ai"], "magic": []},
    {
        "type": "application/mac-binhex40",
        "name": "Macintosh BinHex-encoded file",
        "pattern": ["*.hqx"],
        "magic": [
            {"offset": 0, "value": b"(This file must be converted with BinHex 4.0)"},
            {"offset": 0, "value": b"(This file must be converted; you knew that already.)"},
        ],
    },
    {
        "type": "application/mathematica",
        "name": "Mathematica Notebook file",
        "pattern": ["*.nb"],
        "magic": [
            {"offset": 0, "value": b"(************** Content-type: application/mathematica"},
            {"offset": 100, "value": b"This notebook can be used on any computer system with Mathematica"},
            {"offset": 10, "value": b"This is a Mathematica Notebook file.  It contains ASCII text"},
        ],
    },
    {
        "type": "application/mbox",
        "name": "Mailbox file",
        "pattern": ["*.mbox"],
        "magic": [{"offset": 0, "value": b"From "}],
    },
    {
        "type": "application/x-partial-download",
        "name": "Partially downloaded file",
        "pattern": ["*.wkdownload", "*.crdownload", "*.part"],
        "magic": [],
    },
    {"type": "application/oda", "name": "ODA document", "pattern": ["*.oda"], "magic": []},
    {"type": "application/x-wwf", "name": "WWF document", "pattern": ["*.wwf"], "magic": []},
    {
        "type": "application/pdf",
        "name": "PDF document",
        "pattern": ["*.pdf"],
        "magic": [{"offset": 0, "value": b"%PDF-"}],
    },
    {
        "type": "application/x-windows-themepack",
        "name": "Microsoft Windows theme pack",
        "pattern": ["*.themepack"],
        "magic": [],
    },
    {"type": "audio/x-amzxml", "name": "AmazonMP3 download file", "pattern": ["*.amz"], "magic": []},
    {"type": "audio/x-gsm", "name": "GSM 06.10 audio", "pattern": ["*.gsm"], "magic": []},
    {
        "type": "audio/x-iriver-pla",
        "name": "iRiver playlist",
        "pattern": ["*.pla"],
        "magic": [{"offset": 4, "value": b"iriver UMS PLA"}],
    },
    {
        "type": "application/pgp-encrypted",
        "name": "PGP/MIME-encrypted message header",
        "pattern": ["*.pgp", "*.gpg", "*.asc"],
        "magic": [{"offset": 0, "value": b"-----BEGIN PGP MESSAGE-----"}],
    },
    {
        "type": "application/pgp-keys",
        "name": "PGP keys",
        "pattern": ["*.skr", "*.pkr", "*.asc", "*.pgp", "*.gpg", "*.key"],
        "magic": [
            {"offset": 0, "value": b"-----BEGIN PGP PUBLIC KEY BLOCK-----"},
            {"offset": 0, "value": b"-----BEGIN PGP PRIVATE KEY BLOCK-----"},
            {"offset": 0, "value": b"\x95\x01"},
            {"offset": 0, "value": b"\x95\x00"},
            {"offset": 0, "value": b"\x99\x00"},
            {"offset": 0, "value": b"\x99\x01"},
        ],
    },
    {
        "type": "application/pgp-signature",
        "name": "Detached OpenPGP signature",
        "pattern": ["*.asc", "*.sig", "*.pgp", "*.gpg"],
        "magic": [{"offset": 0, "value": b"-----BEGIN PGP SIGNATURE-----"}],
    },
    {"type": "application/pkcs7-mime", "name": "PKCS#7 file", "pattern": ["*.p7c", "*.p7m"], "magic": []},
    {"type": "application/pkcs7-signature", "name": "Detached S/MIME signature", "pattern": ["*.p7s"], "magic": []},
    {"type": "application/pkcs8", "name": "PKCS#8 private key", "pattern": ["*.p8"], "magic": []},
    {
        "type": "application/pkcs8-encrypted",
        "name": "PKCS#8 private key (encrypted)",
        "pattern": ["*.p8e"],
        "magic": [],
    },
    {"type": "application/pkcs10", "name": "PKCS#10 certification request", "pattern": ["*.p10"], "magic": []},
    {
        "type": "application/pkix-cert",
        "name": "X.509 certificate",
        "pattern": ["*.cer"],
        "magic": [
            {"offset": 0, "value": b"-----BEGIN CERTIFICATE-----"},
            {"offset": 0, "value": b"-----BEGIN X509 CERTIFICATE-----"},
        ],
    },
    {
        "type": "application/pkix-crl",
        "name": "Certificate revocation list",
        "pattern": ["*.crl"],
        "magic": [{"offset": 0, "value": b"-----BEGIN X509 CRL-----"}],
    },
    {"type": "application/pkix-pkipath", "name": "PkiPath certification path", "pattern": ["*.pkipath"], "magic": []},
    {
        "type": "application/postscript",
        "name": "PostScript document",
        "pattern": ["*.ps"],
        "magic": [{"offset": 0, "value": b"\x04%!"}, {"offset": 0, "value": b"%!"}],
    },
    {
        "type": "application/prs.plucker",
        "name": "Plucker document",
        "pattern": [],
        "magic": [{"offset": 60, "value": b"DataPlkr"}],
    },
    {
        "type": "application/buildstream+yaml",
        "name": "BuildStream element",
        "pattern": ["*.bst"],
        "magic": [{"offset": 0, "value": b"kind:"}],
    },
    {
        "type": "application/raml+yaml",
        "name": "RAML document",
        "pattern": ["*.raml"],
        "magic": [{"offset": 0, "value": b"#%RAML "}],
    },
    {"type": "application/relax-ng-compact-syntax", "name": "RELAX NG XML schema", "pattern": ["*.rnc"], "magic": []},
    {
        "type": "application/rtf",
        "name": "RTF document",
        "pattern": ["*.rtf"],
        "magic": [{"offset": 0, "value": b"{\\\\rtf"}],
    },
    {"type": "application/sieve", "name": "Sieve mail filter script", "pattern": ["*.siv", "*.sieve"], "magic": []},
    {
        "type": "application/vnd.ms-wpl",
        "name": "WPL playlist",
        "pattern": ["*.wpl"],
        "magic": [{"offset": 0, "value": b"<?wpl"}],
    },
    {
        "type": "application/x-sqlite2",
        "name": "SQLite2 database",
        "pattern": ["*.sqlite2"],
        "magic": [{"offset": 0, "value": b"** This file contains an SQLite"}],
    },
    {
        "type": "application/vnd.sqlite3",
        "name": "SQLite3 database",
        "pattern": ["*.sqlite3"],
        "magic": [{"offset": 0, "value": b"SQLite format 3"}],
    },
    {
        "type": "text/vnd.familysearch.gedcom",
        "name": "GEDCOM family history",
        "pattern": ["*.ged", "*.gedcom"],
        "magic": [{"offset": 0, "value": b"0 HEAD"}],
    },
    {"type": "video/x-flv", "name": "Flash video", "pattern": ["*.flv"], "magic": [{"offset": 0, "value": b"FLV"}]},
    {"type": "video/x-javafx", "name": "JavaFX video", "pattern": ["*.fxm"], "magic": []},
    {
        "type": "application/x-go-sgf",
        "name": "SGF record",
        "pattern": ["*.sgf"],
        "magic": [{"offset": 0, "value": b"(;FF[3]"}, {"offset": 0, "value": b"(;FF[4]"}],
    },
    {"type": "application/x-godot-project", "name": "Godot Engine project", "pattern": ["project.godot"], "magic": []},
    {
        "type": "application/x-godot-resource",
        "name": "Godot Engine resource",
        "pattern": ["*.res", "*.tres"],
        "magic": [{"offset": 0, "value": b"[gd_resource "}],
    },
    {
        "type": "application/x-godot-scene",
        "name": "Godot Engine scene",
        "pattern": ["*.scn", "*.tscn", "*.escn"],
        "magic": [{"offset": 0, "value": b"[gd_scene "}],
    },
    {"type": "application/x-godot-shader", "name": "Godot Engine shader", "pattern": ["*.gdshader"], "magic": []},
    {"type": "application/x-gdscript", "name": "GDScript script", "pattern": ["*.gd"], "magic": []},
    {"type": "application/toml", "name": "TOML document", "pattern": ["*.toml"], "magic": []},
    {
        "type": "application/yaml",
        "name": "YAML document",
        "pattern": ["*.yaml", "*.yml"],
        "magic": [{"offset": 0, "value": b"%YAML"}],
    },
    {
        "type": "application/vnd.corel-draw",
        "name": "Corel Draw drawing",
        "pattern": ["*.cdr"],
        "magic": [{"offset": 8, "value": b"CDRXvrsn"}],
    },
    {"type": "application/vnd.hp-hpgl", "name": "HPGL file", "pattern": ["*.hpgl"], "magic": []},
    {"type": "application/vnd.hp-pcl", "name": "PCL file", "pattern": ["*.pcl"], "magic": []},
    {
        "type": "application/vnd.cups-ppd",
        "name": "PostScript printer description",
        "pattern": ["*.ppd"],
        "magic": [{"offset": 0, "value": b"*PPD-Adobe:"}],
    },
    {
        "type": "application/vnd.lotus-1-2-3",
        "name": "Lotus 1-2-3 spreadsheet",
        "pattern": ["*.123", "*.wk1", "*.wk3", "*.wk4", "*.wks"],
        "magic": [{"offset": 0, "value": b"\x00\x00\x02\x00\x06\x04\x06\x00\x08\x00\x00\x00\x00\x00"}],
    },
    {
        "type": "application/vnd.lotus-wordpro",
        "name": "Lotus Word Pro document",
        "pattern": ["*.lwp"],
        "magic": [{"offset": 0, "value": b"WordPro"}],
    },
    {
        "type": "application/x-lmdb",
        "name": "LMDB database",
        "pattern": ["*.mdb", "*.lmdb"],
        "magic": [{"offset": 16, "value": b"\xbe\xef\xc0\xde"}],
    },
    {
        "type": "application/vnd.ms-access",
        "name": "JET database",
        "pattern": ["*.mdb"],
        "magic": [{"offset": 0, "value": b"\x00\x01\x00\x00Standard Jet DB"}],
    },
    {
        "type": "application/vnd.ms-cab-compressed",
        "name": "Microsoft Cabinet archive",
        "pattern": ["*.cab"],
        "magic": [{"offset": 0, "value": b"MSCF\x00\x00\x00\x00"}],
    },
    {
        "type": "application/vnd.ms-excel",
        "name": "Excel spreadsheet",
        "pattern": ["*.xls", "*.xlc", "*.xll", "*.xlm", "*.xlw", "*.xla", "*.xlt", "*.xld"],
        "magic": [
            {"offset": 0, "value": b"\xd0\xcf\x11\xe0\xa1\xb1\x1a\xe1"},
            {"offset": 2080, "value": b"Microsoft Excel 5.0 Worksheet"},
        ],
    },
    {
        "type": "application/vnd.ms-excel.addin.macroEnabled.12",
        "name": "Excel add-in",
        "pattern": ["*.xlam"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-excel.sheet.binary.macroEnabled.12",
        "name": "Excel 2007 binary spreadsheet",
        "pattern": ["*.xlsb"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-excel.sheet.macroEnabled.12",
        "name": "Excel spreadsheet",
        "pattern": ["*.xlsm"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-excel.template.macroEnabled.12",
        "name": "Excel spreadsheet template",
        "pattern": ["*.xltm"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-powerpoint",
        "name": "PowerPoint presentation",
        "pattern": ["*.ppz", "*.ppt", "*.pps", "*.pot"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-powerpoint.addin.macroEnabled.12",
        "name": "PowerPoint add-in",
        "pattern": ["*.ppam"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-powerpoint.presentation.macroEnabled.12",
        "name": "PowerPoint presentation",
        "pattern": ["*.pptm"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-powerpoint.slide.macroEnabled.12",
        "name": "PowerPoint slide",
        "pattern": ["*.sldm"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-powerpoint.slideshow.macroEnabled.12",
        "name": "PowerPoint presentation",
        "pattern": ["*.ppsm"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-powerpoint.template.macroEnabled.12",
        "name": "PowerPoint presentation template",
        "pattern": ["*.potm"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-word.document.macroEnabled.12",
        "name": "Word document",
        "pattern": ["*.docm"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-word.template.macroEnabled.12",
        "name": "Word document template",
        "pattern": ["*.dotm"],
        "magic": [],
    },
    {
        "type": "application/vnd.ms-works",
        "name": "Microsoft Works document",
        "pattern": ["*.wcm", "*.wdb", "*.wks", "*.wps", "*.xlr"],
        "magic": [],
    },
    {
        "type": "application/vnd.visio",
        "name": "Microsoft Visio document",
        "pattern": ["*.vsd", "*.vst", "*.vsw", "*.vss"],
        "magic": [],
    },
    {
        "type": "application/msword",
        "name": "Word document",
        "pattern": ["*.doc"],
        "magic": [
            {"offset": 0, "value": b"1\xbe\x00\x00"},
            {"offset": 0, "value": b"PO^Q`"},
            {"offset": 0, "value": b"\xfe7\x00#"},
            {"offset": 0, "value": b"\xdb\xa5-\x00\x00\x00"},
        ],
    },
    {"type": "application/msword-template", "name": "Word template", "pattern": ["*.dot"], "magic": []},
    {
        "type": "application/gnunet-directory",
        "name": "GNUnet search file",
        "pattern": ["*.gnd"],
        "magic": [{"offset": 0, "value": b"\x89GND\r\n\x1a\n"}],
    },
    {
        "type": "application/vnd.ms-tnef",
        "name": "TNEF message",
        "pattern": ["*.tnef", "*.tnf", "winmail.dat"],
        "magic": [{"offset": 0, "value": b'">\x9fx'}],
    },
    {"type": "application/x-starcalc", "name": "StarCalc 3-4 spreadsheet", "pattern": ["*.sdc"], "magic": []},
    {"type": "application/x-starchart", "name": "StarChart 3-4 chart", "pattern": ["*.sds"], "magic": []},
    {"type": "application/x-stardraw", "name": "StarDraw 4 drawing", "pattern": ["*.sda"], "magic": []},
    {"type": "application/x-starimpress", "name": "StarImpress 3-4 presentation", "pattern": ["*.sdd"], "magic": []},
    {
        "type": "application/x-starmail",
        "name": "StarMail 4 email",
        "pattern": ["*.smd"],
        "magic": [{"offset": 0, "value": b"ANCH"}],
    },
    {"type": "application/x-starmath", "name": "StarMath 3-4 formula", "pattern": ["*.smf"], "magic": []},
    {"type": "application/x-starwriter", "name": "StarWriter 3-4 document", "pattern": ["*.sdw", "*.vor"], "magic": []},
    {
        "type": "application/x-starwriter-global",
        "name": "StarWriter 4 master document",
        "pattern": ["*.sgl"],
        "magic": [],
    },
    {"type": "application/vnd.stardivision.calc", "name": "StarCalc 5 spreadsheet", "pattern": ["*.sdc"], "magic": []},
    {"type": "application/vnd.stardivision.chart", "name": "StarChart 5 chart", "pattern": ["*.sds"], "magic": []},
    {"type": "application/vnd.stardivision.draw", "name": "StarDraw 5 drawing", "pattern": ["*.sda"], "magic": []},
    {
        "type": "application/vnd.stardivision.impress",
        "name": "StarImpress 5 presentation",
        "pattern": ["*.sdd"],
        "magic": [],
    },
    {
        "type": "application/vnd.stardivision.impress-packed",
        "name": "StarImpress packed presentation",
        "pattern": ["*.sdp"],
        "magic": [{"offset": 0, "value": b"PIZS"}],
    },
    {"type": "application/vnd.stardivision.mail", "name": "StarMail 5 email", "pattern": ["*.sdm"], "magic": []},
    {"type": "application/vnd.stardivision.math", "name": "StarMath 5 formula", "pattern": ["*.smf"], "magic": []},
    {
        "type": "application/vnd.stardivision.writer",
        "name": "StarWriter 5 document",
        "pattern": ["*.sdw", "*.vor"],
        "magic": [{"offset": 2089, "value": b"StarWriter"}],
    },
    {
        "type": "application/vnd.stardivision.writer-global",
        "name": "StarWriter 5 master document",
        "pattern": ["*.sgl"],
        "magic": [],
    },
    {
        "type": "application/vnd.apache.parquet",
        "name": "Apache Parquet file",
        "pattern": ["*.parquet"],
        "magic": [{"offset": 0, "value": b"PAR1"}, {"offset": 0, "value": b"PARE"}],
    },
    {"type": "application/vnd.android.package-archive", "name": "Android package", "pattern": ["*.apk"], "magic": []},
    {
        "type": "application/x-alpine-package-keeper-package",
        "name": "Alpine Package Keeper package",
        "pattern": ["*.apk"],
        "magic": [],
    },
    {
        "type": "application/vnd.symbian.install",
        "name": "SIS package",
        "pattern": ["*.sis"],
        "magic": [{"offset": 8, "value": b"\x10\x00\x04\x19"}],
    },
    {
        "type": "x-epoc/x-sisx-app",
        "name": "SISX package",
        "pattern": ["*.sisx"],
        "magic": [{"offset": 0, "value": b"\x10 \x1az"}],
    },
    {
        "type": "application/vnd.tcpdump.pcap",
        "name": "Network packet capture",
        "pattern": ["*.pcap", "*.cap", "*.dmp"],
        "magic": [{"offset": 0, "value": b"\xa1\xb2\xc3\xd4"}, {"offset": 0, "value": b"\xd4\xc3\xb2\xa1"}],
    },
    {
        "type": "application/x-pcapng",
        "name": "PCAPNG packet capture",
        "pattern": ["*.pcapng", "*.scap", "*.ntar"],
        "magic": [{"offset": 0, "value": b"\n\r\r\n"}],
    },
    {
        "type": "application/vnd.wordperfect",
        "name": "WordPerfect document",
        "pattern": ["*.wp", "*.wp4", "*.wp5", "*.wp6", "*.wpd", "*.wpp"],
        "magic": [{"offset": 1, "value": b"WPC"}],
    },
    {
        "type": "application/x-spss-por",
        "name": "SPSS portable data file",
        "pattern": ["*.por"],
        "magic": [{"offset": 40, "value": b"ASCII SPSS PORT FILE"}],
    },
    {
        "type": "application/x-spss-sav",
        "name": "SPSS data file",
        "pattern": ["*.sav", "*.zsav"],
        "magic": [{"offset": 0, "value": b"$FL2"}, {"offset": 0, "value": b"$FL3"}],
    },
    {
        "type": "application/x-7z-compressed",
        "name": "7-zip archive",
        "pattern": ["*.7z", "*.7z.001"],
        "magic": [{"offset": 0, "value": b"7z\xbc\xaf'\x1c"}],
    },
    {"type": "application/x-cue", "name": "CD image cuesheet", "pattern": ["*.cue"], "magic": []},
    {"type": "application/x-amipro", "name": "Lotus AmiPro document", "pattern": ["*.sam"], "magic": []},
    {
        "type": "application/x-aportisdoc",
        "name": "AportisDoc document",
        "pattern": ["*.pdb", "*.pdc"],
        "magic": [{"offset": 60, "value": b"TEXtREAd"}, {"offset": 60, "value": b"TEXtTlDc"}],
    },
    {
        "type": "chemical/x-pdb",
        "name": "Protein Data Bank file",
        "pattern": ["*.pdb", "*.brk"],
        "magic": [{"offset": 0, "value": b"HEADER "}],
    },
    {
        "type": "application/x-applix-spreadsheet",
        "name": "Applix Spreadsheets spreadsheet",
        "pattern": ["*.as"],
        "magic": [{"offset": 0, "value": b"*BEGIN SPREADSHEETS"}, {"offset": 0, "value": b"*BEGIN"}],
    },
    {"type": "application/x-applix-word", "name": "Applix Words document", "pattern": ["*.aw"], "magic": []},
    {
        "type": "application/x-arc",
        "name": "ARC archive",
        "pattern": [],
        "magic": [
            {"offset": 0, "value": b"\x00\x00\x08\x1a"},
            {"offset": 0, "value": b"\x00\x00\t\x1a"},
            {"offset": 0, "value": b"\x00\x00\x02\x1a"},
            {"offset": 0, "value": b"\x00\x00\x03\x1a"},
            {"offset": 0, "value": b"\x00\x00\x04\x1a"},
            {"offset": 0, "value": b"\x00\x00\x06\x1a"},
        ],
    },
    {
        "type": "application/x-arj",
        "name": "ARJ archive",
        "pattern": ["*.arj"],
        "magic": [{"offset": 0, "value": b"\xea`"}],
    },
    {
        "type": "application/x-asar",
        "name": "Electron Archive (ASAR)",
        "pattern": ["*.asar"],
        "magic": [{"offset": 0, "value": b"\x04\x00\x00\x00"}],
    },
    {"type": "application/x-asp", "name": "ASP page", "pattern": ["*.asp"], "magic": []},
    {
        "type": "application/x-awk",
        "name": "AWK script",
        "pattern": ["*.awk"],
        "magic": [
            {"offset": 0, "value": b"#!/bin/gawk"},
            {"offset": 0, "value": b"#! /bin/gawk"},
            {"offset": 0, "value": b"#!/usr/bin/gawk"},
            {"offset": 0, "value": b"#! /usr/bin/gawk"},
            {"offset": 0, "value": b"#!/usr/local/bin/gawk"},
            {"offset": 0, "value": b"#! /usr/local/bin/gawk"},
            {"offset": 0, "value": b"#!/bin/awk"},
            {"offset": 0, "value": b"#! /bin/awk"},
            {"offset": 0, "value": b"#!/usr/bin/awk"},
            {"offset": 0, "value": b"#! /usr/bin/awk"},
        ],
    },
    {"type": "application/x-bcpio", "name": "BCPIO archive", "pattern": ["*.bcpio"], "magic": []},
    {
        "type": "application/x-bittorrent",
        "name": "BitTorrent seed file",
        "pattern": ["*.torrent"],
        "magic": [{"offset": 0, "value": b"d8:announce"}],
    },
    {
        "type": "application/x-blender",
        "name": "Blender scene",
        "pattern": ["*.blend", "*.blender"],
        "magic": [{"offset": 0, "value": b"BLENDER"}],
    },
    {
        "type": "application/x-bzdvi",
        "name": "TeX DVI document (bzip2-compressed)",
        "pattern": ["*.dvi.bz2"],
        "magic": [],
    },
    {
        "type": "application/x-bzip1",
        "name": "Bzip1 archive",
        "pattern": ["*.bz"],
        "magic": [{"offset": 0, "value": b"BZ0"}],
    },
    {
        "type": "application/x-bzip1-compressed-tar",
        "name": "Tar archive (bzip1-compressed)",
        "pattern": ["*.tar.bz", "*.tbz"],
        "magic": [],
    },
    {
        "type": "application/x-bzip2",
        "name": "Bzip2 archive",
        "pattern": ["*.bz2"],
        "magic": [{"offset": 0, "value": b"BZh"}],
    },
    {
        "type": "application/x-bzip2-compressed-tar",
        "name": "Tar archive (bzip2-compressed)",
        "pattern": ["*.tar.bz2", "*.tbz2", "*.tb2"],
        "magic": [],
    },
    {
        "type": "application/x-bzip3",
        "name": "Bzip3 archive",
        "pattern": ["*.bz3"],
        "magic": [{"offset": 0, "value": b"BZ3v1"}],
    },
    {
        "type": "application/x-bzip3-compressed-tar",
        "name": "Tar archive (bzip3-compressed)",
        "pattern": ["*.tar.bz3", "*.tbz3"],
        "magic": [],
    },
    {"type": "application/x-bzpdf", "name": "PDF document (bzip2-compressed)", "pattern": ["*.pdf.bz2"], "magic": []},
    {
        "type": "application/x-bzpostscript",
        "name": "PostScript document (bzip2-compressed)",
        "pattern": ["*.ps.bz2"],
        "magic": [],
    },
    {
        "type": "application/vnd.comicbook-rar",
        "name": "Comic book archive (rar container)",
        "pattern": ["*.cbr"],
        "magic": [],
    },
    {"type": "application/x-cb7", "name": "Comic book archive (7z container)", "pattern": ["*.cb7"], "magic": []},
    {"type": "application/x-cbt", "name": "Comic book archive (tar container)", "pattern": ["*.cbt"], "magic": []},
    {
        "type": "application/x-rzip",
        "name": "Rzip archive",
        "pattern": ["*.rz"],
        "magic": [{"offset": 0, "value": b"RZIP"}],
    },
    {
        "type": "application/x-rzip-compressed-tar",
        "name": "Tar archive (rzip-compressed)",
        "pattern": ["*.tar.rz", "*.trz"],
        "magic": [],
    },
    {
        "type": "application/x-lrzip",
        "name": "Lrzip archive",
        "pattern": ["*.lrz"],
        "magic": [{"offset": 0, "value": b"LRZI"}],
    },
    {
        "type": "application/x-lrzip-compressed-tar",
        "name": "Tar archive (lrzip-compressed)",
        "pattern": ["*.tar.lrz", "*.tlrz"],
        "magic": [],
    },
    {"type": "application/x-apple-diskimage", "name": "Apple disk image", "pattern": ["*.dmg"], "magic": []},
    {
        "type": "application/vnd.efi.img",
        "name": "Raw disk image",
        "pattern": ["*.raw-disk-image", "*.img"],
        "magic": [
            {"offset": 512, "value": b"EFI PART"},
            {"offset": 1024, "value": b"EFI PART"},
            {"offset": 2048, "value": b"EFI PART"},
            {"offset": 4096, "value": b"EFI PART"},
        ],
    },
    {
        "type": "application/x-raw-floppy-disk-image",
        "name": "Floppy disk image",
        "pattern": ["*.fd", "*.qd"],
        "magic": [],
    },
    {
        "type": "application/x-raw-disk-image-xz-compressed",
        "name": "Raw disk image (XZ-compressed)",
        "pattern": ["*.raw-disk-image.xz", "*.img.xz"],
        "magic": [],
    },
    {"type": "application/vnd.efi.iso", "name": "Raw CD image", "pattern": ["*.iso", "*.iso9660"], "magic": []},
    {
        "type": "application/x-compressed-iso",
        "name": "Compressed CD image",
        "pattern": ["*.cso"],
        "magic": [{"offset": 0, "value": b"CISO"}],
    },
    {
        "type": "application/x-cdrdao-toc",
        "name": "CD Table Of Contents",
        "pattern": ["*.toc"],
        "magic": [
            {"offset": 0, "value": b"CD_ROM\\n"},
            {"offset": 0, "value": b"CD_DA\\n"},
            {"offset": 0, "value": b"CD_ROM_XA\\n"},
            {"offset": 0, "value": b"CD_TEXT "},
            {"offset": 0, "value": b'CATALOG "'},
        ],
    },
    {"type": "application/x-gd-rom-cue", "name": "GD-ROM image cuesheet", "pattern": ["*.gdi"], "magic": []},
    {
        "type": "application/x-discjuggler-cd-image",
        "name": "Padus DiscJuggler CD image",
        "pattern": ["*.cdi"],
        "magic": [],
    },
    {
        "type": "application/vnd.chess-pgn",
        "name": "PGN chess game notation",
        "pattern": ["*.pgn"],
        "magic": [{"offset": 0, "value": b"[Event "}],
    },
    {"type": "application/vnd.ms-htmlhelp", "name": "CHM document", "pattern": ["*.chm"], "magic": []},
    {
        "type": "application/x-compress",
        "name": "UNIX-compressed file",
        "pattern": ["*.Z"],
        "magic": [{"offset": 0, "value": b"\x1f\x9d"}],
    },
    {
        "type": "application/x-compressed-tar",
        "name": "Tar archive (gzip-compressed)",
        "pattern": ["*.tar.gz", "*.tgz"],
        "magic": [],
    },
    {
        "type": "application/x-cpio",
        "name": "CPIO archive",
        "pattern": ["*.cpio"],
        "magic": [
            {"offset": 0, "value": b"\x07\x07\x07"},
            {"offset": 0, "value": b"070701"},
            {"offset": 0, "value": b"070702"},
        ],
    },
    {
        "type": "application/x-cpio-compressed",
        "name": "CPIO archive (gzip-compressed)",
        "pattern": ["*.cpio.gz"],
        "magic": [],
    },
    {
        "type": "application/x-perf-data",
        "name": "Perf data",
        "pattern": ["perf.data"],
        "magic": [{"offset": 0, "value": b"PERFILE2"}],
    },
    {
        "type": "application/x-csh",
        "name": "C shell script",
        "pattern": ["*.csh"],
        "magic": [
            {"offset": 2, "value": b"/bin/tcsh"},
            {"offset": 2, "value": b"/bin/csh"},
            {"offset": 2, "value": b"/bin/env csh"},
            {"offset": 2, "value": b"/bin/env tcsh"},
        ],
    },
    {"type": "application/vnd.dbf", "name": "Xbase document", "pattern": ["*.dbf"], "magic": []},
    {"type": "application/ecmascript", "name": "ECMAScript program", "pattern": ["*.es"], "magic": []},
    {
        "type": "application/x-mame-chd",
        "name": "MAME compressed hard disk image",
        "pattern": ["*.chd"],
        "magic": [{"offset": 0, "value": b"MComprHD"}],
    },
    {
        "type": "application/x-sega-cd-rom",
        "name": "Sega CD disc image",
        "pattern": ["*.iso"],
        "magic": [{"offset": 0, "value": b"SEGADISCSYSTEM"}, {"offset": 16, "value": b"SEGADISCSYSTEM"}],
    },
    {
        "type": "application/x-sega-pico-rom",
        "name": "Sega Pico ROM",
        "pattern": ["*.iso"],
        "magic": [{"offset": 256, "value": b"SEGA PICO"}],
    },
    {
        "type": "application/x-saturn-rom",
        "name": "Sega Saturn disc image",
        "pattern": ["*.iso"],
        "magic": [{"offset": 0, "value": b"SEGA SEGASATURN"}, {"offset": 16, "value": b"SEGA SEGASATURN"}],
    },
    {
        "type": "application/x-dreamcast-rom",
        "name": "Dreamcast disc image",
        "pattern": ["*.iso"],
        "magic": [{"offset": 16, "value": b"SEGA SEGAKATANA"}],
    },
    {"type": "application/x-nintendo-ds-rom", "name": "Nintendo DS ROM", "pattern": ["*.nds"], "magic": []},
    {
        "type": "application/x-nintendo-3ds-rom",
        "name": "Nintendo 3DS ROM",
        "pattern": ["*.3ds", "*.cci"],
        "magic": [{"offset": 256, "value": b"NCSD"}],
    },
    {
        "type": "application/x-nintendo-3ds-executable",
        "name": "Nintendo 3DS Executable",
        "pattern": ["*.3dsx"],
        "magic": [{"offset": 0, "value": b"3DSX"}],
    },
    {
        "type": "application/x-nintendo-switch-xci",
        "name": "Nintendo Switch encrypted ROM",
        "pattern": ["*.xci"],
        "magic": [{"offset": 256, "value": b"HEAD"}],
    },
    {"type": "application/x-pc-engine-rom", "name": "PC Engine ROM", "pattern": ["*.pce"], "magic": []},
    {
        "type": "application/x-wii-rom",
        "name": "Wii disc image",
        "pattern": ["*.iso"],
        "magic": [
            {"offset": 24, "value": b"]\x1c\x9e\xa3"},
            {"offset": 0, "value": b"WBFS"},
            {"offset": 0, "value": b"WII\x01DISC"},
        ],
    },
    {
        "type": "application/x-wii-wad",
        "name": "WiiWare bundle",
        "pattern": ["*.wad"],
        "magic": [
            {"offset": 4, "value": b"Is\x00\x00"},
            {"offset": 4, "value": b"ib\x00\x00"},
            {"offset": 4, "value": b"Bk\x00\x00"},
        ],
    },
    {
        "type": "application/x-gamecube-rom",
        "name": "GameCube disc image",
        "pattern": ["*.iso"],
        "magic": [{"offset": 28, "value": b"\xc23\x9f="}],
    },
    {
        "type": "application/x-thomson-cartridge-memo7",
        "name": "Thomson Mémo7 cartridge",
        "pattern": ["*.m7"],
        "magic": [],
    },
    {"type": "application/x-thomson-cassette", "name": "Thomson cassette", "pattern": ["*.k7"], "magic": []},
    {
        "type": "application/x-hfe-floppy-image",
        "name": "HFE floppy disk image",
        "pattern": ["*.hfe"],
        "magic": [{"offset": 0, "value": b"HXCPICFE"}],
    },
    {
        "type": "application/x-thomson-sap-image",
        "name": "SAP Thomson floppy disk image",
        "pattern": ["*.sap"],
        "magic": [{"offset": 1, "value": b"SYSTEME D'ARCHIVAGE PUKALL S.A.P. (c) Alexandre PUKALL Avril 1998"}],
    },
    {
        "type": "application/vnd.debian.binary-package",
        "name": "Debian package",
        "pattern": ["*.deb", "*.udeb"],
        "magic": [{"offset": 0, "value": b"!<arch>"}],
    },
    {"type": "text/x-kaitai-struct", "name": "Kaitai Struct definition file", "pattern": ["*.ksy"], "magic": []},
    {
        "type": "text/x-qml",
        "name": "Qt Markup Language file",
        "pattern": ["*.qml", "*.qmltypes", "*.qmlproject"],
        "magic": [
            {"offset": 2, "value": b"/bin/env qml"},
            {"offset": 0, "value": b"import Qt"},
            {"offset": 0, "value": b"import Qml"},
        ],
    },
    {
        "type": "application/x-desktop",
        "name": "Desktop entry",
        "pattern": ["*.desktop", "*.kdelnk"],
        "magic": [
            {"offset": 0, "value": b"[Desktop Entry]"},
            {"offset": 0, "value": b"[Desktop Action"},
            {"offset": 0, "value": b"[KDE Desktop Entry]"},
            {"offset": 0, "value": b"# Config File"},
            {"offset": 0, "value": b"# KDE Config File"},
        ],
    },
    {
        "type": "application/x-dvi",
        "name": "TeX DVI document",
        "pattern": ["*.dvi"],
        "magic": [{"offset": 0, "value": b"\x02\xf7"}],
    },
    {"type": "application/x-e-theme", "name": "Enlightenment theme", "pattern": ["*.etheme"], "magic": []},
    {"type": "application/x-egon", "name": "Egon Animator animation", "pattern": ["*.egon"], "magic": []},
    {
        "type": "application/x-executable",
        "name": "Executable",
        "pattern": [],
        "magic": [
            {"offset": 0, "value": b"\\177ELF"},
            {"offset": 0, "value": b"R\x1c"},
            {"offset": 0, "value": b"\x04 "},
            {"offset": 0, "value": b"\x04!"},
            {"offset": 0, "value": b"\x06\x03"},
        ],
    },
    {
        "type": "application/x-fluid",
        "name": "FLTK Fluid file",
        "pattern": ["*.fl"],
        "magic": [{"offset": 0, "value": b"# data file for the Fltk"}],
    },
    {"type": "font/woff", "name": "WOFF font", "pattern": ["*.woff"], "magic": [{"offset": 0, "value": b"wOFF"}]},
    {"type": "font/woff2", "name": "WOFF2 font", "pattern": ["*.woff2"], "magic": [{"offset": 0, "value": b"wOF2"}]},
    {
        "type": "application/x-font-type1",
        "name": "PostScript type-1 font",
        "pattern": ["*.pfa", "*.pfb", "*.gsf"],
        "magic": [
            {"offset": 0, "value": b"LWFN"},
            {"offset": 65, "value": b"LWFN"},
            {"offset": 0, "value": b"%!PS-AdobeFont-1."},
            {"offset": 6, "value": b"%!PS-AdobeFont-1."},
            {"offset": 0, "value": b"%!FontType1-1."},
            {"offset": 6, "value": b"%!FontType1-1."},
        ],
    },
    {"type": "application/x-font-afm", "name": "Adobe font metrics", "pattern": ["*.afm"], "magic": []},
    {
        "type": "application/x-font-bdf",
        "name": "BDF font",
        "pattern": ["*.bdf"],
        "magic": [{"offset": 0, "value": b"STARTFONT "}],
    },
    {
        "type": "application/x-font-dos",
        "name": "DOS font",
        "pattern": [],
        "magic": [
            {"offset": 0, "value": b"\xffFON"},
            {"offset": 7, "value": b"\x00EGA"},
            {"offset": 7, "value": b"\x00VID"},
        ],
    },
    {
        "type": "application/x-font-framemaker",
        "name": "Adobe FrameMaker font",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"<MakerScreenFont"}],
    },
    {
        "type": "application/x-font-libgrx",
        "name": "LIBGRX font",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"\x14\x02Y\x19"}],
    },
    {
        "type": "application/x-font-linux-psf",
        "name": "Linux PSF console font",
        "pattern": ["*.psf"],
        "magic": [{"offset": 0, "value": b"6\x04"}],
    },
    {
        "type": "application/x-gz-font-linux-psf",
        "name": "Linux PSF console font (gzip-compressed)",
        "pattern": ["*.psf.gz"],
        "magic": [],
    },
    {
        "type": "application/x-font-pcf",
        "name": "PCF font",
        "pattern": ["*.pcf", "*.pcf.Z", "*.pcf.gz"],
        "magic": [{"offset": 0, "value": b"\x01fcp"}],
    },
    {"type": "font/otf", "name": "OpenType font", "pattern": ["*.otf"], "magic": [{"offset": 0, "value": b"OTTO"}]},
    {
        "type": "application/x-font-speedo",
        "name": "Speedo font",
        "pattern": ["*.spd"],
        "magic": [{"offset": 0, "value": b"D1.0\r"}],
    },
    {
        "type": "application/x-font-sunos-news",
        "name": "SunOS News font",
        "pattern": [],
        "magic": [
            {"offset": 0, "value": b"StartFont"},
            {"offset": 0, "value": b"\x13z)"},
            {"offset": 8, "value": b"\x13z+"},
        ],
    },
    {
        "type": "application/font-tdpfr",
        "name": "TDPFR font",
        "pattern": ["*.pfr"],
        "magic": [{"offset": 0, "value": b"PFR0"}, {"offset": 0, "value": b"PFR1"}],
    },
    {
        "type": "application/x-font-tex",
        "name": "TeX font",
        "pattern": [],
        "magic": [
            {"offset": 0, "value": b"\\367\\203"},
            {"offset": 0, "value": b"\\367\\131"},
            {"offset": 0, "value": b"\\367\\312"},
        ],
    },
    {
        "type": "application/x-font-tex-tfm",
        "name": "TeX font metrics",
        "pattern": [],
        "magic": [{"offset": 2, "value": b"\x00\x11"}, {"offset": 2, "value": b"\x00\x12"}],
    },
    {
        "type": "font/ttf",
        "name": "TrueType font",
        "pattern": ["*.ttf"],
        "magic": [
            {"offset": 0, "value": b"FFIL"},
            {"offset": 65, "value": b"FFIL"},
            {"offset": 0, "value": b"\x00\x01\x00\x00\x00"},
        ],
    },
    {"type": "font/collection", "name": "Font collection", "pattern": ["*.ttc"], "magic": []},
    {"type": "application/x-font-vfont", "name": "V font", "pattern": [], "magic": [{"offset": 0, "value": b"FONT"}]},
    {
        "type": "application/vnd.framemaker",
        "name": "Adobe FrameMaker document",
        "pattern": ["*.fm"],
        "magic": [
            {"offset": 0, "value": b"<MakerFile"},
            {"offset": 0, "value": b"<MIFFile"},
            {"offset": 0, "value": b"<MakerDictionary"},
            {"offset": 0, "value": b"<MakerScreenFon"},
            {"offset": 0, "value": b"<MML"},
            {"offset": 0, "value": b"<Book"},
            {"offset": 0, "value": b"<Maker"},
        ],
    },
    {
        "type": "application/x-gameboy-rom",
        "name": "Game Boy ROM",
        "pattern": ["*.gb", "*.sgb"],
        "magic": [
            {
                "offset": 260,
                "value": b"\xce\xedff\xcc\r\x00\x0b\x03s\x00\x83\x00\x0c\x00\r\x00\x08\x11\x1f\x88\x89\x00\x0e",
            }
        ],
    },
    {
        "type": "application/x-gameboy-color-rom",
        "name": "Game Boy Color ROM",
        "pattern": ["*.gbc", "*.cgb"],
        "magic": [{"offset": 260, "value": b"\xce\xedff\xcc\r\x00\x0b\x03s\x00\x83\x00\x0c\x00\r\x00\x08"}],
    },
    {"type": "application/x-gba-rom", "name": "Game Boy Advance ROM", "pattern": ["*.gba", "*.agb"], "magic": []},
    {"type": "application/x-virtual-boy-rom", "name": "Virtual Boy ROM", "pattern": ["*.vb"], "magic": []},
    {
        "type": "application/x-gdbm",
        "name": "GDBM database",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"\x13W\x9a\xce"}, {"offset": 0, "value": b"GDBM"}],
    },
    {
        "type": "application/x-genesis-rom",
        "name": "Genesis ROM",
        "pattern": ["*.gen", "*.smd", "*.md", "*.sgd"],
        "magic": [
            {"offset": 256, "value": b"SEGA GENESIS"},
            {"offset": 256, "value": b"SEGA MEGADRIVE"},
            {"offset": 256, "value": b"SEGA MEGA DRIVE"},
            {"offset": 256, "value": b"SEGA_MEGA_DRIVE"},
            {"offset": 256, "value": b"SEGA SSF"},
            {"offset": 640, "value": b"EAGN"},
            {"offset": 640, "value": b"EAMG"},
        ],
    },
    {
        "type": "application/x-genesis-32x-rom",
        "name": "Genesis 32X ROM",
        "pattern": ["*.32x", "*.mdx"],
        "magic": [{"offset": 256, "value": b"SEGA 32X"}],
    },
    {
        "type": "application/x-gettext-translation",
        "name": "Translated messages (machine-readable)",
        "pattern": ["*.gmo", "*.mo"],
        "magic": [{"offset": 0, "value": b"\\336\\22\\4\\225"}, {"offset": 0, "value": b"\\225\\4\\22\\336"}],
    },
    {
        "type": "application/x-gnucash",
        "name": "GnuCash financial data",
        "pattern": ["*.gnucash", "*.gnc", "*.xac"],
        "magic": [],
    },
    {
        "type": "application/x-gnumeric",
        "name": "Gnumeric spreadsheet",
        "pattern": ["*.gnumeric"],
        "magic": [{"offset": 0, "value": b"gmr:Workbook"}, {"offset": 0, "value": b"gnm:Workbook"}],
    },
    {
        "type": "application/x-gnuplot",
        "name": "Gnuplot document",
        "pattern": ["*.gp", "*.gplt", "*.gnuplot"],
        "magic": [],
    },
    {"type": "application/x-graphite", "name": "Graphite scientific graph", "pattern": ["*.gra"], "magic": []},
    {
        "type": "application/x-gtktalog",
        "name": "GTKtalog catalog",
        "pattern": [],
        "magic": [{"offset": 4, "value": b"gtktalog "}],
    },
    {"type": "application/x-gzdvi", "name": "TeX DVI document (gzip-compressed)", "pattern": ["*.dvi.gz"], "magic": []},
    {
        "type": "application/gzip",
        "name": "Gzip archive",
        "pattern": ["*.gz"],
        "magic": [{"offset": 0, "value": b"\x1f\x8b"}],
    },
    {"type": "application/x-gzpdf", "name": "PDF document (gzip-compressed)", "pattern": ["*.pdf.gz"], "magic": []},
    {
        "type": "application/x-gzpostscript",
        "name": "PostScript document (gzip-compressed)",
        "pattern": ["*.ps.gz"],
        "magic": [],
    },
    {
        "type": "application/x-hdf",
        "name": "HDF document",
        "pattern": ["*.hdf", "*.hdf4", "*.h4", "*.hdf5", "*.h5"],
        "magic": [{"offset": 0, "value": b"\x89HDF\r\n\x1a\n"}, {"offset": 0, "value": b"\x0e\x03\x13\x01"}],
    },
    {"type": "application/x-iff", "name": "IFF file", "pattern": [], "magic": [{"offset": 0, "value": b"FORM"}]},
    {
        "type": "application/x-ipod-firmware",
        "name": "iPod firmware",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"S T O P"}],
    },
    {
        "type": "application/x-java",
        "name": "Java class",
        "pattern": ["*.class"],
        "magic": [{"offset": 0, "value": b"\xca\xfe\xba\xbe"}],
    },
    {
        "type": "text/x-groovy",
        "name": "Groovy source code",
        "pattern": ["*.groovy", "*.gvy", "*.gy", "*.gsh"],
        "magic": [
            {"offset": 0, "value": b"//"},
            {"offset": 0, "value": b"/*"},
            {"offset": 0, "value": b"class"},
            {"offset": 0, "value": b"import"},
            {"offset": 0, "value": b"package"},
        ],
    },
    {"type": "text/x-gradle", "name": "Gradle script", "pattern": ["*.gradle"], "magic": []},
    {
        "type": "application/x-java-keystore",
        "name": "Java keystore",
        "pattern": ["*.jks", "*.ks", "cacerts"],
        "magic": [{"offset": 0, "value": b"\xfe\xed\xfe\xed"}],
    },
    {
        "type": "application/x-java-jce-keystore",
        "name": "Java JCE keystore",
        "pattern": ["*.jceks"],
        "magic": [{"offset": 0, "value": b"\xce\xce\xce\xce"}],
    },
    {
        "type": "application/x-java-pack200",
        "name": "Pack200 Java archive",
        "pattern": ["*.pack"],
        "magic": [{"offset": 0, "value": b"\xca\xfe\xd0\r"}],
    },
    {
        "type": "text/javascript",
        "name": "JavaScript program",
        "pattern": ["*.cjs", "*.js", "*.jsm", "*.mjs"],
        "magic": [
            {"offset": 0, "value": b"#!/bin/gjs"},
            {"offset": 0, "value": b"#! /bin/gjs"},
            {"offset": 0, "value": b'eval \\"exec /bin/gjs'},
            {"offset": 0, "value": b"#!/usr/bin/gjs"},
            {"offset": 0, "value": b"#! /usr/bin/gjs"},
            {"offset": 0, "value": b'eval \\"exec /usr/bin/gjs'},
            {"offset": 0, "value": b"#!/usr/local/bin/gjs"},
            {"offset": 0, "value": b"#! /usr/local/bin/gjs"},
            {"offset": 0, "value": b'eval \\"exec /usr/local/bin/gjs'},
            {"offset": 2, "value": b"/bin/env gjs"},
        ],
    },
    {
        "type": "text/jscript.encode",
        "name": "Encoded JScript program",
        "pattern": ["*.jse"],
        "magic": [{"offset": 0, "value": b"#@~^"}],
    },
    {
        "type": "application/typescript",
        "name": "TypeScript program",
        "pattern": ["*.cts", "*.mts", "*.ts"],
        "magic": [{"offset": 0, "value": b"function"}],
    },
    {"type": "application/json", "name": "JSON document", "pattern": ["*.json"], "magic": []},
    {"type": "application/json5", "name": "JSON5 document", "pattern": ["*.json5"], "magic": []},
    {"type": "application/vnd.coffeescript", "name": "CoffeeScript document", "pattern": ["*.coffee"], "magic": []},
    {"type": "application/x-jbuilder-project", "name": "JBuilder project", "pattern": ["*.jpr", "*.jpx"], "magic": []},
    {"type": "application/x-kexi-connectiondata", "name": "Kexi settings", "pattern": ["*.kexic"], "magic": []},
    {"type": "application/x-kexiproject-shortcut", "name": "Kexi shortcut", "pattern": ["*.kexis"], "magic": []},
    {"type": "application/x-kexiproject-sqlite2", "name": "Kexi database file", "pattern": ["*.kexi"], "magic": []},
    {"type": "application/x-kexiproject-sqlite3", "name": "Kexi database file", "pattern": ["*.kexi"], "magic": []},
    {"type": "application/x-killustrator", "name": "KIllustrator drawing", "pattern": ["*.kil"], "magic": []},
    {"type": "application/x-kpovmodeler", "name": "KPovModeler scene", "pattern": ["*.kpm"], "magic": []},
    {
        "type": "application/x-kspread-crypt",
        "name": "KSpread spreadsheet (encrypted)",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"\r\x1a'\x02"}],
    },
    {
        "type": "application/x-ksysv-package",
        "name": "KSysV init package",
        "pattern": [],
        "magic": [{"offset": 4, "value": b"KSysV"}],
    },
    {"type": "application/x-kugar", "name": "Kugar document", "pattern": ["*.kud"], "magic": []},
    {
        "type": "application/x-kword-crypt",
        "name": "KWord document (encrypted)",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"\r\x1a'\x01"}],
    },
    {
        "type": "application/x-lha",
        "name": "LHA archive",
        "pattern": ["*.lha", "*.lzh"],
        "magic": [
            {"offset": 2, "value": b"-lh -"},
            {"offset": 2, "value": b"-lh0-"},
            {"offset": 2, "value": b"-lh1-"},
            {"offset": 2, "value": b"-lh2-"},
            {"offset": 2, "value": b"-lh3-"},
            {"offset": 2, "value": b"-lh4-"},
            {"offset": 2, "value": b"-lh5-"},
            {"offset": 2, "value": b"-lh40-"},
            {"offset": 2, "value": b"-lhd-"},
            {"offset": 2, "value": b"-lz4-"},
            {"offset": 2, "value": b"-lz5-"},
            {"offset": 2, "value": b"-lzs-"},
        ],
    },
    {"type": "application/x-lhz", "name": "LHZ archive", "pattern": ["*.lhz"], "magic": []},
    {
        "type": "application/x-lyx",
        "name": "LyX document",
        "pattern": ["*.lyx"],
        "magic": [{"offset": 0, "value": b"#LyX"}],
    },
    {
        "type": "application/x-lz4",
        "name": "LZ4 archive",
        "pattern": ["*.lz4"],
        "magic": [{"offset": 0, "value": b'\x18M"\x04'}, {"offset": 0, "value": b"\x18L!\x02"}],
    },
    {
        "type": "application/x-lz4-compressed-tar",
        "name": "Tar archive (LZ4-compressed)",
        "pattern": ["*.tar.lz4"],
        "magic": [],
    },
    {
        "type": "application/x-lzip",
        "name": "Lzip archive",
        "pattern": ["*.lz"],
        "magic": [{"offset": 0, "value": b"LZIP"}],
    },
    {
        "type": "application/x-lzip-compressed-tar",
        "name": "Tar archive (lzip-compressed)",
        "pattern": ["*.tar.lz"],
        "magic": [],
    },
    {"type": "application/x-lzpdf", "name": "PDF document (lzip-compressed)", "pattern": ["*.pdf.lz"], "magic": []},
    {"type": "application/x-lzma", "name": "LZMA archive", "pattern": ["*.lzma"], "magic": []},
    {
        "type": "application/x-lzma-compressed-tar",
        "name": "Tar archive (LZMA-compressed)",
        "pattern": ["*.tar.lzma", "*.tlz"],
        "magic": [],
    },
    {
        "type": "application/x-lzop",
        "name": "LZO archive",
        "pattern": ["*.lzo"],
        "magic": [{"offset": 0, "value": b"\x89LZO\x00\r\n\x1a\n"}],
    },
    {
        "type": "application/x-qpress",
        "name": "Qpress archive",
        "pattern": ["*.qp"],
        "magic": [{"offset": 0, "value": b"qpress10"}],
    },
    {
        "type": "application/x-xar",
        "name": "XAR archive",
        "pattern": ["*.xar", "*.pkg"],
        "magic": [{"offset": 0, "value": b"xar!"}],
    },
    {"type": "application/zlib", "name": "Zlib archive", "pattern": ["*.zz"], "magic": []},
    {"type": "application/x-magicpoint", "name": "MagicPoint presentation", "pattern": ["*.mgp"], "magic": []},
    {
        "type": "application/x-macbinary",
        "name": "Macintosh MacBinary file",
        "pattern": [],
        "magic": [{"offset": 102, "value": b"mBIN"}],
    },
    {
        "type": "application/x-matroska",
        "name": "Matroska stream",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"\x1aE\xdf\xa3"}],
    },
    {"type": "video/x-matroska", "name": "Matroska video", "pattern": ["*.mkv"], "magic": []},
    {"type": "video/x-matroska-3d", "name": "Matroska 3D video", "pattern": ["*.mk3d"], "magic": []},
    {"type": "audio/x-matroska", "name": "Matroska audio", "pattern": ["*.mka"], "magic": []},
    {"type": "video/webm", "name": "WebM video", "pattern": ["*.webm"], "magic": []},
    {"type": "application/x-mimearchive", "name": "MHTML web archive", "pattern": ["*.mhtml", "*.mht"], "magic": []},
    {
        "type": "application/mxf",
        "name": "MXF video",
        "pattern": ["*.mxf"],
        "magic": [{"offset": 0, "value": b"\x06\x0e+4\x02\x05\x01\x01\r\x01\x02\x01\x01\x02"}],
    },
    {"type": "text/x-ocl", "name": "OCL file", "pattern": ["*.ocl"], "magic": []},
    {"type": "text/x-cobol", "name": "COBOL source code", "pattern": ["*.cbl", "*.cob"], "magic": []},
    {
        "type": "application/x-mobipocket-ebook",
        "name": "Mobipocket e-book",
        "pattern": ["*.mobi", "*.prc"],
        "magic": [{"offset": 60, "value": b"BOOKMOBI"}],
    },
    {"type": "application/x-mif", "name": "Adobe FrameMaker MIF document", "pattern": ["*.mif"], "magic": []},
    {
        "type": "application/x-mozilla-bookmarks",
        "name": "Mozilla bookmarks",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"<!DOCTYPE NETSCAPE-Bookmark-file-1>"}],
    },
    {
        "type": "application/x-dosexec",
        "name": "DOS executable",
        "pattern": ["*.exe"],
        "magic": [{"offset": 0, "value": b"MZ"}],
    },
    {
        "type": "application/x-ms-ne-executable",
        "name": "16-bit Windows program",
        "pattern": ["*.exe", "*.dll", "*.cpl", "*.drv", "*.scr"],
        "magic": [],
    },
    {
        "type": "application/vnd.microsoft.portable-executable",
        "name": "Windows or EFI program",
        "pattern": ["*.exe", "*.dll", "*.cpl", "*.drv", "*.scr", "*.efi", "*.ocx", "*.sys"],
        "magic": [],
    },
    {
        "type": "application/x-ms-pdb",
        "name": "Windows program database",
        "pattern": ["*.pdb"],
        "magic": [
            {"offset": 0, "value": b"Microsoft C/C++ MSF 7.00\r\n\x1aDS"},
            {"offset": 0, "value": b"Microsoft C/C++ program database 2.00\r\n\x1aJG"},
        ],
    },
    {"type": "application/x-bat", "name": "DOS/Windows batch file", "pattern": ["*.bat"], "magic": []},
    {
        "type": "application/x-powershell",
        "name": "PowerShell script",
        "pattern": ["*.ps1"],
        "magic": [
            {"offset": 0, "value": b"#Requires -PSEdition Core"},
            {"offset": 0, "value": b"#Requires -PSEdition Desktop"},
        ],
    },
    {
        "type": "application/x-ms-shortcut",
        "name": "Windows shortcut",
        "pattern": ["*.lnk"],
        "magic": [
            {"offset": 0, "value": b"L\x00\x00\x00\x01\x14\x02\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00F"}
        ],
    },
    {
        "type": "application/x-mswinurl",
        "name": "Internet shortcut",
        "pattern": ["*.url"],
        "magic": [{"offset": 1, "value": b"InternetShortcut"}, {"offset": 1, "value": b"DEFAULT"}],
    },
    {"type": "application/x-mswrite", "name": "WRI document", "pattern": ["*.wri"], "magic": []},
    {"type": "application/x-msx-rom", "name": "MSX ROM", "pattern": ["*.msx"], "magic": []},
    {"type": "application/x-m4", "name": "M4 macro", "pattern": ["*.m4"], "magic": []},
    {
        "type": "application/x-n64-rom",
        "name": "Nintendo64 ROM",
        "pattern": ["*.n64", "*.z64", "*.v64"],
        "magic": [
            {"offset": 0, "value": b"\x807\x12@"},
            {"offset": 0, "value": b"7\x80@\x12"},
            {"offset": 0, "value": b"@\x127\x80"},
        ],
    },
    {
        "type": "application/x-nautilus-link",
        "name": "Nautilus link",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"<nautilus_object nautilus_link"}],
    },
    {"type": "application/x-neo-geo-pocket-rom", "name": "Neo-Geo Pocket ROM", "pattern": ["*.ngp"], "magic": []},
    {
        "type": "application/x-neo-geo-pocket-color-rom",
        "name": "Neo-Geo Pocket Color ROM",
        "pattern": ["*.ngc"],
        "magic": [],
    },
    {"type": "application/x-nes-rom", "name": "NES ROM", "pattern": ["*.nes", "*.nez", "*.unf", "*.unif"], "magic": []},
    {"type": "application/x-netcdf", "name": "Unidata NetCDF document", "pattern": ["*.cdf", "*.nc"], "magic": []},
    {"type": "application/x-object", "name": "Object code", "pattern": ["*.o", "*.mod"], "magic": []},
    {
        "type": "application/ogg",
        "name": "Ogg multimedia file",
        "pattern": ["*.ogx"],
        "magic": [{"offset": 0, "value": b"OggS"}],
    },
    {"type": "audio/ogg", "name": "Ogg audio", "pattern": ["*.oga", "*.ogg", "*.opus"], "magic": []},
    {"type": "video/ogg", "name": "Ogg video", "pattern": ["*.ogv", "*.ogg"], "magic": []},
    {"type": "audio/x-vorbis+ogg", "name": "Ogg Vorbis audio", "pattern": ["*.oga", "*.ogg"], "magic": []},
    {"type": "audio/x-flac+ogg", "name": "Ogg FLAC audio", "pattern": ["*.oga", "*.ogg"], "magic": []},
    {"type": "audio/x-opus+ogg", "name": "Opus audio", "pattern": ["*.opus"], "magic": []},
    {"type": "audio/x-speex+ogg", "name": "Ogg Speex audio", "pattern": ["*.oga", "*.ogg", "*.spx"], "magic": []},
    {"type": "audio/x-speex", "name": "Speex audio", "pattern": ["*.spx"], "magic": [{"offset": 0, "value": b"Speex"}]},
    {"type": "video/x-theora+ogg", "name": "Ogg Theora video", "pattern": ["*.ogg"], "magic": []},
    {"type": "video/x-ogm+ogg", "name": "OGM video", "pattern": ["*.ogm"], "magic": []},
    {
        "type": "application/vnd.microsoft.windows.thumbnail-cache",
        "name": "Microsoft Windows Thumbnail Cache",
        "pattern": [
            "ehthumbs.db",
            "ehthumbs_vista.db",
            "image.db",
            "musicthumbs.db",
            "thumbs.db",
            "tvthumb.db",
            "video.db",
        ],
        "magic": [],
    },
    {"type": "application/vnd.ms-publisher", "name": "Microsoft Publisher document", "pattern": ["*.pub"], "magic": []},
    {
        "type": "application/vnd.quark.quarkxpress",
        "name": "QuarkXPress document",
        "pattern": ["*.qwd", "*.qwt", "*.qxb", "*.qxd", "*.qxl", "*.qxp", "*.qxt"],
        "magic": [{"offset": 4, "value": b"XPR3"}],
    },
    {"type": "application/x-msi", "name": "Windows Installer package", "pattern": ["*.msi"], "magic": []},
    {"type": "application/microsoftpatch", "name": "Windows Installer patch", "pattern": ["*.msp"], "magic": []},
    {"type": "application/microsoftupdate", "name": "Windows Update package", "pattern": ["*.msu"], "magic": []},
    {
        "type": "application/x-oleo",
        "name": "GNU Oleo spreadsheet",
        "pattern": ["*.oleo"],
        "magic": [{"offset": 31, "value": b"Oleo"}],
    },
    {"type": "application/x-pak", "name": "PAK archive", "pattern": ["*.pak"], "magic": []},
    {
        "type": "application/vnd.palm",
        "name": "Palm OS database",
        "pattern": ["*.prc", "*.pdb", "*.pqa", "*.oprc"],
        "magic": [],
    },
    {
        "type": "application/x-par2",
        "name": "Parchive archive",
        "pattern": ["*.PAR2", "*.par2"],
        "magic": [{"offset": 0, "value": b"PAR2"}],
    },
    {
        "type": "application/x-pef-executable",
        "name": "PEF executable",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"Joy!"}],
    },
    {
        "type": "application/x-perl",
        "name": "Perl script",
        "pattern": ["*.pl", "*.PL", "*.pm", "*.al", "*.perl", "*.pod", "*.t"],
        "magic": [
            {"offset": 0, "value": b'eval \\"exec /usr/local/bin/perl'},
            {"offset": 2, "value": b"/bin/perl"},
            {"offset": 2, "value": b"/bin/env perl"},
            {"offset": 0, "value": b"use Test::"},
            {"offset": 0, "value": b"use strict"},
            {"offset": 0, "value": b"use warnings"},
            {"offset": 0, "value": b"use diagnostics"},
            {"offset": 0, "value": b"\\n=pod"},
            {"offset": 0, "value": b"\\n=head1 NAME"},
            {"offset": 0, "value": b"\\n=head1 DESCRIPTION"},
            {"offset": 0, "value": b"BEGIN {"},
        ],
    },
    {
        "type": "application/x-php",
        "name": "PHP script",
        "pattern": ["*.php", "*.php3", "*.php4", "*.php5", "*.phps"],
        "magic": [{"offset": 0, "value": b"<?php"}],
    },
    {
        "type": "application/x-pkcs7-certificates",
        "name": "PKCS#7 certificate bundle",
        "pattern": ["*.p7b", "*.spc"],
        "magic": [],
    },
    {"type": "application/pkcs12", "name": "PKCS#12 certificate bundle", "pattern": ["*.p12", "*.pfx"], "magic": []},
    {"type": "application/x-planperfect", "name": "PlanPerfect spreadsheet", "pattern": ["*.pln"], "magic": []},
    {
        "type": "application/x-pocket-word",
        "name": "Pocket Word document",
        "pattern": ["*.psw"],
        "magic": [{"offset": 0, "value": b"{\\\\pwi"}],
    },
    {"type": "application/x-profile", "name": "Profiler results", "pattern": ["gmon.out"], "magic": []},
    {"type": "application/x-pw", "name": "Pathetic Writer document", "pattern": ["*.pw"], "magic": []},
    {
        "type": "application/x-python-bytecode",
        "name": "Python bytecode",
        "pattern": ["*.pyc", "*.pyo"],
        "magic": [{"offset": 0, "value": b"\x99N\r\n"}],
    },
    {
        "type": "application/x-qtiplot",
        "name": "QtiPlot document",
        "pattern": ["*.qti", "*.qti.gz"],
        "magic": [{"offset": 0, "value": b"QtiPlot"}],
    },
    {
        "type": "application/x-quattropro",
        "name": "Quattro Pro spreadsheet",
        "pattern": ["*.wb1", "*.wb2", "*.wb3", "*.qpw"],
        "magic": [],
    },
    {"type": "application/x-qw", "name": "Quicken document", "pattern": ["*.qif"], "magic": []},
    {
        "type": "application/vnd.rar",
        "name": "RAR archive",
        "pattern": ["*.rar"],
        "magic": [{"offset": 0, "value": b"Rar!"}],
    },
    {"type": "application/x-dar", "name": "DAR archive", "pattern": ["*.dar"], "magic": []},
    {
        "type": "application/x-alz",
        "name": "Alzip archive",
        "pattern": ["*.alz"],
        "magic": [{"offset": 0, "value": b"ALZ"}],
    },
    {"type": "text/x-reject", "name": "Rejected patch", "pattern": ["*.rej"], "magic": []},
    {
        "type": "application/x-rpm",
        "name": "RPM package",
        "pattern": ["*.rpm"],
        "magic": [{"offset": 0, "value": b"\xed\xab\xee\xdb"}],
    },
    {"type": "application/x-source-rpm", "name": "Source RPM package", "pattern": ["*.src.rpm", "*.spm"], "magic": []},
    {
        "type": "application/x-ruby",
        "name": "Ruby script",
        "pattern": ["*.rb"],
        "magic": [
            {"offset": 2, "value": b"/bin/env ruby"},
            {"offset": 2, "value": b"/bin/ruby"},
            {"offset": 0, "value": b"def"},
            {"offset": 0, "value": b"module"},
        ],
    },
    {"type": "application/x-markaby", "name": "Markaby script", "pattern": ["*.mab"], "magic": []},
    {
        "type": "text/x-crystal",
        "name": "Crystal source code",
        "pattern": ["*.cr"],
        "magic": [{"offset": 0, "value": b"struct"}],
    },
    {
        "type": "text/julia",
        "name": "Julia source code",
        "pattern": ["*.jl"],
        "magic": [{"offset": 0, "value": b"include"}, {"offset": 0, "value": b"using"}],
    },
    {
        "type": "text/rust",
        "name": "Rust source code",
        "pattern": ["*.rs"],
        "magic": [
            {"offset": 0, "value": b"fn"},
            {"offset": 0, "value": b"impl"},
            {"offset": 0, "value": b"trait"},
            {"offset": 0, "value": b"use"},
        ],
    },
    {
        "type": "application/x-sc",
        "name": "SC/Xspread spreadsheet",
        "pattern": [],
        "magic": [{"offset": 38, "value": b"Spreadsheet"}],
    },
    {"type": "application/x-shar", "name": "Shell archive", "pattern": ["*.shar"], "magic": []},
    {"type": "application/x-shared-library-la", "name": "Libtool shared library", "pattern": ["*.la"], "magic": []},
    {"type": "application/x-sharedlib", "name": "Shared library", "pattern": ["*.so", "*.so.[0-9]*"], "magic": []},
    {
        "type": "application/x-shellscript",
        "name": "Shell script",
        "pattern": ["*.sh"],
        "magic": [
            {"offset": 10, "value": b"# This is a shell archive"},
            {"offset": 2, "value": b"/bin/bash"},
            {"offset": 2, "value": b"/bin/nawk"},
            {"offset": 2, "value": b"/bin/zsh"},
            {"offset": 2, "value": b"/bin/sh"},
            {"offset": 2, "value": b"/bin/ksh"},
            {"offset": 2, "value": b"/bin/dash"},
            {"offset": 2, "value": b"/bin/env sh"},
            {"offset": 2, "value": b"/bin/env bash"},
            {"offset": 2, "value": b"/bin/env zsh"},
            {"offset": 2, "value": b"/bin/env ksh"},
        ],
    },
    {
        "type": "application/x-fishscript",
        "name": "Fish shell script",
        "pattern": ["*.fish"],
        "magic": [{"offset": 2, "value": b"/bin/env fish"}],
    },
    {
        "type": "application/x-nuscript",
        "name": "Nushell script",
        "pattern": ["*.nu"],
        "magic": [{"offset": 2, "value": b"/bin/env nu"}],
    },
    {
        "type": "application/vnd.adobe.flash.movie",
        "name": "Shockwave Flash file",
        "pattern": ["*.swf", "*.spl"],
        "magic": [{"offset": 0, "value": b"FWS"}, {"offset": 0, "value": b"CWS"}],
    },
    {
        "type": "application/x-shorten",
        "name": "Shorten audio",
        "pattern": ["*.shn"],
        "magic": [{"offset": 0, "value": b"ajkg"}],
    },
    {"type": "application/x-siag", "name": "Siag spreadsheet", "pattern": ["*.siag"], "magic": []},
    {
        "type": "image/x-skencil",
        "name": "Skencil document",
        "pattern": ["*.sk", "*.sk1"],
        "magic": [{"offset": 0, "value": b"##Sketch"}],
    },
    {"type": "application/x-sg1000-rom", "name": "SG-1000 ROM", "pattern": ["*.sg"], "magic": []},
    {"type": "application/x-sms-rom", "name": "Master System ROM", "pattern": ["*.sms"], "magic": []},
    {"type": "application/x-gamegear-rom", "name": "Game Gear ROM", "pattern": ["*.gg"], "magic": []},
    {"type": "application/vnd.nintendo.snes.rom", "name": "Super NES ROM", "pattern": ["*.sfc", "*.smc"], "magic": []},
    {
        "type": "application/x-stuffit",
        "name": "StuffIt archive",
        "pattern": ["*.sit"],
        "magic": [{"offset": 0, "value": b"StuffIt "}, {"offset": 0, "value": b"SIT!"}],
    },
    {
        "type": "application/x-stuffitx",
        "name": "StuffIt X archive",
        "pattern": ["*.sitx"],
        "magic": [{"offset": 0, "value": b"StuffIt!"}],
    },
    {"type": "application/x-subrip", "name": "SubRip subtitles", "pattern": ["*.srt"], "magic": []},
    {
        "type": "text/vtt",
        "name": "WebVTT subtitles",
        "pattern": ["*.vtt"],
        "magic": [{"offset": 0, "value": b"WEBVTT"}],
    },
    {
        "type": "application/x-sami",
        "name": "SAMI subtitles",
        "pattern": ["*.smi", "*.sami"],
        "magic": [{"offset": 0, "value": b"<SAMI>"}],
    },
    {
        "type": "text/x-microdvd",
        "name": "MicroDVD subtitles",
        "pattern": ["*.sub"],
        "magic": [{"offset": 0, "value": b"{1}"}, {"offset": 0, "value": b"{0}"}, {"offset": 0, "value": b"}{"}],
    },
    {
        "type": "text/x-mpl2",
        "name": "MPL2 subtitles",
        "pattern": ["*.mpl"],
        "magic": [{"offset": 0, "value": b"[1]"}, {"offset": 0, "value": b"[0]"}, {"offset": 0, "value": b"]["}],
    },
    {
        "type": "text/x-mpsub",
        "name": "MPlayer subtitles",
        "pattern": ["*.sub"],
        "magic": [{"offset": 0, "value": b"FORMAT="}],
    },
    {
        "type": "text/x-ssa",
        "name": "SSA subtitles",
        "pattern": ["*.ssa", "*.ass"],
        "magic": [{"offset": 0, "value": b"[Script Info]"}, {"offset": 0, "value": b"Dialogue: "}],
    },
    {
        "type": "text/x-ssh-public-key",
        "name": "OpenSSH public key",
        "pattern": ["*.pub"],
        "magic": [
            {"offset": 0, "value": b"ssh-ed25519 "},
            {"offset": 0, "value": b"sk-ssh-ed25519@openssh.com "},
            {"offset": 0, "value": b"ecdsa-sha2-nistp521 "},
            {"offset": 0, "value": b"ecdsa-sha2-nistp384 "},
            {"offset": 0, "value": b"ecdsa-sha2-nistp256 "},
            {"offset": 0, "value": b"sk-ecdsa-sha2-nistp256@openssh.com "},
            {"offset": 0, "value": b"ssh-rsa "},
            {"offset": 0, "value": b"ssh-dss "},
        ],
    },
    {
        "type": "text/x-ssh-private-key",
        "name": "OpenSSH private key",
        "pattern": [],
        "magic": [{"offset": 0, "value": b"-----BEGIN OPENSSH PRIVATE KEY-----"}],
    },
    {
        "type": "text/x-subviewer",
        "name": "SubViewer subtitles",
        "pattern": ["*.sub"],
        "magic": [{"offset": 0, "value": b"[INFORMATION]"}],
    },
    {
        "type": "text/x-iMelody",
        "name": "iMelody ringtone",
        "pattern": ["*.imy", "*.ime"],
        "magic": [{"offset": 0, "value": b"BEGIN:IMELODY"}],
    },
    {
        "type": "application/vnd.smaf",
        "name": "SMAF audio",
        "pattern": ["*.mmf", "*.smaf"],
        "magic": [{"offset": 0, "value": b"MMMD"}],
    },
    {"type": "audio/x-xmf", "name": "XMF audio", "pattern": ["*.xmf"], "magic": [{"offset": 0, "value": b"XMF_"}]},
    {
        "type": "audio/mobile-xmf",
        "name": "Mobile XMF audio",
        "pattern": ["*.mxmf"],
        "magic": [{"offset": 0, "value": b"XMF_2.00\x00\x00\x00\x02"}],
    },
    {"type": "application/x-sv4cpio", "name": "SV4 CPIO archive", "pattern": ["*.sv4cpio"], "magic": []},
    {"type": "application/x-sv4crc", "name": "SV4 CPIO archive (with CRC)", "pattern": ["*.sv4crc"], "magic": []},
    {
        "type": "application/x-tar",
        "name": "Tar archive",
        "pattern": ["*.tar", "*.gtar", "*.gem"],
        "magic": [{"offset": 257, "value": b"ustar\x00"}, {"offset": 257, "value": b"ustar  \x00"}],
    },
    {"type": "application/x-tarz", "name": "Tar archive (compressed)", "pattern": ["*.tar.Z", "*.taz"], "magic": []},
    {"type": "application/x-tex-gf", "name": "Generic font file", "pattern": ["*.gf"], "magic": []},
    {"type": "application/x-tex-pk", "name": "Packed font file", "pattern": ["*.pk"], "magic": []},
    {
        "type": "application/x-tgif",
        "name": "TGIF document",
        "pattern": ["*.obj"],
        "magic": [{"offset": 0, "value": b"%TGIF"}],
    },
    {"type": "application/x-theme", "name": "Theme", "pattern": ["*.theme"], "magic": []},
    {
        "type": "application/x-trash",
        "name": "Backup file",
        "pattern": ["*~", "*%", "*.bak", "*.old", "*.sik"],
        "magic": [],
    },
    {
        "type": "text/troff",
        "name": "Troff document",
        "pattern": ["*.tr", "*.roff", "*.t"],
        "magic": [
            {"offset": 0, "value": b'.\\\\\\"'},
            {"offset": 0, "value": b"'\\\\\\\""},
            {"offset": 0, "value": b"'.\\\\\\\""},
            {"offset": 0, "value": b'\\\\\\"'},
        ],
    },
    {"type": "application/x-troff-man", "name": "Manual page", "pattern": ["*.man", "*.[1-9]"], "magic": []},
    {
        "type": "application/x-tzo",
        "name": "Tar archive (LZO-compressed)",
        "pattern": ["*.tar.lzo", "*.tzo"],
        "magic": [],
    },
    {
        "type": "application/x-xz",
        "name": "XZ archive",
        "pattern": ["*.xz"],
        "magic": [{"offset": 0, "value": b"\xfd7zXZ\x00"}],
    },
    {
        "type": "application/x-xz-compressed-tar",
        "name": "Tar archive (XZ-compressed)",
        "pattern": ["*.tar.xz", "*.txz"],
        "magic": [],
    },
    {
        "type": "application/x-zpaq",
        "name": "Zpaq Archive",
        "pattern": ["*.zpaq"],
        "magic": [{"offset": 0, "value": b"7kSt"}],
    },
    {
        "type": "application/zstd",
        "name": "Zstandard archive",
        "pattern": ["*.zst"],
        "magic": [{"offset": 0, "value": b"\xfd/\xb5("}],
    },
    {
        "type": "application/x-zstd-compressed-tar",
        "name": "Tar archive (Zstandard-compressed)",
        "pattern": ["*.tar.zst", "*.tzst"],
        "magic": [],
    },
    {"type": "application/x-xzpdf", "name": "PDF document (XZ-compressed)", "pattern": ["*.pdf.xz"], "magic": []},
    {"type": "application/x-ustar", "name": "Ustar archive", "pattern": ["*.ustar"], "magic": []},
    {"type": "application/x-wais-source", "name": "WAIS source code", "pattern": ["*.src"], "magic": []},
    {"type": "application/x-wpg", "name": "WordPerfect/Drawperfect image", "pattern": ["*.wpg"], "magic": []},
    {"type": "application/x-wonderswan-rom", "name": "Bandai WonderSwan ROM", "pattern": ["*.ws"], "magic": []},
    {
        "type": "application/x-wonderswan-color-rom",
        "name": "Bandai WonderSwan Color ROM",
        "pattern": ["*.wsc"],
        "magic": [],
    },
    {
        "type": "application/x-x509-ca-cert",
        "name": "DER/PEM/Netscape-encoded X.509 certificate",
        "pattern": ["*.der", "*.crt", "*.cert", "*.pem"],
        "magic": [
            {"offset": 0, "value": b"-----BEGIN CA CERTIFICATE-----"},
            {"offset": 0, "value": b"-----BEGIN TRUSTED CERTIFICATE-----"},
        ],
    },
    {
        "type": "application/x-zoo",
        "name": "Zoo archive",
        "pattern": ["*.zoo"],
        "magic": [{"offset": 20, "value": b"\xfd\xc4\xa7\xdc"}],
    },
    {
        "type": "application/zip",
        "name": "Zip archive",
        "pattern": ["*.zip", "*.zipx"],
        "magic": [{"offset": 0, "value": b"PK\x03\x04"}],
    },
    {
        "type": "application/x-ms-wim",
        "name": "WIM disk image",
        "pattern": ["*.wim", "*.swm"],
        "magic": [{"offset": 0, "value": b"MSWIM\x00\x00\x00"}],
    },
    {
        "type": "audio/ac3",
        "name": "Dolby Digital audio",
        "pattern": ["*.ac3"],
        "magic": [{"offset": 0, "value": b"\x0bw"}],
    },
    {
        "type": "audio/vnd.dts",
        "name": "DTS audio",
        "pattern": ["*.dts"],
        "magic": [
            {"offset": 0, "value": b"\x7f\xfe\x80\x01"},
            {"offset": 0, "value": b"\xfe\x7f\x01\x80"},
            {"offset": 0, "value": b"\x1f\xff\xe8\x00"},
            {"offset": 0, "value": b"\xff\x1f\x00\xe8"},
        ],
    },
    {"type": "audio/vnd.dts.hd", "name": "DTS-HD audio", "pattern": ["*.dtshd"], "magic": []},
    {
        "type": "audio/AMR",
        "name": "AMR audio",
        "pattern": ["*.amr"],
        "magic": [{"offset": 0, "value": b"#!AMR\\n"}, {"offset": 0, "value": b"#!AMR_MC1.0\\n"}],
    },
    {
        "type": "audio/AMR-WB",
        "name": "AMR-WB audio",
        "pattern": ["*.awb"],
        "magic": [{"offset": 0, "value": b"#!AMR-WB\\n"}, {"offset": 0, "value": b"#!AMR-WB_MC1.0\\n"}],
    },
    {
        "type": "audio/basic",
        "name": "ULAW (Sun) audio",
        "pattern": ["*.au", "*.snd"],
        "magic": [{"offset": 0, "value": b".snd"}],
    },
    {
        "type": "audio/prs.sid",
        "name": "Commodore 64 audio",
        "pattern": ["*.sid", "*.psid"],
        "magic": [{"offset": 0, "value": b"PSID"}],
    },
    {"type": "audio/x-adpcm", "name": "PCM audio", "pattern": [], "magic": [{"offset": 0, "value": b"\x00ds."}]},
    {
        "type": "audio/x-aifc",
        "name": "AIFC audio",
        "pattern": ["*.aifc", "*.aiffc"],
        "magic": [{"offset": 8, "value": b"AIFC"}],
    },
    {
        "type": "audio/x-aiff",
        "name": "AIFF/Amiga/Mac audio",
        "pattern": ["*.aiff", "*.aif"],
        "magic": [{"offset": 8, "value": b"AIFF"}, {"offset": 8, "value": b"8SVX"}],
    },
    {"type": "audio/x-ape", "name": "Monkey's audio", "pattern": ["*.ape"], "magic": [{"offset": 0, "value": b"MAC "}]},
    {
        "type": "audio/x-pn-audibleaudio",
        "name": "Audible.Com audio",
        "pattern": ["*.aa"],
        "magic": [{"offset": 4, "value": b"\x14i\x08I\x82"}],
    },
    {
        "type": "audio/vnd.audible.aax",
        "name": "Audible Enhanced audio",
        "pattern": ["*.aax"],
        "magic": [{"offset": 4, "value": b"ftypaax "}],
    },
    {
        "type": "audio/vnd.audible.aaxc",
        "name": "Audible Enhanced audio",
        "pattern": ["*.aaxc"],
        "magic": [{"offset": 4, "value": b"ftypaaxc"}],
    },
    {"type": "audio/x-dff", "name": "DSDIFF audio", "pattern": ["*.dff"], "magic": [{"offset": 0, "value": b"FRM8"}]},
    {"type": "audio/x-dsf", "name": "DSF audio", "pattern": ["*.dsf"], "magic": [{"offset": 0, "value": b"DSD "}]},
    {
        "type": "audio/x-it",
        "name": "Impulse Tracker audio",
        "pattern": ["*.it"],
        "magic": [{"offset": 0, "value": b"IMPM"}],
    },
    {"type": "audio/flac", "name": "FLAC audio", "pattern": ["*.flac"], "magic": [{"offset": 0, "value": b"fLaC"}]},
    {"type": "audio/x-tak", "name": "TAK audio", "pattern": ["*.tak"], "magic": [{"offset": 0, "value": b"tBaK"}]},
    {
        "type": "audio/x-wavpack",
        "name": "WavPack audio",
        "pattern": ["*.wv", "*.wvp"],
        "magic": [{"offset": 0, "value": b"wvpk"}],
    },
    {"type": "audio/x-wavpack-correction", "name": "WavPack audio correction file", "pattern": ["*.wvc"], "magic": []},
    {
        "type": "audio/midi",
        "name": "MIDI audio",
        "pattern": ["*.mid", "*.midi", "*.kar"],
        "magic": [{"offset": 0, "value": b"MThd"}],
    },
    {
        "type": "audio/x-mo3",
        "name": "Compressed Tracker audio",
        "pattern": ["*.mo3"],
        "magic": [{"offset": 0, "value": b"MO3"}],
    },
    {
        "type": "audio/aac",
        "name": "AAC audio",
        "pattern": ["*.aac", "*.adts", "*.ass"],
        "magic": [{"offset": 0, "value": b"ADIF"}, {"offset": 0, "value": b"\xff\xf0"}],
    },
    {"type": "audio/usac", "name": "USAC audio", "pattern": ["*.loas", "*.xhe"], "magic": []},
    {
        "type": "audio/mp4",
        "name": "MPEG-4 audio",
        "pattern": ["*.m4a", "*.f4a"],
        "magic": [{"offset": 4, "value": b"ftypM4A"}],
    },
    {"type": "audio/x-m4r", "name": "MPEG-4 ringtone", "pattern": ["*.m4r"], "magic": []},
    {
        "type": "video/mp4",
        "name": "MPEG-4 video",
        "pattern": ["*.mp4", "*.m4v", "*.f4v", "*.lrv", "*.lrf"],
        "magic": [
            {"offset": 4, "value": b"ftypisom"},
            {"offset": 4, "value": b"ftypmp41"},
            {"offset": 4, "value": b"ftypmp42"},
            {"offset": 4, "value": b"ftypMSNV"},
            {"offset": 4, "value": b"ftypM4V "},
            {"offset": 4, "value": b"ftypf4v "},
        ],
    },
    {
        "type": "audio/x-m4b",
        "name": "MPEG-4 audio book",
        "pattern": ["*.m4b", "*.f4b"],
        "magic": [{"offset": 4, "value": b"ftypM4B"}],
    },
    {
        "type": "video/3gpp",
        "name": "3GPP multimedia file",
        "pattern": ["*.3gp", "*.3gpp", "*.3ga"],
        "magic": [
            {"offset": 4, "value": b"ftyp3ge"},
            {"offset": 4, "value": b"ftyp3gg"},
            {"offset": 4, "value": b"ftyp3gp"},
            {"offset": 4, "value": b"ftyp3gs"},
        ],
    },
    {
        "type": "video/3gpp2",
        "name": "3GPP2 multimedia file",
        "pattern": ["*.3g2", "*.3gp2", "*.3gpp2"],
        "magic": [{"offset": 4, "value": b"ftyp3g2"}],
    },
    {
        "type": "audio/x-mod",
        "name": "Amiga SoundTracker audio",
        "pattern": ["*.mod", "*.ult", "*.uni", "*.m15", "*.mtm", "*.669", "*.med"],
        "magic": [
            {"offset": 0, "value": b"MTM"},
            {"offset": 0, "value": b"MMD0"},
            {"offset": 0, "value": b"MMD1"},
            {"offset": 0, "value": b"MAS_UTrack_V00"},
            {"offset": 1080, "value": b"M.K."},
            {"offset": 1080, "value": b"M!K!"},
        ],
    },
    {
        "type": "audio/x-dsp",
        "name": "Dynamic Studio module audio",
        "pattern": ["*.dsm", "*.dsp"],
        "magic": [{"offset": 0, "value": b"DSm\x1a "}],
    },
    {"type": "audio/mp2", "name": "MP2 audio", "pattern": ["*.mp2"], "magic": []},
    {
        "type": "audio/mpeg",
        "name": "MP3 audio",
        "pattern": ["*.mp3", "*.mpga"],
        "magic": [
            {"offset": 0, "value": b"\xff\xfa"},
            {"offset": 0, "value": b"\xff\xfb"},
            {"offset": 0, "value": b"\xff\xf3"},
            {"offset": 0, "value": b"\xff\xf2"},
            {"offset": 0, "value": b"\xff\xe3"},
            {"offset": 0, "value": b"\xff\xe2"},
            {"offset": 0, "value": b"ID3"},
        ],
    },
    {
        "type": "audio/x-mpegurl",
        "name": "Media playlist",
        "pattern": ["*.m3u", "*.m3u8", "*.vlc"],
        "magic": [{"offset": 0, "value": b"#EXTM3U"}],
    },
    {"type": "application/vnd.apple.mpegurl", "name": "Media playlist", "pattern": ["*.m3u", "*.m3u8"], "magic": []},
    {
        "type": "audio/x-ms-asx",
        "name": "Microsoft ASX playlist",
        "pattern": ["*.asx", "*.wax", "*.wvx", "*.wmx"],
        "magic": [
            {"offset": 0, "value": b"ASF "},
            {"offset": 0, "value": b"<ASX"},
            {"offset": 0, "value": b"<asx"},
            {"offset": 0, "value": b"<Asx"},
        ],
    },
    {"type": "audio/x-psf", "name": "PSF audio", "pattern": ["*.psf"], "magic": [{"offset": 0, "value": b"PSF"}]},
    {"type": "audio/x-minipsf", "name": "MiniPSF audio", "pattern": ["*.minipsf"], "magic": []},
    {"type": "audio/x-psflib", "name": "PSFlib audio library", "pattern": ["*.psflib"], "magic": []},
    {"type": "audio/x-ms-wma", "name": "Windows Media audio", "pattern": ["*.wma"], "magic": []},
    {
        "type": "audio/x-musepack",
        "name": "Musepack audio",
        "pattern": ["*.mpc", "*.mpp", "*.mp+"],
        "magic": [{"offset": 0, "value": b"MP+"}, {"offset": 0, "value": b"MPCK"}],
    },
    {"type": "audio/vnd.rn-realaudio", "name": "RealAudio document", "pattern": ["*.ra", "*.rax"], "magic": []},
    {"type": "application/ram", "name": "RealMedia playlist", "pattern": ["*.ram"], "magic": []},
    {"type": "video/vnd.rn-realvideo", "name": "RealVideo document", "pattern": ["*.rv", "*.rvx"], "magic": []},
    {
        "type": "application/vnd.rn-realmedia",
        "name": "RealMedia document",
        "pattern": ["*.rm", "*.rmj", "*.rmm", "*.rms", "*.rmx", "*.rmvb"],
        "magic": [{"offset": 0, "value": b".RMF"}],
    },
    {
        "type": "image/vnd.radiance",
        "name": "Radiance HDR image",
        "pattern": ["*.hdr", "*.pic", "*.rgbe", "*.xyze"],
        "magic": [{"offset": 0, "value": b"#?RADIANCE"}],
    },
    {"type": "image/vnd.rn-realpix", "name": "RealPix document", "pattern": ["*.rp"], "magic": []},
    {"type": "text/vnd.rn-realtext", "name": "RealText document", "pattern": ["*.rt"], "magic": []},
    {"type": "application/x-riff", "name": "RIFF container", "pattern": [], "magic": [{"offset": 0, "value": b"RIFF"}]},
    {
        "type": "audio/x-s3m",
        "name": "Scream Tracker 3 audio",
        "pattern": ["*.s3m"],
        "magic": [{"offset": 44, "value": b"SCRM"}],
    },
    {
        "type": "audio/x-scpls",
        "name": "MP3 ShoutCast playlist",
        "pattern": ["*.pls"],
        "magic": [
            {"offset": 0, "value": b"[playlist]"},
            {"offset": 0, "value": b"[Playlist]"},
            {"offset": 0, "value": b"[PLAYLIST]"},
        ],
    },
    {
        "type": "audio/x-stm",
        "name": "Scream Tracker audio",
        "pattern": ["*.stm"],
        "magic": [
            {"offset": 20, "value": b"!Scream!\x1a"},
            {"offset": 20, "value": b"!SCREAM!\x1a"},
            {"offset": 20, "value": b"BMOD2STM\x1a"},
        ],
    },
    {"type": "audio/x-voc", "name": "VOC audio", "pattern": ["*.voc"], "magic": []},
    {
        "type": "audio/vnd.wave",
        "name": "WAV audio",
        "pattern": ["*.wav"],
        "magic": [{"offset": 8, "value": b"WAVE"}, {"offset": 8, "value": b"WAV "}],
    },
    {
        "type": "audio/x-xi",
        "name": "FastTracker II instrument",
        "pattern": ["*.xi"],
        "magic": [{"offset": 0, "value": b"Extended Instrument:"}],
    },
    {
        "type": "audio/x-xm",
        "name": "FastTracker II audio",
        "pattern": ["*.xm"],
        "magic": [{"offset": 0, "value": b"Extended Module:"}],
    },
    {
        "type": "audio/x-tta",
        "name": "TrueAudio audio",
        "pattern": ["*.tta"],
        "magic": [{"offset": 0, "value": b"TTA1"}],
    },
    {
        "type": "image/bmp",
        "name": "Windows BMP image",
        "pattern": ["*.bmp", "*.dib"],
        "magic": [{"offset": 0, "value": b"BMxxxx\x00\x00"}, {"offset": 0, "value": b"BM"}],
    },
    {"type": "image/vnd.wap.wbmp", "name": "WBMP image", "pattern": ["*.wbmp"], "magic": []},
    {"type": "image/cgm", "name": "CGM image", "pattern": ["*.cgm"], "magic": []},
    {"type": "image/g3fax", "name": "CCITT G3 fax image", "pattern": ["*.g3"], "magic": []},
    {"type": "image/gif", "name": "GIF image", "pattern": ["*.gif"], "magic": [{"offset": 0, "value": b"GIF8"}]},
    {
        "type": "image/heif",
        "name": "HEIF image",
        "pattern": ["*.heic", "*.heif", "*.hif"],
        "magic": [
            {"offset": 4, "value": b"ftypmif1"},
            {"offset": 4, "value": b"ftypmsf1"},
            {"offset": 4, "value": b"ftypheic"},
            {"offset": 4, "value": b"ftypheix"},
            {"offset": 4, "value": b"ftyphevc"},
            {"offset": 4, "value": b"ftyphevx"},
        ],
    },
    {
        "type": "image/hej2k",
        "name": "JPEG 2000 image encapsulated in HEIF",
        "pattern": ["*.hej2"],
        "magic": [{"offset": 4, "value": b"ftypj2ki"}],
    },
    {
        "type": "image/avci",
        "name": "AVC-encoded image encapsulated in HEIF",
        "pattern": ["*.avci"],
        "magic": [{"offset": 4, "value": b"ftypavci"}],
    },
    {"type": "image/ief", "name": "IEF image", "pattern": ["*.ief"], "magic": []},
    {
        "type": "image/jpeg",
        "name": "JPEG image",
        "pattern": ["*.jpg", "*.jpeg", "*.jpe", "*.jfif"],
        "magic": [{"offset": 0, "value": b"\\377\\330\\377"}, {"offset": 0, "value": b"\xff\xd8"}],
    },
    {"type": "video/x-mjpeg", "name": "MJPEG video stream", "pattern": ["*.mjpeg", "*.mjpg"], "magic": []},
    {
        "type": "image/x-jp2-codestream",
        "name": "JPEG-2000 codestream",
        "pattern": ["*.j2c", "*.j2k", "*.jpc"],
        "magic": [{"offset": 0, "value": b"\xffO\xffQ"}],
    },
    {
        "type": "image/jp2",
        "name": "JPEG-2000 JP2 image",
        "pattern": ["*.jp2", "*.jpg2"],
        "magic": [{"offset": 0, "value": b"\x00\x00\x00\x0cjP  \r\n\x87\n        jp2 "}],
    },
    {
        "type": "image/jpx",
        "name": "JPEG-2000 JPX image",
        "pattern": ["*.jpf", "*.jpx"],
        "magic": [{"offset": 0, "value": b"\x00\x00\x00\x0cjP  \r\n\x87\n        jpx "}],
    },
    {
        "type": "image/jpm",
        "name": "JPEG-2000 JPM image",
        "pattern": ["*.jpm", "*.jpgm"],
        "magic": [{"offset": 0, "value": b"\x00\x00\x00\x0cjP  \r\n\x87\n        jpm "}],
    },
    {
        "type": "video/mj2",
        "name": "JPEG-2000 MJ2 video",
        "pattern": ["*.mj2", "*.mjp2"],
        "magic": [{"offset": 0, "value": b"\x00\x00\x00\x0cjP  \r\n\x87\n        mjp2"}],
    },
    {
        "type": "image/jxl",
        "name": "JPEG XL image",
        "pattern": ["*.jxl"],
        "magic": [{"offset": 0, "value": b"\xff\n"}, {"offset": 0, "value": b"\x00\x00\x00\x0cJXL \r\n\x87\n"}],
    },
    {
        "type": "image/x-dds",
        "name": "DirectDraw surface",
        "pattern": ["*.dds"],
        "magic": [{"offset": 0, "value": b"DDS"}],
    },
    {"type": "image/x-xcursor", "name": "X11 cursor", "pattern": [], "magic": [{"offset": 0, "value": b"Xcur"}]},
    {
        "type": "image/x-exr",
        "name": "EXR image",
        "pattern": ["*.exr"],
        "magic": [{"offset": 0, "value": b" \x00\x060"}],
    },
    {
        "type": "image/x-pict",
        "name": "Macintosh Quickdraw/PICT drawing",
        "pattern": ["*.pct", "*.pict", "*.pict1", "*.pict2"],
        "magic": [{"offset": 10, "value": b"\x00\x11"}, {"offset": 522, "value": b"\x00\x11"}],
    },
    {"type": "image/x-adobe-dng", "name": "Adobe DNG negative", "pattern": ["*.dng"], "magic": []},
    {
        "type": "image/x-canon-crw",
        "name": "Canon CRW raw image",
        "pattern": ["*.crw"],
        "magic": [{"offset": 0, "value": b"II\x1a\x00\x00\x00HEAPCCDR"}],
    },
    {"type": "image/x-canon-cr2", "name": "Canon CR2 raw image", "pattern": ["*.cr2"], "magic": []},
    {"type": "image/x-canon-cr3", "name": "Canon CR3 raw image", "pattern": ["*.cr3"], "magic": []},
    {
        "type": "image/x-fuji-raf",
        "name": "Fuji RAF raw image",
        "pattern": ["*.raf"],
        "magic": [{"offset": 0, "value": b"FUJIFILMCCD-RAW "}],
    },
    {"type": "image/x-kodak-dcr", "name": "Kodak DCR raw image", "pattern": ["*.dcr"], "magic": []},
    {"type": "image/x-kodak-k25", "name": "Kodak K25 raw image", "pattern": ["*.k25"], "magic": []},
    {
        "type": "image/x-kodak-kdc",
        "name": "Kodak KDC raw image",
        "pattern": ["*.kdc"],
        "magic": [{"offset": 242, "value": b"EASTMAN KODAK COMPANY"}],
    },
    {
        "type": "image/x-minolta-mrw",
        "name": "Minolta MRW raw image",
        "pattern": ["*.mrw"],
        "magic": [{"offset": 0, "value": b"\x00MRM"}],
    },
    {"type": "image/x-nikon-nef", "name": "Nikon NEF raw image", "pattern": ["*.nef"], "magic": []},
    {"type": "image/x-nikon-nrw", "name": "Nikon NRW raw image", "pattern": ["*.nrw"], "magic": []},
    {
        "type": "image/x-olympus-orf",
        "name": "Olympus ORF raw image",
        "pattern": ["*.orf"],
        "magic": [{"offset": 0, "value": b"IIRO\x08\x00\x00\x00"}],
    },
    {
        "type": "image/x-panasonic-rw",
        "name": "Panasonic raw image",
        "pattern": ["*.raw"],
        "magic": [{"offset": 0, "value": b"IIU\x00\x08\x00\x00\x00"}],
    },
    {
        "type": "image/x-panasonic-rw2",
        "name": "Panasonic raw image",
        "pattern": ["*.rw2"],
        "magic": [{"offset": 0, "value": b"IIU\x00\x18\x00\x00\x00"}],
    },
    {"type": "image/x-pentax-pef", "name": "Pentax PEF raw image", "pattern": ["*.pef"], "magic": []},
    {
        "type": "image/x-sigma-x3f",
        "name": "Sigma X3F raw image",
        "pattern": ["*.x3f"],
        "magic": [{"offset": 0, "value": b"FOVb"}],
    },
    {"type": "image/x-sony-srf", "name": "Sony SRF raw image", "pattern": ["*.srf"], "magic": []},
    {"type": "image/x-sony-sr2", "name": "Sony SR2 raw image", "pattern": ["*.sr2"], "magic": []},
    {"type": "image/x-sony-arw", "name": "Sony ARW raw image", "pattern": ["*.arw"], "magic": []},
    {
        "type": "application/x-sony-bbeb",
        "name": "BroadBand eBook",
        "pattern": ["*.lrf"],
        "magic": [{"offset": 0, "value": b"L\x00R\x00F\x00\x00\x00"}],
    },
    {
        "type": "image/png",
        "name": "PNG image",
        "pattern": ["*.png"],
        "magic": [{"offset": 0, "value": b"\x89PNG\r\n\x1a\n"}],
    },
    {"type": "image/rle", "name": "RLE bitmap image", "pattern": ["*.rle"], "magic": []},
    {
        "type": "image/svg+xml-compressed",
        "name": "Compressed SVG image",
        "pattern": ["*.svgz", "*.svg.gz"],
        "magic": [],
    },
    {
        "type": "image/tiff",
        "name": "TIFF image",
        "pattern": ["*.tif", "*.tiff"],
        "magic": [{"offset": 0, "value": b"MM\x00*"}, {"offset": 0, "value": b"II*\x00"}],
    },
    {"type": "image/vnd.dwg", "name": "AutoCAD image", "pattern": ["*.dwg"], "magic": []},
    {
        "type": "image/vnd.dxf",
        "name": "DXF vector image",
        "pattern": ["*.dxf"],
        "magic": [{"offset": 0, "value": b"\\nHEADER\\n"}, {"offset": 0, "value": b"\r\nHEADER\r\n"}],
    },
    {
        "type": "image/vnd.ms-modi",
        "name": "MDI image",
        "pattern": ["*.mdi"],
        "magic": [{"offset": 0, "value": b"EP*\x00"}],
    },
    {
        "type": "image/jxr",
        "name": "JPEG XR image",
        "pattern": ["*.jxr", "*.hdp", "*.wdp"],
        "magic": [{"offset": 0, "value": b"II\xbc\x01"}],
    },
    {"type": "image/webp", "name": "WebP image", "pattern": ["*.webp"], "magic": []},
    {"type": "image/x-applix-graphics", "name": "Applix Graphics image", "pattern": ["*.ag"], "magic": []},
    {
        "type": "image/x-bzeps",
        "name": "EPS image (bzip2-compressed)",
        "pattern": ["*.eps.bz2", "*.epsi.bz2", "*.epsf.bz2"],
        "magic": [],
    },
    {"type": "image/x-cmu-raster", "name": "CMU raster image", "pattern": ["*.ras"], "magic": []},
    {
        "type": "image/x-compressed-xcf",
        "name": "Compressed GIMP image",
        "pattern": ["*.xcf.gz", "*.xcf.bz2"],
        "magic": [],
    },
    {
        "type": "application/dicom",
        "name": "DICOM image",
        "pattern": ["dicomdir", "*.dcm"],
        "magic": [{"offset": 128, "value": b"DICM"}],
    },
    {"type": "image/x-dib", "name": "DIB image", "pattern": [], "magic": [{"offset": 0, "value": b"(\x00\x00\x00"}]},
    {
        "type": "image/vnd.djvu",
        "name": "DjVu image",
        "pattern": ["*.djvu", "*.djv"],
        "magic": [{"offset": 0, "value": b"AT&TFORM"}],
    },
    {"type": "image/vnd.djvu+multipage", "name": "DjVu document", "pattern": ["*.djvu", "*.djv"], "magic": []},
    {"type": "image/dpx", "name": "DPX image", "pattern": [], "magic": [{"offset": 0, "value": b"SDPX"}]},
    {
        "type": "image/x-eps",
        "name": "EPS image",
        "pattern": ["*.eps", "*.epsi", "*.epsf"],
        "magic": [{"offset": 0, "value": b"\xc5\xd0\xd3\xc6"}],
    },
    {
        "type": "application/fits",
        "name": "FITS document",
        "pattern": ["*.fits", "*.fit", "*.fts"],
        "magic": [{"offset": 0, "value": b"SIMPLE  ="}],
    },
    {"type": "image/vnd.fpx", "name": "FlashPix image", "pattern": ["*.fpx"], "magic": []},
    {
        "type": "image/x-gzeps",
        "name": "EPS image (gzip-compressed)",
        "pattern": ["*.eps.gz", "*.epsi.gz", "*.epsf.gz"],
        "magic": [],
    },
    {
        "type": "image/vnd.microsoft.icon",
        "name": "Windows icon",
        "pattern": ["*.ico"],
        "magic": [{"offset": 0, "value": b"\x00\x00\x01\x00"}],
    },
    {"type": "image/x-icns", "name": "MacOS X icon", "pattern": ["*.icns"], "magic": [{"offset": 0, "value": b"icns"}]},
    {
        "type": "image/x-ilbm",
        "name": "ILBM image",
        "pattern": ["*.iff", "*.ilbm", "*.lbm"],
        "magic": [{"offset": 8, "value": b"ILBM"}, {"offset": 8, "value": b"PBM "}],
    },
    {"type": "image/x-jng", "name": "JNG image", "pattern": ["*.jng"], "magic": []},
    {"type": "image/x-lwo", "name": "LightWave object", "pattern": ["*.lwo", "*.lwob"], "magic": []},
    {"type": "image/x-lws", "name": "LightWave scene", "pattern": ["*.lws"], "magic": []},
    {"type": "image/x-macpaint", "name": "MacPaint Bitmap image", "pattern": ["*.pntg"], "magic": []},
    {"type": "image/x-msod", "name": "Office drawing", "pattern": ["*.msod"], "magic": []},
    {"type": "image/x-niff", "name": "NIFF image", "pattern": [], "magic": [{"offset": 0, "value": b"IIN1"}]},
    {"type": "image/vnd.zbrush.pcx", "name": "PCX image", "pattern": ["*.pcx"], "magic": []},
    {"type": "image/x-photo-cd", "name": "PCD image", "pattern": ["*.pcd"], "magic": []},
    {"type": "image/x-portable-anymap", "name": "PNM image", "pattern": ["*.pnm"], "magic": []},
    {
        "type": "image/x-portable-bitmap",
        "name": "PBM image",
        "pattern": ["*.pbm"],
        "magic": [{"offset": 0, "value": b"P1"}, {"offset": 0, "value": b"P4"}],
    },
    {
        "type": "image/x-portable-graymap",
        "name": "PGM image",
        "pattern": ["*.pgm"],
        "magic": [{"offset": 0, "value": b"P2"}, {"offset": 0, "value": b"P5"}],
    },
    {
        "type": "image/x-portable-pixmap",
        "name": "PPM image",
        "pattern": ["*.ppm"],
        "magic": [{"offset": 0, "value": b"P3"}, {"offset": 0, "value": b"P6"}],
    },
    {
        "type": "image/vnd.adobe.photoshop",
        "name": "Photoshop image",
        "pattern": ["*.psd"],
        "magic": [{"offset": 0, "value": b"8BPS  \x00\x00\x00\x00"}],
    },
    {"type": "image/x-rgb", "name": "RGB image", "pattern": ["*.rgb"], "magic": []},
    {"type": "image/x-sgi", "name": "SGI image", "pattern": ["*.sgi"], "magic": []},
    {
        "type": "image/x-sun-raster",
        "name": "Sun raster image",
        "pattern": ["*.sun"],
        "magic": [{"offset": 0, "value": b"Y\xa6j\x95"}],
    },
    {
        "type": "image/x-tga",
        "name": "TGA image",
        "pattern": ["*.tga", "*.icb", "*.tpic", "*.vda", "*.vst"],
        "magic": [
            {"offset": 1, "value": b"\\1\\1"},
            {"offset": 1, "value": b"\\1\\11"},
            {"offset": 1, "value": b"\x00\x03"},
            {"offset": 1, "value": b"\x00\x02"},
        ],
    },
    {
        "type": "image/x-win-bitmap",
        "name": "Windows cursor",
        "pattern": ["*.cur"],
        "magic": [{"offset": 0, "value": b"\x00\x00\x02\x00"}],
    },
    {"type": "application/x-navi-animation", "name": "Windows animated cursor", "pattern": ["*.ani"], "magic": []},
    {
        "type": "image/emf",
        "name": "EMF image",
        "pattern": ["*.emf"],
        "magic": [{"offset": 0, "value": b"\x00\x00\x00\x01"}],
    },
    {
        "type": "image/wmf",
        "name": "WMF image",
        "pattern": ["*.wmf"],
        "magic": [{"offset": 0, "value": b"\x9a\xc6\xcd\xd7"}, {"offset": 0, "value": b"\x00\x01"}],
    },
    {"type": "image/x-xbitmap", "name": "XBM image", "pattern": ["*.xbm"], "magic": []},
    {
        "type": "image/x-xcf",
        "name": "GIMP image",
        "pattern": ["*.xcf"],
        "magic": [{"offset": 0, "value": b"gimp xcf file"}, {"offset": 0, "value": b"gimp xcf v"}],
    },
    {
        "type": "image/x-gimp-gbr",
        "name": "GIMP brush",
        "pattern": ["*.gbr"],
        "magic": [{"offset": 20, "value": b"GIMP"}],
    },
    {"type": "image/x-gimp-gih", "name": "GIMP brush pipe", "pattern": ["*.gih"], "magic": []},
    {
        "type": "image/x-gimp-pat",
        "name": "GIMP pattern",
        "pattern": ["*.pat"],
        "magic": [{"offset": 20, "value": b"GPAT"}],
    },
    {"type": "image/x-xfig", "name": "XFig image", "pattern": ["*.fig"], "magic": [{"offset": 0, "value": b"#FIG"}]},
    {
        "type": "image/x-xpixmap",
        "name": "XPM image",
        "pattern": ["*.xpm"],
        "magic": [{"offset": 0, "value": b"/* XPM */"}, {"offset": 0, "value": b"! XPM2\\n"}],
    },
    {"type": "image/x-xwindowdump", "name": "X window image", "pattern": ["*.xwd"], "magic": []},
    {
        "type": "image/x-kiss-cel",
        "name": "KiSS cel",
        "pattern": ["*.cel", "*.kcf"],
        "magic": [{"offset": 0, "value": b"KiSS"}],
    },
    {
        "type": "message/news",
        "name": "Usenet news message",
        "pattern": [],
        "magic": [
            {"offset": 0, "value": b"Article"},
            {"offset": 0, "value": b"Path:"},
            {"offset": 0, "value": b"Xref:"},
        ],
    },
    {
        "type": "message/rfc822",
        "name": "Email message",
        "pattern": ["*.eml"],
        "magic": [
            {"offset": 0, "value": b"#! rnews"},
            {"offset": 0, "value": b"Content-Type:"},
            {"offset": 0, "value": b"Forward to"},
            {"offset": 0, "value": b"From:"},
            {"offset": 0, "value": b"N#! rnews"},
            {"offset": 0, "value": b"Pipe to"},
            {"offset": 0, "value": b"Received:"},
            {"offset": 0, "value": b"Relay-Version:"},
            {"offset": 0, "value": b"Return-Path:"},
            {"offset": 0, "value": b"Return-path:"},
            {"offset": 0, "value": b"Subject: "},
            {"offset": 0, "value": b"To:"},
        ],
    },
    {"type": "message/x-gnu-rmail", "name": "GNU mail message", "pattern": ["RMAIL"], "magic": []},
    {
        "type": "model/iges",
        "name": "IGES document",
        "pattern": ["*.igs", "*.iges"],
        "magic": [{"offset": 72, "value": b"S      1\n"}, {"offset": 72, "value": b"S0000001\n"}],
    },
    {
        "type": "model/gltf-binary",
        "name": "glTF model",
        "pattern": ["*.glb"],
        "magic": [{"offset": 0, "value": b"glTF"}],
    },
    {
        "type": "model/vrml",
        "name": "VRML document",
        "pattern": ["*.vrm", "*.vrml", "*.wrl"],
        "magic": [{"offset": 0, "value": b"#VRML "}],
    },
    {
        "type": "model/obj",
        "name": "OBJ 3D model",
        "pattern": ["*.obj"],
        "magic": [{"offset": 0, "value": b" OBJ File: '"}, {"offset": 0, "value": b"mtllib "}],
    },
    {
        "type": "model/mtl",
        "name": "OBJ 3D model material library",
        "pattern": ["*.mtl"],
        "magic": [{"offset": 0, "value": b"# Blender MTL File: '"}, {"offset": 0, "value": b"newmtl "}],
    },
    {
        "type": "text/calendar",
        "name": "VCS/ICS calendar",
        "pattern": ["*.vcs", "*.ics", "*.ifb", "*.icalendar"],
        "magic": [{"offset": 0, "value": b"BEGIN:VCALENDAR"}, {"offset": 0, "value": b"begin:vcalendar"}],
    },
    {"type": "text/css", "name": "CSS stylesheet", "pattern": ["*.css"], "magic": []},
    {
        "type": "text/spdx",
        "name": "SPDX document",
        "pattern": ["*.spdx"],
        "magic": [{"offset": 0, "value": b"SPDXVersion: SPDX-"}],
    },
    {
        "type": "text/vcard",
        "name": "Electronic business card",
        "pattern": ["*.vcard", "*.vcf", "*.vct", "*.gcrd"],
        "magic": [{"offset": 0, "value": b"BEGIN:VCARD"}, {"offset": 0, "value": b"begin:vcard"}],
    },
    {"type": "text/turtle", "name": "Turtle document", "pattern": ["*.ttl"], "magic": []},
    {
        "type": "text/x-txt2tags",
        "name": "txt2tags document",
        "pattern": ["*.t2t"],
        "magic": [{"offset": 0, "value": b"%!postproc"}, {"offset": 0, "value": b"%!encoding"}],
    },
    {"type": "text/x-verilog", "name": "Verilog source code", "pattern": ["*.v"], "magic": []},
    {"type": "text/x-svhdr", "name": "SystemVerilog header", "pattern": ["*.svh"], "magic": []},
    {"type": "text/x-svsrc", "name": "SystemVerilog source code", "pattern": ["*.sv"], "magic": []},
    {"type": "text/x-vhdl", "name": "VHDL source code", "pattern": ["*.vhd", "*.vhdl"], "magic": []},
    {
        "type": "text/plain",
        "name": "Plain text document",
        "pattern": ["*.txt", "*.asc", "*,v"],
        "magic": [{"offset": 0, "value": b"This is TeX,"}, {"offset": 0, "value": b"This is METAFONT,"}],
    },
    {"type": "text/x-rst", "name": "ReStructuredText document", "pattern": ["*.rst"], "magic": []},
    {"type": "text/richtext", "name": "Rich text document", "pattern": ["*.rtx"], "magic": []},
    {"type": "text/sgml", "name": "SGML document", "pattern": ["*.sgml", "*.sgm"], "magic": []},
    {
        "type": "application/x-sylk",
        "name": "Spreadsheet interchange document",
        "pattern": ["*.sylk", "*.slk"],
        "magic": [{"offset": 0, "value": b"ID;"}],
    },
    {"type": "text/tab-separated-values", "name": "TSV document", "pattern": ["*.tsv"], "magic": []},
    {
        "type": "text/vnd.graphviz",
        "name": "Graphviz DOT graph",
        "pattern": ["*.gv", "*.dot"],
        "magic": [
            {"offset": 0, "value": b"digraph "},
            {"offset": 0, "value": b"strict digraph "},
            {"offset": 0, "value": b"graph "},
            {"offset": 0, "value": b"strict graph "},
        ],
    },
    {
        "type": "text/vnd.sun.j2me.app-descriptor",
        "name": "JAD document",
        "pattern": ["*.jad"],
        "magic": [{"offset": 0, "value": b"MIDlet-"}],
    },
    {"type": "text/vnd.wap.wmlscript", "name": "WMLScript program", "pattern": ["*.wmls"], "magic": []},
    {"type": "text/vnd.senx.warpscript", "name": "WarpScript source code", "pattern": ["*.mc2", "*.mc2"], "magic": []},
    {
        "type": "application/x-ace",
        "name": "ACE archive",
        "pattern": ["*.ace"],
        "magic": [{"offset": 7, "value": b"**ACE**"}],
    },
    {"type": "text/x-adasrc", "name": "Ada source code", "pattern": ["*.adb", "*.ads"], "magic": []},
    {"type": "text/x-authors", "name": "Author list", "pattern": ["AUTHORS"], "magic": []},
    {
        "type": "text/x-bibtex",
        "name": "BibTeX document",
        "pattern": ["*.bib"],
        "magic": [{"offset": 0, "value": b"% This file was created with JabRef"}],
    },
    {"type": "text/x-blueprint", "name": "Blueprint source code", "pattern": ["*.blp"], "magic": []},
    {
        "type": "text/x-c++hdr",
        "name": "C++ header",
        "pattern": ["*.hh", "*.hp", "*.hpp", "*.h++", "*.hxx"],
        "magic": [],
    },
    {
        "type": "text/x-c++src",
        "name": "C++ source code",
        "pattern": ["*.cpp", "*.cxx", "*.cc", "*.C", "*.c++"],
        "magic": [],
    },
    {"type": "text/x-changelog", "name": "ChangeLog document", "pattern": ["ChangeLog"], "magic": []},
    {"type": "text/x-chdr", "name": "C header", "pattern": ["*.h"], "magic": []},
    {"type": "text/x-cmake", "name": "CMake source code", "pattern": ["*.cmake", "CMakeLists.txt"], "magic": []},
    {
        "type": "text/x-common-lisp",
        "name": "Common Lisp source code",
        "pattern": ["*.asd", "*.fasl", "*.lisp", "*.ros"],
        "magic": [],
    },
    {"type": "text/csv", "name": "CSV document", "pattern": ["*.csv"], "magic": []},
    {"type": "text/csv-schema", "name": "CSV Schema document", "pattern": ["*.csvs"], "magic": []},
    {"type": "text/x-copying", "name": "License terms", "pattern": ["COPYING"], "magic": []},
    {"type": "text/x-credits", "name": "Author credits", "pattern": ["CREDITS"], "magic": []},
    {"type": "text/x-csrc", "name": "C source code", "pattern": ["*.c"], "magic": []},
    {
        "type": "text/x-dockerfile",
        "name": "Docker container build file",
        "pattern": ["Dockerfile", "*.Dockerfile", "Dockerfile.*"],
        "magic": [{"offset": 0, "value": b"# syntax=docker/dockerfile:"}],
    },
    {
        "type": "text/x-asm",
        "name": "Assembly code",
        "pattern": ["*.asm", "*.s"],
        "magic": [
            {"offset": 0, "value": b"\\t.asciiz"},
            {"offset": 0, "value": b"\\t.byte"},
            {"offset": 0, "value": b"\\t.even"},
            {"offset": 0, "value": b"\\t.file"},
            {"offset": 0, "value": b"\\t.globl"},
            {"offset": 0, "value": b"\\t.text"},
            {"offset": 0, "value": b"\\t.type"},
        ],
    },
    {
        "type": "text/x-csharp",
        "name": "C# source code",
        "pattern": ["*.cs"],
        "magic": [{"offset": 0, "value": b"interface"}, {"offset": 0, "value": b"namespace"}],
    },
    {
        "type": "text/x-vala",
        "name": "Vala source code",
        "pattern": ["*.vala", "*.vapi"],
        "magic": [
            {"offset": 0, "value": b"#!/bin/vala"},
            {"offset": 0, "value": b"#!/usr/bin/vala"},
            {"offset": 0, "value": b"#!/usr/bin/env vala"},
            {"offset": 0, "value": b"#!/usr/bin/env -S vala"},
            {"offset": 0, "value": b"#!/bin/env vala"},
            {"offset": 0, "value": b"#!/bin/env -S vala"},
        ],
    },
    {"type": "text/x-ooc", "name": "OOC source code", "pattern": ["*.ooc"], "magic": []},
    {"type": "text/x-dcl", "name": "DCL script", "pattern": ["*.dcl"], "magic": []},
    {"type": "text/x-dsl", "name": "DSSSL document", "pattern": ["*.dsl"], "magic": []},
    {"type": "text/x-dsrc", "name": "D source code", "pattern": ["*.d", "*.di"], "magic": []},
    {"type": "application/xml-dtd", "name": "DTD file", "pattern": ["*.dtd"], "magic": []},
    {"type": "text/x-eiffel", "name": "Eiffel source code", "pattern": ["*.e", "*.eif"], "magic": []},
    {
        "type": "text/x-emacs-lisp",
        "name": "Emacs Lisp source code",
        "pattern": ["*.el"],
        "magic": [{"offset": 0, "value": b"\n("}, {"offset": 0, "value": b";ELC\x13\x00\x00\x00"}],
    },
    {"type": "text/x-elixir", "name": "Elixir source code", "pattern": ["*.ex", "*.exs"], "magic": []},
    {"type": "text/x-erlang", "name": "Erlang source code", "pattern": ["*.erl"], "magic": []},
    {
        "type": "text/x-fortran",
        "name": "Fortran source code",
        "pattern": ["*.f", "*.f90", "*.f95", "*.for"],
        "magic": [],
    },
    {
        "type": "text/x-genie",
        "name": "Genie source code",
        "pattern": ["*.gs"],
        "magic": [{"offset": 0, "value": b"uses"}],
    },
    {"type": "text/x-gettext-translation", "name": "Translation file", "pattern": ["*.po"], "magic": []},
    {
        "type": "text/x-gettext-translation-template",
        "name": "Translation template",
        "pattern": ["*.pot"],
        "magic": [{"offset": 0, "value": b'#, fuzzy\\nmsgid \\"\\"\\nmsgstr \\"\\"\\n\\"Project-Id-Version:'}],
    },
    {"type": "text/x-gherkin", "name": "Gherkin document", "pattern": ["*.feature"], "magic": []},
    {
        "type": "text/html",
        "name": "HTML document",
        "pattern": ["*.html", "*.htm"],
        "magic": [
            {"offset": 0, "value": b"<!DOCTYPE HTML"},
            {"offset": 0, "value": b"<!doctype html"},
            {"offset": 0, "value": b"<!DOCTYPE html"},
            {"offset": 0, "value": b"<HEAD"},
            {"offset": 0, "value": b"<head"},
            {"offset": 0, "value": b"<HTML"},
            {"offset": 0, "value": b"<html"},
            {"offset": 0, "value": b"<SCRIPT"},
            {"offset": 0, "value": b"<script"},
            {"offset": 0, "value": b"<BODY"},
            {"offset": 0, "value": b"<body"},
            {"offset": 0, "value": b"<h1"},
            {"offset": 0, "value": b"<H1"},
            {"offset": 0, "value": b"<!doctype HTML"},
            {"offset": 0, "value": b"<!--"},
            {"offset": 0, "value": b"<TITLE"},
            {"offset": 0, "value": b"<title"},
        ],
    },
    {
        "type": "application/hta",
        "name": "Windows HTML desktop application",
        "pattern": ["*.hta"],
        "magic": [{"offset": 0, "value": b"<hta:application"}, {"offset": 0, "value": b"<HTA:APPLICATION"}],
    },
    {
        "type": "text/cache-manifest",
        "name": "Web application cache file",
        "pattern": ["*.manifest"],
        "magic": [{"offset": 0, "value": b"CACHE MANIFEST"}],
    },
    {
        "type": "text/x-google-video-pointer",
        "name": "Google Video Pointer shortcut",
        "pattern": ["*.gvp"],
        "magic": [
            {"offset": 0, "value": b"#.download.the.free.Google.Video.Player"},
            {"offset": 0, "value": b"# download the free Google Video Player"},
        ],
    },
    {"type": "text/x-haskell", "name": "Haskell source code", "pattern": ["*.hs"], "magic": []},
    {"type": "text/x-idl", "name": "IDL document", "pattern": ["*.idl"], "magic": []},
    {"type": "text/x-install", "name": "Installation instructions", "pattern": ["INSTALL"], "magic": []},
    {"type": "text/x-java", "name": "Java source code", "pattern": ["*.java"], "magic": []},
    {
        "type": "text/x-ldif",
        "name": "LDIF address book",
        "pattern": ["*.ldif"],
        "magic": [{"offset": 0, "value": b"dn: cn="}, {"offset": 0, "value": b"dn: mail="}],
    },
    {"type": "text/x-lilypond", "name": "Lilypond music sheet", "pattern": ["*.ly"], "magic": []},
    {"type": "text/x-literate-haskell", "name": "LHS source code", "pattern": ["*.lhs"], "magic": []},
    {"type": "text/x-log", "name": "Application log", "pattern": ["*.log"], "magic": []},
    {
        "type": "text/x-makefile",
        "name": "Makefile build file",
        "pattern": ["makefile", "GNUmakefile", "*.mk", "*.mak", "Makefile.*"],
        "magic": [{"offset": 0, "value": b"#!/usr/bin/make"}, {"offset": 0, "value": b"#! /usr/bin/make"}],
    },
    {"type": "text/markdown", "name": "Markdown document", "pattern": ["*.md", "*.mkd", "*.markdown"], "magic": []},
    {"type": "text/x-moc", "name": "Qt MOC file", "pattern": ["*.moc"], "magic": []},
    {
        "type": "text/x-ms-regedit",
        "name": "Windows Registry extract",
        "pattern": ["*.reg"],
        "magic": [
            {"offset": 0, "value": b"REGEDIT"},
            {"offset": 0, "value": b"Windows Registry Editor Version 5.00"},
            {
                "offset": 0,
                "value": b"\xff\xfeW\x00i\x00n\x00d\x00o\x00w\x00s\x00 \x00R\x00e\x00g\x00i\x00s\x00t\x00r\x00y\x00 \x00E\x00d\x00i\x00t\x00o\x00r\x00",
            },
        ],
    },
    {
        "type": "text/x-ms-visualstudio.project",
        "name": "Visual Studio Project",
        "pattern": ["*.dsp"],
        "magic": [{"offset": 0, "value": b"# Microsoft Developer Studio Project File"}],
    },
    {
        "type": "text/x-ms-visualstudio.workspace",
        "name": "Visual Studio Workspace",
        "pattern": ["*.dsw"],
        "magic": [{"offset": 0, "value": b"Microsoft Developer Studio Workspace File"}],
    },
    {"type": "text/x-mof", "name": "MOF file", "pattern": ["*.mof"], "magic": []},
    {
        "type": "text/x-mup",
        "name": "Mup musical composition document",
        "pattern": ["*.mup", "*.not"],
        "magic": [{"offset": 0, "value": b"//!Mup"}],
    },
    {"type": "text/x-nix", "name": "Nix source code", "pattern": ["*.nix"], "magic": []},
    {"type": "text/x-objcsrc", "name": "Objective-C source code", "pattern": ["*.m"], "magic": []},
    {
        "type": "text/x-objc++src",
        "name": "Objective-C++ source code",
        "pattern": ["*.mm"],
        "magic": [
            {"offset": 0, "value": b"#import "},
            {"offset": 0, "value": b"#include "},
            {"offset": 0, "value": b"@interface"},
        ],
    },
    {
        "type": "text/x-ocaml",
        "name": "OCaml source code",
        "pattern": ["*.ml", "*.mli"],
        "magic": [{"offset": 0, "value": b"fun"}],
    },
    {"type": "text/x-opencl-csrc", "name": "OpenCL C source code", "pattern": ["*.cl"], "magic": []},
    {"type": "text/x-opencl-c++src", "name": "C++ for OpenCL source code", "pattern": ["*.clcpp"], "magic": []},
    {"type": "text/x-matlab", "name": "MATLAB file", "pattern": ["*.m"], "magic": []},
    {"type": "text/x-meson", "name": "Meson source code", "pattern": ["meson.build", "meson_options.txt"], "magic": []},
    {
        "type": "text/x-modelica",
        "name": "Modelica model",
        "pattern": ["*.mo"],
        "magic": [{"offset": 0, "value": b"model"}, {"offset": 0, "value": b"record"}],
    },
    {"type": "text/x-pascal", "name": "Pascal source code", "pattern": ["*.p", "*.pas"], "magic": []},
    {
        "type": "text/x-patch",
        "name": "Differences between files",
        "pattern": ["*.diff", "*.patch"],
        "magic": [
            {"offset": 0, "value": b"diff\\t"},
            {"offset": 0, "value": b"diff "},
            {"offset": 0, "value": b"***\\t"},
            {"offset": 0, "value": b"*** "},
            {"offset": 0, "value": b"=== "},
            {"offset": 0, "value": b"--- "},
            {"offset": 0, "value": b"Only in\\t"},
            {"offset": 0, "value": b"Only in "},
            {"offset": 0, "value": b"Common subdirectories: "},
            {"offset": 0, "value": b"Index:"},
        ],
    },
    {"type": "application/vnd.dart", "name": "Dart source code", "pattern": ["*.dart"], "magic": []},
    {"type": "text/x-nim", "name": "Nim source code", "pattern": ["*.nim"], "magic": [{"offset": 0, "value": b"proc"}]},
    {"type": "text/x-nimscript", "name": "Nimscript source code", "pattern": ["*.nims", "*.nimble"], "magic": []},
    {"type": "text/x-go", "name": "Go source code", "pattern": ["*.go"], "magic": [{"offset": 0, "value": b"func"}]},
    {
        "type": "text/x-scons",
        "name": "SCons configuration file",
        "pattern": ["SConstruct", "SConscript", "SConscript.*"],
        "magic": [],
    },
    {
        "type": "text/x-python3",
        "name": "Python 3 script",
        "pattern": ["*.py", "*.py3", "*.pyi"],
        "magic": [
            {"offset": 0, "value": b"#!/bin/python3"},
            {"offset": 0, "value": b"#! /bin/python3"},
            {"offset": 0, "value": b'eval \\"exec /bin/python3'},
            {"offset": 0, "value": b"#!/usr/bin/python3"},
            {"offset": 0, "value": b"#! /usr/bin/python3"},
            {"offset": 0, "value": b'eval \\"exec /usr/bin/python3'},
            {"offset": 0, "value": b"#!/usr/local/bin/python3"},
            {"offset": 0, "value": b"#! /usr/local/bin/python3"},
            {"offset": 0, "value": b'eval \\"exec /usr/local/bin/python3'},
            {"offset": 2, "value": b"/bin/env python3"},
        ],
    },
    {
        "type": "text/x-python2",
        "name": "Python 2 script",
        "pattern": ["*.py", "*.py2"],
        "magic": [
            {"offset": 0, "value": b"#!/bin/python2"},
            {"offset": 0, "value": b"#! /bin/python2"},
            {"offset": 0, "value": b'eval \\"exec /bin/python2'},
            {"offset": 0, "value": b"#!/usr/bin/python2"},
            {"offset": 0, "value": b"#! /usr/bin/python2"},
            {"offset": 0, "value": b'eval \\"exec /usr/bin/python2'},
            {"offset": 0, "value": b"#!/usr/local/bin/python2"},
            {"offset": 0, "value": b"#! /usr/local/bin/python2"},
            {"offset": 0, "value": b'eval \\"exec /usr/local/bin/python2'},
            {"offset": 2, "value": b"/bin/env python2"},
        ],
    },
    {
        "type": "text/x-python",
        "name": "Python script",
        "pattern": ["*.py", "*.wsgi"],
        "magic": [
            {"offset": 0, "value": b"#!/bin/python"},
            {"offset": 0, "value": b"#! /bin/python"},
            {"offset": 0, "value": b'eval \\"exec /bin/python'},
            {"offset": 0, "value": b"#!/usr/bin/python"},
            {"offset": 0, "value": b"#! /usr/bin/python"},
            {"offset": 0, "value": b'eval \\"exec /usr/bin/python'},
            {"offset": 0, "value": b"#!/usr/local/bin/python"},
            {"offset": 0, "value": b"#! /usr/local/bin/python"},
            {"offset": 0, "value": b'eval \\"exec /usr/local/bin/python'},
            {"offset": 2, "value": b"/bin/env python"},
        ],
    },
    {
        "type": "text/x-cython",
        "name": "Cython source code",
        "pattern": ["*.pxd", "*.pxi", "*.pyx"],
        "magic": [{"offset": 0, "value": b"cdef"}],
    },
    {"type": "text/x-sagemath", "name": "SageMath script", "pattern": ["*.sage"], "magic": []},
    {
        "type": "text/x-lua",
        "name": "Lua script",
        "pattern": ["*.lua"],
        "magic": [
            {"offset": 2, "value": b"/bin/lua"},
            {"offset": 2, "value": b"/bin/luajit"},
            {"offset": 2, "value": b"/bin/env lua"},
            {"offset": 2, "value": b"/bin/env luajit"},
        ],
    },
    {"type": "text/x-readme", "name": "README document", "pattern": ["README*"], "magic": []},
    {"type": "text/x-nfo", "name": "NFO document", "pattern": ["*.nfo"], "magic": []},
    {
        "type": "text/x-rpm-spec",
        "name": "RPM spec file",
        "pattern": ["*.spec"],
        "magic": [{"offset": 0, "value": b"Summary: "}, {"offset": 0, "value": b"%define "}],
    },
    {"type": "text/x-sass", "name": "Sass CSS pre-processor file", "pattern": ["*.sass"], "magic": []},
    {"type": "text/x-scala", "name": "Scala source code", "pattern": ["*.scala", "*.sc"], "magic": []},
    {"type": "text/x-scheme", "name": "Scheme source code", "pattern": ["*.scm", "*.ss"], "magic": []},
    {"type": "text/x-scss", "name": "SCSS pre-processor file", "pattern": ["*.scss"], "magic": []},
    {"type": "text/x-setext", "name": "Setext document", "pattern": ["*.etx"], "magic": []},
    {"type": "application/sql", "name": "SQL code", "pattern": ["*.sql"], "magic": []},
    {"type": "text/tcl", "name": "Tcl script", "pattern": ["*.tcl", "*.tk"], "magic": []},
    {
        "type": "text/x-tex",
        "name": "TeX document",
        "pattern": ["*.tex", "*.ltx", "*.sty", "*.cls", "*.dtx", "*.ins", "*.latex"],
        "magic": [{"offset": 1, "value": b"documentclass"}],
    },
    {"type": "text/x-texinfo", "name": "TeXInfo document", "pattern": ["*.texi", "*.texinfo"], "magic": []},
    {"type": "text/vnd.typst", "name": "Typst document", "pattern": ["*.typ"], "magic": []},
    {"type": "text/x-troff-me", "name": "Troff ME input document", "pattern": ["*.me"], "magic": []},
    {"type": "text/x-troff-mm", "name": "Troff MM input document", "pattern": ["*.mm"], "magic": []},
    {"type": "text/x-troff-ms", "name": "Troff MS input document", "pattern": ["*.ms"], "magic": []},
    {"type": "text/x-twig", "name": "Twig template", "pattern": ["*.twig"], "magic": []},
    {"type": "text/x-uil", "name": "X-Motif UIL table", "pattern": ["*.uil"], "magic": []},
    {
        "type": "text/x-uuencode",
        "name": "uuencoded file",
        "pattern": ["*.uue"],
        "magic": [{"offset": 0, "value": b"begin "}],
    },
    {"type": "text/x-basic", "name": "BASIC program", "pattern": ["*.bas"], "magic": []},
    {
        "type": "text/x-vb",
        "name": "Visual Basic .NET source code",
        "pattern": ["*.vb"],
        "magic": [
            {"offset": 0, "value": b"Imports"},
            {"offset": 0, "value": b"Module"},
            {"offset": 0, "value": b"REM"},
        ],
    },
    {"type": "text/vbscript", "name": "VBScript program", "pattern": ["*.vbs"], "magic": []},
    {"type": "text/vbscript.encode", "name": "Encoded VBScript program", "pattern": ["*.vbe"], "magic": []},
    {
        "type": "text/x-iptables",
        "name": "iptables configuration file",
        "pattern": ["*.iptables"],
        "magic": [
            {"offset": 0, "value": b"/etc/sysconfig/iptables"},
            {"offset": 0, "value": b"*filter"},
            {"offset": 0, "value": b"-A INPUT"},
            {"offset": 0, "value": b"-P INPUT"},
        ],
    },
    {
        "type": "text/x-dbus-service",
        "name": "D-Bus service file",
        "pattern": ["*.service"],
        "magic": [{"offset": 0, "value": b"\\n[D-BUS Service]\\n"}, {"offset": 0, "value": b"[D-BUS Service]\\n"}],
    },
    {
        "type": "text/x-systemd-unit",
        "name": "Systemd unit file",
        "pattern": [
            "*.automount",
            "*.device",
            "*.mount",
            "*.path",
            "*.scope",
            "*.service",
            "*.slice",
            "*.socket",
            "*.swap",
            "*.target",
            "*.timer",
        ],
        "magic": [
            {"offset": 0, "value": b"\\n[Unit]\\n"},
            {"offset": 0, "value": b"\\n[Install]\\n"},
            {"offset": 0, "value": b"\\n[Automount]\\n"},
            {"offset": 0, "value": b"\\n[Mount]\\n"},
            {"offset": 0, "value": b"\\n[Path]\\n"},
            {"offset": 0, "value": b"\\n[Scope]\\n"},
            {"offset": 0, "value": b"\\n[Service]\\n"},
            {"offset": 0, "value": b"\\n[Slice]\\n"},
            {"offset": 0, "value": b"\\n[Socket]\\n"},
            {"offset": 0, "value": b"\\n[Swap]\\n"},
            {"offset": 0, "value": b"\\n[Timer]\\n"},
            {"offset": 0, "value": b"[Unit]\\n"},
            {"offset": 0, "value": b"[Install]\\n"},
            {"offset": 0, "value": b"[Automount]\\n"},
            {"offset": 0, "value": b"[Mount]\\n"},
            {"offset": 0, "value": b"[Path]\\n"},
            {"offset": 0, "value": b"[Scope]\\n"},
            {"offset": 0, "value": b"[Service]\\n"},
            {"offset": 0, "value": b"[Slice]\\n"},
            {"offset": 0, "value": b"[Socket]\\n"},
            {"offset": 0, "value": b"[Swap]\\n"},
            {"offset": 0, "value": b"[Timer]\\n"},
        ],
    },
    {"type": "text/xmcd", "name": "XMCD CD database", "pattern": [], "magic": [{"offset": 0, "value": b"# xmcd"}]},
    {
        "type": "application/xml",
        "name": "XML document",
        "pattern": ["*.xml", "*.xbl", "*.xsd", "*.rng"],
        "magic": [{"offset": 0, "value": b"<?xml"}],
    },
    {
        "type": "video/dv",
        "name": "DV video",
        "pattern": ["*.dv"],
        "magic": [{"offset": 0, "value": b"\x1f\x07\x00\x00"}],
    },
    {
        "type": "video/mpeg",
        "name": "MPEG video",
        "pattern": ["*.mpeg", "*.mpg", "*.mp2", "*.mpe", "*.vob", "[0-9][0-9][0-9].vdr"],
        "magic": [
            {"offset": 0, "value": b"G?\xff\x10"},
            {"offset": 0, "value": b"\x00\x00\x01\xb3"},
            {"offset": 0, "value": b"\x00\x00\x01\xba"},
        ],
    },
    {
        "type": "video/vnd.mpegurl",
        "name": "Video playlist",
        "pattern": ["*.m1u", "*.m4u", "*.mxu"],
        "magic": [{"offset": 0, "value": b"#EXTM4U"}],
    },
    {
        "type": "video/quicktime",
        "name": "QuickTime video",
        "pattern": ["*.qt", "*.mov", "*.moov", "*.qtvr"],
        "magic": [
            {"offset": 12, "value": b"mdat"},
            {"offset": 4, "value": b"mdat"},
            {"offset": 4, "value": b"moov"},
            {"offset": 4, "value": b"ftypqt"},
        ],
    },
    {
        "type": "image/x-quicktime",
        "name": "QuickTime image",
        "pattern": ["*.qtif", "*.qif"],
        "magic": [{"offset": 4, "value": b"idat"}],
    },
    {
        "type": "image/ktx",
        "name": "Khronos texture image",
        "pattern": ["*.ktx"],
        "magic": [{"offset": 0, "value": b"\xabKTX"}],
    },
    {"type": "image/ktx2", "name": "Khronos texture image", "pattern": ["*.ktx2"], "magic": []},
    {
        "type": "image/astc",
        "name": "ASTC texture",
        "pattern": ["*.astc"],
        "magic": [{"offset": 0, "value": b"\\\xa1\xab\x13"}],
    },
    {"type": "video/vnd.vivo", "name": "Vivo video", "pattern": ["*.viv", "*.vivo"], "magic": []},
    {"type": "video/x-anim", "name": "ANIM animation", "pattern": ["*.anim[1-9j]"], "magic": []},
    {
        "type": "video/x-flic",
        "name": "FLIC animation",
        "pattern": ["*.fli", "*.flc"],
        "magic": [{"offset": 0, "value": b"\xaf\x11"}, {"offset": 0, "value": b"\xaf\x12"}],
    },
    {
        "type": "application/x-hwp",
        "name": "Haansoft Hangul document",
        "pattern": ["*.hwp"],
        "magic": [{"offset": 0, "value": b"HWP Document File"}],
    },
    {"type": "application/x-hwt", "name": "Haansoft Hangul document template", "pattern": ["*.hwt"], "magic": []},
    {
        "type": "video/x-mng",
        "name": "MNG animation",
        "pattern": ["*.mng"],
        "magic": [{"offset": 0, "value": b"\x8aMNG\r\n\x1a\n"}],
    },
    {
        "type": "application/vnd.ms-asf",
        "name": "ASF video",
        "pattern": ["*.asf"],
        "magic": [{"offset": 0, "value": b"0&\xb2u"}, {"offset": 0, "value": b"[Reference]"}],
    },
    {
        "type": "application/x-netshow-channel",
        "name": "Windows Media Station file",
        "pattern": ["*.nsc"],
        "magic": [{"offset": 0, "value": b"[Address]"}],
    },
    {"type": "video/x-ms-wmv", "name": "Windows Media video", "pattern": ["*.wmv"], "magic": []},
    {
        "type": "video/vnd.avi",
        "name": "AVI video",
        "pattern": ["*.avi", "*.avf", "*.divx"],
        "magic": [{"offset": 0, "value": b"AVF0"}],
    },
    {"type": "video/x-nsv", "name": "NullSoft video", "pattern": ["*.nsv"], "magic": [{"offset": 0, "value": b"NSVf"}]},
    {
        "type": "application/sdp",
        "name": "SDP multicast stream file",
        "pattern": ["*.sdp"],
        "magic": [{"offset": 0, "value": b"v="}],
    },
    {
        "type": "video/x-sgi-movie",
        "name": "SGI video",
        "pattern": ["*.movie"],
        "magic": [{"offset": 0, "value": b"MOVI"}],
    },
    {
        "type": "application/vnd.emusic-emusic_package",
        "name": "eMusic download package",
        "pattern": ["*.emp"],
        "magic": [{"offset": 0, "value": b"nF7YLao"}],
    },
    {"type": "application/x-ica", "name": "Citrix ICA settings file", "pattern": ["*.ica"], "magic": []},
    {
        "type": "application/x-t602",
        "name": "T602 document",
        "pattern": ["*.602"],
        "magic": [{"offset": 0, "value": b"@CT 0"}, {"offset": 0, "value": b"@CT 1"}, {"offset": 0, "value": b"@CT 2"}],
    },
    {
        "type": "application/x-cisco-vpn-settings",
        "name": "Cisco VPN settings",
        "pattern": ["*.pcf"],
        "magic": [{"offset": 0, "value": b"[main]"}],
    },
    {
        "type": "application/vnd.iccprofile",
        "name": "ICC profile",
        "pattern": ["*.icc", "*.icm"],
        "magic": [{"offset": 36, "value": b"acsp"}],
    },
    {
        "type": "application/x-it87",
        "name": "IT 8.7 color calibration file",
        "pattern": ["*.it87"],
        "magic": [{"offset": 0, "value": b"IT8.7"}],
    },
    {
        "type": "application/x-ccmx",
        "name": "CCMX color correction file",
        "pattern": ["*.ccmx"],
        "magic": [{"offset": 0, "value": b"CCMX"}],
    },
    {
        "type": "application/winhlp",
        "name": "WinHelp help file",
        "pattern": ["*.hlp"],
        "magic": [{"offset": 0, "value": b"\x00\x03_?"}],
    },
    {
        "type": "application/x-bsdiff",
        "name": "Binary differences between files",
        "pattern": ["*.bsdiff"],
        "magic": [{"offset": 0, "value": b"BSDIFF40"}, {"offset": 0, "value": b"BSDIFN40"}],
    },
    {"type": "application/trig", "name": "TriG RDF document", "pattern": ["*.trig"], "magic": []},
    {
        "type": "application/x-pagemaker",
        "name": "Adobe PageMaker document",
        "pattern": ["*.p65", "*.pm", "*.pm6", "*.pmd"],
        "magic": [],
    },
    {
        "type": "application/x-doom-wad",
        "name": "Doom WAD file",
        "pattern": ["*.wad"],
        "magic": [{"offset": 0, "value": b"IWAD"}, {"offset": 0, "value": b"PWAD"}],
    },
    {
        "type": "application/x-amiga-disk-format",
        "name": "Amiga disk image",
        "pattern": ["*.adf"],
        "magic": [{"offset": 0, "value": b"DOS\x00"}],
    },
    {
        "type": "application/vnd.flatpak",
        "name": "Flatpak application bundle",
        "pattern": ["*.flatpak", "*.xdgapp"],
        "magic": [
            {"offset": 0, "value": b"xdg-app\x00\x01\x00\x89\xe5"},
            {"offset": 0, "value": b"flatpak\x00\x01\x00\x89\xe5"},
        ],
    },
    {
        "type": "application/vnd.flatpak.repo",
        "name": "Flatpak repository description",
        "pattern": ["*.flatpakrepo"],
        "magic": [{"offset": 0, "value": b"[Flatpak Repo]"}],
    },
    {
        "type": "application/vnd.flatpak.ref",
        "name": "Flatpak repository reference",
        "pattern": ["*.flatpakref"],
        "magic": [{"offset": 0, "value": b"[Flatpak Ref]"}],
    },
    {
        "type": "application/vnd.squashfs",
        "name": "Squashfs filesystem image",
        "pattern": ["*.sfs", "*.sqfs", "*.sqsh", "*.squashfs"],
        "magic": [{"offset": 0, "value": b"hsqs"}],
    },
    {"type": "application/vnd.snap", "name": "Snap package", "pattern": ["*.snap"], "magic": []},
    {
        "type": "model/stl",
        "name": "STL 3D model",
        "pattern": ["*.stl"],
        "magic": [{"offset": 0, "value": b"solid"}, {"offset": 0, "value": b"SOLID"}],
    },
    {
        "type": "model/step",
        "name": "STEP 3D model",
        "pattern": ["*.step", "*.stp"],
        "magic": [{"offset": 0, "value": b"ISO-10303-21;"}],
    },
    {"type": "application/x-amf", "name": "AMF 3D model", "pattern": ["*.amf"], "magic": []},
    {"type": "text/x.gcode", "name": "G-code file", "pattern": ["*.gcode"], "magic": []},
    {
        "type": "text/x-gcode-gx",
        "name": "G-code Extended file",
        "pattern": ["*.gx"],
        "magic": [{"offset": 0, "value": b"xgcode 1.0"}],
    },
    {
        "type": "application/x-fds-disk",
        "name": "Nintendo FDS disk image",
        "pattern": ["*.fds"],
        "magic": [{"offset": 1, "value": b"*NINTENDO-HVC*"}],
    },
    {
        "type": "application/ovf",
        "name": "OVF disk image",
        "pattern": ["*.ova"],
        "magic": [{"offset": 1, "value": b".ovf"}],
    },
    {
        "type": "application/x-qed-disk",
        "name": "QEMU QED disk image",
        "pattern": ["*.qed"],
        "magic": [{"offset": 0, "value": b"QED\x00"}],
    },
    {
        "type": "application/x-qemu-disk",
        "name": "QEMU QCOW disk image",
        "pattern": ["*.qcow2", "*.qcow"],
        "magic": [{"offset": 0, "value": b"QFI"}],
    },
    {
        "type": "application/x-vhd-disk",
        "name": "VHD disk image",
        "pattern": ["*.vhd", "*.vpc"],
        "magic": [{"offset": 0, "value": b"conectix"}],
    },
    {
        "type": "application/x-vhdx-disk",
        "name": "VHDX disk image",
        "pattern": ["*.vhdx"],
        "magic": [{"offset": 0, "value": b"vhdxfile"}],
    },
    {
        "type": "application/x-vmdk-disk",
        "name": "VMDK disk image",
        "pattern": ["*.vmdk"],
        "magic": [{"offset": 0, "value": b"KDMV\x01\x00\x00\x00"}, {"offset": 0, "value": b"KDMV\x02\x00\x00\x00"}],
    },
    {
        "type": "application/x-vdi-disk",
        "name": "VDI disk image",
        "pattern": ["*.vdi"],
        "magic": [
            {"offset": 0, "value": b"<<< QEMU VM Virtual Disk Image >>>\\n"},
            {"offset": 0, "value": b"<<< Oracle VM VirtualBox Disk Image >>>\\n"},
            {"offset": 0, "value": b"<<< Sun VirtualBox Disk Image >>>\\n"},
            {"offset": 0, "value": b"<<< Sun xVM VirtualBox Disk Image >>>\\n"},
            {"offset": 0, "value": b"<<< innotek VirtualBox Disk Image >>>"},
            {"offset": 0, "value": b"<<< CloneVDI VirtualBox Disk Image >>>\\n"},
        ],
    },
    {"type": "application/x-appleworks-document", "name": "AppleWorks document", "pattern": ["*.cwk"], "magic": []},
    {
        "type": "application/x-bps-patch",
        "name": "BPS patch",
        "pattern": ["*.bps"],
        "magic": [{"offset": 0, "value": b"BPS1"}],
    },
    {
        "type": "application/x-ips-patch",
        "name": "IPS patch",
        "pattern": ["*.ips"],
        "magic": [{"offset": 0, "value": b"PATCH"}],
    },
    {
        "type": "application/x-pyspread-spreadsheet",
        "name": "Pyspread spreadsheet",
        "pattern": ["*.pysu"],
        "magic": [{"offset": 0, "value": b"[Pyspread save file version]"}],
    },
    {
        "type": "application/x-pyspread-bz-spreadsheet",
        "name": "Pyspread spreadsheet (bzip2-compressed)",
        "pattern": ["*.pys"],
        "magic": [],
    },
    {"type": "text/x-kotlin", "name": "Kotlin source code", "pattern": ["*.kt"], "magic": []},
    {
        "type": "text/x-devicetree-binary",
        "name": "Flattened Devicetree",
        "pattern": ["*.dtb"],
        "magic": [{"offset": 0, "value": b"\xd0\r\xfe\xed"}],
    },
    {
        "type": "image/avif",
        "name": "AVIF image",
        "pattern": ["*.avif", "*.avifs"],
        "magic": [{"offset": 4, "value": b"ftypavif"}, {"offset": 4, "value": b"ftypavis"}],
    },
    {
        "type": "image/qoi",
        "name": "Quite OK Image Format",
        "pattern": ["*.qoi"],
        "magic": [{"offset": 0, "value": b"qoif"}],
    },
    {
        "type": "video/vnd.radgamettools.bink",
        "name": "Bink Video",
        "pattern": ["*.bik", "*.bk2"],
        "magic": [{"offset": 0, "value": b"BIK"}, {"offset": 0, "value": b"KB2"}],
    },
    {
        "type": "video/vnd.radgamettools.smacker",
        "name": "Smacker Video",
        "pattern": ["*.smk"],
        "magic": [{"offset": 0, "value": b"SMK"}],
    },
    {"type": "text/org", "name": "Org-mode file", "pattern": ["*.org"], "magic": []},
    {
        "type": "application/x-openzim",
        "name": "OpenZIM file",
        "pattern": ["*.zim"],
        "magic": [{"offset": 0, "value": b"ZIM\x04"}],
    },
    {
        "type": "application/sparql-query",
        "name": "SPARQL query",
        "pattern": ["*.qs"],
        "magic": [{"offset": 0, "value": b"PREFIX"}],
    },
    {
        "type": "application/wasm",
        "name": "WASM binary module",
        "pattern": ["*.wasm"],
        "magic": [{"offset": 0, "value": b"\x00asm"}],
    },
    {
        "type": "application/x-openvpn-profile",
        "name": "OpenVPN profile",
        "pattern": ["*.openvpn", "*.ovpn"],
        "magic": [],
    },
    {"type": "application/cbor", "name": "CBOR Data", "pattern": ["*.cbor"], "magic": []},
    {
        "type": "application/x-eris-link+cbor",
        "name": "ERIS Link",
        "pattern": ["*.eris"],
        "magic": [{"offset": 0, "value": b"\xd9\xd9\xf7\x84\xd9\x01\x14XB"}],
    },
    {
        "type": "application/vnd.gerber",
        "name": "Gerber file",
        "pattern": ["*.gbr"],
        "magic": [
            {"offset": 0, "value": b"G04 "},
            {"offset": 0, "value": b"%FSLA"},
            {"offset": 0, "value": b"%MO"},
            {"offset": 0, "value": b"%TF."},
            {"offset": 0, "value": b"G75*"},
        ],
    },
    {
        "type": "application/x-excellon",
        "name": "Excellon drill file",
        "pattern": ["*.drl"],
        "magic": [{"offset": 0, "value": b"M48\\n"}],
    },
    {"type": "image/x-sct", "name": "Scitex CT", "pattern": ["*.sct"], "magic": [{"offset": 80, "value": b"CT"}]},
    {
        "type": "image/x-pxr",
        "name": "Pixar raster",
        "pattern": ["*.pxr"],
        "magic": [{"offset": 0, "value": b"\x80\xe8\x00\x00"}],
    },
    {
        "type": "image/x-pfm",
        "name": "Portable FloatMap",
        "pattern": ["*.pfm"],
        "magic": [{"offset": 0, "value": b"PF\\n"}, {"offset": 0, "value": b"Pf\\n"}],
    },
    {"type": "text/x-nsis", "name": "NSIS Script", "pattern": ["*.nsi", "*.nsh"], "magic": []},
    {
        "type": "image/x-phm",
        "name": "Portable HalfMap",
        "pattern": ["*.phm"],
        "magic": [{"offset": 0, "value": b"PH\\n"}, {"offset": 0, "value": b"Ph\\n"}],
    },
    {
        "type": "application/x-ns-proxy-autoconfig",
        "name": "Proxy Auto-Configuration file",
        "pattern": ["*.pac"],
        "magic": [{"offset": 0, "value": b"function FindProxyForURL"}],
    },
    {
        "type": "application/x.sf3-archive",
        "name": "SF3 Archive",
        "pattern": ["*.ar.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\x01"}],
    },
    {
        "type": "audio/x.sf3",
        "name": "SF3 Audio",
        "pattern": ["*.au.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\x02"}],
    },
    {
        "type": "image/x.sf3",
        "name": "SF3 Image",
        "pattern": ["*.img.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\x03"}],
    },
    {
        "type": "application/x.sf3-log",
        "name": "SF3 Log File",
        "pattern": ["*.log.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\x04"}],
    },
    {
        "type": "model/x.sf3",
        "name": "SF3 3D Model",
        "pattern": ["*.mod.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\x05"}],
    },
    {
        "type": "model/x.sf3-physics",
        "name": "SF3 Physics Model",
        "pattern": ["*.phys.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\x06"}],
    },
    {
        "type": "application/x.sf3-table",
        "name": "SF3 Table",
        "pattern": ["*.tab.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\x07"}],
    },
    {
        "type": "application/x.sf3-text",
        "name": "SF3 Rich Text",
        "pattern": ["*.txt.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\x08"}],
    },
    {
        "type": "image/x.sf3-vector",
        "name": "SF3 Vector Graphic",
        "pattern": ["*.vec.sf3", "*.sf3"],
        "magic": [{"offset": 0, "value": b"\x81SF3\x00\xe0\xd0\r\n\n\t"}],
    },
]
