/* linux.c generated by valac 0.58.0-frida, the Vala compiler
 * generated from linux.vala, do not modify */

#include <glib.h>
#include "frida-base.h"
#include <sys/utsname.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib-object.h>
#include <errno.h>
#include <unistd.h>
#include <sys/syscall.h>
#include <linux-syscall.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 5)
#pragma GCC diagnostic ignored "-Wchar-subscripts"
#pragma GCC diagnostic ignored "-Wincompatible-pointer-types"
#pragma GCC diagnostic ignored "-Wint-conversion"
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#pragma GCC diagnostic ignored "-Wpointer-sign"
#pragma GCC diagnostic ignored "-Wpointer-to-int-cast"
#pragma GCC diagnostic ignored "-Wreturn-type"
#pragma GCC diagnostic ignored "-Wsign-compare"
#pragma GCC diagnostic ignored "-Wunused-function"
#pragma GCC diagnostic ignored "-Wunused-label"
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wunused-variable"
#pragma GCC diagnostic ignored "-Wdiscarded-qualifiers"
#pragma GCC diagnostic ignored "-Wint-to-pointer-cast"
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#pragma GCC diagnostic ignored "-Wunused-but-set-variable"
#elif defined(__clang__)
#pragma clang diagnostic ignored "-Wchar-subscripts"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#pragma clang diagnostic ignored "-Wint-conversion"
#pragma clang diagnostic ignored "-Wmissing-field-initializers"
#pragma clang diagnostic ignored "-Wpointer-sign"
#pragma clang diagnostic ignored "-Wpointer-to-int-cast"
#pragma clang diagnostic ignored "-Wreturn-type"
#pragma clang diagnostic ignored "-Wsign-compare"
#pragma clang diagnostic ignored "-Wunused-function"
#pragma clang diagnostic ignored "-Wunused-label"
#pragma clang diagnostic ignored "-Wunused-parameter"
#pragma clang diagnostic ignored "-Wunused-variable"
#pragma clang diagnostic ignored "-Wint-to-void-pointer-cast"
#pragma clang diagnostic ignored "-Wtypedef-redefinition"
#pragma clang diagnostic ignored "-Wunused-value"
#pragma clang diagnostic ignored "-Wvoid-pointer-to-int-cast"
#elif defined(_MSC_VER)
#pragma warning (disable: 4022 4047 4057 4090 4100 4102 4113 4127 4133 4152 4189 4244 4267 4305 4311 4312 4389 4456 4702 4715)
#endif
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 8)
#pragma GCC diagnostic ignored "-Wcast-function-type"
#endif
#if defined(__clang__) && (__clang_major__ >= 13)
#pragma clang diagnostic ignored "-Wunused-but-set-variable"
#endif
#endif

typedef struct _FridaPidFileDescriptor FridaPidFileDescriptor;
typedef struct _FridaPidFileDescriptorClass FridaPidFileDescriptorClass;
typedef struct _FridaPidFileDescriptorPrivate FridaPidFileDescriptorPrivate;
enum  {
	FRIDA_PID_FILE_DESCRIPTOR_0_PROPERTY,
	FRIDA_PID_FILE_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* frida_pid_file_descriptor_properties[FRIDA_PID_FILE_DESCRIPTOR_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FridaPidFileDescriptor {
	FridaFileDescriptor parent_instance;
	FridaPidFileDescriptorPrivate * priv;
};

struct _FridaPidFileDescriptorClass {
	FridaFileDescriptorClass parent_class;
};

struct _FridaPidFileDescriptorPrivate {
	guint pid;
};

VALA_EXTERN guint frida_linux_major;
guint frida_linux_major = (guint) 0;
VALA_EXTERN guint frida_linux_minor;
guint frida_linux_minor = (guint) 0;
static gint FridaPidFileDescriptor_private_offset;
static gpointer frida_pid_file_descriptor_parent_class = NULL;

static FridaPidFileDescriptor* frida_pid_file_descriptor_new (gint fd,
                                                       guint pid);
static FridaPidFileDescriptor* frida_pid_file_descriptor_construct (GType object_type,
                                                             gint fd,
                                                             guint pid);
static gint frida_pid_file_descriptor_pidfd_open (guint pid,
                                           guint flags);
static void frida_pid_file_descriptor_throw_pidfd_error (guint pid,
                                                  gint err,
                                                  GError** error);
static gint frida_pid_file_descriptor_pidfd_getfd (gint pidfd,
                                            gint targetfd,
                                            guint flags);
static void frida_pid_file_descriptor_finalize (GObject * obj);
static GType frida_pid_file_descriptor_get_type_once (void);
VALA_EXTERN gint frida_memory_file_descriptor_memfd_create (const gchar* name,
                                                guint flags);

gboolean
frida_check_kernel_version (guint major,
                            guint minor)
{
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean result;
#line 6 "../subprojects/frida-core/lib/base/linux.vala"
	if (frida_linux_major == ((guint) 0)) {
#line 123 "linux.c"
		struct utsname name = {0};
		struct utsname _tmp0_;
		const gchar* _tmp1_;
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
#line 7 "../subprojects/frida-core/lib/base/linux.vala"
		uname (&name);
#line 8 "../subprojects/frida-core/lib/base/linux.vala"
		_tmp0_ = name;
#line 8 "../subprojects/frida-core/lib/base/linux.vala"
		_tmp1_ = _tmp0_.release;
#line 8 "../subprojects/frida-core/lib/base/linux.vala"
		sscanf (_tmp1_, "%u.%u", &_tmp2_, &_tmp3_);
#line 8 "../subprojects/frida-core/lib/base/linux.vala"
		frida_linux_major = _tmp2_;
#line 8 "../subprojects/frida-core/lib/base/linux.vala"
		frida_linux_minor = _tmp3_;
#line 141 "linux.c"
	}
#line 11 "../subprojects/frida-core/lib/base/linux.vala"
	if (frida_linux_major == major) {
#line 11 "../subprojects/frida-core/lib/base/linux.vala"
		_tmp5_ = frida_linux_minor >= minor;
#line 147 "linux.c"
	} else {
#line 11 "../subprojects/frida-core/lib/base/linux.vala"
		_tmp5_ = FALSE;
#line 151 "linux.c"
	}
#line 11 "../subprojects/frida-core/lib/base/linux.vala"
	if (_tmp5_) {
#line 11 "../subprojects/frida-core/lib/base/linux.vala"
		_tmp4_ = TRUE;
#line 157 "linux.c"
	} else {
#line 11 "../subprojects/frida-core/lib/base/linux.vala"
		_tmp4_ = frida_linux_major > major;
#line 161 "linux.c"
	}
#line 11 "../subprojects/frida-core/lib/base/linux.vala"
	result = _tmp4_;
#line 11 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 167 "linux.c"
}

static inline gpointer
frida_pid_file_descriptor_get_instance_private (FridaPidFileDescriptor* self)
{
	return G_STRUCT_MEMBER_P (self, FridaPidFileDescriptor_private_offset);
}

static FridaPidFileDescriptor*
frida_pid_file_descriptor_construct (GType object_type,
                                     gint fd,
                                     guint pid)
{
	FridaPidFileDescriptor * self = NULL;
#line 18 "../subprojects/frida-core/lib/base/linux.vala"
	self = (FridaPidFileDescriptor*) frida_file_descriptor_construct (object_type, fd);
#line 19 "../subprojects/frida-core/lib/base/linux.vala"
	self->priv->pid = pid;
#line 17 "../subprojects/frida-core/lib/base/linux.vala"
	return self;
#line 188 "linux.c"
}

static FridaPidFileDescriptor*
frida_pid_file_descriptor_new (gint fd,
                               guint pid)
{
#line 17 "../subprojects/frida-core/lib/base/linux.vala"
	return frida_pid_file_descriptor_construct (FRIDA_TYPE_PID_FILE_DESCRIPTOR, fd, pid);
#line 197 "linux.c"
}

gboolean
frida_pid_file_descriptor_is_supported (void)
{
	gboolean result;
#line 23 "../subprojects/frida-core/lib/base/linux.vala"
	result = frida_check_kernel_version ((guint) 5, (guint) 3);
#line 23 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 208 "linux.c"
}

gboolean
frida_pid_file_descriptor_getfd_is_supported (void)
{
	gboolean result;
#line 27 "../subprojects/frida-core/lib/base/linux.vala"
	result = frida_check_kernel_version ((guint) 5, (guint) 6);
#line 27 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 219 "linux.c"
}

FridaPidFileDescriptor*
frida_pid_file_descriptor_from_pid (guint pid,
                                    GError** error)
{
	gint fd = 0;
	FridaPidFileDescriptor* _tmp0_;
	GError* _inner_error0_ = NULL;
	FridaPidFileDescriptor* result;
#line 31 "../subprojects/frida-core/lib/base/linux.vala"
	fd = frida_pid_file_descriptor_pidfd_open (pid, (guint) 0);
#line 32 "../subprojects/frida-core/lib/base/linux.vala"
	if (fd == -1) {
#line 33 "../subprojects/frida-core/lib/base/linux.vala"
		frida_pid_file_descriptor_throw_pidfd_error (pid, errno, &_inner_error0_);
#line 33 "../subprojects/frida-core/lib/base/linux.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 33 "../subprojects/frida-core/lib/base/linux.vala"
			if (_inner_error0_->domain == FRIDA_ERROR) {
#line 33 "../subprojects/frida-core/lib/base/linux.vala"
				g_propagate_error (error, _inner_error0_);
#line 33 "../subprojects/frida-core/lib/base/linux.vala"
				return NULL;
#line 244 "linux.c"
			} else {
#line 33 "../subprojects/frida-core/lib/base/linux.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 33 "../subprojects/frida-core/lib/base/linux.vala"
				g_clear_error (&_inner_error0_);
#line 33 "../subprojects/frida-core/lib/base/linux.vala"
				return NULL;
#line 252 "linux.c"
			}
		}
	}
#line 34 "../subprojects/frida-core/lib/base/linux.vala"
	_tmp0_ = frida_pid_file_descriptor_new (fd, pid);
#line 34 "../subprojects/frida-core/lib/base/linux.vala"
	result = _tmp0_;
#line 34 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 262 "linux.c"
}

FridaFileDescriptor*
frida_pid_file_descriptor_getfd (FridaPidFileDescriptor* self,
                                 gint targetfd,
                                 GError** error)
{
	gint fd = 0;
	FridaFileDescriptor* _tmp0_;
	GError* _inner_error0_ = NULL;
	FridaFileDescriptor* result;
#line 37 "../subprojects/frida-core/lib/base/linux.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "../subprojects/frida-core/lib/base/linux.vala"
	fd = frida_pid_file_descriptor_pidfd_getfd (((FridaFileDescriptor*) self)->handle, targetfd, (guint) 0);
#line 39 "../subprojects/frida-core/lib/base/linux.vala"
	if (fd == -1) {
#line 40 "../subprojects/frida-core/lib/base/linux.vala"
		frida_pid_file_descriptor_throw_pidfd_error (self->priv->pid, errno, &_inner_error0_);
#line 40 "../subprojects/frida-core/lib/base/linux.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 40 "../subprojects/frida-core/lib/base/linux.vala"
			if (_inner_error0_->domain == FRIDA_ERROR) {
#line 40 "../subprojects/frida-core/lib/base/linux.vala"
				g_propagate_error (error, _inner_error0_);
#line 40 "../subprojects/frida-core/lib/base/linux.vala"
				return NULL;
#line 290 "linux.c"
			} else {
#line 40 "../subprojects/frida-core/lib/base/linux.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 40 "../subprojects/frida-core/lib/base/linux.vala"
				g_clear_error (&_inner_error0_);
#line 40 "../subprojects/frida-core/lib/base/linux.vala"
				return NULL;
#line 298 "linux.c"
			}
		}
	}
#line 41 "../subprojects/frida-core/lib/base/linux.vala"
	_tmp0_ = frida_file_descriptor_new (fd);
#line 41 "../subprojects/frida-core/lib/base/linux.vala"
	result = _tmp0_;
#line 41 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 308 "linux.c"
}

static gint
frida_pid_file_descriptor_pidfd_open (guint pid,
                                      guint flags)
{
	gint result;
#line 45 "../subprojects/frida-core/lib/base/linux.vala"
	result = syscall ((gint) SYS_pidfd_open, pid, flags, NULL);
#line 45 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 320 "linux.c"
}

static gint
frida_pid_file_descriptor_pidfd_getfd (gint pidfd,
                                       gint targetfd,
                                       guint flags)
{
	gint result;
#line 49 "../subprojects/frida-core/lib/base/linux.vala"
	result = syscall ((gint) SYS_pidfd_getfd, pidfd, targetfd, flags, NULL);
#line 49 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 333 "linux.c"
}

static void
frida_pid_file_descriptor_throw_pidfd_error (guint pid,
                                             gint err,
                                             GError** error)
{
	GError* _inner_error0_ = NULL;
#line 54 "../subprojects/frida-core/lib/base/linux.vala"
	switch (err) {
#line 54 "../subprojects/frida-core/lib/base/linux.vala"
		case ESRCH:
#line 346 "linux.c"
		{
			GError* _tmp0_;
#line 56 "../subprojects/frida-core/lib/base/linux.vala"
			_tmp0_ = g_error_new_literal (FRIDA_ERROR, FRIDA_ERROR_PROCESS_NOT_FOUND, "Process not found");
#line 56 "../subprojects/frida-core/lib/base/linux.vala"
			_inner_error0_ = _tmp0_;
#line 56 "../subprojects/frida-core/lib/base/linux.vala"
			if (_inner_error0_->domain == FRIDA_ERROR) {
#line 56 "../subprojects/frida-core/lib/base/linux.vala"
				g_propagate_error (error, _inner_error0_);
#line 56 "../subprojects/frida-core/lib/base/linux.vala"
				return;
#line 359 "linux.c"
			} else {
#line 56 "../subprojects/frida-core/lib/base/linux.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 56 "../subprojects/frida-core/lib/base/linux.vala"
				g_clear_error (&_inner_error0_);
#line 56 "../subprojects/frida-core/lib/base/linux.vala"
				return;
#line 367 "linux.c"
			}
		}
#line 54 "../subprojects/frida-core/lib/base/linux.vala"
		case EPERM:
#line 372 "linux.c"
		{
			const gchar* _tmp1_;
			GError* _tmp2_;
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
			_tmp1_ = g_strerror (err);
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
			_tmp2_ = g_error_new (FRIDA_ERROR, FRIDA_ERROR_PERMISSION_DENIED, "Unable to use pidfd for pid %u: %s", pid, _tmp1_);
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
			_inner_error0_ = _tmp2_;
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
			if (_inner_error0_->domain == FRIDA_ERROR) {
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
				g_propagate_error (error, _inner_error0_);
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
				return;
#line 388 "linux.c"
			} else {
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
				g_clear_error (&_inner_error0_);
#line 58 "../subprojects/frida-core/lib/base/linux.vala"
				return;
#line 396 "linux.c"
			}
		}
		default:
		{
			const gchar* _tmp3_;
			GError* _tmp4_;
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
			_tmp3_ = g_strerror (err);
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
			_tmp4_ = g_error_new (FRIDA_ERROR, FRIDA_ERROR_NOT_SUPPORTED, "Unable to use pidfd for pid %u: %s", pid, _tmp3_);
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
			_inner_error0_ = _tmp4_;
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
			if (_inner_error0_->domain == FRIDA_ERROR) {
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
				g_propagate_error (error, _inner_error0_);
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
				return;
#line 415 "linux.c"
			} else {
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
				g_clear_error (&_inner_error0_);
#line 60 "../subprojects/frida-core/lib/base/linux.vala"
				return;
#line 423 "linux.c"
			}
		}
	}
}

static void
frida_pid_file_descriptor_class_init (FridaPidFileDescriptorClass * klass,
                                      gpointer klass_data)
{
#line 14 "../subprojects/frida-core/lib/base/linux.vala"
	frida_pid_file_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 14 "../subprojects/frida-core/lib/base/linux.vala"
	g_type_class_adjust_private_offset (klass, &FridaPidFileDescriptor_private_offset);
#line 14 "../subprojects/frida-core/lib/base/linux.vala"
	G_OBJECT_CLASS (klass)->finalize = frida_pid_file_descriptor_finalize;
#line 439 "linux.c"
}

static void
frida_pid_file_descriptor_instance_init (FridaPidFileDescriptor * self,
                                         gpointer klass)
{
#line 14 "../subprojects/frida-core/lib/base/linux.vala"
	self->priv = frida_pid_file_descriptor_get_instance_private (self);
#line 448 "linux.c"
}

static void
frida_pid_file_descriptor_finalize (GObject * obj)
{
	FridaPidFileDescriptor * self;
#line 14 "../subprojects/frida-core/lib/base/linux.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FRIDA_TYPE_PID_FILE_DESCRIPTOR, FridaPidFileDescriptor);
#line 14 "../subprojects/frida-core/lib/base/linux.vala"
	G_OBJECT_CLASS (frida_pid_file_descriptor_parent_class)->finalize (obj);
#line 459 "linux.c"
}

 G_GNUC_NO_INLINE static GType
frida_pid_file_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FridaPidFileDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) frida_pid_file_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FridaPidFileDescriptor), 0, (GInstanceInitFunc) frida_pid_file_descriptor_instance_init, NULL };
	GType frida_pid_file_descriptor_type_id;
	frida_pid_file_descriptor_type_id = g_type_register_static (FRIDA_TYPE_FILE_DESCRIPTOR, "FridaPidFileDescriptor", &g_define_type_info, G_TYPE_FLAG_FINAL);
	FridaPidFileDescriptor_private_offset = g_type_add_instance_private (frida_pid_file_descriptor_type_id, sizeof (FridaPidFileDescriptorPrivate));
	return frida_pid_file_descriptor_type_id;
}

GType
frida_pid_file_descriptor_get_type (void)
{
	static gsize frida_pid_file_descriptor_type_id__once = 0;
	if (g_once_init_enter (&frida_pid_file_descriptor_type_id__once)) {
		GType frida_pid_file_descriptor_type_id;
		frida_pid_file_descriptor_type_id = frida_pid_file_descriptor_get_type_once ();
		g_once_init_leave (&frida_pid_file_descriptor_type_id__once, frida_pid_file_descriptor_type_id);
	}
	return frida_pid_file_descriptor_type_id__once;
}

gboolean
frida_memory_file_descriptor_is_supported (void)
{
	gboolean result;
#line 67 "../subprojects/frida-core/lib/base/linux.vala"
	result = frida_check_kernel_version ((guint) 3, (guint) 17);
#line 67 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 492 "linux.c"
}

FridaFileDescriptor*
frida_memory_file_descriptor_from_bytes (const gchar* name,
                                         GBytes* bytes)
{
	FridaFileDescriptor* fd = NULL;
	FridaFileDescriptor* _tmp0_;
	guint8* data = NULL;
	gsize _tmp1_ = 0;
	guint8* _tmp2_;
	gint data_length1;
	gint _data_size_;
	gssize n = 0L;
	FridaFileDescriptor* result;
#line 70 "../subprojects/frida-core/lib/base/linux.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 70 "../subprojects/frida-core/lib/base/linux.vala"
	g_return_val_if_fail (bytes != NULL, NULL);
#line 71 "../subprojects/frida-core/lib/base/linux.vala"
	_vala_assert (frida_memory_file_descriptor_is_supported (), "is_supported ()");
#line 73 "../subprojects/frida-core/lib/base/linux.vala"
	_tmp0_ = frida_file_descriptor_new (frida_memory_file_descriptor_memfd_create (name, (guint) 0));
#line 73 "../subprojects/frida-core/lib/base/linux.vala"
	fd = _tmp0_;
#line 74 "../subprojects/frida-core/lib/base/linux.vala"
	_tmp2_ = g_bytes_get_data (bytes, &_tmp1_);
#line 74 "../subprojects/frida-core/lib/base/linux.vala"
	data = _tmp2_;
#line 74 "../subprojects/frida-core/lib/base/linux.vala"
	data_length1 = _tmp1_;
#line 74 "../subprojects/frida-core/lib/base/linux.vala"
	_data_size_ = data_length1;
#line 75 "../subprojects/frida-core/lib/base/linux.vala"
	n = write (fd->handle, data, (gsize) data_length1);
#line 76 "../subprojects/frida-core/lib/base/linux.vala"
	_vala_assert (n == ((gssize) data_length1), "n == data.length");
#line 77 "../subprojects/frida-core/lib/base/linux.vala"
	result = fd;
#line 77 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 534 "linux.c"
}

gint
frida_memory_file_descriptor_memfd_create (const gchar* name,
                                           guint flags)
{
	gint result;
#line 80 "../subprojects/frida-core/lib/base/linux.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 81 "../subprojects/frida-core/lib/base/linux.vala"
	result = syscall ((gint) SYS_memfd_create, name, flags, NULL);
#line 81 "../subprojects/frida-core/lib/base/linux.vala"
	return result;
#line 548 "linux.c"
}

