/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.html;

import org.jpype.html.AttrParser;
import org.jpype.html.Parser;
import org.w3c.dom.Attr;

public class AttrGrammar
implements Parser.Grammar {
    static final AttrGrammar INSTANCE = new AttrGrammar();
    static final Token[] freeTokens = AttrGrammar.tokens(Token.QUOTE, Token.SQUOTE, Token.EQ, Token.WHITESPACE, Token.TEXT);
    static final Token[] qtTokens = AttrGrammar.tokens(Token.QUOTE, Token.TEXT);
    static final Token[] sqtTokens = AttrGrammar.tokens(Token.SQUOTE, Token.TEXT);
    static final Parser.Rule ignoreWS = new IgnoreWSRule();
    static final Parser.Rule quoteRule = new QuoteRule();
    static final Parser.Rule endRule = new EndQuoteRule();
    static final Parser.Rule attrRule = new AttrRule();
    static final Parser.Rule boolRule = new BooleanRule();
    static final Parser.Rule[] freeRules = AttrGrammar.rules(attrRule, boolRule, ignoreWS, quoteRule);
    static final Parser.Rule[] qtRules = AttrGrammar.rules(endRule);

    private AttrGrammar() {
    }

    @Override
    public void start(Parser parser) {
        parser.state = State.FREE;
        ((AttrParser)parser).attrs.clear();
    }

    @Override
    public Object end(Parser parser) {
        return ((AttrParser)parser).attrs;
    }

    static Token[] tokens(Token ... tokenArray) {
        return tokenArray;
    }

    static Parser.Rule[] rules(Parser.Rule ... ruleArray) {
        return ruleArray;
    }

    static enum State implements Parser.State
    {
        FREE(freeTokens, freeRules),
        IN_QUOTE(qtTokens, qtRules),
        IN_SQUOTE(sqtTokens, qtRules);

        Token[] tokens;
        Parser.Rule[] rules;

        private State(Token[] tokenArray, Parser.Rule[] ruleArray) {
            this.tokens = tokenArray;
            this.rules = ruleArray;
        }

        public Token[] getTokens() {
            return this.tokens;
        }

        @Override
        public Parser.Rule[] getRules() {
            return this.rules;
        }
    }

    static enum Token implements Parser.Token
    {
        TEXT,
        QUOTE("\""),
        SQUOTE("'"),
        EQ("="),
        WHITESPACE(" ");

        byte value;
        String text;

        private Token() {
        }

        private Token(String string2) {
            this.text = string2;
            if (string2.length() == 1) {
                this.value = (byte)string2.charAt(0);
            }
        }

        @Override
        public final boolean matches(byte by) {
            if (this.value == 32) {
                return Character.isWhitespace(by);
            }
            if (this.value == 0) {
                return true;
            }
            return by == this.value;
        }

        @Override
        public boolean runs() {
            return this == TEXT;
        }

        public String toString() {
            if (this.text != null) {
                return this.text;
            }
            return "TEXT";
        }
    }

    static class IgnoreWSRule
    implements Parser.Rule {
        IgnoreWSRule() {
        }

        public boolean apply(Parser parser, Parser.Entity entity) {
            if (entity.token != Token.WHITESPACE) {
                return false;
            }
            parser.stack.removeLast();
            return true;
        }
    }

    static class QuoteRule
    implements Parser.Rule {
        QuoteRule() {
        }

        public boolean apply(Parser parser, Parser.Entity entity) {
            if (entity.token == Token.QUOTE) {
                parser.state = State.IN_QUOTE;
                parser.stack.removeLast();
                return true;
            }
            if (entity.token == Token.SQUOTE) {
                parser.state = State.IN_SQUOTE;
                parser.stack.removeLast();
                return true;
            }
            return false;
        }
    }

    static class EndQuoteRule
    implements Parser.Rule {
        EndQuoteRule() {
        }

        public boolean apply(Parser parser, Parser.Entity entity) {
            if (State.IN_QUOTE == parser.state && entity.token == Token.QUOTE) {
                parser.state = State.FREE;
                parser.stack.removeLast();
                return true;
            }
            if (State.IN_SQUOTE == parser.state && entity.token == Token.SQUOTE) {
                parser.state = State.FREE;
                parser.stack.removeLast();
                return true;
            }
            return false;
        }
    }

    static class AttrRule
    extends Parser.MatchRule {
        AttrRule() {
            super(Token.TEXT, Token.EQ, Token.TEXT);
        }

        @Override
        public void execute(Parser parser) {
            Parser.Entity entity = parser.stack.removeLast();
            Parser.Entity entity2 = parser.stack.removeLast();
            Parser.Entity entity3 = parser.stack.removeLast();
            AttrParser attrParser = (AttrParser)parser;
            Attr attr = attrParser.doc.createAttribute((String)entity3.value);
            attr.setNodeValue((String)entity.value);
            attrParser.attrs.add(attr);
        }
    }

    static class BooleanRule
    extends Parser.MatchRule {
        BooleanRule() {
            super(Token.TEXT, Token.TEXT);
        }

        @Override
        public void execute(Parser parser) {
            Parser.Entity entity = parser.stack.removeLast();
            Parser.Entity entity2 = parser.stack.removeLast();
            AttrParser attrParser = (AttrParser)parser;
            Attr attr = attrParser.doc.createAttribute((String)entity2.value);
            attr.setNodeValue((String)entity2.value);
            attrParser.attrs.add(attr);
            parser.stack.add(entity);
        }
    }
}

