"""
This type stub file was generated by pyright.
"""

import builtins
import datetime
from collections.abc import Sequence
from types import TracebackType
from typing import Generic, Literal, overload

from typing_extensions import TypeVar, override

from . import _mssql
from ._mssql import QueryParams as QueryParams, SqlValue as SqlValue, set_wait_callback as set_wait_callback
from .exceptions import *

TupleRow = tuple[SqlValue, ...]
DictRow = dict[str, SqlValue]

_Row = TypeVar("_Row", default=TupleRow)

ColumnDescription = tuple[str, int, None, None, None, None, None]

__author__: str
__full_version__: str
__version__: str
VERSION: tuple[int, ...]
apilevel: str
threadsafety: int
paramstyle: str
NoParams = _mssql.NoParams

class DBAPIType:
    value: int
    def __init__(self, value: int) -> None: ...
    def __cmp__(self, other: object) -> int: ...
    @override
    def __eq__(self, other: object) -> bool: ...
    @override
    def __repr__(self) -> str: ...

STRING: DBAPIType
BINARY: DBAPIType
NUMBER: DBAPIType
DATETIME: DBAPIType
DECIMAL: DBAPIType
Date = datetime.date
Time = datetime.time
Timestamp = datetime.datetime
def DateFromTicks(ticks: float) -> datetime.date: ...
def TimeFromTicks(ticks: float) -> datetime.time: ...
def TimestampFromTicks(ticks: float) -> datetime.datetime: ...
Binary: type[bytearray]

def row2dict(row: _mssql.DictRow) -> DictRow:
    """Filter dict so it only has string keys; used when as_dict == True"""
    ...

class output:
    @property
    def type(self) -> type: ...
    @property
    def value(self) -> SqlValue: ...
    def __init__(self, param_type: builtins.type, value: SqlValue = None) -> None: ...

class Connection(Generic[_Row]):
    """
    This class represents an MS-SQL database connection.
    """

    as_dict: bool
    @property
    def autocommit_state(self) -> bool: ...
    @property
    def _conn(self) -> _mssql.MSSQLConnection: ...
    arraysize: int
    def __init__(
        self,
        conn: _mssql.MSSQLConnection,
        as_dict: bool,
        autocommit: bool,
        arraysize: int = ...,
    ) -> None: ...
    def __dealloc__(self) -> None: ...
    def autocommit(self, status: bool) -> None:
        """
        Turn autocommit ON or OFF.
        """
        ...

    def __enter__(self) -> Connection[_Row]: ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_value: BaseException | None, traceback: TracebackType | None) -> None: ...
    def close(self) -> None:
        """
        Close the connection to the database. Implicitly rolls back all
        uncommitted transactions.
        """
        ...

    def commit(self) -> None:
        """
        Commit transaction which is currently in progress.
        """
        ...

    @overload
    def cursor(self, as_dict: None = None, arraysize: int | None = None) -> Cursor[_Row]: ...
    @overload
    def cursor(self, as_dict: Literal[True], arraysize: int | None = None) -> Cursor[DictRow]: ...
    @overload
    def cursor(self, as_dict: Literal[False], arraysize: int | None = None) -> Cursor[TupleRow]:
        """
        Return cursor object that can be used to make queries and fetch
        results from the database.
        """
        ...

    def rollback(self) -> None:
        """
        Roll back transaction which is currently in progress.
        """
        ...

    def bulk_copy(
        self,
        table_name: str,
        elements: Sequence[Sequence[SqlValue]],
        column_ids: list[int] | None = None,
        batch_size: int = 1000,
        tablock: bool = False,
        check_constraints: bool = False,
        fire_triggers: bool = False,
    ) -> None: ...

class Cursor(Generic[_Row]):
    """
    This class represents a database cursor, which is used to issue queries
    and fetch results from a database connection.
    """

    @property
    def connection(self) -> Connection[TupleRow | DictRow]: ...
    description: tuple[ColumnDescription, ...] | None
    @property
    def lastrowid(self) -> SqlValue: ...
    @property
    def rowcount(self) -> int: ...
    @property
    def returnvalue(self) -> int | None: ...
    @property
    def rownumber(self) -> int: ...
    @property
    def _source(self) -> Connection[TupleRow | DictRow]: ...
    arraysize: int
    def __init__(
        self,
        conn: Connection[TupleRow | DictRow],
        as_dict: bool,
        arraysize: int = 1,
    ) -> None: ...
    def __iter__(self) -> Cursor[_Row]:
        """
        Return self to make cursors compatible with Python iteration
        protocol.
        """
        ...

    def __enter__(self) -> Cursor[_Row]: ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_value: BaseException | None, traceback: TracebackType | None) -> None: ...
    def callproc(
        self,
        procname: str,
        parameters: Sequence[SqlValue | output] = ...,
    ) -> tuple[SqlValue, ...]:
        """
        Call a stored procedure with the given name.

        :param procname: The name of the procedure to call
        :type procname: str
        :keyword parameters: The optional parameters for the procedure
        :type parameters: sequence
        """
        ...

    def close(self) -> None:
        """
        Closes the cursor. The cursor is unusable from this point.
        """
        ...

    def execute(self, operation: str, params: QueryParams = ...) -> None: ...
    def executemany(
        self,
        operation: str,
        seq_of_parameters: Sequence[QueryParams],
        *,
        batch_size: int = -1,
    ) -> None: ...
    def nextset(self) -> int | None: ...
    def fetchone(self) -> _Row | None: ...
    def fetchmany(self, size: int | None = None) -> list[_Row]: ...
    def fetchall(self) -> list[_Row]: ...
    def __next__(self) -> _Row: ...
    def setinputsizes(self, sizes: int | None = None) -> None:
        """
        This method does nothing, as permitted by DB-API specification.
        """
        ...

    def setoutputsize(self, size: int | None = None, column: int = 0) -> None:
        """
        This method does nothing, as permitted by DB-API specification.
        """
        ...

@overload
def connect(
    server: str = ...,
    user: str | None = ...,
    password: str | None = ...,
    database: str = ...,
    timeout: int = ...,
    login_timeout: int = ...,
    charset: str = ...,
    as_dict: Literal[False] = ...,
    host: str = ...,
    appname: str | None = ...,
    port: str = ...,
    encryption: str | None = ...,
    read_only: bool = ...,
    conn_properties: str | list[str] | None = ...,
    autocommit: bool = ...,
    tds_version: str | None = ...,
    use_datetime2: bool = ...,
    arraysize: int = ...,
) -> Connection[TupleRow]: ...
@overload
def connect(
    server: str,
    user: str | None,
    password: str | None,
    database: str,
    timeout: int,
    login_timeout: int,
    charset: str,
    as_dict: Literal[True],
    host: str = ...,
    appname: str | None = ...,
    port: str = ...,
    encryption: str | None = ...,
    read_only: bool = ...,
    conn_properties: str | list[str] | None = ...,
    autocommit: bool = ...,
    tds_version: str | None = ...,
    use_datetime2: bool = ...,
    arraysize: int = ...,
) -> Connection[DictRow]: ...
@overload
def connect(
    server: str = ...,
    user: str | None = ...,
    password: str | None = ...,
    database: str = ...,
    timeout: int = ...,
    login_timeout: int = ...,
    charset: str = ...,
    *,
    as_dict: Literal[True],
    host: str = ...,
    appname: str | None = ...,
    port: str = ...,
    encryption: str | None = ...,
    read_only: bool = ...,
    conn_properties: str | list[str] | None = ...,
    autocommit: bool = ...,
    tds_version: str | None = ...,
    use_datetime2: bool = ...,
    arraysize: int = ...,
) -> Connection[DictRow]:
    """
    Constructor for creating a connection to the database. Returns a
    Connection object.

    :param server: database host
    :param user: database user to connect as
    :param password: user's password
    :param database: the database to initially connect to
    :param timeout: query timeout in seconds, default 0 (no timeout)
    :param login_timeout: timeout for connection and login in seconds, default 60
    :param charset: character set with which to connect to the database
    :keyword as_dict: whether rows should be returned as dictionaries instead of tuples
    :keyword appname: Set the application name to use for the connection
    :keyword port: the TCP port to use to connect to the server
    :keyword conn_properties: SQL queries to send to the server upon connection establishment
    :keyword autocommit: Whether to use default autocommitting mode or not
    :keyword tds_version: TDS protocol version to use
    :keyword use_datetime2: Whether to use datetime.datetime conversion compatible with DATETIME2
    :keyword arraysize: Number of rows to fetch at a time with .fetchmany(). Default: 1
    """
    ...

def get_max_connections() -> int:
    """
    Get the maximum number of simultaneous connections pymssql will open
    to the server.
    """
    ...

def set_max_connections(limit: int) -> None:
    """
    Set maximum simultaneous connections db-lib will open to the server.

    :param limit: the connection limit
    :type limit: int
    """
    ...

def get_dbversion() -> str:
    """
    Return string representing the version of db-lib.
    """
    ...

get_freetds_version = get_dbversion

def version_info() -> str:
    """
    Returns string with version information about pymssql, FreeTDS, Python and OS.
    """
    ...
