// components/network_hints/common/network_hints.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_H_
#define COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/network_hints/common/network_hints.mojom-shared.h"
#include "components/network_hints/common/network_hints.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network_hints {
namespace mojom {

class NetworkHintsHandlerProxy;

template <typename ImplRefTraits>
class NetworkHintsHandlerStub;

class NetworkHintsHandlerRequestValidator;


class  NetworkHintsHandler
    : public NetworkHintsHandlerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NetworkHintsHandlerInterfaceBase;
  using Proxy_ = NetworkHintsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkHintsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = NetworkHintsHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPrefetchDNSMinVersion = 0,
    kPreconnectMinVersion = 0,
  };
  virtual ~NetworkHintsHandler() {}

  
  virtual void PrefetchDNS(const std::vector<std::string>& hostname_list) = 0;

  
  virtual void Preconnect(const ::GURL& url, bool allow_credentials) = 0;
};



class  NetworkHintsHandlerProxy
    : public NetworkHintsHandler {
 public:
  using InterfaceType = NetworkHintsHandler;

  explicit NetworkHintsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PrefetchDNS(const std::vector<std::string>& hostname_list) final;
  
  void Preconnect(const ::GURL& url, bool allow_credentials) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkHintsHandlerStubDispatch {
 public:
  static bool Accept(NetworkHintsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkHintsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkHintsHandler>>
class NetworkHintsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkHintsHandlerStub() {}
  ~NetworkHintsHandlerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkHintsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkHintsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkHintsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace network_hints

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_H_