// components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace paint_preview {
namespace mojom {
class SerializedRecordingDataView;


}  // namespace mojom
}  // namespace paint_preview

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::paint_preview::mojom::SerializedRecordingDataView> {
  using Data = ::paint_preview::mojom::internal::SerializedRecording_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace paint_preview {
namespace mojom {


enum class RecordingPersistence : int32_t {
  
  kFileSystem = 0,
  
  kMemoryBuffer = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, RecordingPersistence value);
inline bool IsKnownEnumValue(RecordingPersistence value) {
  return internal::RecordingPersistence_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SerializedRecordingDataView {
 public:
  using Tag = internal::SerializedRecording_Data::SerializedRecording_Tag;

  SerializedRecordingDataView() {}

  SerializedRecordingDataView(
      internal::SerializedRecording_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_file() const { return data_->tag == Tag::FILE; }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFile(UserType* output) {
    
    DCHECK(is_file());
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        data_->data.f_file.Get(), output, context_);
  }
  bool is_buffer() const { return data_->tag == Tag::BUFFER; }
  inline void GetBufferDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBuffer(UserType* output) {
    
    DCHECK(is_buffer());
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        data_->data.f_buffer.Get(), output, context_);
  }

 private:
  internal::SerializedRecording_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace paint_preview

namespace std {

template <>
struct hash<::paint_preview::mojom::RecordingPersistence>
    : public mojo::internal::EnumHashImpl<::paint_preview::mojom::RecordingPersistence> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::paint_preview::mojom::RecordingPersistence, ::paint_preview::mojom::RecordingPersistence> {
  static ::paint_preview::mojom::RecordingPersistence ToMojom(::paint_preview::mojom::RecordingPersistence input) { return input; }
  static bool FromMojom(::paint_preview::mojom::RecordingPersistence input, ::paint_preview::mojom::RecordingPersistence* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::RecordingPersistence, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::paint_preview::mojom::RecordingPersistence, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::paint_preview::mojom::RecordingPersistence>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::SerializedRecordingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::paint_preview::mojom::SerializedRecordingDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::paint_preview::mojom::internal::SerializedRecording_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::paint_preview::mojom::internal::SerializedRecording_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::paint_preview::mojom::SerializedRecordingDataView::Tag::FILE: {
        decltype(Traits::file(input))
            in_file = Traits::file(input);
        typename decltype(result->data.f_file)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
            in_file, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file in SerializedRecording union");
        result->data.f_file.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::paint_preview::mojom::SerializedRecordingDataView::Tag::BUFFER: {
        decltype(Traits::buffer(input))
            in_buffer = Traits::buffer(input);
        typename decltype(result->data.f_buffer)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
            in_buffer, buffer, &value_writer, false, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null buffer in SerializedRecording union");
        result->data.f_buffer.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::paint_preview::mojom::internal::SerializedRecording_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::SerializedRecordingDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace paint_preview {
namespace mojom {

inline void SerializedRecordingDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  DCHECK(is_file());
  *output = ::mojo_base::mojom::FileDataView(data_->data.f_file.Get(), context_);
}
inline void SerializedRecordingDataView::GetBufferDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  DCHECK(is_buffer());
  *output = ::mojo_base::mojom::BigBufferDataView(data_->data.f_buffer.Get(), context_);
}


}  // namespace mojom
}  // namespace paint_preview

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SHARED_H_