// components/pdf/common/pdf.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PDF_COMMON_PDF_MOJOM_H_
#define COMPONENTS_PDF_COMMON_PDF_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/pdf/common/pdf.mojom-shared.h"
#include "components/pdf/common/pdf.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace pdf {
namespace mojom {

class PdfListenerProxy;

template <typename ImplRefTraits>
class PdfListenerStub;

class PdfListenerRequestValidator;


class  PdfListener
    : public PdfListenerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PdfListenerInterfaceBase;
  using Proxy_ = PdfListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfListenerStub<ImplRefTraits>;

  using RequestValidator_ = PdfListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetCaretPositionMinVersion = 0,
    kMoveRangeSelectionExtentMinVersion = 0,
    kSetSelectionBoundsMinVersion = 0,
  };
  virtual ~PdfListener() {}

  
  virtual void SetCaretPosition(const ::gfx::PointF& position) = 0;

  
  virtual void MoveRangeSelectionExtent(const ::gfx::PointF& extent) = 0;

  
  virtual void SetSelectionBounds(const ::gfx::PointF& base, const ::gfx::PointF& extent) = 0;
};

class PdfServiceProxy;

template <typename ImplRefTraits>
class PdfServiceStub;

class PdfServiceRequestValidator;


class  PdfService
    : public PdfServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PdfServiceInterfaceBase;
  using Proxy_ = PdfServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfServiceStub<ImplRefTraits>;

  using RequestValidator_ = PdfServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetListenerMinVersion = 0,
    kUpdateContentRestrictionsMinVersion = 0,
    kHasUnsupportedFeatureMinVersion = 0,
    kSaveUrlAsMinVersion = 0,
    kSelectionChangedMinVersion = 0,
    kSetPluginCanSaveMinVersion = 0,
  };
  virtual ~PdfService() {}

  
  virtual void SetListener(::mojo::PendingRemote<PdfListener> client) = 0;

  
  virtual void UpdateContentRestrictions(int32_t restrictions) = 0;

  
  virtual void HasUnsupportedFeature() = 0;

  
  virtual void SaveUrlAs(const ::GURL& url, ::blink::mojom::ReferrerPtr referrer) = 0;

  
  virtual void SelectionChanged(const ::gfx::PointF& left, int32_t left_height, const ::gfx::PointF& right, int32_t right_height) = 0;

  
  virtual void SetPluginCanSave(bool can_save) = 0;
};



class  PdfListenerProxy
    : public PdfListener {
 public:
  using InterfaceType = PdfListener;

  explicit PdfListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCaretPosition(const ::gfx::PointF& position) final;
  
  void MoveRangeSelectionExtent(const ::gfx::PointF& extent) final;
  
  void SetSelectionBounds(const ::gfx::PointF& base, const ::gfx::PointF& extent) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PdfServiceProxy
    : public PdfService {
 public:
  using InterfaceType = PdfService;

  explicit PdfServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetListener(::mojo::PendingRemote<PdfListener> client) final;
  
  void UpdateContentRestrictions(int32_t restrictions) final;
  
  void HasUnsupportedFeature() final;
  
  void SaveUrlAs(const ::GURL& url, ::blink::mojom::ReferrerPtr referrer) final;
  
  void SelectionChanged(const ::gfx::PointF& left, int32_t left_height, const ::gfx::PointF& right, int32_t right_height) final;
  
  void SetPluginCanSave(bool can_save) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PdfListenerStubDispatch {
 public:
  static bool Accept(PdfListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfListener>>
class PdfListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfListenerStub() {}
  ~PdfListenerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfServiceStubDispatch {
 public:
  static bool Accept(PdfService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfService>>
class PdfServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfServiceStub() {}
  ~PdfServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace pdf

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_PDF_COMMON_PDF_MOJOM_H_