// components/services/storage/public/mojom/blob_storage_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/blob_storage_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-params-data.h"
#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
BlobDataItem::BlobDataItem()
    : type(),
      size(),
      side_data_size(),
      content_type(),
      reader() {}

BlobDataItem::BlobDataItem(
    BlobDataItemType type_in,
    uint64_t size_in,
    uint64_t side_data_size_in,
    const std::string& content_type_in,
    ::mojo::PendingRemote<BlobDataItemReader> reader_in)
    : type(std::move(type_in)),
      size(std::move(size_in)),
      side_data_size(std::move(side_data_size_in)),
      content_type(std::move(content_type_in)),
      reader(std::move(reader_in)) {}

BlobDataItem::~BlobDataItem() = default;

void BlobDataItem::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetString("size", base::NumberToString(this->size));
  value->SetString("side_data_size", base::NumberToString(this->side_data_size));
  value->SetString("content_type", this->content_type);
  value->SetBoolean("reader", this->reader.is_valid());
}

bool BlobDataItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char BlobDataItemReader::Name_[] = "storage.mojom.BlobDataItemReader";

class BlobDataItemReader_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobDataItemReader_Read_ForwardToCallback(
      BlobDataItemReader::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobDataItemReader::ReadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobDataItemReader_Read_ForwardToCallback);
};

class BlobDataItemReader_ReadSideData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobDataItemReader_ReadSideData_ForwardToCallback(
      BlobDataItemReader::ReadSideDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobDataItemReader::ReadSideDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobDataItemReader_ReadSideData_ForwardToCallback);
};

BlobDataItemReaderProxy::BlobDataItemReaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobDataItemReaderProxy::Read(
    uint64_t in_offset, uint64_t in_length, ::mojo::ScopedDataPipeProducerHandle in_pipe, ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::BlobDataItemReader::Read", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("offset", base::NumberToString(in_offset));
      raw_value->SetString("length", base::NumberToString(in_length));
      raw_value->SetBoolean("pipe", in_pipe.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobDataItemReader_Read_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::BlobDataItemReader_Read_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->offset = in_offset;
  params->length = in_length;
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_pipe, &params->pipe, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid pipe in BlobDataItemReader.Read request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobDataItemReader::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobDataItemReader_Read_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BlobDataItemReaderProxy::ReadSideData(
    ReadSideDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::BlobDataItemReader::ReadSideData");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobDataItemReader_ReadSideData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::BlobDataItemReader_ReadSideData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobDataItemReader::Name_);
  message.set_method_name("ReadSideData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobDataItemReader_ReadSideData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BlobDataItemReader_Read_ProxyToResponder {
 public:
  static BlobDataItemReader::ReadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobDataItemReader_Read_ProxyToResponder> proxy(
        new BlobDataItemReader_Read_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobDataItemReader_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobDataItemReader_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobDataItemReader_Read_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobDataItemReader::ReadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobDataItemReader_Read_ProxyToResponder);
};

bool BlobDataItemReader_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::BlobDataItemReader::ReadCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::BlobDataItemReader_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobDataItemReader_Read_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_success{};
  BlobDataItemReader_Read_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobDataItemReader::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void BlobDataItemReader_Read_ProxyToResponder::Run(
    int32_t in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::BlobDataItemReader::ReadCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobDataItemReader_Read_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::BlobDataItemReader_Read_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::BlobDataItemReader::ReadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobDataItemReader::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BlobDataItemReader_ReadSideData_ProxyToResponder {
 public:
  static BlobDataItemReader::ReadSideDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobDataItemReader_ReadSideData_ProxyToResponder> proxy(
        new BlobDataItemReader_ReadSideData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobDataItemReader_ReadSideData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobDataItemReader_ReadSideData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobDataItemReader_ReadSideData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobDataItemReader::ReadSideDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_success, ::mojo_base::BigBuffer in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobDataItemReader_ReadSideData_ProxyToResponder);
};

bool BlobDataItemReader_ReadSideData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::BlobDataItemReader::ReadSideDataCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::BlobDataItemReader_ReadSideData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobDataItemReader_ReadSideData_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_success{};
  ::mojo_base::BigBuffer p_data{};
  BlobDataItemReader_ReadSideData_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobDataItemReader::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_data));
  return true;
}

void BlobDataItemReader_ReadSideData_ProxyToResponder::Run(
    int32_t in_success, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::BlobDataItemReader::ReadSideDataCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("success", in_success);
      raw_value->SetString("data", base::trace_event::ValueToString(in_data, "<value of type ::mojo_base::BigBuffer>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobDataItemReader_ReadSideData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::BlobDataItemReader_ReadSideData_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  typename decltype(params->data)::BufferWriter data_writer;
  data_writer.AllocateInline(buffer, &params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, buffer, &data_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::BlobDataItemReader::ReadSideDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobDataItemReader::Name_);
  message.set_method_name("ReadSideData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobDataItemReaderStubDispatch::Accept(
    BlobDataItemReader* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kBlobDataItemReader_Read_Name: {
      break;
    }
    case internal::kBlobDataItemReader_ReadSideData_Name: {
      break;
    }
  }
  return false;
}

// static
bool BlobDataItemReaderStubDispatch::AcceptWithResponder(
    BlobDataItemReader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBlobDataItemReader_Read_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::BlobDataItemReader::Read",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::BlobDataItemReader::Read");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobDataItemReader_Read_Params_Data* params =
          reinterpret_cast<
              internal::BlobDataItemReader_Read_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_offset{};
      uint64_t p_length{};
      ::mojo::ScopedDataPipeProducerHandle p_pipe{};
      BlobDataItemReader_Read_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobDataItemReader::Name_, 0, false);
        return false;
      }
      BlobDataItemReader::ReadCallback callback =
          BlobDataItemReader_Read_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(
std::move(p_offset), 
std::move(p_length), 
std::move(p_pipe), std::move(callback));
      return true;
    }
    case internal::kBlobDataItemReader_ReadSideData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::BlobDataItemReader::ReadSideData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::BlobDataItemReader::ReadSideData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobDataItemReader_ReadSideData_Params_Data* params =
          reinterpret_cast<
              internal::BlobDataItemReader_ReadSideData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BlobDataItemReader_ReadSideData_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobDataItemReader::Name_, 1, false);
        return false;
      }
      BlobDataItemReader::ReadSideDataCallback callback =
          BlobDataItemReader_ReadSideData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadSideData(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBlobDataItemReaderValidationInfo[] = {
    {internal::kBlobDataItemReader_Read_Name,
     {&internal::BlobDataItemReader_Read_Params_Data::Validate,
      &internal::BlobDataItemReader_Read_ResponseParams_Data::Validate}},
    {internal::kBlobDataItemReader_ReadSideData_Name,
     {&internal::BlobDataItemReader_ReadSideData_Params_Data::Validate,
      &internal::BlobDataItemReader_ReadSideData_ResponseParams_Data::Validate}},
};

bool BlobDataItemReaderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::BlobDataItemReader::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBlobDataItemReaderValidationInfo);
}

bool BlobDataItemReaderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::BlobDataItemReader::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kBlobDataItemReaderValidationInfo);

}
const char BlobStorageContext::Name_[] = "storage.mojom.BlobStorageContext";

class BlobStorageContext_WriteBlobToFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobStorageContext_WriteBlobToFile_ForwardToCallback(
      BlobStorageContext::WriteBlobToFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobStorageContext::WriteBlobToFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobStorageContext_WriteBlobToFile_ForwardToCallback);
};

BlobStorageContextProxy::BlobStorageContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobStorageContextProxy::RegisterFromDataItem(
    ::mojo::PendingReceiver<::blink::mojom::Blob> in_blob, const std::string& in_uuid, BlobDataItemPtr in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::BlobStorageContext::RegisterFromDataItem", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("blob", in_blob.is_valid());
      raw_value->SetString("uuid", in_uuid);
      if (in_item.is_null()) {
        raw_value->SetString("item", "nullptr");
      } else {
        raw_value->BeginDictionary("item");
        in_item->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobStorageContext_RegisterFromDataItem_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::BlobStorageContext_RegisterFromDataItem_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobStorageContext.RegisterFromDataItem request");
  typename decltype(params->uuid)::BaseType::BufferWriter
      uuid_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_uuid, buffer, &uuid_writer, &serialization_context);
  params->uuid.Set(
      uuid_writer.is_null() ? nullptr : uuid_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BlobStorageContext.RegisterFromDataItem request");
  typename decltype(params->item)::BaseType::BufferWriter
      item_writer;
  mojo::internal::Serialize<::storage::mojom::BlobDataItemDataView>(
      in_item, buffer, &item_writer, &serialization_context);
  params->item.Set(
      item_writer.is_null() ? nullptr : item_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->item.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item in BlobStorageContext.RegisterFromDataItem request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("RegisterFromDataItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobStorageContextProxy::RegisterFromMemory(
    ::mojo::PendingReceiver<::blink::mojom::Blob> in_blob, const std::string& in_uuid, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::BlobStorageContext::RegisterFromMemory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("blob", in_blob.is_valid());
      raw_value->SetString("uuid", in_uuid);
      raw_value->SetString("data", base::trace_event::ValueToString(in_data, "<value of type ::mojo_base::BigBuffer>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobStorageContext_RegisterFromMemory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::BlobStorageContext_RegisterFromMemory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobStorageContext.RegisterFromMemory request");
  typename decltype(params->uuid)::BaseType::BufferWriter
      uuid_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_uuid, buffer, &uuid_writer, &serialization_context);
  params->uuid.Set(
      uuid_writer.is_null() ? nullptr : uuid_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BlobStorageContext.RegisterFromMemory request");
  typename decltype(params->data)::BufferWriter data_writer;
  data_writer.AllocateInline(buffer, &params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, buffer, &data_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in BlobStorageContext.RegisterFromMemory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("RegisterFromMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobStorageContextProxy::WriteBlobToFile(
    ::mojo::PendingRemote<::blink::mojom::Blob> in_blob, const ::base::FilePath& in_path, bool in_flush_on_write, base::Optional<::base::Time> in_last_modified, WriteBlobToFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::BlobStorageContext::WriteBlobToFile", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("blob", in_blob.is_valid());
      raw_value->SetString("path", base::trace_event::ValueToString(in_path, "<value of type const ::base::FilePath&>"));
      raw_value->SetBoolean("flush_on_write", in_flush_on_write);
      raw_value->SetString("last_modified", base::trace_event::ValueToString(in_last_modified, "<value of type base::Optional<::base::Time>>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobStorageContext_WriteBlobToFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::BlobStorageContext_WriteBlobToFile_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobStorageContext.WriteBlobToFile request");
  typename decltype(params->path)::BaseType::BufferWriter
      path_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, buffer, &path_writer, &serialization_context);
  params->path.Set(
      path_writer.is_null() ? nullptr : path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in BlobStorageContext.WriteBlobToFile request");
  params->flush_on_write = in_flush_on_write;
  typename decltype(params->last_modified)::BaseType::BufferWriter
      last_modified_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_modified, buffer, &last_modified_writer, &serialization_context);
  params->last_modified.Set(
      last_modified_writer.is_null() ? nullptr : last_modified_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("WriteBlobToFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobStorageContext_WriteBlobToFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BlobStorageContext_WriteBlobToFile_ProxyToResponder {
 public:
  static BlobStorageContext::WriteBlobToFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobStorageContext_WriteBlobToFile_ProxyToResponder> proxy(
        new BlobStorageContext_WriteBlobToFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobStorageContext_WriteBlobToFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobStorageContext_WriteBlobToFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobStorageContext_WriteBlobToFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobStorageContext::WriteBlobToFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WriteBlobToFileResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobStorageContext_WriteBlobToFile_ProxyToResponder);
};

bool BlobStorageContext_WriteBlobToFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::BlobStorageContext::WriteBlobToFileCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WriteBlobToFileResult p_result{};
  BlobStorageContext_WriteBlobToFile_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobStorageContext::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void BlobStorageContext_WriteBlobToFile_ProxyToResponder::Run(
    WriteBlobToFileResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::BlobStorageContext::WriteBlobToFileCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobStorageContext_WriteBlobToFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::storage::mojom::WriteBlobToFileResult>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::BlobStorageContext::WriteBlobToFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobStorageContext::Name_);
  message.set_method_name("WriteBlobToFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobStorageContextStubDispatch::Accept(
    BlobStorageContext* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kBlobStorageContext_RegisterFromDataItem_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::BlobStorageContext::RegisterFromDataItem",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::BlobStorageContext::RegisterFromDataItem");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobStorageContext_RegisterFromDataItem_Params_Data* params =
          reinterpret_cast<internal::BlobStorageContext_RegisterFromDataItem_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::Blob> p_blob{};
      std::string p_uuid{};
      BlobDataItemPtr p_item{};
      BlobStorageContext_RegisterFromDataItem_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobStorageContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFromDataItem(
std::move(p_blob), 
std::move(p_uuid), 
std::move(p_item));
      return true;
    }
    case internal::kBlobStorageContext_RegisterFromMemory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::BlobStorageContext::RegisterFromMemory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::BlobStorageContext::RegisterFromMemory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobStorageContext_RegisterFromMemory_Params_Data* params =
          reinterpret_cast<internal::BlobStorageContext_RegisterFromMemory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::Blob> p_blob{};
      std::string p_uuid{};
      ::mojo_base::BigBuffer p_data{};
      BlobStorageContext_RegisterFromMemory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobStorageContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFromMemory(
std::move(p_blob), 
std::move(p_uuid), 
std::move(p_data));
      return true;
    }
    case internal::kBlobStorageContext_WriteBlobToFile_Name: {
      break;
    }
  }
  return false;
}

// static
bool BlobStorageContextStubDispatch::AcceptWithResponder(
    BlobStorageContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBlobStorageContext_RegisterFromDataItem_Name: {
      break;
    }
    case internal::kBlobStorageContext_RegisterFromMemory_Name: {
      break;
    }
    case internal::kBlobStorageContext_WriteBlobToFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::BlobStorageContext::WriteBlobToFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::BlobStorageContext::WriteBlobToFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobStorageContext_WriteBlobToFile_Params_Data* params =
          reinterpret_cast<
              internal::BlobStorageContext_WriteBlobToFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::Blob> p_blob{};
      ::base::FilePath p_path{};
      bool p_flush_on_write{};
      base::Optional<::base::Time> p_last_modified{};
      BlobStorageContext_WriteBlobToFile_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_flush_on_write = input_data_view.flush_on_write();
      if (success && !input_data_view.ReadLastModified(&p_last_modified))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobStorageContext::Name_, 2, false);
        return false;
      }
      BlobStorageContext::WriteBlobToFileCallback callback =
          BlobStorageContext_WriteBlobToFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteBlobToFile(
std::move(p_blob), 
std::move(p_path), 
std::move(p_flush_on_write), 
std::move(p_last_modified), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBlobStorageContextValidationInfo[] = {
    {internal::kBlobStorageContext_RegisterFromDataItem_Name,
     {&internal::BlobStorageContext_RegisterFromDataItem_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kBlobStorageContext_RegisterFromMemory_Name,
     {&internal::BlobStorageContext_RegisterFromMemory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kBlobStorageContext_WriteBlobToFile_Name,
     {&internal::BlobStorageContext_WriteBlobToFile_Params_Data::Validate,
      &internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data::Validate}},
};

bool BlobStorageContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::BlobStorageContext::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBlobStorageContextValidationInfo);
}

bool BlobStorageContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::BlobStorageContext::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kBlobStorageContextValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {


// static
bool StructTraits<::storage::mojom::BlobDataItem::DataView, ::storage::mojom::BlobDataItemPtr>::Read(
    ::storage::mojom::BlobDataItem::DataView input,
    ::storage::mojom::BlobDataItemPtr* output) {
  bool success = true;
  ::storage::mojom::BlobDataItemPtr result(::storage::mojom::BlobDataItem::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->size = input.size();
      if (success)
        result->side_data_size = input.side_data_size();
      if (success && !input.ReadContentType(&result->content_type))
        success = false;
      if (success) {
        result->reader =
            input.TakeReader<decltype(result->reader)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif