// components/services/storage/public/mojom/blob_storage_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared.h"
#include "components/services/storage/public/mojom/blob_storage_context.mojom-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class BlobDataItemReaderProxy;

template <typename ImplRefTraits>
class BlobDataItemReaderStub;

class BlobDataItemReaderRequestValidator;
class BlobDataItemReaderResponseValidator;


class  BlobDataItemReader
    : public BlobDataItemReaderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = BlobDataItemReaderInterfaceBase;
  using Proxy_ = BlobDataItemReaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = BlobDataItemReaderStub<ImplRefTraits>;

  using RequestValidator_ = BlobDataItemReaderRequestValidator;
  using ResponseValidator_ = BlobDataItemReaderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
    kReadSideDataMinVersion = 0,
  };
  virtual ~BlobDataItemReader() {}


  using ReadCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void Read(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ReadCallback callback) = 0;


  using ReadSideDataCallback = base::OnceCallback<void(int32_t, ::mojo_base::BigBuffer)>;
  
  virtual void ReadSideData(ReadSideDataCallback callback) = 0;
};

class BlobStorageContextProxy;

template <typename ImplRefTraits>
class BlobStorageContextStub;

class BlobStorageContextRequestValidator;
class BlobStorageContextResponseValidator;


class  BlobStorageContext
    : public BlobStorageContextInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = BlobStorageContextInterfaceBase;
  using Proxy_ = BlobStorageContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = BlobStorageContextStub<ImplRefTraits>;

  using RequestValidator_ = BlobStorageContextRequestValidator;
  using ResponseValidator_ = BlobStorageContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterFromDataItemMinVersion = 0,
    kRegisterFromMemoryMinVersion = 0,
    kWriteBlobToFileMinVersion = 0,
  };
  virtual ~BlobStorageContext() {}

  
  virtual void RegisterFromDataItem(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, BlobDataItemPtr item) = 0;

  
  virtual void RegisterFromMemory(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, ::mojo_base::BigBuffer data) = 0;


  using WriteBlobToFileCallback = base::OnceCallback<void(WriteBlobToFileResult)>;
  
  virtual void WriteBlobToFile(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, base::Optional<::base::Time> last_modified, WriteBlobToFileCallback callback) = 0;
};



class  BlobDataItemReaderProxy
    : public BlobDataItemReader {
 public:
  using InterfaceType = BlobDataItemReader;

  explicit BlobDataItemReaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ReadCallback callback) final;
  
  void ReadSideData(ReadSideDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BlobStorageContextProxy
    : public BlobStorageContext {
 public:
  using InterfaceType = BlobStorageContext;

  explicit BlobStorageContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterFromDataItem(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, BlobDataItemPtr item) final;
  
  void RegisterFromMemory(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, ::mojo_base::BigBuffer data) final;
  
  void WriteBlobToFile(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::base::FilePath& path, bool flush_on_write, base::Optional<::base::Time> last_modified, WriteBlobToFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  BlobDataItemReaderStubDispatch {
 public:
  static bool Accept(BlobDataItemReader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BlobDataItemReader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BlobDataItemReader>>
class BlobDataItemReaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BlobDataItemReaderStub() {}
  ~BlobDataItemReaderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobDataItemReaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobDataItemReaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BlobStorageContextStubDispatch {
 public:
  static bool Accept(BlobStorageContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BlobStorageContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BlobStorageContext>>
class BlobStorageContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BlobStorageContextStub() {}
  ~BlobStorageContextStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobStorageContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobStorageContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BlobDataItemReaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BlobStorageContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BlobDataItemReaderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BlobStorageContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  BlobDataItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BlobDataItem, T>::value>;
  using DataView = BlobDataItemDataView;
  using Data_ = internal::BlobDataItem_Data;

  template <typename... Args>
  static BlobDataItemPtr New(Args&&... args) {
    return BlobDataItemPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlobDataItemPtr From(const U& u) {
    return mojo::TypeConverter<BlobDataItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BlobDataItem>::Convert(*this);
  }


  BlobDataItem();

  BlobDataItem(
      BlobDataItemType type,
      uint64_t size,
      uint64_t side_data_size,
      const std::string& content_type,
      ::mojo::PendingRemote<BlobDataItemReader> reader);

  ~BlobDataItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlobDataItemPtr>
  BlobDataItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlobDataItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BlobDataItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BlobDataItem_UnserializedMessageContext<
            UserType, BlobDataItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BlobDataItem::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BlobDataItem::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BlobDataItem_UnserializedMessageContext<
            UserType, BlobDataItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BlobDataItem::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  BlobDataItemType type;
  
  uint64_t size;
  
  uint64_t side_data_size;
  
  std::string content_type;
  
  ::mojo::PendingRemote<BlobDataItemReader> reader;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(BlobDataItem);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BlobDataItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BlobDataItemPtr BlobDataItem::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(size),
      mojo::Clone(side_data_size),
      mojo::Clone(content_type),
      mojo::Clone(reader)
  );
}

template <typename T, BlobDataItem::EnableIfSame<T>*>
bool BlobDataItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->side_data_size, other_struct.side_data_size))
    return false;
  if (!mojo::Equals(this->content_type, other_struct.content_type))
    return false;
  if (!mojo::Equals(this->reader, other_struct.reader))
    return false;
  return true;
}

template <typename T, BlobDataItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.size, rhs.size))
    return true;
  if (std::less<>{}(rhs.size, lhs.size))
    return false;
  if (std::less<>{}(lhs.side_data_size, rhs.side_data_size))
    return true;
  if (std::less<>{}(rhs.side_data_size, lhs.side_data_size))
    return false;
  if (std::less<>{}(lhs.content_type, rhs.content_type))
    return true;
  if (std::less<>{}(rhs.content_type, lhs.content_type))
    return false;
  if (std::less<>{}(lhs.reader, rhs.reader))
    return true;
  if (std::less<>{}(rhs.reader, lhs.reader))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace storage

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::BlobDataItem::DataView,
                                         ::storage::mojom::BlobDataItemPtr> {
  static bool IsNull(const ::storage::mojom::BlobDataItemPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::BlobDataItemPtr* output) { output->reset(); }

  static decltype(::storage::mojom::BlobDataItem::type) type(
      const ::storage::mojom::BlobDataItemPtr& input) {
    return input->type;
  }

  static decltype(::storage::mojom::BlobDataItem::size) size(
      const ::storage::mojom::BlobDataItemPtr& input) {
    return input->size;
  }

  static decltype(::storage::mojom::BlobDataItem::side_data_size) side_data_size(
      const ::storage::mojom::BlobDataItemPtr& input) {
    return input->side_data_size;
  }

  static const decltype(::storage::mojom::BlobDataItem::content_type)& content_type(
      const ::storage::mojom::BlobDataItemPtr& input) {
    return input->content_type;
  }

  static  decltype(::storage::mojom::BlobDataItem::reader)& reader(
       ::storage::mojom::BlobDataItemPtr& input) {
    return input->reader;
  }

  static bool Read(::storage::mojom::BlobDataItem::DataView input, ::storage::mojom::BlobDataItemPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_H_