// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Audits_h
#define content_protocol_Audits_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/network.h"

namespace content {
namespace protocol {
namespace Audits {
class AffectedCookie;
class AffectedRequest;
class AffectedFrame;
using SameSiteCookieExclusionReason = String;
using SameSiteCookieWarningReason = String;
using SameSiteCookieOperation = String;
class SameSiteCookieIssueDetails;
using MixedContentResolutionStatus = String;
using MixedContentResourceType = String;
class MixedContentIssueDetails;
using BlockedByResponseReason = String;
class BlockedByResponseIssueDetails;
using HeavyAdResolutionStatus = String;
using HeavyAdReason = String;
class HeavyAdIssueDetails;
using ContentSecurityPolicyViolationType = String;
class SourceCodeLocation;
class ContentSecurityPolicyIssueDetails;
using InspectorIssueCode = String;
class InspectorIssueDetails;
class InspectorIssue;

// ------------- Forward and enum declarations.

namespace SameSiteCookieExclusionReasonEnum {
CONTENT_EXPORT extern const char ExcludeSameSiteUnspecifiedTreatedAsLax[];
CONTENT_EXPORT extern const char ExcludeSameSiteNoneInsecure[];
CONTENT_EXPORT extern const char ExcludeSameSiteLax[];
CONTENT_EXPORT extern const char ExcludeSameSiteStrict[];
} // namespace SameSiteCookieExclusionReasonEnum

namespace SameSiteCookieWarningReasonEnum {
CONTENT_EXPORT extern const char WarnSameSiteUnspecifiedCrossSiteContext[];
CONTENT_EXPORT extern const char WarnSameSiteNoneInsecure[];
CONTENT_EXPORT extern const char WarnSameSiteUnspecifiedLaxAllowUnsafe[];
CONTENT_EXPORT extern const char WarnSameSiteStrictLaxDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteStrictCrossDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteStrictCrossDowngradeLax[];
CONTENT_EXPORT extern const char WarnSameSiteLaxCrossDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteLaxCrossDowngradeLax[];
} // namespace SameSiteCookieWarningReasonEnum

namespace SameSiteCookieOperationEnum {
CONTENT_EXPORT extern const char SetCookie[];
CONTENT_EXPORT extern const char ReadCookie[];
} // namespace SameSiteCookieOperationEnum

namespace MixedContentResolutionStatusEnum {
CONTENT_EXPORT extern const char MixedContentBlocked[];
CONTENT_EXPORT extern const char MixedContentAutomaticallyUpgraded[];
CONTENT_EXPORT extern const char MixedContentWarning[];
} // namespace MixedContentResolutionStatusEnum

namespace MixedContentResourceTypeEnum {
CONTENT_EXPORT extern const char Audio[];
CONTENT_EXPORT extern const char Beacon[];
CONTENT_EXPORT extern const char CSPReport[];
CONTENT_EXPORT extern const char Download[];
CONTENT_EXPORT extern const char EventSource[];
CONTENT_EXPORT extern const char Favicon[];
CONTENT_EXPORT extern const char Font[];
CONTENT_EXPORT extern const char Form[];
CONTENT_EXPORT extern const char Frame[];
CONTENT_EXPORT extern const char Image[];
CONTENT_EXPORT extern const char Import[];
CONTENT_EXPORT extern const char Manifest[];
CONTENT_EXPORT extern const char Ping[];
CONTENT_EXPORT extern const char PluginData[];
CONTENT_EXPORT extern const char PluginResource[];
CONTENT_EXPORT extern const char Prefetch[];
CONTENT_EXPORT extern const char Resource[];
CONTENT_EXPORT extern const char Script[];
CONTENT_EXPORT extern const char ServiceWorker[];
CONTENT_EXPORT extern const char SharedWorker[];
CONTENT_EXPORT extern const char Stylesheet[];
CONTENT_EXPORT extern const char Track[];
CONTENT_EXPORT extern const char Video[];
CONTENT_EXPORT extern const char Worker[];
CONTENT_EXPORT extern const char XMLHttpRequest[];
CONTENT_EXPORT extern const char XSLT[];
} // namespace MixedContentResourceTypeEnum

namespace BlockedByResponseReasonEnum {
CONTENT_EXPORT extern const char CoepFrameResourceNeedsCoepHeader[];
CONTENT_EXPORT extern const char CoopSandboxedIFrameCannotNavigateToCoopPage[];
CONTENT_EXPORT extern const char CorpNotSameOrigin[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[];
CONTENT_EXPORT extern const char CorpNotSameSite[];
} // namespace BlockedByResponseReasonEnum

namespace HeavyAdResolutionStatusEnum {
CONTENT_EXPORT extern const char HeavyAdBlocked[];
CONTENT_EXPORT extern const char HeavyAdWarning[];
} // namespace HeavyAdResolutionStatusEnum

namespace HeavyAdReasonEnum {
CONTENT_EXPORT extern const char NetworkTotalLimit[];
CONTENT_EXPORT extern const char CpuTotalLimit[];
CONTENT_EXPORT extern const char CpuPeakLimit[];
} // namespace HeavyAdReasonEnum

namespace ContentSecurityPolicyViolationTypeEnum {
CONTENT_EXPORT extern const char KInlineViolation[];
CONTENT_EXPORT extern const char KEvalViolation[];
CONTENT_EXPORT extern const char KURLViolation[];
CONTENT_EXPORT extern const char KTrustedTypesSinkViolation[];
CONTENT_EXPORT extern const char KTrustedTypesPolicyViolation[];
} // namespace ContentSecurityPolicyViolationTypeEnum

namespace InspectorIssueCodeEnum {
CONTENT_EXPORT extern const char SameSiteCookieIssue[];
CONTENT_EXPORT extern const char MixedContentIssue[];
CONTENT_EXPORT extern const char BlockedByResponseIssue[];
CONTENT_EXPORT extern const char HeavyAdIssue[];
CONTENT_EXPORT extern const char ContentSecurityPolicyIssue[];
} // namespace InspectorIssueCodeEnum

namespace GetEncodedResponse {
namespace EncodingEnum {
CONTENT_EXPORT extern const char* Webp;
CONTENT_EXPORT extern const char* Jpeg;
CONTENT_EXPORT extern const char* Png;
} // EncodingEnum
} // GetEncodedResponse

// ------------- Type and builder declarations.

class CONTENT_EXPORT AffectedCookie : public ::crdtp::ProtocolObject<AffectedCookie> {
public:
    ~AffectedCookie() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetPath() { return m_path; }
    void SetPath(const String& value) { m_path = value; }

    String GetDomain() { return m_domain; }
    void SetDomain(const String& value) { m_domain = value; }

    template<int STATE>
    class AffectedCookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            PathSet = 1 << 2,
            DomainSet = 1 << 3,
            AllFieldsSet = (NameSet | PathSet | DomainSet | 0)};


        AffectedCookieBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        AffectedCookieBuilder<STATE | PathSet>& SetPath(const String& value)
        {
            static_assert(!(STATE & PathSet), "property path should not be set yet");
            m_result->SetPath(value);
            return castState<PathSet>();
        }

        AffectedCookieBuilder<STATE | DomainSet>& SetDomain(const String& value)
        {
            static_assert(!(STATE & DomainSet), "property domain should not be set yet");
            m_result->SetDomain(value);
            return castState<DomainSet>();
        }

        std::unique_ptr<AffectedCookie> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedCookie;
        AffectedCookieBuilder() : m_result(new AffectedCookie()) { }

        template<int STEP> AffectedCookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedCookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedCookie> m_result;
    };

    static AffectedCookieBuilder<0> Create()
    {
        return AffectedCookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedCookie()
    {
    }

    String m_name;
    String m_path;
    String m_domain;
};


class CONTENT_EXPORT AffectedRequest : public ::crdtp::ProtocolObject<AffectedRequest> {
public:
    ~AffectedRequest() override { }

    String GetRequestId() { return m_requestId; }
    void SetRequestId(const String& value) { m_requestId = value; }

    bool HasUrl() { return m_url.isJust(); }
    String GetUrl(const String& defaultValue) { return m_url.isJust() ? m_url.fromJust() : defaultValue; }
    void SetUrl(const String& value) { m_url = value; }

    template<int STATE>
    class AffectedRequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestIdSet = 1 << 1,
            AllFieldsSet = (RequestIdSet | 0)};


        AffectedRequestBuilder<STATE | RequestIdSet>& SetRequestId(const String& value)
        {
            static_assert(!(STATE & RequestIdSet), "property requestId should not be set yet");
            m_result->SetRequestId(value);
            return castState<RequestIdSet>();
        }

        AffectedRequestBuilder<STATE>& SetUrl(const String& value)
        {
            m_result->SetUrl(value);
            return *this;
        }

        std::unique_ptr<AffectedRequest> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedRequest;
        AffectedRequestBuilder() : m_result(new AffectedRequest()) { }

        template<int STEP> AffectedRequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedRequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedRequest> m_result;
    };

    static AffectedRequestBuilder<0> Create()
    {
        return AffectedRequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedRequest()
    {
    }

    String m_requestId;
    Maybe<String> m_url;
};


class CONTENT_EXPORT AffectedFrame : public ::crdtp::ProtocolObject<AffectedFrame> {
public:
    ~AffectedFrame() override { }

    String GetFrameId() { return m_frameId; }
    void SetFrameId(const String& value) { m_frameId = value; }

    template<int STATE>
    class AffectedFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameIdSet = 1 << 1,
            AllFieldsSet = (FrameIdSet | 0)};


        AffectedFrameBuilder<STATE | FrameIdSet>& SetFrameId(const String& value)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
            m_result->SetFrameId(value);
            return castState<FrameIdSet>();
        }

        std::unique_ptr<AffectedFrame> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedFrame;
        AffectedFrameBuilder() : m_result(new AffectedFrame()) { }

        template<int STEP> AffectedFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedFrame> m_result;
    };

    static AffectedFrameBuilder<0> Create()
    {
        return AffectedFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedFrame()
    {
    }

    String m_frameId;
};


class CONTENT_EXPORT SameSiteCookieIssueDetails : public ::crdtp::ProtocolObject<SameSiteCookieIssueDetails> {
public:
    ~SameSiteCookieIssueDetails() override { }

    protocol::Audits::AffectedCookie* GetCookie() { return m_cookie.get(); }
    void SetCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value) { m_cookie = std::move(value); }

    protocol::Array<String>* GetCookieWarningReasons() { return m_cookieWarningReasons.get(); }
    void SetCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieWarningReasons = std::move(value); }

    protocol::Array<String>* GetCookieExclusionReasons() { return m_cookieExclusionReasons.get(); }
    void SetCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieExclusionReasons = std::move(value); }

    String GetOperation() { return m_operation; }
    void SetOperation(const String& value) { m_operation = value; }

    bool HasSiteForCookies() { return m_siteForCookies.isJust(); }
    String GetSiteForCookies(const String& defaultValue) { return m_siteForCookies.isJust() ? m_siteForCookies.fromJust() : defaultValue; }
    void SetSiteForCookies(const String& value) { m_siteForCookies = value; }

    bool HasCookieUrl() { return m_cookieUrl.isJust(); }
    String GetCookieUrl(const String& defaultValue) { return m_cookieUrl.isJust() ? m_cookieUrl.fromJust() : defaultValue; }
    void SetCookieUrl(const String& value) { m_cookieUrl = value; }

    bool HasRequest() { return m_request.isJust(); }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) { return m_request.isJust() ? m_request.fromJust() : defaultValue; }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    template<int STATE>
    class SameSiteCookieIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CookieSet = 1 << 1,
            CookieWarningReasonsSet = 1 << 2,
            CookieExclusionReasonsSet = 1 << 3,
            OperationSet = 1 << 4,
            AllFieldsSet = (CookieSet | CookieWarningReasonsSet | CookieExclusionReasonsSet | OperationSet | 0)};


        SameSiteCookieIssueDetailsBuilder<STATE | CookieSet>& SetCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value)
        {
            static_assert(!(STATE & CookieSet), "property cookie should not be set yet");
            m_result->SetCookie(std::move(value));
            return castState<CookieSet>();
        }

        SameSiteCookieIssueDetailsBuilder<STATE | CookieWarningReasonsSet>& SetCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & CookieWarningReasonsSet), "property cookieWarningReasons should not be set yet");
            m_result->SetCookieWarningReasons(std::move(value));
            return castState<CookieWarningReasonsSet>();
        }

        SameSiteCookieIssueDetailsBuilder<STATE | CookieExclusionReasonsSet>& SetCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & CookieExclusionReasonsSet), "property cookieExclusionReasons should not be set yet");
            m_result->SetCookieExclusionReasons(std::move(value));
            return castState<CookieExclusionReasonsSet>();
        }

        SameSiteCookieIssueDetailsBuilder<STATE | OperationSet>& SetOperation(const String& value)
        {
            static_assert(!(STATE & OperationSet), "property operation should not be set yet");
            m_result->SetOperation(value);
            return castState<OperationSet>();
        }

        SameSiteCookieIssueDetailsBuilder<STATE>& SetSiteForCookies(const String& value)
        {
            m_result->SetSiteForCookies(value);
            return *this;
        }

        SameSiteCookieIssueDetailsBuilder<STATE>& SetCookieUrl(const String& value)
        {
            m_result->SetCookieUrl(value);
            return *this;
        }

        SameSiteCookieIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->SetRequest(std::move(value));
            return *this;
        }

        std::unique_ptr<SameSiteCookieIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SameSiteCookieIssueDetails;
        SameSiteCookieIssueDetailsBuilder() : m_result(new SameSiteCookieIssueDetails()) { }

        template<int STEP> SameSiteCookieIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SameSiteCookieIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SameSiteCookieIssueDetails> m_result;
    };

    static SameSiteCookieIssueDetailsBuilder<0> Create()
    {
        return SameSiteCookieIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SameSiteCookieIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::AffectedCookie> m_cookie;
    std::unique_ptr<protocol::Array<String>> m_cookieWarningReasons;
    std::unique_ptr<protocol::Array<String>> m_cookieExclusionReasons;
    String m_operation;
    Maybe<String> m_siteForCookies;
    Maybe<String> m_cookieUrl;
    Maybe<protocol::Audits::AffectedRequest> m_request;
};


class CONTENT_EXPORT MixedContentIssueDetails : public ::crdtp::ProtocolObject<MixedContentIssueDetails> {
public:
    ~MixedContentIssueDetails() override { }

    bool HasResourceType() { return m_resourceType.isJust(); }
    String GetResourceType(const String& defaultValue) { return m_resourceType.isJust() ? m_resourceType.fromJust() : defaultValue; }
    void SetResourceType(const String& value) { m_resourceType = value; }

    String GetResolutionStatus() { return m_resolutionStatus; }
    void SetResolutionStatus(const String& value) { m_resolutionStatus = value; }

    String GetInsecureURL() { return m_insecureURL; }
    void SetInsecureURL(const String& value) { m_insecureURL = value; }

    String GetMainResourceURL() { return m_mainResourceURL; }
    void SetMainResourceURL(const String& value) { m_mainResourceURL = value; }

    bool HasRequest() { return m_request.isJust(); }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) { return m_request.isJust() ? m_request.fromJust() : defaultValue; }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool HasFrame() { return m_frame.isJust(); }
    protocol::Audits::AffectedFrame* GetFrame(protocol::Audits::AffectedFrame* defaultValue) { return m_frame.isJust() ? m_frame.fromJust() : defaultValue; }
    void SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

    template<int STATE>
    class MixedContentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionStatusSet = 1 << 1,
            InsecureURLSet = 1 << 2,
            MainResourceURLSet = 1 << 3,
            AllFieldsSet = (ResolutionStatusSet | InsecureURLSet | MainResourceURLSet | 0)};


        MixedContentIssueDetailsBuilder<STATE>& SetResourceType(const String& value)
        {
            m_result->SetResourceType(value);
            return *this;
        }

        MixedContentIssueDetailsBuilder<STATE | ResolutionStatusSet>& SetResolutionStatus(const String& value)
        {
            static_assert(!(STATE & ResolutionStatusSet), "property resolutionStatus should not be set yet");
            m_result->SetResolutionStatus(value);
            return castState<ResolutionStatusSet>();
        }

        MixedContentIssueDetailsBuilder<STATE | InsecureURLSet>& SetInsecureURL(const String& value)
        {
            static_assert(!(STATE & InsecureURLSet), "property insecureURL should not be set yet");
            m_result->SetInsecureURL(value);
            return castState<InsecureURLSet>();
        }

        MixedContentIssueDetailsBuilder<STATE | MainResourceURLSet>& SetMainResourceURL(const String& value)
        {
            static_assert(!(STATE & MainResourceURLSet), "property mainResourceURL should not be set yet");
            m_result->SetMainResourceURL(value);
            return castState<MainResourceURLSet>();
        }

        MixedContentIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->SetRequest(std::move(value));
            return *this;
        }

        MixedContentIssueDetailsBuilder<STATE>& SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetFrame(std::move(value));
            return *this;
        }

        std::unique_ptr<MixedContentIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MixedContentIssueDetails;
        MixedContentIssueDetailsBuilder() : m_result(new MixedContentIssueDetails()) { }

        template<int STEP> MixedContentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MixedContentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_result;
    };

    static MixedContentIssueDetailsBuilder<0> Create()
    {
        return MixedContentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MixedContentIssueDetails()
    {
    }

    Maybe<String> m_resourceType;
    String m_resolutionStatus;
    String m_insecureURL;
    String m_mainResourceURL;
    Maybe<protocol::Audits::AffectedRequest> m_request;
    Maybe<protocol::Audits::AffectedFrame> m_frame;
};


class CONTENT_EXPORT BlockedByResponseIssueDetails : public ::crdtp::ProtocolObject<BlockedByResponseIssueDetails> {
public:
    ~BlockedByResponseIssueDetails() override { }

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool HasParentFrame() { return m_parentFrame.isJust(); }
    protocol::Audits::AffectedFrame* GetParentFrame(protocol::Audits::AffectedFrame* defaultValue) { return m_parentFrame.isJust() ? m_parentFrame.fromJust() : defaultValue; }
    void SetParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_parentFrame = std::move(value); }

    bool HasBlockedFrame() { return m_blockedFrame.isJust(); }
    protocol::Audits::AffectedFrame* GetBlockedFrame(protocol::Audits::AffectedFrame* defaultValue) { return m_blockedFrame.isJust() ? m_blockedFrame.fromJust() : defaultValue; }
    void SetBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_blockedFrame = std::move(value); }

    String GetReason() { return m_reason; }
    void SetReason(const String& value) { m_reason = value; }

    template<int STATE>
    class BlockedByResponseIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestSet = 1 << 1,
            ReasonSet = 1 << 2,
            AllFieldsSet = (RequestSet | ReasonSet | 0)};


        BlockedByResponseIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->SetRequest(std::move(value));
            return castState<RequestSet>();
        }

        BlockedByResponseIssueDetailsBuilder<STATE>& SetParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetParentFrame(std::move(value));
            return *this;
        }

        BlockedByResponseIssueDetailsBuilder<STATE>& SetBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetBlockedFrame(std::move(value));
            return *this;
        }

        BlockedByResponseIssueDetailsBuilder<STATE | ReasonSet>& SetReason(const String& value)
        {
            static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
            m_result->SetReason(value);
            return castState<ReasonSet>();
        }

        std::unique_ptr<BlockedByResponseIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BlockedByResponseIssueDetails;
        BlockedByResponseIssueDetailsBuilder() : m_result(new BlockedByResponseIssueDetails()) { }

        template<int STEP> BlockedByResponseIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BlockedByResponseIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_result;
    };

    static BlockedByResponseIssueDetailsBuilder<0> Create()
    {
        return BlockedByResponseIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BlockedByResponseIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    Maybe<protocol::Audits::AffectedFrame> m_parentFrame;
    Maybe<protocol::Audits::AffectedFrame> m_blockedFrame;
    String m_reason;
};


class CONTENT_EXPORT HeavyAdIssueDetails : public ::crdtp::ProtocolObject<HeavyAdIssueDetails> {
public:
    ~HeavyAdIssueDetails() override { }

    String GetResolution() { return m_resolution; }
    void SetResolution(const String& value) { m_resolution = value; }

    String GetReason() { return m_reason; }
    void SetReason(const String& value) { m_reason = value; }

    protocol::Audits::AffectedFrame* GetFrame() { return m_frame.get(); }
    void SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

    template<int STATE>
    class HeavyAdIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionSet = 1 << 1,
            ReasonSet = 1 << 2,
            FrameSet = 1 << 3,
            AllFieldsSet = (ResolutionSet | ReasonSet | FrameSet | 0)};


        HeavyAdIssueDetailsBuilder<STATE | ResolutionSet>& SetResolution(const String& value)
        {
            static_assert(!(STATE & ResolutionSet), "property resolution should not be set yet");
            m_result->SetResolution(value);
            return castState<ResolutionSet>();
        }

        HeavyAdIssueDetailsBuilder<STATE | ReasonSet>& SetReason(const String& value)
        {
            static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
            m_result->SetReason(value);
            return castState<ReasonSet>();
        }

        HeavyAdIssueDetailsBuilder<STATE | FrameSet>& SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            static_assert(!(STATE & FrameSet), "property frame should not be set yet");
            m_result->SetFrame(std::move(value));
            return castState<FrameSet>();
        }

        std::unique_ptr<HeavyAdIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HeavyAdIssueDetails;
        HeavyAdIssueDetailsBuilder() : m_result(new HeavyAdIssueDetails()) { }

        template<int STEP> HeavyAdIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HeavyAdIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_result;
    };

    static HeavyAdIssueDetailsBuilder<0> Create()
    {
        return HeavyAdIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HeavyAdIssueDetails()
    {
    }

    String m_resolution;
    String m_reason;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CONTENT_EXPORT SourceCodeLocation : public ::crdtp::ProtocolObject<SourceCodeLocation> {
public:
    ~SourceCodeLocation() override { }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    int GetLineNumber() { return m_lineNumber; }
    void SetLineNumber(int value) { m_lineNumber = value; }

    int GetColumnNumber() { return m_columnNumber; }
    void SetColumnNumber(int value) { m_columnNumber = value; }

    template<int STATE>
    class SourceCodeLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            LineNumberSet = 1 << 2,
            ColumnNumberSet = 1 << 3,
            AllFieldsSet = (UrlSet | LineNumberSet | ColumnNumberSet | 0)};


        SourceCodeLocationBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        SourceCodeLocationBuilder<STATE | LineNumberSet>& SetLineNumber(int value)
        {
            static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
            m_result->SetLineNumber(value);
            return castState<LineNumberSet>();
        }

        SourceCodeLocationBuilder<STATE | ColumnNumberSet>& SetColumnNumber(int value)
        {
            static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
            m_result->SetColumnNumber(value);
            return castState<ColumnNumberSet>();
        }

        std::unique_ptr<SourceCodeLocation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SourceCodeLocation;
        SourceCodeLocationBuilder() : m_result(new SourceCodeLocation()) { }

        template<int STEP> SourceCodeLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SourceCodeLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SourceCodeLocation> m_result;
    };

    static SourceCodeLocationBuilder<0> Create()
    {
        return SourceCodeLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SourceCodeLocation()
    {
          m_lineNumber = 0;
          m_columnNumber = 0;
    }

    String m_url;
    int m_lineNumber;
    int m_columnNumber;
};


class CONTENT_EXPORT ContentSecurityPolicyIssueDetails : public ::crdtp::ProtocolObject<ContentSecurityPolicyIssueDetails> {
public:
    ~ContentSecurityPolicyIssueDetails() override { }

    bool HasBlockedURL() { return m_blockedURL.isJust(); }
    String GetBlockedURL(const String& defaultValue) { return m_blockedURL.isJust() ? m_blockedURL.fromJust() : defaultValue; }
    void SetBlockedURL(const String& value) { m_blockedURL = value; }

    String GetViolatedDirective() { return m_violatedDirective; }
    void SetViolatedDirective(const String& value) { m_violatedDirective = value; }

    String GetContentSecurityPolicyViolationType() { return m_contentSecurityPolicyViolationType; }
    void SetContentSecurityPolicyViolationType(const String& value) { m_contentSecurityPolicyViolationType = value; }

    bool HasFrameAncestor() { return m_frameAncestor.isJust(); }
    protocol::Audits::AffectedFrame* GetFrameAncestor(protocol::Audits::AffectedFrame* defaultValue) { return m_frameAncestor.isJust() ? m_frameAncestor.fromJust() : defaultValue; }
    void SetFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frameAncestor = std::move(value); }

    bool HasSourceCodeLocation() { return m_sourceCodeLocation.isJust(); }
    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation(protocol::Audits::SourceCodeLocation* defaultValue) { return m_sourceCodeLocation.isJust() ? m_sourceCodeLocation.fromJust() : defaultValue; }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    bool HasViolatingNodeId() { return m_violatingNodeId.isJust(); }
    int GetViolatingNodeId(int defaultValue) { return m_violatingNodeId.isJust() ? m_violatingNodeId.fromJust() : defaultValue; }
    void SetViolatingNodeId(int value) { m_violatingNodeId = value; }

    template<int STATE>
    class ContentSecurityPolicyIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatedDirectiveSet = 1 << 1,
            ContentSecurityPolicyViolationTypeSet = 1 << 2,
            AllFieldsSet = (ViolatedDirectiveSet | ContentSecurityPolicyViolationTypeSet | 0)};


        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetBlockedURL(const String& value)
        {
            m_result->SetBlockedURL(value);
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ViolatedDirectiveSet>& SetViolatedDirective(const String& value)
        {
            static_assert(!(STATE & ViolatedDirectiveSet), "property violatedDirective should not be set yet");
            m_result->SetViolatedDirective(value);
            return castState<ViolatedDirectiveSet>();
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyViolationTypeSet>& SetContentSecurityPolicyViolationType(const String& value)
        {
            static_assert(!(STATE & ContentSecurityPolicyViolationTypeSet), "property contentSecurityPolicyViolationType should not be set yet");
            m_result->SetContentSecurityPolicyViolationType(value);
            return castState<ContentSecurityPolicyViolationTypeSet>();
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetFrameAncestor(std::move(value));
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            m_result->SetSourceCodeLocation(std::move(value));
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetViolatingNodeId(int value)
        {
            m_result->SetViolatingNodeId(value);
            return *this;
        }

        std::unique_ptr<ContentSecurityPolicyIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContentSecurityPolicyIssueDetails;
        ContentSecurityPolicyIssueDetailsBuilder() : m_result(new ContentSecurityPolicyIssueDetails()) { }

        template<int STEP> ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_result;
    };

    static ContentSecurityPolicyIssueDetailsBuilder<0> Create()
    {
        return ContentSecurityPolicyIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContentSecurityPolicyIssueDetails()
    {
    }

    Maybe<String> m_blockedURL;
    String m_violatedDirective;
    String m_contentSecurityPolicyViolationType;
    Maybe<protocol::Audits::AffectedFrame> m_frameAncestor;
    Maybe<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    Maybe<int> m_violatingNodeId;
};


class CONTENT_EXPORT InspectorIssueDetails : public ::crdtp::ProtocolObject<InspectorIssueDetails> {
public:
    ~InspectorIssueDetails() override { }

    bool HasSameSiteCookieIssueDetails() { return m_sameSiteCookieIssueDetails.isJust(); }
    protocol::Audits::SameSiteCookieIssueDetails* GetSameSiteCookieIssueDetails(protocol::Audits::SameSiteCookieIssueDetails* defaultValue) { return m_sameSiteCookieIssueDetails.isJust() ? m_sameSiteCookieIssueDetails.fromJust() : defaultValue; }
    void SetSameSiteCookieIssueDetails(std::unique_ptr<protocol::Audits::SameSiteCookieIssueDetails> value) { m_sameSiteCookieIssueDetails = std::move(value); }

    bool HasMixedContentIssueDetails() { return m_mixedContentIssueDetails.isJust(); }
    protocol::Audits::MixedContentIssueDetails* GetMixedContentIssueDetails(protocol::Audits::MixedContentIssueDetails* defaultValue) { return m_mixedContentIssueDetails.isJust() ? m_mixedContentIssueDetails.fromJust() : defaultValue; }
    void SetMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value) { m_mixedContentIssueDetails = std::move(value); }

    bool HasBlockedByResponseIssueDetails() { return m_blockedByResponseIssueDetails.isJust(); }
    protocol::Audits::BlockedByResponseIssueDetails* GetBlockedByResponseIssueDetails(protocol::Audits::BlockedByResponseIssueDetails* defaultValue) { return m_blockedByResponseIssueDetails.isJust() ? m_blockedByResponseIssueDetails.fromJust() : defaultValue; }
    void SetBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value) { m_blockedByResponseIssueDetails = std::move(value); }

    bool HasHeavyAdIssueDetails() { return m_heavyAdIssueDetails.isJust(); }
    protocol::Audits::HeavyAdIssueDetails* GetHeavyAdIssueDetails(protocol::Audits::HeavyAdIssueDetails* defaultValue) { return m_heavyAdIssueDetails.isJust() ? m_heavyAdIssueDetails.fromJust() : defaultValue; }
    void SetHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value) { m_heavyAdIssueDetails = std::move(value); }

    bool HasContentSecurityPolicyIssueDetails() { return m_contentSecurityPolicyIssueDetails.isJust(); }
    protocol::Audits::ContentSecurityPolicyIssueDetails* GetContentSecurityPolicyIssueDetails(protocol::Audits::ContentSecurityPolicyIssueDetails* defaultValue) { return m_contentSecurityPolicyIssueDetails.isJust() ? m_contentSecurityPolicyIssueDetails.fromJust() : defaultValue; }
    void SetContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value) { m_contentSecurityPolicyIssueDetails = std::move(value); }

    template<int STATE>
    class InspectorIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        InspectorIssueDetailsBuilder<STATE>& SetSameSiteCookieIssueDetails(std::unique_ptr<protocol::Audits::SameSiteCookieIssueDetails> value)
        {
            m_result->SetSameSiteCookieIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value)
        {
            m_result->SetMixedContentIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value)
        {
            m_result->SetBlockedByResponseIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value)
        {
            m_result->SetHeavyAdIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value)
        {
            m_result->SetContentSecurityPolicyIssueDetails(std::move(value));
            return *this;
        }

        std::unique_ptr<InspectorIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssueDetails;
        InspectorIssueDetailsBuilder() : m_result(new InspectorIssueDetails()) { }

        template<int STEP> InspectorIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_result;
    };

    static InspectorIssueDetailsBuilder<0> Create()
    {
        return InspectorIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssueDetails()
    {
    }

    Maybe<protocol::Audits::SameSiteCookieIssueDetails> m_sameSiteCookieIssueDetails;
    Maybe<protocol::Audits::MixedContentIssueDetails> m_mixedContentIssueDetails;
    Maybe<protocol::Audits::BlockedByResponseIssueDetails> m_blockedByResponseIssueDetails;
    Maybe<protocol::Audits::HeavyAdIssueDetails> m_heavyAdIssueDetails;
    Maybe<protocol::Audits::ContentSecurityPolicyIssueDetails> m_contentSecurityPolicyIssueDetails;
};


class CONTENT_EXPORT InspectorIssue : public ::crdtp::ProtocolObject<InspectorIssue> {
public:
    ~InspectorIssue() override { }

    String GetCode() { return m_code; }
    void SetCode(const String& value) { m_code = value; }

    protocol::Audits::InspectorIssueDetails* GetDetails() { return m_details.get(); }
    void SetDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value) { m_details = std::move(value); }

    template<int STATE>
    class InspectorIssueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CodeSet = 1 << 1,
            DetailsSet = 1 << 2,
            AllFieldsSet = (CodeSet | DetailsSet | 0)};


        InspectorIssueBuilder<STATE | CodeSet>& SetCode(const String& value)
        {
            static_assert(!(STATE & CodeSet), "property code should not be set yet");
            m_result->SetCode(value);
            return castState<CodeSet>();
        }

        InspectorIssueBuilder<STATE | DetailsSet>& SetDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value)
        {
            static_assert(!(STATE & DetailsSet), "property details should not be set yet");
            m_result->SetDetails(std::move(value));
            return castState<DetailsSet>();
        }

        std::unique_ptr<InspectorIssue> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssue;
        InspectorIssueBuilder() : m_result(new InspectorIssue()) { }

        template<int STEP> InspectorIssueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssue> m_result;
    };

    static InspectorIssueBuilder<0> Create()
    {
        return InspectorIssueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssue()
    {
    }

    String m_code;
    std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_details;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void IssueAdded(std::unique_ptr<protocol::Audits::InspectorIssue> issue);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Audits
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Audits_h)
