// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Overlay_h
#define content_protocol_Overlay_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/dom.h"
#include "content/browser/devtools/protocol/page.h"
#include "content/browser/devtools/protocol/runtime.h"

namespace content {
namespace protocol {
namespace Overlay {
class GridHighlightConfig;
class HighlightConfig;
using ColorFormat = String;
using InspectMode = String;

// ------------- Forward and enum declarations.

namespace ColorFormatEnum {
CONTENT_EXPORT extern const char Rgb[];
CONTENT_EXPORT extern const char Hsl[];
CONTENT_EXPORT extern const char Hex[];
} // namespace ColorFormatEnum

namespace InspectModeEnum {
CONTENT_EXPORT extern const char SearchForNode[];
CONTENT_EXPORT extern const char SearchForUAShadowDOM[];
CONTENT_EXPORT extern const char CaptureAreaScreenshot[];
CONTENT_EXPORT extern const char ShowDistances[];
CONTENT_EXPORT extern const char None[];
} // namespace InspectModeEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT GridHighlightConfig : public ::crdtp::ProtocolObject<GridHighlightConfig> {
public:
    ~GridHighlightConfig() override { }

    bool HasShowGridExtensionLines() { return m_showGridExtensionLines.isJust(); }
    bool GetShowGridExtensionLines(bool defaultValue) { return m_showGridExtensionLines.isJust() ? m_showGridExtensionLines.fromJust() : defaultValue; }
    void SetShowGridExtensionLines(bool value) { m_showGridExtensionLines = value; }

    bool HasShowPositiveLineNumbers() { return m_showPositiveLineNumbers.isJust(); }
    bool GetShowPositiveLineNumbers(bool defaultValue) { return m_showPositiveLineNumbers.isJust() ? m_showPositiveLineNumbers.fromJust() : defaultValue; }
    void SetShowPositiveLineNumbers(bool value) { m_showPositiveLineNumbers = value; }

    bool HasShowNegativeLineNumbers() { return m_showNegativeLineNumbers.isJust(); }
    bool GetShowNegativeLineNumbers(bool defaultValue) { return m_showNegativeLineNumbers.isJust() ? m_showNegativeLineNumbers.fromJust() : defaultValue; }
    void SetShowNegativeLineNumbers(bool value) { m_showNegativeLineNumbers = value; }

    bool HasShowAreaNames() { return m_showAreaNames.isJust(); }
    bool GetShowAreaNames(bool defaultValue) { return m_showAreaNames.isJust() ? m_showAreaNames.fromJust() : defaultValue; }
    void SetShowAreaNames(bool value) { m_showAreaNames = value; }

    bool HasShowLineNames() { return m_showLineNames.isJust(); }
    bool GetShowLineNames(bool defaultValue) { return m_showLineNames.isJust() ? m_showLineNames.fromJust() : defaultValue; }
    void SetShowLineNames(bool value) { m_showLineNames = value; }

    bool HasShowTrackSizes() { return m_showTrackSizes.isJust(); }
    bool GetShowTrackSizes(bool defaultValue) { return m_showTrackSizes.isJust() ? m_showTrackSizes.fromJust() : defaultValue; }
    void SetShowTrackSizes(bool value) { m_showTrackSizes = value; }

    bool HasGridBorderColor() { return m_gridBorderColor.isJust(); }
    protocol::DOM::RGBA* GetGridBorderColor(protocol::DOM::RGBA* defaultValue) { return m_gridBorderColor.isJust() ? m_gridBorderColor.fromJust() : defaultValue; }
    void SetGridBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_gridBorderColor = std::move(value); }

    bool HasCellBorderColor() { return m_cellBorderColor.isJust(); }
    protocol::DOM::RGBA* GetCellBorderColor(protocol::DOM::RGBA* defaultValue) { return m_cellBorderColor.isJust() ? m_cellBorderColor.fromJust() : defaultValue; }
    void SetCellBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_cellBorderColor = std::move(value); }

    bool HasRowLineColor() { return m_rowLineColor.isJust(); }
    protocol::DOM::RGBA* GetRowLineColor(protocol::DOM::RGBA* defaultValue) { return m_rowLineColor.isJust() ? m_rowLineColor.fromJust() : defaultValue; }
    void SetRowLineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowLineColor = std::move(value); }

    bool HasColumnLineColor() { return m_columnLineColor.isJust(); }
    protocol::DOM::RGBA* GetColumnLineColor(protocol::DOM::RGBA* defaultValue) { return m_columnLineColor.isJust() ? m_columnLineColor.fromJust() : defaultValue; }
    void SetColumnLineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnLineColor = std::move(value); }

    bool HasGridBorderDash() { return m_gridBorderDash.isJust(); }
    bool GetGridBorderDash(bool defaultValue) { return m_gridBorderDash.isJust() ? m_gridBorderDash.fromJust() : defaultValue; }
    void SetGridBorderDash(bool value) { m_gridBorderDash = value; }

    bool HasCellBorderDash() { return m_cellBorderDash.isJust(); }
    bool GetCellBorderDash(bool defaultValue) { return m_cellBorderDash.isJust() ? m_cellBorderDash.fromJust() : defaultValue; }
    void SetCellBorderDash(bool value) { m_cellBorderDash = value; }

    bool HasRowLineDash() { return m_rowLineDash.isJust(); }
    bool GetRowLineDash(bool defaultValue) { return m_rowLineDash.isJust() ? m_rowLineDash.fromJust() : defaultValue; }
    void SetRowLineDash(bool value) { m_rowLineDash = value; }

    bool HasColumnLineDash() { return m_columnLineDash.isJust(); }
    bool GetColumnLineDash(bool defaultValue) { return m_columnLineDash.isJust() ? m_columnLineDash.fromJust() : defaultValue; }
    void SetColumnLineDash(bool value) { m_columnLineDash = value; }

    bool HasRowGapColor() { return m_rowGapColor.isJust(); }
    protocol::DOM::RGBA* GetRowGapColor(protocol::DOM::RGBA* defaultValue) { return m_rowGapColor.isJust() ? m_rowGapColor.fromJust() : defaultValue; }
    void SetRowGapColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowGapColor = std::move(value); }

    bool HasRowHatchColor() { return m_rowHatchColor.isJust(); }
    protocol::DOM::RGBA* GetRowHatchColor(protocol::DOM::RGBA* defaultValue) { return m_rowHatchColor.isJust() ? m_rowHatchColor.fromJust() : defaultValue; }
    void SetRowHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowHatchColor = std::move(value); }

    bool HasColumnGapColor() { return m_columnGapColor.isJust(); }
    protocol::DOM::RGBA* GetColumnGapColor(protocol::DOM::RGBA* defaultValue) { return m_columnGapColor.isJust() ? m_columnGapColor.fromJust() : defaultValue; }
    void SetColumnGapColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnGapColor = std::move(value); }

    bool HasColumnHatchColor() { return m_columnHatchColor.isJust(); }
    protocol::DOM::RGBA* GetColumnHatchColor(protocol::DOM::RGBA* defaultValue) { return m_columnHatchColor.isJust() ? m_columnHatchColor.fromJust() : defaultValue; }
    void SetColumnHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnHatchColor = std::move(value); }

    bool HasAreaBorderColor() { return m_areaBorderColor.isJust(); }
    protocol::DOM::RGBA* GetAreaBorderColor(protocol::DOM::RGBA* defaultValue) { return m_areaBorderColor.isJust() ? m_areaBorderColor.fromJust() : defaultValue; }
    void SetAreaBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_areaBorderColor = std::move(value); }

    bool HasGridBackgroundColor() { return m_gridBackgroundColor.isJust(); }
    protocol::DOM::RGBA* GetGridBackgroundColor(protocol::DOM::RGBA* defaultValue) { return m_gridBackgroundColor.isJust() ? m_gridBackgroundColor.fromJust() : defaultValue; }
    void SetGridBackgroundColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_gridBackgroundColor = std::move(value); }

    template<int STATE>
    class GridHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        GridHighlightConfigBuilder<STATE>& SetShowGridExtensionLines(bool value)
        {
            m_result->SetShowGridExtensionLines(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetShowPositiveLineNumbers(bool value)
        {
            m_result->SetShowPositiveLineNumbers(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetShowNegativeLineNumbers(bool value)
        {
            m_result->SetShowNegativeLineNumbers(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetShowAreaNames(bool value)
        {
            m_result->SetShowAreaNames(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetShowLineNames(bool value)
        {
            m_result->SetShowLineNames(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetShowTrackSizes(bool value)
        {
            m_result->SetShowTrackSizes(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetGridBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetGridBorderColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetCellBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetCellBorderColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetRowLineColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetRowLineColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetColumnLineColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetColumnLineColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetGridBorderDash(bool value)
        {
            m_result->SetGridBorderDash(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetCellBorderDash(bool value)
        {
            m_result->SetCellBorderDash(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetRowLineDash(bool value)
        {
            m_result->SetRowLineDash(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetColumnLineDash(bool value)
        {
            m_result->SetColumnLineDash(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetRowGapColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetRowGapColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetRowHatchColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetRowHatchColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetColumnGapColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetColumnGapColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetColumnHatchColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetColumnHatchColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetAreaBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetAreaBorderColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& SetGridBackgroundColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetGridBackgroundColor(std::move(value));
            return *this;
        }

        std::unique_ptr<GridHighlightConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GridHighlightConfig;
        GridHighlightConfigBuilder() : m_result(new GridHighlightConfig()) { }

        template<int STEP> GridHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GridHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::GridHighlightConfig> m_result;
    };

    static GridHighlightConfigBuilder<0> Create()
    {
        return GridHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GridHighlightConfig()
    {
    }

    Maybe<bool> m_showGridExtensionLines;
    Maybe<bool> m_showPositiveLineNumbers;
    Maybe<bool> m_showNegativeLineNumbers;
    Maybe<bool> m_showAreaNames;
    Maybe<bool> m_showLineNames;
    Maybe<bool> m_showTrackSizes;
    Maybe<protocol::DOM::RGBA> m_gridBorderColor;
    Maybe<protocol::DOM::RGBA> m_cellBorderColor;
    Maybe<protocol::DOM::RGBA> m_rowLineColor;
    Maybe<protocol::DOM::RGBA> m_columnLineColor;
    Maybe<bool> m_gridBorderDash;
    Maybe<bool> m_cellBorderDash;
    Maybe<bool> m_rowLineDash;
    Maybe<bool> m_columnLineDash;
    Maybe<protocol::DOM::RGBA> m_rowGapColor;
    Maybe<protocol::DOM::RGBA> m_rowHatchColor;
    Maybe<protocol::DOM::RGBA> m_columnGapColor;
    Maybe<protocol::DOM::RGBA> m_columnHatchColor;
    Maybe<protocol::DOM::RGBA> m_areaBorderColor;
    Maybe<protocol::DOM::RGBA> m_gridBackgroundColor;
};


class CONTENT_EXPORT HighlightConfig : public ::crdtp::ProtocolObject<HighlightConfig> {
public:
    ~HighlightConfig() override { }

    bool HasShowInfo() { return m_showInfo.isJust(); }
    bool GetShowInfo(bool defaultValue) { return m_showInfo.isJust() ? m_showInfo.fromJust() : defaultValue; }
    void SetShowInfo(bool value) { m_showInfo = value; }

    bool HasShowStyles() { return m_showStyles.isJust(); }
    bool GetShowStyles(bool defaultValue) { return m_showStyles.isJust() ? m_showStyles.fromJust() : defaultValue; }
    void SetShowStyles(bool value) { m_showStyles = value; }

    bool HasShowRulers() { return m_showRulers.isJust(); }
    bool GetShowRulers(bool defaultValue) { return m_showRulers.isJust() ? m_showRulers.fromJust() : defaultValue; }
    void SetShowRulers(bool value) { m_showRulers = value; }

    bool HasShowAccessibilityInfo() { return m_showAccessibilityInfo.isJust(); }
    bool GetShowAccessibilityInfo(bool defaultValue) { return m_showAccessibilityInfo.isJust() ? m_showAccessibilityInfo.fromJust() : defaultValue; }
    void SetShowAccessibilityInfo(bool value) { m_showAccessibilityInfo = value; }

    bool HasShowExtensionLines() { return m_showExtensionLines.isJust(); }
    bool GetShowExtensionLines(bool defaultValue) { return m_showExtensionLines.isJust() ? m_showExtensionLines.fromJust() : defaultValue; }
    void SetShowExtensionLines(bool value) { m_showExtensionLines = value; }

    bool HasContentColor() { return m_contentColor.isJust(); }
    protocol::DOM::RGBA* GetContentColor(protocol::DOM::RGBA* defaultValue) { return m_contentColor.isJust() ? m_contentColor.fromJust() : defaultValue; }
    void SetContentColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_contentColor = std::move(value); }

    bool HasPaddingColor() { return m_paddingColor.isJust(); }
    protocol::DOM::RGBA* GetPaddingColor(protocol::DOM::RGBA* defaultValue) { return m_paddingColor.isJust() ? m_paddingColor.fromJust() : defaultValue; }
    void SetPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_paddingColor = std::move(value); }

    bool HasBorderColor() { return m_borderColor.isJust(); }
    protocol::DOM::RGBA* GetBorderColor(protocol::DOM::RGBA* defaultValue) { return m_borderColor.isJust() ? m_borderColor.fromJust() : defaultValue; }
    void SetBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_borderColor = std::move(value); }

    bool HasMarginColor() { return m_marginColor.isJust(); }
    protocol::DOM::RGBA* GetMarginColor(protocol::DOM::RGBA* defaultValue) { return m_marginColor.isJust() ? m_marginColor.fromJust() : defaultValue; }
    void SetMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_marginColor = std::move(value); }

    bool HasEventTargetColor() { return m_eventTargetColor.isJust(); }
    protocol::DOM::RGBA* GetEventTargetColor(protocol::DOM::RGBA* defaultValue) { return m_eventTargetColor.isJust() ? m_eventTargetColor.fromJust() : defaultValue; }
    void SetEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_eventTargetColor = std::move(value); }

    bool HasShapeColor() { return m_shapeColor.isJust(); }
    protocol::DOM::RGBA* GetShapeColor(protocol::DOM::RGBA* defaultValue) { return m_shapeColor.isJust() ? m_shapeColor.fromJust() : defaultValue; }
    void SetShapeColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_shapeColor = std::move(value); }

    bool HasShapeMarginColor() { return m_shapeMarginColor.isJust(); }
    protocol::DOM::RGBA* GetShapeMarginColor(protocol::DOM::RGBA* defaultValue) { return m_shapeMarginColor.isJust() ? m_shapeMarginColor.fromJust() : defaultValue; }
    void SetShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_shapeMarginColor = std::move(value); }

    bool HasCssGridColor() { return m_cssGridColor.isJust(); }
    protocol::DOM::RGBA* GetCssGridColor(protocol::DOM::RGBA* defaultValue) { return m_cssGridColor.isJust() ? m_cssGridColor.fromJust() : defaultValue; }
    void SetCssGridColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_cssGridColor = std::move(value); }

    bool HasColorFormat() { return m_colorFormat.isJust(); }
    String GetColorFormat(const String& defaultValue) { return m_colorFormat.isJust() ? m_colorFormat.fromJust() : defaultValue; }
    void SetColorFormat(const String& value) { m_colorFormat = value; }

    bool HasGridHighlightConfig() { return m_gridHighlightConfig.isJust(); }
    protocol::Overlay::GridHighlightConfig* GetGridHighlightConfig(protocol::Overlay::GridHighlightConfig* defaultValue) { return m_gridHighlightConfig.isJust() ? m_gridHighlightConfig.fromJust() : defaultValue; }
    void SetGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value) { m_gridHighlightConfig = std::move(value); }

    template<int STATE>
    class HighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        HighlightConfigBuilder<STATE>& SetShowInfo(bool value)
        {
            m_result->SetShowInfo(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetShowStyles(bool value)
        {
            m_result->SetShowStyles(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetShowRulers(bool value)
        {
            m_result->SetShowRulers(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetShowAccessibilityInfo(bool value)
        {
            m_result->SetShowAccessibilityInfo(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetShowExtensionLines(bool value)
        {
            m_result->SetShowExtensionLines(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetContentColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetContentColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetPaddingColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetBorderColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetMarginColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetMarginColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetEventTargetColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetShapeColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetShapeColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetShapeMarginColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetCssGridColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->SetCssGridColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetColorFormat(const String& value)
        {
            m_result->SetColorFormat(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& SetGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value)
        {
            m_result->SetGridHighlightConfig(std::move(value));
            return *this;
        }

        std::unique_ptr<HighlightConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HighlightConfig;
        HighlightConfigBuilder() : m_result(new HighlightConfig()) { }

        template<int STEP> HighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::HighlightConfig> m_result;
    };

    static HighlightConfigBuilder<0> Create()
    {
        return HighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HighlightConfig()
    {
    }

    Maybe<bool> m_showInfo;
    Maybe<bool> m_showStyles;
    Maybe<bool> m_showRulers;
    Maybe<bool> m_showAccessibilityInfo;
    Maybe<bool> m_showExtensionLines;
    Maybe<protocol::DOM::RGBA> m_contentColor;
    Maybe<protocol::DOM::RGBA> m_paddingColor;
    Maybe<protocol::DOM::RGBA> m_borderColor;
    Maybe<protocol::DOM::RGBA> m_marginColor;
    Maybe<protocol::DOM::RGBA> m_eventTargetColor;
    Maybe<protocol::DOM::RGBA> m_shapeColor;
    Maybe<protocol::DOM::RGBA> m_shapeMarginColor;
    Maybe<protocol::DOM::RGBA> m_cssGridColor;
    Maybe<String> m_colorFormat;
    Maybe<protocol::Overlay::GridHighlightConfig> m_gridHighlightConfig;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse SetInspectMode(const String& in_mode, Maybe<protocol::Overlay::HighlightConfig> in_highlightConfig) = 0;
    virtual DispatchResponse SetPausedInDebuggerMessage(Maybe<String> in_message) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void InspectNodeRequested(int backendNodeId);
    void NodeHighlightRequested(int nodeId);
    void ScreenshotRequested(std::unique_ptr<protocol::Page::Viewport> viewport);
    void InspectModeCanceled();

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Overlay
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Overlay_h)
