// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Storage_h
#define content_protocol_Storage_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/browser.h"
#include "content/browser/devtools/protocol/network.h"

namespace content {
namespace protocol {
namespace Storage {
using StorageType = String;
class UsageForType;

// ------------- Forward and enum declarations.

namespace StorageTypeEnum {
CONTENT_EXPORT extern const char Appcache[];
CONTENT_EXPORT extern const char Cookies[];
CONTENT_EXPORT extern const char File_systems[];
CONTENT_EXPORT extern const char Indexeddb[];
CONTENT_EXPORT extern const char Local_storage[];
CONTENT_EXPORT extern const char Shader_cache[];
CONTENT_EXPORT extern const char Websql[];
CONTENT_EXPORT extern const char Service_workers[];
CONTENT_EXPORT extern const char Cache_storage[];
CONTENT_EXPORT extern const char All[];
CONTENT_EXPORT extern const char Other[];
} // namespace StorageTypeEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT UsageForType : public ::crdtp::ProtocolObject<UsageForType> {
public:
    ~UsageForType() override { }

    String GetStorageType() { return m_storageType; }
    void SetStorageType(const String& value) { m_storageType = value; }

    double GetUsage() { return m_usage; }
    void SetUsage(double value) { m_usage = value; }

    template<int STATE>
    class UsageForTypeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StorageTypeSet = 1 << 1,
            UsageSet = 1 << 2,
            AllFieldsSet = (StorageTypeSet | UsageSet | 0)};


        UsageForTypeBuilder<STATE | StorageTypeSet>& SetStorageType(const String& value)
        {
            static_assert(!(STATE & StorageTypeSet), "property storageType should not be set yet");
            m_result->SetStorageType(value);
            return castState<StorageTypeSet>();
        }

        UsageForTypeBuilder<STATE | UsageSet>& SetUsage(double value)
        {
            static_assert(!(STATE & UsageSet), "property usage should not be set yet");
            m_result->SetUsage(value);
            return castState<UsageSet>();
        }

        std::unique_ptr<UsageForType> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UsageForType;
        UsageForTypeBuilder() : m_result(new UsageForType()) { }

        template<int STEP> UsageForTypeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UsageForTypeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::UsageForType> m_result;
    };

    static UsageForTypeBuilder<0> Create()
    {
        return UsageForTypeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UsageForType()
    {
          m_usage = 0;
    }

    String m_storageType;
    double m_usage;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    class CONTENT_EXPORT ClearDataForOriginCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearDataForOriginCallback() { }
    };
    virtual void ClearDataForOrigin(const String& in_origin, const String& in_storageTypes, std::unique_ptr<ClearDataForOriginCallback> callback) = 0;
    class CONTENT_EXPORT GetCookiesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Network::Cookie>> cookies) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetCookiesCallback() { }
    };
    virtual void GetCookies(Maybe<String> in_browserContextId, std::unique_ptr<GetCookiesCallback> callback) = 0;
    class CONTENT_EXPORT SetCookiesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetCookiesCallback() { }
    };
    virtual void SetCookies(std::unique_ptr<protocol::Array<protocol::Network::CookieParam>> in_cookies, Maybe<String> in_browserContextId, std::unique_ptr<SetCookiesCallback> callback) = 0;
    class CONTENT_EXPORT ClearCookiesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearCookiesCallback() { }
    };
    virtual void ClearCookies(Maybe<String> in_browserContextId, std::unique_ptr<ClearCookiesCallback> callback) = 0;
    class CONTENT_EXPORT GetUsageAndQuotaCallback {
    public:
        virtual void sendSuccess(double usage, double quota, std::unique_ptr<protocol::Array<protocol::Storage::UsageForType>> usageBreakdown) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetUsageAndQuotaCallback() { }
    };
    virtual void GetUsageAndQuota(const String& in_origin, std::unique_ptr<GetUsageAndQuotaCallback> callback) = 0;
    virtual DispatchResponse TrackCacheStorageForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse TrackIndexedDBForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse UntrackCacheStorageForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse UntrackIndexedDBForOrigin(const String& in_origin) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void CacheStorageContentUpdated(const String& origin, const String& cacheName);
    void CacheStorageListUpdated(const String& origin);
    void IndexedDBContentUpdated(const String& origin, const String& databaseName, const String& objectStoreName);
    void IndexedDBListUpdated(const String& origin);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Storage
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Storage_h)
