// content/common/document_scoped_interface_bundle.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOCUMENT_SCOPED_INTERFACE_BUNDLE_MOJOM_H_
#define CONTENT_COMMON_DOCUMENT_SCOPED_INTERFACE_BUNDLE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/document_scoped_interface_bundle.mojom-shared.h"
#include "content/common/document_scoped_interface_bundle.mojom-forward.h"
#include "services/service_manager/public/mojom/interface_provider.mojom.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {








class CONTENT_EXPORT DocumentScopedInterfaceBundle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DocumentScopedInterfaceBundle, T>::value>;
  using DataView = DocumentScopedInterfaceBundleDataView;
  using Data_ = internal::DocumentScopedInterfaceBundle_Data;

  template <typename... Args>
  static DocumentScopedInterfaceBundlePtr New(Args&&... args) {
    return DocumentScopedInterfaceBundlePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DocumentScopedInterfaceBundlePtr From(const U& u) {
    return mojo::TypeConverter<DocumentScopedInterfaceBundlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DocumentScopedInterfaceBundle>::Convert(*this);
  }


  DocumentScopedInterfaceBundle();

  DocumentScopedInterfaceBundle(
      ::mojo::PendingRemote<::service_manager::mojom::InterfaceProvider> interface_provider,
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker);

  ~DocumentScopedInterfaceBundle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DocumentScopedInterfaceBundlePtr>
  DocumentScopedInterfaceBundlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DocumentScopedInterfaceBundle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentScopedInterfaceBundle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DocumentScopedInterfaceBundle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DocumentScopedInterfaceBundle_UnserializedMessageContext<
            UserType, DocumentScopedInterfaceBundle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DocumentScopedInterfaceBundle::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DocumentScopedInterfaceBundle::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DocumentScopedInterfaceBundle_UnserializedMessageContext<
            UserType, DocumentScopedInterfaceBundle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DocumentScopedInterfaceBundle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<::service_manager::mojom::InterfaceProvider> interface_provider;
  
  ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DocumentScopedInterfaceBundle);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DocumentScopedInterfaceBundle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DocumentScopedInterfaceBundle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DocumentScopedInterfaceBundle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DocumentScopedInterfaceBundle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DocumentScopedInterfaceBundlePtr DocumentScopedInterfaceBundle::Clone() const {
  return New(
      mojo::Clone(interface_provider),
      mojo::Clone(browser_interface_broker)
  );
}

template <typename T, DocumentScopedInterfaceBundle::EnableIfSame<T>*>
bool DocumentScopedInterfaceBundle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interface_provider, other_struct.interface_provider))
    return false;
  if (!mojo::Equals(this->browser_interface_broker, other_struct.browser_interface_broker))
    return false;
  return true;
}

template <typename T, DocumentScopedInterfaceBundle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.interface_provider, rhs.interface_provider))
    return true;
  if (std::less<>{}(rhs.interface_provider, lhs.interface_provider))
    return false;
  if (std::less<>{}(lhs.browser_interface_broker, rhs.browser_interface_broker))
    return true;
  if (std::less<>{}(rhs.browser_interface_broker, lhs.browser_interface_broker))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::DocumentScopedInterfaceBundle::DataView,
                                         ::content::mojom::DocumentScopedInterfaceBundlePtr> {
  static bool IsNull(const ::content::mojom::DocumentScopedInterfaceBundlePtr& input) { return !input; }
  static void SetToNull(::content::mojom::DocumentScopedInterfaceBundlePtr* output) { output->reset(); }

  static  decltype(::content::mojom::DocumentScopedInterfaceBundle::interface_provider)& interface_provider(
       ::content::mojom::DocumentScopedInterfaceBundlePtr& input) {
    return input->interface_provider;
  }

  static  decltype(::content::mojom::DocumentScopedInterfaceBundle::browser_interface_broker)& browser_interface_broker(
       ::content::mojom::DocumentScopedInterfaceBundlePtr& input) {
    return input->browser_interface_broker;
  }

  static bool Read(::content::mojom::DocumentScopedInterfaceBundle::DataView input, ::content::mojom::DocumentScopedInterfaceBundlePtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_DOCUMENT_SCOPED_INTERFACE_BUNDLE_MOJOM_H_