// content/common/download/mhtml_file_writer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_H_
#define CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/download/mhtml_file_writer.mojom-shared.h"
#include "content/common/download/mhtml_file_writer.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class MhtmlFileWriterProxy;

template <typename ImplRefTraits>
class MhtmlFileWriterStub;

class MhtmlFileWriterRequestValidator;
class MhtmlFileWriterResponseValidator;


class CONTENT_EXPORT MhtmlFileWriter
    : public MhtmlFileWriterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MhtmlFileWriterInterfaceBase;
  using Proxy_ = MhtmlFileWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = MhtmlFileWriterStub<ImplRefTraits>;

  using RequestValidator_ = MhtmlFileWriterRequestValidator;
  using ResponseValidator_ = MhtmlFileWriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSerializeAsMHTMLMinVersion = 0,
  };
  virtual ~MhtmlFileWriter() {}


  using SerializeAsMHTMLCallback = base::OnceCallback<void(MhtmlSaveStatus, const std::vector<std::string>&, ::base::TimeDelta)>;
  
  virtual void SerializeAsMHTML(SerializeAsMHTMLParamsPtr params, SerializeAsMHTMLCallback callback) = 0;
};



class CONTENT_EXPORT MhtmlFileWriterProxy
    : public MhtmlFileWriter {
 public:
  using InterfaceType = MhtmlFileWriter;

  explicit MhtmlFileWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SerializeAsMHTML(SerializeAsMHTMLParamsPtr params, SerializeAsMHTMLCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT MhtmlFileWriterStubDispatch {
 public:
  static bool Accept(MhtmlFileWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MhtmlFileWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MhtmlFileWriter>>
class MhtmlFileWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MhtmlFileWriterStub() {}
  ~MhtmlFileWriterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MhtmlFileWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MhtmlFileWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT MhtmlFileWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT MhtmlFileWriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class CONTENT_EXPORT MhtmlOutputHandle {
 public:
  using DataView = MhtmlOutputHandleDataView;
  using Data_ = internal::MhtmlOutputHandle_Data;
  using Tag = Data_::MhtmlOutputHandle_Tag;

  static MhtmlOutputHandlePtr New() {
    return MhtmlOutputHandlePtr(base::in_place);
  }
  // Construct an instance holding |file_handle|.
  static MhtmlOutputHandlePtr
  NewFileHandle(
      ::base::File file_handle) {
    auto result = MhtmlOutputHandlePtr(base::in_place);
    result->set_file_handle(std::move(file_handle));
    return result;
  }
  // Construct an instance holding |producer_handle|.
  static MhtmlOutputHandlePtr
  NewProducerHandle(
      ::mojo::ScopedDataPipeProducerHandle producer_handle) {
    auto result = MhtmlOutputHandlePtr(base::in_place);
    result->set_producer_handle(std::move(producer_handle));
    return result;
  }

  template <typename U>
  static MhtmlOutputHandlePtr From(const U& u) {
    return mojo::TypeConverter<MhtmlOutputHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MhtmlOutputHandle>::Convert(*this);
  }

  MhtmlOutputHandle();
  ~MhtmlOutputHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MhtmlOutputHandlePtr>
  MhtmlOutputHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MhtmlOutputHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_file_handle() const { return tag_ == Tag::FILE_HANDLE; }

  
  ::base::File& get_file_handle() const {
    DCHECK(tag_ == Tag::FILE_HANDLE);
    return *(data_.file_handle);
  }

  
  void set_file_handle(
      ::base::File file_handle);
  
  bool is_producer_handle() const { return tag_ == Tag::PRODUCER_HANDLE; }

  
  ::mojo::ScopedDataPipeProducerHandle& get_producer_handle() const {
    DCHECK(tag_ == Tag::PRODUCER_HANDLE);
    return *(data_.producer_handle);
  }

  
  void set_producer_handle(
      ::mojo::ScopedDataPipeProducerHandle producer_handle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MhtmlOutputHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MhtmlOutputHandle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    ::base::File* file_handle;
    ::mojo::ScopedDataPipeProducerHandle* producer_handle;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class CONTENT_EXPORT SerializeAsMHTMLParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerializeAsMHTMLParams, T>::value>;
  using DataView = SerializeAsMHTMLParamsDataView;
  using Data_ = internal::SerializeAsMHTMLParams_Data;

  template <typename... Args>
  static SerializeAsMHTMLParamsPtr New(Args&&... args) {
    return SerializeAsMHTMLParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerializeAsMHTMLParamsPtr From(const U& u) {
    return mojo::TypeConverter<SerializeAsMHTMLParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializeAsMHTMLParams>::Convert(*this);
  }


  SerializeAsMHTMLParams();

  SerializeAsMHTMLParams(
      const std::string& mhtml_boundary_marker,
      bool mhtml_binary_encoding,
      bool mhtml_popup_overlay_removal,
      bool mhtml_problem_detection,
      std::vector<std::string> digests_of_uris_to_skip,
      const std::string& salt,
      MhtmlOutputHandlePtr output_handle);

  ~SerializeAsMHTMLParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerializeAsMHTMLParamsPtr>
  SerializeAsMHTMLParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerializeAsMHTMLParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializeAsMHTMLParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerializeAsMHTMLParams_UnserializedMessageContext<
            UserType, SerializeAsMHTMLParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SerializeAsMHTMLParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SerializeAsMHTMLParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerializeAsMHTMLParams_UnserializedMessageContext<
            UserType, SerializeAsMHTMLParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerializeAsMHTMLParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string mhtml_boundary_marker;
  
  bool mhtml_binary_encoding;
  
  bool mhtml_popup_overlay_removal;
  
  bool mhtml_problem_detection;
  
  std::vector<std::string> digests_of_uris_to_skip;
  
  std::string salt;
  
  MhtmlOutputHandlePtr output_handle;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(SerializeAsMHTMLParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
MhtmlOutputHandlePtr MhtmlOutputHandle::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::FILE_HANDLE:
      rv->set_file_handle(mojo::Clone(*data_.file_handle));
      break;
    case Tag::PRODUCER_HANDLE:
      rv->set_producer_handle(mojo::Clone(*data_.producer_handle));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MhtmlOutputHandle>::value>::type*>
bool MhtmlOutputHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::FILE_HANDLE:
      return mojo::Equals(*(data_.file_handle), *(other.data_.file_handle));
    case Tag::PRODUCER_HANDLE:
      return mojo::Equals(*(data_.producer_handle), *(other.data_.producer_handle));
  }

  return false;
}
template <typename StructPtrType>
SerializeAsMHTMLParamsPtr SerializeAsMHTMLParams::Clone() const {
  return New(
      mojo::Clone(mhtml_boundary_marker),
      mojo::Clone(mhtml_binary_encoding),
      mojo::Clone(mhtml_popup_overlay_removal),
      mojo::Clone(mhtml_problem_detection),
      mojo::Clone(digests_of_uris_to_skip),
      mojo::Clone(salt),
      mojo::Clone(output_handle)
  );
}

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>*>
bool SerializeAsMHTMLParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mhtml_boundary_marker, other_struct.mhtml_boundary_marker))
    return false;
  if (!mojo::Equals(this->mhtml_binary_encoding, other_struct.mhtml_binary_encoding))
    return false;
  if (!mojo::Equals(this->mhtml_popup_overlay_removal, other_struct.mhtml_popup_overlay_removal))
    return false;
  if (!mojo::Equals(this->mhtml_problem_detection, other_struct.mhtml_problem_detection))
    return false;
  if (!mojo::Equals(this->digests_of_uris_to_skip, other_struct.digests_of_uris_to_skip))
    return false;
  if (!mojo::Equals(this->salt, other_struct.salt))
    return false;
  if (!mojo::Equals(this->output_handle, other_struct.output_handle))
    return false;
  return true;
}

template <typename T, SerializeAsMHTMLParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mhtml_boundary_marker, rhs.mhtml_boundary_marker))
    return true;
  if (std::less<>{}(rhs.mhtml_boundary_marker, lhs.mhtml_boundary_marker))
    return false;
  if (std::less<>{}(lhs.mhtml_binary_encoding, rhs.mhtml_binary_encoding))
    return true;
  if (std::less<>{}(rhs.mhtml_binary_encoding, lhs.mhtml_binary_encoding))
    return false;
  if (std::less<>{}(lhs.mhtml_popup_overlay_removal, rhs.mhtml_popup_overlay_removal))
    return true;
  if (std::less<>{}(rhs.mhtml_popup_overlay_removal, lhs.mhtml_popup_overlay_removal))
    return false;
  if (std::less<>{}(lhs.mhtml_problem_detection, rhs.mhtml_problem_detection))
    return true;
  if (std::less<>{}(rhs.mhtml_problem_detection, lhs.mhtml_problem_detection))
    return false;
  if (std::less<>{}(lhs.digests_of_uris_to_skip, rhs.digests_of_uris_to_skip))
    return true;
  if (std::less<>{}(rhs.digests_of_uris_to_skip, lhs.digests_of_uris_to_skip))
    return false;
  if (std::less<>{}(lhs.salt, rhs.salt))
    return true;
  if (std::less<>{}(rhs.salt, lhs.salt))
    return false;
  if (std::less<>{}(lhs.output_handle, rhs.output_handle))
    return true;
  if (std::less<>{}(rhs.output_handle, lhs.output_handle))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SerializeAsMHTMLParams::DataView,
                                         ::content::mojom::SerializeAsMHTMLParamsPtr> {
  static bool IsNull(const ::content::mojom::SerializeAsMHTMLParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SerializeAsMHTMLParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::SerializeAsMHTMLParams::mhtml_boundary_marker)& mhtml_boundary_marker(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->mhtml_boundary_marker;
  }

  static decltype(::content::mojom::SerializeAsMHTMLParams::mhtml_binary_encoding) mhtml_binary_encoding(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->mhtml_binary_encoding;
  }

  static decltype(::content::mojom::SerializeAsMHTMLParams::mhtml_popup_overlay_removal) mhtml_popup_overlay_removal(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->mhtml_popup_overlay_removal;
  }

  static decltype(::content::mojom::SerializeAsMHTMLParams::mhtml_problem_detection) mhtml_problem_detection(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->mhtml_problem_detection;
  }

  static const decltype(::content::mojom::SerializeAsMHTMLParams::digests_of_uris_to_skip)& digests_of_uris_to_skip(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->digests_of_uris_to_skip;
  }

  static const decltype(::content::mojom::SerializeAsMHTMLParams::salt)& salt(
      const ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->salt;
  }

  static  decltype(::content::mojom::SerializeAsMHTMLParams::output_handle)& output_handle(
       ::content::mojom::SerializeAsMHTMLParamsPtr& input) {
    return input->output_handle;
  }

  static bool Read(::content::mojom::SerializeAsMHTMLParams::DataView input, ::content::mojom::SerializeAsMHTMLParamsPtr* output);
};


template <>
struct CONTENT_EXPORT UnionTraits<::content::mojom::MhtmlOutputHandle::DataView,
                                        ::content::mojom::MhtmlOutputHandlePtr> {
  static bool IsNull(const ::content::mojom::MhtmlOutputHandlePtr& input) { return !input; }
  static void SetToNull(::content::mojom::MhtmlOutputHandlePtr* output) { output->reset(); }

  static ::content::mojom::MhtmlOutputHandle::Tag GetTag(const ::content::mojom::MhtmlOutputHandlePtr& input) {
    return input->which();
  }

  static  ::base::File& file_handle( ::content::mojom::MhtmlOutputHandlePtr& input) {
    return input->get_file_handle();
  }

  static  ::mojo::ScopedDataPipeProducerHandle& producer_handle( ::content::mojom::MhtmlOutputHandlePtr& input) {
    return input->get_producer_handle();
  }

  static bool Read(::content::mojom::MhtmlOutputHandle::DataView input, ::content::mojom::MhtmlOutputHandlePtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_H_