// content/common/render_accessibility.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_SHARED_H_
#define CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/common/render_accessibility.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_action_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace content {
namespace mojom {
class LocationChangesDataView;

class HitTestResponseDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::LocationChangesDataView> {
  using Data = ::content::mojom::internal::LocationChanges_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::HitTestResponseDataView> {
  using Data = ::content::mojom::internal::HitTestResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {
// Interface base classes. They are used for type safety check.
class RenderAccessibilityHostInterfaceBase {};

using RenderAccessibilityHostPtrDataView =
    mojo::InterfacePtrDataView<RenderAccessibilityHostInterfaceBase>;
using RenderAccessibilityHostRequestDataView =
    mojo::InterfaceRequestDataView<RenderAccessibilityHostInterfaceBase>;
using RenderAccessibilityHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderAccessibilityHostInterfaceBase>;
using RenderAccessibilityHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderAccessibilityHostInterfaceBase>;
class RenderAccessibilityInterfaceBase {};

using RenderAccessibilityPtrDataView =
    mojo::InterfacePtrDataView<RenderAccessibilityInterfaceBase>;
using RenderAccessibilityRequestDataView =
    mojo::InterfaceRequestDataView<RenderAccessibilityInterfaceBase>;
using RenderAccessibilityAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderAccessibilityInterfaceBase>;
using RenderAccessibilityAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderAccessibilityInterfaceBase>;


class LocationChangesDataView {
 public:
  LocationChangesDataView() {}

  LocationChangesDataView(
      internal::LocationChanges_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetNewLocationDataView(
      ::ax::mojom::AXRelativeBoundsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNewLocation(UserType* output) {
    
    auto* pointer = data_->new_location.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXRelativeBoundsDataView>(
        pointer, output, context_);
  }
 private:
  internal::LocationChanges_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class HitTestResponseDataView {
 public:
  HitTestResponseDataView() {}

  HitTestResponseDataView(
      internal::HitTestResponse_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetHitFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHitFrameToken(UserType* output) {
    
    auto* pointer = data_->hit_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetHitFrameTransformedPointDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHitFrameTransformedPoint(UserType* output) {
    
    auto* pointer = data_->hit_frame_transformed_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, context_);
  }
  int32_t hit_node_id() const {
    return data_->hit_node_id;
  }
 private:
  internal::HitTestResponse_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::LocationChangesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::LocationChangesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::LocationChanges_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->id = Traits::id(input);
    decltype(Traits::new_location(input)) in_new_location = Traits::new_location(input);
    typename decltype((*output)->new_location)::BaseType::BufferWriter
        new_location_writer;
    mojo::internal::Serialize<::ax::mojom::AXRelativeBoundsDataView>(
        in_new_location, buffer, &new_location_writer, context);
    (*output)->new_location.Set(
        new_location_writer.is_null() ? nullptr : new_location_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->new_location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_location in LocationChanges struct");
  }

  static bool Deserialize(::content::mojom::internal::LocationChanges_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::LocationChangesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::HitTestResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::HitTestResponseDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::HitTestResponse_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::hit_frame_token(input)) in_hit_frame_token = Traits::hit_frame_token(input);
    typename decltype((*output)->hit_frame_token)::BaseType::BufferWriter
        hit_frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_hit_frame_token, buffer, &hit_frame_token_writer, context);
    (*output)->hit_frame_token.Set(
        hit_frame_token_writer.is_null() ? nullptr : hit_frame_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->hit_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hit_frame_token in HitTestResponse struct");
    decltype(Traits::hit_frame_transformed_point(input)) in_hit_frame_transformed_point = Traits::hit_frame_transformed_point(input);
    typename decltype((*output)->hit_frame_transformed_point)::BaseType::BufferWriter
        hit_frame_transformed_point_writer;
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_hit_frame_transformed_point, buffer, &hit_frame_transformed_point_writer, context);
    (*output)->hit_frame_transformed_point.Set(
        hit_frame_transformed_point_writer.is_null() ? nullptr : hit_frame_transformed_point_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->hit_frame_transformed_point.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hit_frame_transformed_point in HitTestResponse struct");
    (*output)->hit_node_id = Traits::hit_node_id(input);
  }

  static bool Deserialize(::content::mojom::internal::HitTestResponse_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::HitTestResponseDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {

inline void LocationChangesDataView::GetNewLocationDataView(
    ::ax::mojom::AXRelativeBoundsDataView* output) {
  auto pointer = data_->new_location.Get();
  *output = ::ax::mojom::AXRelativeBoundsDataView(pointer, context_);
}


inline void HitTestResponseDataView::GetHitFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->hit_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void HitTestResponseDataView::GetHitFrameTransformedPointDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->hit_frame_transformed_point.Get();
  *output = ::gfx::mojom::PointDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_SHARED_H_