// content/public/common/resource_usage_reporter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SHARED_H_
#define CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/public/common/resource_usage_reporter.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace content {
namespace mojom {
class ResourceTypeStatDataView;

class ResourceTypeStatsDataView;

class ResourceUsageDataDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::ResourceTypeStatDataView> {
  using Data = ::content::mojom::internal::ResourceTypeStat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::ResourceTypeStatsDataView> {
  using Data = ::content::mojom::internal::ResourceTypeStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::ResourceUsageDataDataView> {
  using Data = ::content::mojom::internal::ResourceUsageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {
// Interface base classes. They are used for type safety check.
class ResourceUsageReporterInterfaceBase {};

using ResourceUsageReporterPtrDataView =
    mojo::InterfacePtrDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterRequestDataView =
    mojo::InterfaceRequestDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResourceUsageReporterInterfaceBase>;


class ResourceTypeStatDataView {
 public:
  ResourceTypeStatDataView() {}

  ResourceTypeStatDataView(
      internal::ResourceTypeStat_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t count() const {
    return data_->count;
  }
  uint64_t size() const {
    return data_->size;
  }
  uint64_t live_size() const {
    return data_->live_size;
  }
  uint64_t decoded_size() const {
    return data_->decoded_size;
  }
 private:
  internal::ResourceTypeStat_Data* data_ = nullptr;
};



class ResourceTypeStatsDataView {
 public:
  ResourceTypeStatsDataView() {}

  ResourceTypeStatsDataView(
      internal::ResourceTypeStats_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetImagesDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImages(UserType* output) {
    
    auto* pointer = data_->images.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, context_);
  }
  inline void GetCssStyleSheetsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCssStyleSheets(UserType* output) {
    
    auto* pointer = data_->css_style_sheets.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, context_);
  }
  inline void GetScriptsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScripts(UserType* output) {
    
    auto* pointer = data_->scripts.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, context_);
  }
  inline void GetXslStyleSheetsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadXslStyleSheets(UserType* output) {
    
    auto* pointer = data_->xsl_style_sheets.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, context_);
  }
  inline void GetFontsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFonts(UserType* output) {
    
    auto* pointer = data_->fonts.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, context_);
  }
  inline void GetOtherDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOther(UserType* output) {
    
    auto* pointer = data_->other.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, context_);
  }
 private:
  internal::ResourceTypeStats_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ResourceUsageDataDataView {
 public:
  ResourceUsageDataDataView() {}

  ResourceUsageDataDataView(
      internal::ResourceUsageData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool reports_v8_stats() const {
    return data_->reports_v8_stats;
  }
  uint64_t v8_bytes_allocated() const {
    return data_->v8_bytes_allocated;
  }
  uint64_t v8_bytes_used() const {
    return data_->v8_bytes_used;
  }
  inline void GetWebCacheStatsDataView(
      ResourceTypeStatsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWebCacheStats(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::ResourceTypeStatsDataView, UserType>(),
    "Attempting to read the optional `web_cache_stats` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWebCacheStats` instead "
    "of `ReadWebCacheStats if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->web_cache_stats.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatsDataView>(
        pointer, output, context_);
  }
 private:
  internal::ResourceUsageData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ResourceTypeStatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceTypeStatDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::ResourceTypeStat_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->count = Traits::count(input);
    (*output)->size = Traits::size(input);
    (*output)->live_size = Traits::live_size(input);
    (*output)->decoded_size = Traits::decoded_size(input);
  }

  static bool Deserialize(::content::mojom::internal::ResourceTypeStat_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::ResourceTypeStatDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ResourceTypeStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceTypeStatsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::ResourceTypeStats_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::images(input)) in_images = Traits::images(input);
    typename decltype((*output)->images)::BaseType::BufferWriter
        images_writer;
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_images, buffer, &images_writer, context);
    (*output)->images.Set(
        images_writer.is_null() ? nullptr : images_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->images.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null images in ResourceTypeStats struct");
    decltype(Traits::css_style_sheets(input)) in_css_style_sheets = Traits::css_style_sheets(input);
    typename decltype((*output)->css_style_sheets)::BaseType::BufferWriter
        css_style_sheets_writer;
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_css_style_sheets, buffer, &css_style_sheets_writer, context);
    (*output)->css_style_sheets.Set(
        css_style_sheets_writer.is_null() ? nullptr : css_style_sheets_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->css_style_sheets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null css_style_sheets in ResourceTypeStats struct");
    decltype(Traits::scripts(input)) in_scripts = Traits::scripts(input);
    typename decltype((*output)->scripts)::BaseType::BufferWriter
        scripts_writer;
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_scripts, buffer, &scripts_writer, context);
    (*output)->scripts.Set(
        scripts_writer.is_null() ? nullptr : scripts_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scripts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scripts in ResourceTypeStats struct");
    decltype(Traits::xsl_style_sheets(input)) in_xsl_style_sheets = Traits::xsl_style_sheets(input);
    typename decltype((*output)->xsl_style_sheets)::BaseType::BufferWriter
        xsl_style_sheets_writer;
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_xsl_style_sheets, buffer, &xsl_style_sheets_writer, context);
    (*output)->xsl_style_sheets.Set(
        xsl_style_sheets_writer.is_null() ? nullptr : xsl_style_sheets_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->xsl_style_sheets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null xsl_style_sheets in ResourceTypeStats struct");
    decltype(Traits::fonts(input)) in_fonts = Traits::fonts(input);
    typename decltype((*output)->fonts)::BaseType::BufferWriter
        fonts_writer;
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_fonts, buffer, &fonts_writer, context);
    (*output)->fonts.Set(
        fonts_writer.is_null() ? nullptr : fonts_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->fonts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fonts in ResourceTypeStats struct");
    decltype(Traits::other(input)) in_other = Traits::other(input);
    typename decltype((*output)->other)::BaseType::BufferWriter
        other_writer;
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_other, buffer, &other_writer, context);
    (*output)->other.Set(
        other_writer.is_null() ? nullptr : other_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->other.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null other in ResourceTypeStats struct");
  }

  static bool Deserialize(::content::mojom::internal::ResourceTypeStats_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::ResourceTypeStatsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ResourceUsageDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceUsageDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::ResourceUsageData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->reports_v8_stats = Traits::reports_v8_stats(input);
    (*output)->v8_bytes_allocated = Traits::v8_bytes_allocated(input);
    (*output)->v8_bytes_used = Traits::v8_bytes_used(input);
    decltype(Traits::web_cache_stats(input)) in_web_cache_stats = Traits::web_cache_stats(input);
    typename decltype((*output)->web_cache_stats)::BaseType::BufferWriter
        web_cache_stats_writer;
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatsDataView>(
        in_web_cache_stats, buffer, &web_cache_stats_writer, context);
    (*output)->web_cache_stats.Set(
        web_cache_stats_writer.is_null() ? nullptr : web_cache_stats_writer.data());
  }

  static bool Deserialize(::content::mojom::internal::ResourceUsageData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::ResourceUsageDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {



inline void ResourceTypeStatsDataView::GetImagesDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->images.Get();
  *output = ResourceTypeStatDataView(pointer, context_);
}
inline void ResourceTypeStatsDataView::GetCssStyleSheetsDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->css_style_sheets.Get();
  *output = ResourceTypeStatDataView(pointer, context_);
}
inline void ResourceTypeStatsDataView::GetScriptsDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->scripts.Get();
  *output = ResourceTypeStatDataView(pointer, context_);
}
inline void ResourceTypeStatsDataView::GetXslStyleSheetsDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->xsl_style_sheets.Get();
  *output = ResourceTypeStatDataView(pointer, context_);
}
inline void ResourceTypeStatsDataView::GetFontsDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->fonts.Get();
  *output = ResourceTypeStatDataView(pointer, context_);
}
inline void ResourceTypeStatsDataView::GetOtherDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->other.Get();
  *output = ResourceTypeStatDataView(pointer, context_);
}


inline void ResourceUsageDataDataView::GetWebCacheStatsDataView(
    ResourceTypeStatsDataView* output) {
  auto pointer = data_->web_cache_stats.Get();
  *output = ResourceTypeStatsDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#endif  // CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SHARED_H_