// gpu/ipc/common/vulkan_ycbcr_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_YCBCR_INFO_MOJOM_BLINK_H_
#define GPU_IPC_COMMON_VULKAN_YCBCR_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace gpu {
namespace mojom {
namespace blink {








class BLINK_PLATFORM_EXPORT VulkanYCbCrInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VulkanYCbCrInfo, T>::value>;
  using DataView = VulkanYCbCrInfoDataView;
  using Data_ = internal::VulkanYCbCrInfo_Data;

  template <typename... Args>
  static VulkanYCbCrInfoPtr New(Args&&... args) {
    return VulkanYCbCrInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VulkanYCbCrInfoPtr From(const U& u) {
    return mojo::TypeConverter<VulkanYCbCrInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VulkanYCbCrInfo>::Convert(*this);
  }


  VulkanYCbCrInfo();

  VulkanYCbCrInfo(
      uint32_t image_format,
      uint64_t external_format,
      uint32_t suggested_ycbcr_model,
      uint32_t suggested_ycbcr_range,
      uint32_t suggested_xchroma_offset,
      uint32_t suggested_ychroma_offset,
      uint32_t format_features);

  ~VulkanYCbCrInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VulkanYCbCrInfoPtr>
  VulkanYCbCrInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VulkanYCbCrInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VulkanYCbCrInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VulkanYCbCrInfo_UnserializedMessageContext<
            UserType, VulkanYCbCrInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VulkanYCbCrInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VulkanYCbCrInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VulkanYCbCrInfo_UnserializedMessageContext<
            UserType, VulkanYCbCrInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VulkanYCbCrInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t image_format;
  
  uint64_t external_format;
  
  uint32_t suggested_ycbcr_model;
  
  uint32_t suggested_ycbcr_range;
  
  uint32_t suggested_xchroma_offset;
  
  uint32_t suggested_ychroma_offset;
  
  uint32_t format_features;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VulkanYCbCrInfoPtr VulkanYCbCrInfo::Clone() const {
  return New(
      mojo::Clone(image_format),
      mojo::Clone(external_format),
      mojo::Clone(suggested_ycbcr_model),
      mojo::Clone(suggested_ycbcr_range),
      mojo::Clone(suggested_xchroma_offset),
      mojo::Clone(suggested_ychroma_offset),
      mojo::Clone(format_features)
  );
}

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>*>
bool VulkanYCbCrInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_format, other_struct.image_format))
    return false;
  if (!mojo::Equals(this->external_format, other_struct.external_format))
    return false;
  if (!mojo::Equals(this->suggested_ycbcr_model, other_struct.suggested_ycbcr_model))
    return false;
  if (!mojo::Equals(this->suggested_ycbcr_range, other_struct.suggested_ycbcr_range))
    return false;
  if (!mojo::Equals(this->suggested_xchroma_offset, other_struct.suggested_xchroma_offset))
    return false;
  if (!mojo::Equals(this->suggested_ychroma_offset, other_struct.suggested_ychroma_offset))
    return false;
  if (!mojo::Equals(this->format_features, other_struct.format_features))
    return false;
  return true;
}

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.image_format, rhs.image_format))
    return true;
  if (std::less<>{}(rhs.image_format, lhs.image_format))
    return false;
  if (std::less<>{}(lhs.external_format, rhs.external_format))
    return true;
  if (std::less<>{}(rhs.external_format, lhs.external_format))
    return false;
  if (std::less<>{}(lhs.suggested_ycbcr_model, rhs.suggested_ycbcr_model))
    return true;
  if (std::less<>{}(rhs.suggested_ycbcr_model, lhs.suggested_ycbcr_model))
    return false;
  if (std::less<>{}(lhs.suggested_ycbcr_range, rhs.suggested_ycbcr_range))
    return true;
  if (std::less<>{}(rhs.suggested_ycbcr_range, lhs.suggested_ycbcr_range))
    return false;
  if (std::less<>{}(lhs.suggested_xchroma_offset, rhs.suggested_xchroma_offset))
    return true;
  if (std::less<>{}(rhs.suggested_xchroma_offset, lhs.suggested_xchroma_offset))
    return false;
  if (std::less<>{}(lhs.suggested_ychroma_offset, rhs.suggested_ychroma_offset))
    return true;
  if (std::less<>{}(rhs.suggested_ychroma_offset, lhs.suggested_ychroma_offset))
    return false;
  if (std::less<>{}(lhs.format_features, rhs.format_features))
    return true;
  if (std::less<>{}(rhs.format_features, lhs.format_features))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace gpu

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::gpu::mojom::blink::VulkanYCbCrInfo::DataView,
                                         ::gpu::mojom::blink::VulkanYCbCrInfoPtr> {
  static bool IsNull(const ::gpu::mojom::blink::VulkanYCbCrInfoPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::VulkanYCbCrInfoPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::blink::VulkanYCbCrInfo::image_format) image_format(
      const ::gpu::mojom::blink::VulkanYCbCrInfoPtr& input) {
    return input->image_format;
  }

  static decltype(::gpu::mojom::blink::VulkanYCbCrInfo::external_format) external_format(
      const ::gpu::mojom::blink::VulkanYCbCrInfoPtr& input) {
    return input->external_format;
  }

  static decltype(::gpu::mojom::blink::VulkanYCbCrInfo::suggested_ycbcr_model) suggested_ycbcr_model(
      const ::gpu::mojom::blink::VulkanYCbCrInfoPtr& input) {
    return input->suggested_ycbcr_model;
  }

  static decltype(::gpu::mojom::blink::VulkanYCbCrInfo::suggested_ycbcr_range) suggested_ycbcr_range(
      const ::gpu::mojom::blink::VulkanYCbCrInfoPtr& input) {
    return input->suggested_ycbcr_range;
  }

  static decltype(::gpu::mojom::blink::VulkanYCbCrInfo::suggested_xchroma_offset) suggested_xchroma_offset(
      const ::gpu::mojom::blink::VulkanYCbCrInfoPtr& input) {
    return input->suggested_xchroma_offset;
  }

  static decltype(::gpu::mojom::blink::VulkanYCbCrInfo::suggested_ychroma_offset) suggested_ychroma_offset(
      const ::gpu::mojom::blink::VulkanYCbCrInfoPtr& input) {
    return input->suggested_ychroma_offset;
  }

  static decltype(::gpu::mojom::blink::VulkanYCbCrInfo::format_features) format_features(
      const ::gpu::mojom::blink::VulkanYCbCrInfoPtr& input) {
    return input->format_features;
  }

  static bool Read(::gpu::mojom::blink::VulkanYCbCrInfo::DataView input, ::gpu::mojom::blink::VulkanYCbCrInfoPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_VULKAN_YCBCR_INFO_MOJOM_BLINK_H_