// media/learning/mojo/public/mojom/learning_task_controller.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TASK_CONTROLLER_MOJOM_H_
#define MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TASK_CONTROLLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-shared.h"
#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "media/learning/mojo/public/mojom/learning_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace learning {
namespace mojom {

class LearningTaskControllerProxy;

template <typename ImplRefTraits>
class LearningTaskControllerStub;

class LearningTaskControllerRequestValidator;
class LearningTaskControllerResponseValidator;


class  LearningTaskController
    : public LearningTaskControllerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = LearningTaskControllerInterfaceBase;
  using Proxy_ = LearningTaskControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = LearningTaskControllerStub<ImplRefTraits>;

  using RequestValidator_ = LearningTaskControllerRequestValidator;
  using ResponseValidator_ = LearningTaskControllerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBeginObservationMinVersion = 0,
    kCompleteObservationMinVersion = 0,
    kCancelObservationMinVersion = 0,
    kUpdateDefaultTargetMinVersion = 0,
    kPredictDistributionMinVersion = 0,
  };
  virtual ~LearningTaskController() {}

  
  virtual void BeginObservation(const ::base::UnguessableToken& id, const std::vector<::media::learning::FeatureValue>& features, const base::Optional<::media::learning::TargetValue>& default_target) = 0;

  
  virtual void CompleteObservation(const ::base::UnguessableToken& id, const ::media::learning::ObservationCompletion& completion) = 0;

  
  virtual void CancelObservation(const ::base::UnguessableToken& id) = 0;

  
  virtual void UpdateDefaultTarget(const ::base::UnguessableToken& id, const base::Optional<::media::learning::TargetValue>& default_target) = 0;


  using PredictDistributionCallback = base::OnceCallback<void(const base::Optional<::media::learning::TargetHistogram>&)>;
  
  virtual void PredictDistribution(const std::vector<::media::learning::FeatureValue>& features, PredictDistributionCallback callback) = 0;
};



class  LearningTaskControllerProxy
    : public LearningTaskController {
 public:
  using InterfaceType = LearningTaskController;

  explicit LearningTaskControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BeginObservation(const ::base::UnguessableToken& id, const std::vector<::media::learning::FeatureValue>& features, const base::Optional<::media::learning::TargetValue>& default_target) final;
  
  void CompleteObservation(const ::base::UnguessableToken& id, const ::media::learning::ObservationCompletion& completion) final;
  
  void CancelObservation(const ::base::UnguessableToken& id) final;
  
  void UpdateDefaultTarget(const ::base::UnguessableToken& id, const base::Optional<::media::learning::TargetValue>& default_target) final;
  
  void PredictDistribution(const std::vector<::media::learning::FeatureValue>& features, PredictDistributionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LearningTaskControllerStubDispatch {
 public:
  static bool Accept(LearningTaskController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LearningTaskController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LearningTaskController>>
class LearningTaskControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LearningTaskControllerStub() {}
  ~LearningTaskControllerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LearningTaskControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LearningTaskControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LearningTaskControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LearningTaskControllerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace learning
}  // namespace media

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TASK_CONTROLLER_MOJOM_H_