// qtwebengine/userscript/userscript.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_SHARED_H_
#define QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "qtwebengine/userscript/userscript.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace qtwebengine {
namespace mojom {
class UserScriptDataDataView;



}  // namespace mojom
}  // namespace qtwebengine

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::qtwebengine::mojom::UserScriptDataDataView> {
  using Data = ::qtwebengine::mojom::internal::UserScriptData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace qtwebengine {
namespace mojom {


enum class InjectionPoint : int32_t {
  
  AfterLoad = 0,
  
  DocumentLoadFinished = 1,
  
  DocumentElementCreation = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, InjectionPoint value);
inline bool IsKnownEnumValue(InjectionPoint value) {
  return internal::InjectionPoint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class UserResourceControllerRenderFrameInterfaceBase {};

using UserResourceControllerRenderFramePtrDataView =
    mojo::InterfacePtrDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameRequestDataView =
    mojo::InterfaceRequestDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UserResourceControllerRenderFrameInterfaceBase>;
class UserResourceControllerInterfaceBase {};

using UserResourceControllerPtrDataView =
    mojo::InterfacePtrDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerRequestDataView =
    mojo::InterfaceRequestDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UserResourceControllerInterfaceBase>;


class UserScriptDataDataView {
 public:
  UserScriptDataDataView() {}

  UserScriptDataDataView(
      internal::UserScriptData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSource(UserType* output) {
    
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  uint8_t injectionPoint() const {
    return data_->injectionPoint;
  }
  bool injectForSubframes() const {
    return data_->injectForSubframes;
  }
  uint8_t worldId() const {
    return data_->worldId;
  }
  uint64_t scriptId() const {
    return data_->scriptId;
  }
  inline void GetGlobsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGlobs(UserType* output) {
    
    auto* pointer = data_->globs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetExcludeGlobsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExcludeGlobs(UserType* output) {
    
    auto* pointer = data_->excludeGlobs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetUrlPatternsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrlPatterns(UserType* output) {
    
    auto* pointer = data_->urlPatterns.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
 private:
  internal::UserScriptData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace qtwebengine

namespace std {

template <>
struct hash<::qtwebengine::mojom::InjectionPoint>
    : public mojo::internal::EnumHashImpl<::qtwebengine::mojom::InjectionPoint> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::qtwebengine::mojom::InjectionPoint, ::qtwebengine::mojom::InjectionPoint> {
  static ::qtwebengine::mojom::InjectionPoint ToMojom(::qtwebengine::mojom::InjectionPoint input) { return input; }
  static bool FromMojom(::qtwebengine::mojom::InjectionPoint input, ::qtwebengine::mojom::InjectionPoint* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::qtwebengine::mojom::InjectionPoint, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::qtwebengine::mojom::InjectionPoint, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::qtwebengine::mojom::InjectionPoint>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::qtwebengine::mojom::UserScriptDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::qtwebengine::mojom::UserScriptDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::qtwebengine::mojom::internal::UserScriptData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::source(input)) in_source = Traits::source(input);
    typename decltype((*output)->source)::BaseType::BufferWriter
        source_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_source, buffer, &source_writer, context);
    (*output)->source.Set(
        source_writer.is_null() ? nullptr : source_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->source.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source in UserScriptData struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in UserScriptData struct");
    (*output)->injectionPoint = Traits::injectionPoint(input);
    (*output)->injectForSubframes = Traits::injectForSubframes(input);
    (*output)->worldId = Traits::worldId(input);
    (*output)->scriptId = Traits::scriptId(input);
    decltype(Traits::globs(input)) in_globs = Traits::globs(input);
    typename decltype((*output)->globs)::BaseType::BufferWriter
        globs_writer;
    const mojo::internal::ContainerValidateParams globs_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_globs, buffer, &globs_writer, &globs_validate_params,
        context);
    (*output)->globs.Set(
        globs_writer.is_null() ? nullptr : globs_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->globs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null globs in UserScriptData struct");
    decltype(Traits::excludeGlobs(input)) in_excludeGlobs = Traits::excludeGlobs(input);
    typename decltype((*output)->excludeGlobs)::BaseType::BufferWriter
        excludeGlobs_writer;
    const mojo::internal::ContainerValidateParams excludeGlobs_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_excludeGlobs, buffer, &excludeGlobs_writer, &excludeGlobs_validate_params,
        context);
    (*output)->excludeGlobs.Set(
        excludeGlobs_writer.is_null() ? nullptr : excludeGlobs_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->excludeGlobs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null excludeGlobs in UserScriptData struct");
    decltype(Traits::urlPatterns(input)) in_urlPatterns = Traits::urlPatterns(input);
    typename decltype((*output)->urlPatterns)::BaseType::BufferWriter
        urlPatterns_writer;
    const mojo::internal::ContainerValidateParams urlPatterns_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_urlPatterns, buffer, &urlPatterns_writer, &urlPatterns_validate_params,
        context);
    (*output)->urlPatterns.Set(
        urlPatterns_writer.is_null() ? nullptr : urlPatterns_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->urlPatterns.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null urlPatterns in UserScriptData struct");
  }

  static bool Deserialize(::qtwebengine::mojom::internal::UserScriptData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::qtwebengine::mojom::UserScriptDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace qtwebengine {
namespace mojom {

inline void UserScriptDataDataView::GetSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void UserScriptDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void UserScriptDataDataView::GetGlobsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->globs.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void UserScriptDataDataView::GetExcludeGlobsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->excludeGlobs.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void UserScriptDataDataView::GetUrlPatternsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->urlPatterns.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace qtwebengine

#endif  // QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_SHARED_H_