// services/audio/public/mojom/audio_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_SERVICE_MOJOM_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/audio/public/mojom/audio_service.mojom-shared.h"
#include "services/audio/public/mojom/audio_service.mojom-forward.h"
#include "services/audio/public/mojom/debug_recording.mojom.h"
#include "services/audio/public/mojom/device_notifications.mojom.h"
#include "services/audio/public/mojom/log_factory_manager.mojom.h"
#include "services/audio/public/mojom/stream_factory.mojom.h"
#include "services/audio/public/mojom/system_info.mojom.h"
#include "services/audio/public/mojom/testing_api.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace audio {
namespace mojom {

class AudioServiceProxy;

template <typename ImplRefTraits>
class AudioServiceStub;

class AudioServiceRequestValidator;


class  AudioService
    : public AudioServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = AudioServiceInterfaceBase;
  using Proxy_ = AudioServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioServiceStub<ImplRefTraits>;

  using RequestValidator_ = AudioServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindSystemInfoMinVersion = 0,
    kBindDebugRecordingMinVersion = 0,
    kBindStreamFactoryMinVersion = 0,
    kBindDeviceNotifierMinVersion = 0,
    kBindLogFactoryManagerMinVersion = 0,
    kBindTestingApiMinVersion = 0,
  };
  virtual ~AudioService() {}

  
  virtual void BindSystemInfo(::mojo::PendingReceiver<::audio::mojom::SystemInfo> receiver) = 0;

  
  virtual void BindDebugRecording(::mojo::PendingReceiver<::audio::mojom::DebugRecording> receiver) = 0;

  
  virtual void BindStreamFactory(::mojo::PendingReceiver<::audio::mojom::StreamFactory> receiver) = 0;

  
  virtual void BindDeviceNotifier(::mojo::PendingReceiver<::audio::mojom::DeviceNotifier> receiver) = 0;

  
  virtual void BindLogFactoryManager(::mojo::PendingReceiver<::audio::mojom::LogFactoryManager> receiver) = 0;

  
  virtual void BindTestingApi(::mojo::PendingReceiver<::audio::mojom::TestingApi> receiver) = 0;
};



class  AudioServiceProxy
    : public AudioService {
 public:
  using InterfaceType = AudioService;

  explicit AudioServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindSystemInfo(::mojo::PendingReceiver<::audio::mojom::SystemInfo> receiver) final;
  
  void BindDebugRecording(::mojo::PendingReceiver<::audio::mojom::DebugRecording> receiver) final;
  
  void BindStreamFactory(::mojo::PendingReceiver<::audio::mojom::StreamFactory> receiver) final;
  
  void BindDeviceNotifier(::mojo::PendingReceiver<::audio::mojom::DeviceNotifier> receiver) final;
  
  void BindLogFactoryManager(::mojo::PendingReceiver<::audio::mojom::LogFactoryManager> receiver) final;
  
  void BindTestingApi(::mojo::PendingReceiver<::audio::mojom::TestingApi> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AudioServiceStubDispatch {
 public:
  static bool Accept(AudioService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioService>>
class AudioServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioServiceStub() {}
  ~AudioServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace audio

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_SERVICE_MOJOM_H_