// services/content/public/mojom/navigable_contents.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_SHARED_H_
#define SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/content/public/mojom/navigable_contents.mojom-shared-internal.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace content {
namespace mojom {
class NavigateParamsDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::NavigateParamsDataView> {
  using Data = ::content::mojom::internal::NavigateParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {
// Interface base classes. They are used for type safety check.
class NavigableContentsInterfaceBase {};

using NavigableContentsPtrDataView =
    mojo::InterfacePtrDataView<NavigableContentsInterfaceBase>;
using NavigableContentsRequestDataView =
    mojo::InterfaceRequestDataView<NavigableContentsInterfaceBase>;
using NavigableContentsAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NavigableContentsInterfaceBase>;
using NavigableContentsAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NavigableContentsInterfaceBase>;
class NavigableContentsClientInterfaceBase {};

using NavigableContentsClientPtrDataView =
    mojo::InterfacePtrDataView<NavigableContentsClientInterfaceBase>;
using NavigableContentsClientRequestDataView =
    mojo::InterfaceRequestDataView<NavigableContentsClientInterfaceBase>;
using NavigableContentsClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NavigableContentsClientInterfaceBase>;
using NavigableContentsClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NavigableContentsClientInterfaceBase>;


class NavigateParamsDataView {
 public:
  NavigateParamsDataView() {}

  NavigateParamsDataView(
      internal::NavigateParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool should_clear_session_history() const {
    return data_->should_clear_session_history;
  }
 private:
  internal::NavigateParams_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::NavigateParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::NavigateParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::NavigateParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->should_clear_session_history = Traits::should_clear_session_history(input);
  }

  static bool Deserialize(::content::mojom::internal::NavigateParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::NavigateParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {




}  // namespace mojom
}  // namespace content

#endif  // SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_SHARED_H_