// services/content/public/mojom/navigable_contents.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_H_
#define SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/content/public/mojom/navigable_contents.mojom-shared.h"
#include "services/content/public/mojom/navigable_contents.mojom-forward.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class NavigableContentsProxy;

template <typename ImplRefTraits>
class NavigableContentsStub;

class NavigableContentsRequestValidator;
class NavigableContentsResponseValidator;


class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContents
    : public NavigableContentsInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NavigableContentsInterfaceBase;
  using Proxy_ = NavigableContentsProxy;

  template <typename ImplRefTraits>
  using Stub_ = NavigableContentsStub<ImplRefTraits>;

  using RequestValidator_ = NavigableContentsRequestValidator;
  using ResponseValidator_ = NavigableContentsResponseValidator;
  enum MethodMinVersions : uint32_t {
    kNavigateMinVersion = 0,
    kGoBackMinVersion = 0,
    kCreateViewMinVersion = 0,
    kFocusMinVersion = 0,
    kFocusThroughTabTraversalMinVersion = 0,
  };
  virtual ~NavigableContents() {}

  
  virtual void Navigate(const ::GURL& url, NavigateParamsPtr params) = 0;


  using GoBackCallback = base::OnceCallback<void(bool)>;
  
  virtual void GoBack(GoBackCallback callback) = 0;


  using CreateViewCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;
  
  virtual void CreateView(CreateViewCallback callback) = 0;

  
  virtual void Focus() = 0;

  
  virtual void FocusThroughTabTraversal(bool reverse) = 0;
};

class NavigableContentsClientProxy;

template <typename ImplRefTraits>
class NavigableContentsClientStub;

class NavigableContentsClientRequestValidator;


class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsClient
    : public NavigableContentsClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NavigableContentsClientInterfaceBase;
  using Proxy_ = NavigableContentsClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NavigableContentsClientStub<ImplRefTraits>;

  using RequestValidator_ = NavigableContentsClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kClearViewFocusMinVersion = 0,
    kDidFinishNavigationMinVersion = 0,
    kDidStopLoadingMinVersion = 0,
    kDidAutoResizeViewMinVersion = 0,
    kDidSuppressNavigationMinVersion = 0,
    kUpdateCanGoBackMinVersion = 0,
    kUpdateContentAXTreeMinVersion = 0,
    kFocusedNodeChangedMinVersion = 0,
  };
  virtual ~NavigableContentsClient() {}

  
  virtual void ClearViewFocus() = 0;

  
  virtual void DidFinishNavigation(const ::GURL& url, bool is_main_frame, bool is_error_page, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers) = 0;

  
  virtual void DidStopLoading() = 0;

  
  virtual void DidAutoResizeView(const ::gfx::Size& new_size) = 0;

  
  virtual void DidSuppressNavigation(const ::GURL& url, ::WindowOpenDisposition disposition, bool from_user_gesture) = 0;

  
  virtual void UpdateCanGoBack(bool can_go_back) = 0;

  
  virtual void UpdateContentAXTree(const ::ui::AXTreeID& id) = 0;

  
  virtual void FocusedNodeChanged(bool is_editable_node, const ::gfx::Rect& node_bounds_in_screen) = 0;
};



class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsProxy
    : public NavigableContents {
 public:
  using InterfaceType = NavigableContents;

  explicit NavigableContentsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Navigate(const ::GURL& url, NavigateParamsPtr params) final;
  
  void GoBack(GoBackCallback callback) final;
  
  void CreateView(CreateViewCallback callback) final;
  
  void Focus() final;
  
  void FocusThroughTabTraversal(bool reverse) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsClientProxy
    : public NavigableContentsClient {
 public:
  using InterfaceType = NavigableContentsClient;

  explicit NavigableContentsClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ClearViewFocus() final;
  
  void DidFinishNavigation(const ::GURL& url, bool is_main_frame, bool is_error_page, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers) final;
  
  void DidStopLoading() final;
  
  void DidAutoResizeView(const ::gfx::Size& new_size) final;
  
  void DidSuppressNavigation(const ::GURL& url, ::WindowOpenDisposition disposition, bool from_user_gesture) final;
  
  void UpdateCanGoBack(bool can_go_back) final;
  
  void UpdateContentAXTree(const ::ui::AXTreeID& id) final;
  
  void FocusedNodeChanged(bool is_editable_node, const ::gfx::Rect& node_bounds_in_screen) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsStubDispatch {
 public:
  static bool Accept(NavigableContents* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NavigableContents* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NavigableContents>>
class NavigableContentsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NavigableContentsStub() {}
  ~NavigableContentsStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigableContentsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigableContentsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsClientStubDispatch {
 public:
  static bool Accept(NavigableContentsClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NavigableContentsClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NavigableContentsClient>>
class NavigableContentsClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NavigableContentsClientStub() {}
  ~NavigableContentsClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigableContentsClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigableContentsClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigateParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigateParams, T>::value>;
  using DataView = NavigateParamsDataView;
  using Data_ = internal::NavigateParams_Data;

  template <typename... Args>
  static NavigateParamsPtr New(Args&&... args) {
    return NavigateParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigateParamsPtr From(const U& u) {
    return mojo::TypeConverter<NavigateParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigateParams>::Convert(*this);
  }


  NavigateParams();

  explicit NavigateParams(
      bool should_clear_session_history);

  ~NavigateParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigateParamsPtr>
  NavigateParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigateParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigateParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigateParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigateParams_UnserializedMessageContext<
            UserType, NavigateParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NavigateParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NavigateParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigateParams_UnserializedMessageContext<
            UserType, NavigateParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigateParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool should_clear_session_history;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigateParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigateParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigateParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigateParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
NavigateParamsPtr NavigateParams::Clone() const {
  return New(
      mojo::Clone(should_clear_session_history)
  );
}

template <typename T, NavigateParams::EnableIfSame<T>*>
bool NavigateParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->should_clear_session_history, other_struct.should_clear_session_history))
    return false;
  return true;
}

template <typename T, NavigateParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.should_clear_session_history, rhs.should_clear_session_history))
    return true;
  if (std::less<>{}(rhs.should_clear_session_history, lhs.should_clear_session_history))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) StructTraits<::content::mojom::NavigateParams::DataView,
                                         ::content::mojom::NavigateParamsPtr> {
  static bool IsNull(const ::content::mojom::NavigateParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::NavigateParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::NavigateParams::should_clear_session_history) should_clear_session_history(
      const ::content::mojom::NavigateParamsPtr& input) {
    return input->should_clear_session_history;
  }

  static bool Read(::content::mojom::NavigateParams::DataView input, ::content::mojom::NavigateParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_H_