// services/network/public/mojom/cert_verifier_service.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared-internal.h"
#include "services/network/public/mojom/network_param.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace cert_verifier {
namespace mojom {
namespace internal {
class RequestParams_Data;
class CertVerifierConfig_Data;

#pragma pack(push, 1)
class  RequestParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RequestParams_Data));
      new (data()) RequestParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RequestParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RequestParams_Data>(index_);
    }
    RequestParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::X509Certificate_Data> certificate;
  mojo::internal::Pointer<mojo::internal::String_Data> hostname;
  int32_t flags;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> ocsp_response;
  mojo::internal::Pointer<mojo::internal::String_Data> sct_list;

 private:
  RequestParams_Data();
  ~RequestParams_Data() = delete;
};
static_assert(sizeof(RequestParams_Data) == 48,
              "Bad sizeof(RequestParams_Data)");
// Used by RequestParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RequestParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RequestParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RequestParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    RequestParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RequestParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CertVerifierConfig_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CertVerifierConfig_Data));
      new (data()) CertVerifierConfig_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CertVerifierConfig_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CertVerifierConfig_Data>(index_);
    }
    CertVerifierConfig_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enable_rev_checking : 1;
  uint8_t require_rev_checking_local_anchors : 1;
  uint8_t enable_sha1_local_anchors : 1;
  uint8_t disable_symantec_enforcement : 1;
  uint8_t pad3_[7];
  ::mojo_base::mojom::internal::BigBuffer_Data crl_set;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::X509Certificate_Data>>> additional_trust_anchors;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::X509Certificate_Data>>> additional_untrusted_authorities;

 private:
  CertVerifierConfig_Data();
  ~CertVerifierConfig_Data() = delete;
};
static_assert(sizeof(CertVerifierConfig_Data) == 48,
              "Bad sizeof(CertVerifierConfig_Data)");
// Used by CertVerifierConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CertVerifierConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CertVerifierConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CertVerifierConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CertVerifierConfig_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CertVerifierConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace cert_verifier

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_INTERNAL_H_