// services/network/public/mojom/content_security_policy.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/content_security_policy.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/content_security_policy.mojom-params-data.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/content_security_policy.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
ContentSecurityPolicyHeader::ContentSecurityPolicyHeader()
    : header_value(),
      type(ContentSecurityPolicyType::kEnforce),
      source(ContentSecurityPolicySource::kHTTP) {}

ContentSecurityPolicyHeader::ContentSecurityPolicyHeader(
    const WTF::String& header_value_in,
    ContentSecurityPolicyType type_in,
    ContentSecurityPolicySource source_in)
    : header_value(std::move(header_value_in)),
      type(std::move(type_in)),
      source(std::move(source_in)) {}

ContentSecurityPolicyHeader::~ContentSecurityPolicyHeader() = default;
size_t ContentSecurityPolicyHeader::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->header_value);
  seed = mojo::internal::WTFHash(seed, this->type);
  seed = mojo::internal::WTFHash(seed, this->source);
  return seed;
}

void ContentSecurityPolicyHeader::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("header_value", this->header_value.Utf8());
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetString("source", base::trace_event::ValueToString(this->source));
}

bool ContentSecurityPolicyHeader::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPSource::CSPSource()
    : scheme(),
      host(),
      port(-1),
      path(),
      is_host_wildcard(false),
      is_port_wildcard(false) {}

CSPSource::CSPSource(
    const WTF::String& scheme_in,
    const WTF::String& host_in,
    int32_t port_in,
    const WTF::String& path_in,
    bool is_host_wildcard_in,
    bool is_port_wildcard_in)
    : scheme(std::move(scheme_in)),
      host(std::move(host_in)),
      port(std::move(port_in)),
      path(std::move(path_in)),
      is_host_wildcard(std::move(is_host_wildcard_in)),
      is_port_wildcard(std::move(is_port_wildcard_in)) {}

CSPSource::~CSPSource() = default;
size_t CSPSource::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->scheme);
  seed = mojo::internal::WTFHash(seed, this->host);
  seed = mojo::internal::WTFHash(seed, this->port);
  seed = mojo::internal::WTFHash(seed, this->path);
  seed = mojo::internal::WTFHash(seed, this->is_host_wildcard);
  seed = mojo::internal::WTFHash(seed, this->is_port_wildcard);
  return seed;
}

void CSPSource::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("scheme", this->scheme.Utf8());
  value->SetString("host", this->host.Utf8());
  value->SetInteger("port", this->port);
  value->SetString("path", this->path.Utf8());
  value->SetBoolean("is_host_wildcard", this->is_host_wildcard);
  value->SetBoolean("is_port_wildcard", this->is_port_wildcard);
}

bool CSPSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPHashSource::CSPHashSource()
    : algorithm(),
      value() {}

CSPHashSource::CSPHashSource(
    CSPHashAlgorithm algorithm_in,
    const WTF::String& value_in)
    : algorithm(std::move(algorithm_in)),
      value(std::move(value_in)) {}

CSPHashSource::~CSPHashSource() = default;
size_t CSPHashSource::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->algorithm);
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void CSPHashSource::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("algorithm", base::trace_event::ValueToString(this->algorithm));
  value->SetString("value", this->value.Utf8());
}

bool CSPHashSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPSourceList::CSPSourceList()
    : sources(),
      nonces(),
      hashes(),
      allow_self(false),
      allow_star(false),
      allow_response_redirects(false),
      allow_inline(false),
      allow_eval(false),
      allow_wasm_eval(false),
      allow_dynamic(false),
      allow_unsafe_hashes(false),
      report_sample(false) {}

CSPSourceList::CSPSourceList(
    WTF::Vector<CSPSourcePtr> sources_in,
    WTF::Vector<WTF::String> nonces_in,
    WTF::Vector<CSPHashSourcePtr> hashes_in,
    bool allow_self_in,
    bool allow_star_in,
    bool allow_response_redirects_in,
    bool allow_inline_in,
    bool allow_eval_in,
    bool allow_wasm_eval_in,
    bool allow_dynamic_in,
    bool allow_unsafe_hashes_in,
    bool report_sample_in)
    : sources(std::move(sources_in)),
      nonces(std::move(nonces_in)),
      hashes(std::move(hashes_in)),
      allow_self(std::move(allow_self_in)),
      allow_star(std::move(allow_star_in)),
      allow_response_redirects(std::move(allow_response_redirects_in)),
      allow_inline(std::move(allow_inline_in)),
      allow_eval(std::move(allow_eval_in)),
      allow_wasm_eval(std::move(allow_wasm_eval_in)),
      allow_dynamic(std::move(allow_dynamic_in)),
      allow_unsafe_hashes(std::move(allow_unsafe_hashes_in)),
      report_sample(std::move(report_sample_in)) {}

CSPSourceList::~CSPSourceList() = default;

void CSPSourceList::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("sources");
  for (const auto& item0 : this->sources) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->BeginArray("nonces");
  for (const auto& item0 : this->nonces) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
  value->BeginArray("hashes");
  for (const auto& item0 : this->hashes) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetBoolean("allow_self", this->allow_self);
  value->SetBoolean("allow_star", this->allow_star);
  value->SetBoolean("allow_response_redirects", this->allow_response_redirects);
  value->SetBoolean("allow_inline", this->allow_inline);
  value->SetBoolean("allow_eval", this->allow_eval);
  value->SetBoolean("allow_wasm_eval", this->allow_wasm_eval);
  value->SetBoolean("allow_dynamic", this->allow_dynamic);
  value->SetBoolean("allow_unsafe_hashes", this->allow_unsafe_hashes);
  value->SetBoolean("report_sample", this->report_sample);
}

bool CSPSourceList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentSecurityPolicy::ContentSecurityPolicy()
    : directives(),
      upgrade_insecure_requests(false),
      treat_as_public_address(false),
      sandbox(::network::mojom::blink::WebSandboxFlags::kAll),
      header(),
      use_reporting_api(false),
      report_endpoints(),
      plugin_types(),
      parsing_errors() {}

ContentSecurityPolicy::ContentSecurityPolicy(
    WTF::HashMap<CSPDirectiveName, CSPSourceListPtr> directives_in,
    bool upgrade_insecure_requests_in,
    bool treat_as_public_address_in,
    ::network::mojom::blink::WebSandboxFlags sandbox_in,
    ContentSecurityPolicyHeaderPtr header_in,
    bool use_reporting_api_in,
    WTF::Vector<WTF::String> report_endpoints_in,
    base::Optional<WTF::Vector<WTF::String>> plugin_types_in,
    WTF::Vector<WTF::String> parsing_errors_in)
    : directives(std::move(directives_in)),
      upgrade_insecure_requests(std::move(upgrade_insecure_requests_in)),
      treat_as_public_address(std::move(treat_as_public_address_in)),
      sandbox(std::move(sandbox_in)),
      header(std::move(header_in)),
      use_reporting_api(std::move(use_reporting_api_in)),
      report_endpoints(std::move(report_endpoints_in)),
      plugin_types(std::move(plugin_types_in)),
      parsing_errors(std::move(parsing_errors_in)) {}

ContentSecurityPolicy::~ContentSecurityPolicy() = default;

void ContentSecurityPolicy::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginDictionary("directives");
  for (const auto& item0 : this->directives) {
    if (item0.value.is_null()) {
      value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type CSPDirectiveName>"), "nullptr");
    } else {
      value->BeginDictionaryWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type CSPDirectiveName>"));
      item0.value->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndDictionary();
  value->SetBoolean("upgrade_insecure_requests", this->upgrade_insecure_requests);
  value->SetBoolean("treat_as_public_address", this->treat_as_public_address);
  value->SetString("sandbox", base::trace_event::ValueToString(this->sandbox));
  if (this->header.is_null()) {
    value->SetString("header", "nullptr");
  } else {
    value->BeginDictionary("header");
    this->header->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("use_reporting_api", this->use_reporting_api);
  value->BeginArray("report_endpoints");
  for (const auto& item0 : this->report_endpoints) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
  if (this->plugin_types.has_value()) {
    value->BeginArray("plugin_types");
    for (const auto& item0 : this->plugin_types.value()) {
      value->AppendString(item0.Utf8());
    }
    value->EndArray();
  } else {
    value->SetString("plugin_types", "base::nullopt");
  }
  value->BeginArray("parsing_errors");
  for (const auto& item0 : this->parsing_errors) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
}

bool ContentSecurityPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPViolation::CSPViolation()
    : directive(),
      effective_directive(),
      console_message(),
      blocked_url(),
      report_endpoints(),
      use_reporting_api(),
      header(),
      type(),
      after_redirect(),
      source_location() {}

CSPViolation::CSPViolation(
    const WTF::String& directive_in,
    const WTF::String& effective_directive_in,
    const WTF::String& console_message_in,
    const ::blink::KURL& blocked_url_in,
    WTF::Vector<WTF::String> report_endpoints_in,
    bool use_reporting_api_in,
    const WTF::String& header_in,
    ContentSecurityPolicyType type_in,
    bool after_redirect_in,
    ::network::mojom::blink::SourceLocationPtr source_location_in)
    : directive(std::move(directive_in)),
      effective_directive(std::move(effective_directive_in)),
      console_message(std::move(console_message_in)),
      blocked_url(std::move(blocked_url_in)),
      report_endpoints(std::move(report_endpoints_in)),
      use_reporting_api(std::move(use_reporting_api_in)),
      header(std::move(header_in)),
      type(std::move(type_in)),
      after_redirect(std::move(after_redirect_in)),
      source_location(std::move(source_location_in)) {}

CSPViolation::~CSPViolation() = default;

void CSPViolation::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("directive", this->directive.Utf8());
  value->SetString("effective_directive", this->effective_directive.Utf8());
  value->SetString("console_message", this->console_message.Utf8());
  value->SetString("blocked_url", base::trace_event::ValueToString(this->blocked_url, "<value of type const ::blink::KURL&>"));
  value->BeginArray("report_endpoints");
  for (const auto& item0 : this->report_endpoints) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
  value->SetBoolean("use_reporting_api", this->use_reporting_api);
  value->SetString("header", this->header.Utf8());
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetBoolean("after_redirect", this->after_redirect);
  if (this->source_location.is_null()) {
    value->SetString("source_location", "nullptr");
  } else {
    value->BeginDictionary("source_location");
    this->source_location->AsValueInto(value);
    value->EndDictionary();
  }
}

bool CSPViolation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AllowCSPFromHeaderValue::AllowCSPFromHeaderValue() : tag_(Tag::ALLOW_STAR) {
  data_.allow_star = bool();
}

AllowCSPFromHeaderValue::~AllowCSPFromHeaderValue() {
  DestroyActive();
}


void AllowCSPFromHeaderValue::set_allow_star(
    bool allow_star) {
  if (tag_ != Tag::ALLOW_STAR) {
    DestroyActive();
    tag_ = Tag::ALLOW_STAR;
  }
  data_.allow_star = allow_star;
}
void AllowCSPFromHeaderValue::set_origin(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin) {
  if (tag_ == Tag::ORIGIN) {
    *(data_.origin) = std::move(origin);
  } else {
    DestroyActive();
    tag_ = Tag::ORIGIN;
    data_.origin = new ::scoped_refptr<const ::blink::SecurityOrigin>(
        std::move(origin));
  }
}
void AllowCSPFromHeaderValue::set_error_message(
    const WTF::String& error_message) {
  if (tag_ == Tag::ERROR_MESSAGE) {
    *(data_.error_message) = std::move(error_message);
  } else {
    DestroyActive();
    tag_ = Tag::ERROR_MESSAGE;
    data_.error_message = new WTF::String(
        std::move(error_message));
  }
}

void AllowCSPFromHeaderValue::DestroyActive() {
  switch (tag_) {

    case Tag::ALLOW_STAR:

      break;
    case Tag::ORIGIN:

      delete data_.origin;
      break;
    case Tag::ERROR_MESSAGE:

      delete data_.error_message;
      break;
  }
}

bool AllowCSPFromHeaderValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ContentSecurityPolicyHeader::DataView, ::network::mojom::blink::ContentSecurityPolicyHeaderPtr>::Read(
    ::network::mojom::blink::ContentSecurityPolicyHeader::DataView input,
    ::network::mojom::blink::ContentSecurityPolicyHeaderPtr* output) {
  bool success = true;
  ::network::mojom::blink::ContentSecurityPolicyHeaderPtr result(::network::mojom::blink::ContentSecurityPolicyHeader::New());
  
      if (success && !input.ReadHeaderValue(&result->header_value))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPSource::DataView, ::network::mojom::blink::CSPSourcePtr>::Read(
    ::network::mojom::blink::CSPSource::DataView input,
    ::network::mojom::blink::CSPSourcePtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPSourcePtr result(::network::mojom::blink::CSPSource::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->is_host_wildcard = input.is_host_wildcard();
      if (success)
        result->is_port_wildcard = input.is_port_wildcard();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPHashSource::DataView, ::network::mojom::blink::CSPHashSourcePtr>::Read(
    ::network::mojom::blink::CSPHashSource::DataView input,
    ::network::mojom::blink::CSPHashSourcePtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPHashSourcePtr result(::network::mojom::blink::CSPHashSource::New());
  
      if (success && !input.ReadAlgorithm(&result->algorithm))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPSourceList::DataView, ::network::mojom::blink::CSPSourceListPtr>::Read(
    ::network::mojom::blink::CSPSourceList::DataView input,
    ::network::mojom::blink::CSPSourceListPtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPSourceListPtr result(::network::mojom::blink::CSPSourceList::New());
  
      if (success && !input.ReadSources(&result->sources))
        success = false;
      if (success && !input.ReadNonces(&result->nonces))
        success = false;
      if (success && !input.ReadHashes(&result->hashes))
        success = false;
      if (success)
        result->allow_self = input.allow_self();
      if (success)
        result->allow_star = input.allow_star();
      if (success)
        result->allow_response_redirects = input.allow_response_redirects();
      if (success)
        result->allow_inline = input.allow_inline();
      if (success)
        result->allow_eval = input.allow_eval();
      if (success)
        result->allow_wasm_eval = input.allow_wasm_eval();
      if (success)
        result->allow_dynamic = input.allow_dynamic();
      if (success)
        result->allow_unsafe_hashes = input.allow_unsafe_hashes();
      if (success)
        result->report_sample = input.report_sample();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ContentSecurityPolicy::DataView, ::network::mojom::blink::ContentSecurityPolicyPtr>::Read(
    ::network::mojom::blink::ContentSecurityPolicy::DataView input,
    ::network::mojom::blink::ContentSecurityPolicyPtr* output) {
  bool success = true;
  ::network::mojom::blink::ContentSecurityPolicyPtr result(::network::mojom::blink::ContentSecurityPolicy::New());
  
      if (success && !input.ReadDirectives(&result->directives))
        success = false;
      if (success)
        result->upgrade_insecure_requests = input.upgrade_insecure_requests();
      if (success)
        result->treat_as_public_address = input.treat_as_public_address();
      if (success && !input.ReadSandbox(&result->sandbox))
        success = false;
      if (success && !input.ReadHeader(&result->header))
        success = false;
      if (success)
        result->use_reporting_api = input.use_reporting_api();
      if (success && !input.ReadReportEndpoints(&result->report_endpoints))
        success = false;
      if (success && !input.ReadPluginTypes(&result->plugin_types))
        success = false;
      if (success && !input.ReadParsingErrors(&result->parsing_errors))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPViolation::DataView, ::network::mojom::blink::CSPViolationPtr>::Read(
    ::network::mojom::blink::CSPViolation::DataView input,
    ::network::mojom::blink::CSPViolationPtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPViolationPtr result(::network::mojom::blink::CSPViolation::New());
  
      if (success && !input.ReadDirective(&result->directive))
        success = false;
      if (success && !input.ReadEffectiveDirective(&result->effective_directive))
        success = false;
      if (success && !input.ReadConsoleMessage(&result->console_message))
        success = false;
      if (success && !input.ReadBlockedUrl(&result->blocked_url))
        success = false;
      if (success && !input.ReadReportEndpoints(&result->report_endpoints))
        success = false;
      if (success)
        result->use_reporting_api = input.use_reporting_api();
      if (success && !input.ReadHeader(&result->header))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->after_redirect = input.after_redirect();
      if (success && !input.ReadSourceLocation(&result->source_location))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::AllowCSPFromHeaderValue::DataView, ::network::mojom::blink::AllowCSPFromHeaderValuePtr>::Read(
    ::network::mojom::blink::AllowCSPFromHeaderValue::DataView input,
    ::network::mojom::blink::AllowCSPFromHeaderValuePtr* output) {
  using UnionType = ::network::mojom::blink::AllowCSPFromHeaderValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ALLOW_STAR: {
      *output = UnionType::NewAllowStar(input.allow_star());
      break;
    }
    case Tag::ORIGIN: {
      ::scoped_refptr<const ::blink::SecurityOrigin> result_origin;
      if (!input.ReadOrigin(&result_origin))
        return false;

      *output = UnionType::NewOrigin(
          std::move(result_origin));
      break;
    }
    case Tag::ERROR_MESSAGE: {
      WTF::String result_error_message;
      if (!input.ReadErrorMessage(&result_error_message))
        return false;

      *output = UnionType::NewErrorMessage(
          std::move(result_error_message));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif