// services/network/public/mojom/content_security_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/content_security_policy.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/content_security_policy.mojom-params-data.h"
namespace network {
namespace mojom {

std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyType value) {
  switch(value) {
    case ContentSecurityPolicyType::kReport:
      return os << "ContentSecurityPolicyType::kReport";
    case ContentSecurityPolicyType::kEnforce:
      return os << "ContentSecurityPolicyType::kEnforce";
    default:
      return os << "Unknown ContentSecurityPolicyType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, ContentSecurityPolicySource value) {
  switch(value) {
    case ContentSecurityPolicySource::kHTTP:
      return os << "ContentSecurityPolicySource::kHTTP";
    case ContentSecurityPolicySource::kMeta:
      return os << "ContentSecurityPolicySource::kMeta";
    case ContentSecurityPolicySource::kOriginPolicy:
      return os << "ContentSecurityPolicySource::kOriginPolicy";
    default:
      return os << "Unknown ContentSecurityPolicySource value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, CSPDisposition value) {
  switch(value) {
    case CSPDisposition::CHECK:
      return os << "CSPDisposition::CHECK";
    case CSPDisposition::DO_NOT_CHECK:
      return os << "CSPDisposition::DO_NOT_CHECK";
    default:
      return os << "Unknown CSPDisposition value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, CSPHashAlgorithm value) {
  switch(value) {
    case CSPHashAlgorithm::SHA256:
      return os << "CSPHashAlgorithm::SHA256";
    case CSPHashAlgorithm::SHA384:
      return os << "CSPHashAlgorithm::SHA384";
    case CSPHashAlgorithm::SHA512:
      return os << "CSPHashAlgorithm::SHA512";
    default:
      return os << "Unknown CSPHashAlgorithm value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, CSPDirectiveName value) {
  switch(value) {
    case CSPDirectiveName::Unknown:
      return os << "CSPDirectiveName::Unknown";
    case CSPDirectiveName::BaseURI:
      return os << "CSPDirectiveName::BaseURI";
    case CSPDirectiveName::BlockAllMixedContent:
      return os << "CSPDirectiveName::BlockAllMixedContent";
    case CSPDirectiveName::ChildSrc:
      return os << "CSPDirectiveName::ChildSrc";
    case CSPDirectiveName::ConnectSrc:
      return os << "CSPDirectiveName::ConnectSrc";
    case CSPDirectiveName::DefaultSrc:
      return os << "CSPDirectiveName::DefaultSrc";
    case CSPDirectiveName::FontSrc:
      return os << "CSPDirectiveName::FontSrc";
    case CSPDirectiveName::FormAction:
      return os << "CSPDirectiveName::FormAction";
    case CSPDirectiveName::FrameAncestors:
      return os << "CSPDirectiveName::FrameAncestors";
    case CSPDirectiveName::FrameSrc:
      return os << "CSPDirectiveName::FrameSrc";
    case CSPDirectiveName::ImgSrc:
      return os << "CSPDirectiveName::ImgSrc";
    case CSPDirectiveName::ManifestSrc:
      return os << "CSPDirectiveName::ManifestSrc";
    case CSPDirectiveName::MediaSrc:
      return os << "CSPDirectiveName::MediaSrc";
    case CSPDirectiveName::NavigateTo:
      return os << "CSPDirectiveName::NavigateTo";
    case CSPDirectiveName::ObjectSrc:
      return os << "CSPDirectiveName::ObjectSrc";
    case CSPDirectiveName::PluginTypes:
      return os << "CSPDirectiveName::PluginTypes";
    case CSPDirectiveName::PrefetchSrc:
      return os << "CSPDirectiveName::PrefetchSrc";
    case CSPDirectiveName::ReportTo:
      return os << "CSPDirectiveName::ReportTo";
    case CSPDirectiveName::ReportURI:
      return os << "CSPDirectiveName::ReportURI";
    case CSPDirectiveName::RequireTrustedTypesFor:
      return os << "CSPDirectiveName::RequireTrustedTypesFor";
    case CSPDirectiveName::Sandbox:
      return os << "CSPDirectiveName::Sandbox";
    case CSPDirectiveName::ScriptSrc:
      return os << "CSPDirectiveName::ScriptSrc";
    case CSPDirectiveName::ScriptSrcAttr:
      return os << "CSPDirectiveName::ScriptSrcAttr";
    case CSPDirectiveName::ScriptSrcElem:
      return os << "CSPDirectiveName::ScriptSrcElem";
    case CSPDirectiveName::StyleSrc:
      return os << "CSPDirectiveName::StyleSrc";
    case CSPDirectiveName::StyleSrcAttr:
      return os << "CSPDirectiveName::StyleSrcAttr";
    case CSPDirectiveName::StyleSrcElem:
      return os << "CSPDirectiveName::StyleSrcElem";
    case CSPDirectiveName::TreatAsPublicAddress:
      return os << "CSPDirectiveName::TreatAsPublicAddress";
    case CSPDirectiveName::TrustedTypes:
      return os << "CSPDirectiveName::TrustedTypes";
    case CSPDirectiveName::UpgradeInsecureRequests:
      return os << "CSPDirectiveName::UpgradeInsecureRequests";
    case CSPDirectiveName::WorkerSrc:
      return os << "CSPDirectiveName::WorkerSrc";
    default:
      return os << "Unknown CSPDirectiveName value: " << static_cast<int32_t>(value);
  }
}

namespace internal {
// static
bool AllowCSPFromHeaderValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AllowCSPFromHeaderValue_Data* object = static_cast<const AllowCSPFromHeaderValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AllowCSPFromHeaderValue_Tag::ALLOW_STAR: {

      return true;
    }
    case AllowCSPFromHeaderValue_Tag::ORIGIN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_origin, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_origin, validation_context))
        return false;
      return true;
    }
    case AllowCSPFromHeaderValue_Tag::ERROR_MESSAGE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_message, 3, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams error_message_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_error_message, validation_context,
                                             &error_message_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AllowCSPFromHeaderValue");
      return false;
    }
  }
}


// static
bool ContentSecurityPolicyHeader_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ContentSecurityPolicyHeader_Data* object = static_cast<const ContentSecurityPolicyHeader_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header_value, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams header_value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->header_value, validation_context,
                                         &header_value_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::ContentSecurityPolicyType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::network::mojom::internal::ContentSecurityPolicySource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

ContentSecurityPolicyHeader_Data::ContentSecurityPolicyHeader_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPSource_Data* object = static_cast<const CSPSource_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams scheme_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  return true;
}

CSPSource_Data::CSPSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPHashSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPHashSource_Data* object = static_cast<const CSPHashSource_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::network::mojom::internal::CSPHashAlgorithm_Data
        ::Validate(object->algorithm, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

CSPHashSource_Data::CSPHashSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPSourceList_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPSourceList_Data* object = static_cast<const CSPSourceList_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sources_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nonces, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams nonces_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->nonces, validation_context,
                                         &nonces_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hashes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hashes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hashes, validation_context,
                                         &hashes_validate_params)) {
    return false;
  }

  return true;
}

CSPSourceList_Data::CSPSourceList_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSecurityPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ContentSecurityPolicy_Data* object = static_cast<const ContentSecurityPolicy_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 56 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->directives, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams directives_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::network::mojom::internal::CSPDirectiveName_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->directives, validation_context,
                                         &directives_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::WebSandboxFlags_Data
        ::Validate(object->sandbox, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->header, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_endpoints, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams report_endpoints_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->report_endpoints, validation_context,
                                         &report_endpoints_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams plugin_types_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->plugin_types, validation_context,
                                         &plugin_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parsing_errors, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams parsing_errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->parsing_errors, validation_context,
                                         &parsing_errors_validate_params)) {
    return false;
  }

  return true;
}

ContentSecurityPolicy_Data::ContentSecurityPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPViolation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPViolation_Data* object = static_cast<const CSPViolation_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 72 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->directive, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams directive_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->directive, validation_context,
                                         &directive_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->effective_directive, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams effective_directive_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->effective_directive, validation_context,
                                         &effective_directive_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->console_message, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams console_message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->console_message, validation_context,
                                         &console_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blocked_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_endpoints, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams report_endpoints_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->report_endpoints, validation_context,
                                         &report_endpoints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams header_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->header, validation_context,
                                         &header_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::ContentSecurityPolicyType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  return true;
}

CSPViolation_Data::CSPViolation_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network