// services/network/public/mojom/cookie_access_observer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class CookieAccessObserverProxy;

template <typename ImplRefTraits>
class CookieAccessObserverStub;

class CookieAccessObserverRequestValidator;


class  CookieAccessObserver
    : public CookieAccessObserverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CookieAccessObserverInterfaceBase;
  using Proxy_ = CookieAccessObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = CookieAccessObserverStub<ImplRefTraits>;

  using RequestValidator_ = CookieAccessObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCookiesAccessedMinVersion = 0,
    kCloneMinVersion = 0,
  };
  virtual ~CookieAccessObserver() {}

  
  virtual void OnCookiesAccessed(CookieAccessDetailsPtr details) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<CookieAccessObserver> listener) = 0;
};



class  CookieAccessObserverProxy
    : public CookieAccessObserver {
 public:
  using InterfaceType = CookieAccessObserver;

  explicit CookieAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCookiesAccessed(CookieAccessDetailsPtr details) final;
  
  void Clone(::mojo::PendingReceiver<CookieAccessObserver> listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CookieAccessObserverStubDispatch {
 public:
  static bool Accept(CookieAccessObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CookieAccessObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CookieAccessObserver>>
class CookieAccessObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CookieAccessObserverStub() {}
  ~CookieAccessObserverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieAccessObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieAccessObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CookieAccessObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  CookieAccessDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieAccessDetails, T>::value>;
  using DataView = CookieAccessDetailsDataView;
  using Data_ = internal::CookieAccessDetails_Data;
  using Type = CookieAccessDetails_Type;

  template <typename... Args>
  static CookieAccessDetailsPtr New(Args&&... args) {
    return CookieAccessDetailsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieAccessDetailsPtr From(const U& u) {
    return mojo::TypeConverter<CookieAccessDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieAccessDetails>::Convert(*this);
  }


  CookieAccessDetails();

  CookieAccessDetails(
      CookieAccessDetails::Type type,
      const ::GURL& url,
      const ::net::SiteForCookies& site_for_cookies,
      std::vector<::net::CookieWithAccessResult> cookie_list,
      const base::Optional<std::string>& devtools_request_id);

  ~CookieAccessDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieAccessDetailsPtr>
  CookieAccessDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieAccessDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieAccessDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieAccessDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieAccessDetails_UnserializedMessageContext<
            UserType, CookieAccessDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieAccessDetails::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieAccessDetails::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieAccessDetails_UnserializedMessageContext<
            UserType, CookieAccessDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieAccessDetails::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  CookieAccessDetails::Type type;
  
  ::GURL url;
  
  ::net::SiteForCookies site_for_cookies;
  
  std::vector<::net::CookieWithAccessResult> cookie_list;
  
  base::Optional<std::string> devtools_request_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieAccessDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieAccessDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieAccessDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieAccessDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CookieAccessDetailsPtr CookieAccessDetails::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(url),
      mojo::Clone(site_for_cookies),
      mojo::Clone(cookie_list),
      mojo::Clone(devtools_request_id)
  );
}

template <typename T, CookieAccessDetails::EnableIfSame<T>*>
bool CookieAccessDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  if (!mojo::Equals(this->cookie_list, other_struct.cookie_list))
    return false;
  if (!mojo::Equals(this->devtools_request_id, other_struct.devtools_request_id))
    return false;
  return true;
}

template <typename T, CookieAccessDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.site_for_cookies, rhs.site_for_cookies))
    return true;
  if (std::less<>{}(rhs.site_for_cookies, lhs.site_for_cookies))
    return false;
  if (std::less<>{}(lhs.cookie_list, rhs.cookie_list))
    return true;
  if (std::less<>{}(rhs.cookie_list, lhs.cookie_list))
    return false;
  if (std::less<>{}(lhs.devtools_request_id, rhs.devtools_request_id))
    return true;
  if (std::less<>{}(rhs.devtools_request_id, lhs.devtools_request_id))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CookieAccessDetails::DataView,
                                         ::network::mojom::CookieAccessDetailsPtr> {
  static bool IsNull(const ::network::mojom::CookieAccessDetailsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieAccessDetailsPtr* output) { output->reset(); }

  static decltype(::network::mojom::CookieAccessDetails::type) type(
      const ::network::mojom::CookieAccessDetailsPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::CookieAccessDetails::url)& url(
      const ::network::mojom::CookieAccessDetailsPtr& input) {
    return input->url;
  }

  static const decltype(::network::mojom::CookieAccessDetails::site_for_cookies)& site_for_cookies(
      const ::network::mojom::CookieAccessDetailsPtr& input) {
    return input->site_for_cookies;
  }

  static const decltype(::network::mojom::CookieAccessDetails::cookie_list)& cookie_list(
      const ::network::mojom::CookieAccessDetailsPtr& input) {
    return input->cookie_list;
  }

  static const decltype(::network::mojom::CookieAccessDetails::devtools_request_id)& devtools_request_id(
      const ::network::mojom::CookieAccessDetailsPtr& input) {
    return input->devtools_request_id;
  }

  static bool Read(::network::mojom::CookieAccessDetails::DataView input, ::network::mojom::CookieAccessDetailsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_H_