// services/network/public/mojom/cookie_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-forward.h"
#include "components/content_settings/core/common/content_settings.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "services/network/public/cpp/cookie_manager_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class CookieChangeListenerProxy;

template <typename ImplRefTraits>
class CookieChangeListenerStub;

class CookieChangeListenerRequestValidator;


class  CookieChangeListener
    : public CookieChangeListenerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CookieChangeListenerInterfaceBase;
  using Proxy_ = CookieChangeListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CookieChangeListenerStub<ImplRefTraits>;

  using RequestValidator_ = CookieChangeListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCookieChangeMinVersion = 0,
  };
  virtual ~CookieChangeListener() {}

  
  virtual void OnCookieChange(const ::net::CookieChangeInfo& change) = 0;
};

class CookieRemoteAccessFilterProxy;

template <typename ImplRefTraits>
class CookieRemoteAccessFilterStub;

class CookieRemoteAccessFilterRequestValidator;
class CookieRemoteAccessFilterResponseValidator;


class  CookieRemoteAccessFilter
    : public CookieRemoteAccessFilterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CookieRemoteAccessFilterInterfaceBase;
  using Proxy_ = CookieRemoteAccessFilterProxy;

  template <typename ImplRefTraits>
  using Stub_ = CookieRemoteAccessFilterStub<ImplRefTraits>;

  using RequestValidator_ = CookieRemoteAccessFilterRequestValidator;
  using ResponseValidator_ = CookieRemoteAccessFilterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAllowedAccessMinVersion = 0,
  };
  virtual ~CookieRemoteAccessFilter() {}


  using AllowedAccessCallback = base::OnceCallback<void(bool)>;
  
  virtual void AllowedAccess(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, AllowedAccessCallback callback) = 0;
};

class CookieManagerProxy;

template <typename ImplRefTraits>
class CookieManagerStub;

class CookieManagerRequestValidator;
class CookieManagerResponseValidator;


class  CookieManager
    : public CookieManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CookieManagerInterfaceBase;
  using Proxy_ = CookieManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CookieManagerStub<ImplRefTraits>;

  using RequestValidator_ = CookieManagerRequestValidator;
  using ResponseValidator_ = CookieManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllCookiesMinVersion = 0,
    kGetAllCookiesWithAccessSemanticsMinVersion = 0,
    kGetCookieListMinVersion = 0,
    kSetCanonicalCookieMinVersion = 0,
    kDeleteCanonicalCookieMinVersion = 0,
    kDeleteCookiesMinVersion = 0,
    kAddCookieChangeListenerMinVersion = 0,
    kAddGlobalChangeListenerMinVersion = 0,
    kCloneInterfaceMinVersion = 0,
    kFlushCookieStoreMinVersion = 0,
    kAllowFileSchemeCookiesMinVersion = 0,
    kSetContentSettingsMinVersion = 0,
    kSetRemoteFilterMinVersion = 0,
    kSetForceKeepSessionStateMinVersion = 0,
    kBlockThirdPartyCookiesMinVersion = 0,
    kSetContentSettingsForLegacyCookieAccessMinVersion = 0,
    kSetStorageAccessGrantSettingsMinVersion = 0,
  };
  virtual ~CookieManager() {}


  using GetAllCookiesCallback = base::OnceCallback<void(const std::vector<::net::CanonicalCookie>&)>;
  
  virtual void GetAllCookies(GetAllCookiesCallback callback) = 0;


  using GetAllCookiesWithAccessSemanticsCallback = base::OnceCallback<void(const std::vector<::net::CanonicalCookie>&, const std::vector<::net::CookieAccessSemantics>&)>;
  
  virtual void GetAllCookiesWithAccessSemantics(GetAllCookiesWithAccessSemanticsCallback callback) = 0;


  using GetCookieListCallback = base::OnceCallback<void(const std::vector<::net::CookieWithAccessResult>&, const std::vector<::net::CookieWithAccessResult>&)>;
  
  virtual void GetCookieList(const ::GURL& url, const ::net::CookieOptions& cookie_options, GetCookieListCallback callback) = 0;


  using SetCanonicalCookieCallback = base::OnceCallback<void(::net::CookieAccessResult)>;
  
  virtual void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::GURL& source_url, const ::net::CookieOptions& cookie_options, SetCanonicalCookieCallback callback) = 0;


  using DeleteCanonicalCookieCallback = base::OnceCallback<void(bool)>;
  
  virtual void DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie, DeleteCanonicalCookieCallback callback) = 0;


  using DeleteCookiesCallback = base::OnceCallback<void(uint32_t)>;
  
  virtual void DeleteCookies(CookieDeletionFilterPtr filter, DeleteCookiesCallback callback) = 0;

  
  virtual void AddCookieChangeListener(const ::GURL& url, const base::Optional<std::string>& name, ::mojo::PendingRemote<CookieChangeListener> listener) = 0;

  
  virtual void AddGlobalChangeListener(::mojo::PendingRemote<CookieChangeListener> notification_pointer) = 0;

  
  virtual void CloneInterface(::mojo::PendingReceiver<CookieManager> new_interface) = 0;


  using FlushCookieStoreCallback = base::OnceCallback<void()>;
  
  virtual void FlushCookieStore(FlushCookieStoreCallback callback) = 0;


  using AllowFileSchemeCookiesCallback = base::OnceCallback<void(bool)>;
  
  virtual void AllowFileSchemeCookies(bool allow, AllowFileSchemeCookiesCallback callback) = 0;

  
  virtual void SetContentSettings(const std::vector<::ContentSettingPatternSource>& settings) = 0;

  
  virtual void SetRemoteFilter(::mojo::PendingRemote<CookieRemoteAccessFilter> remote_access_filter) = 0;

  
  virtual void SetForceKeepSessionState() = 0;

  
  virtual void BlockThirdPartyCookies(bool block) = 0;

  
  virtual void SetContentSettingsForLegacyCookieAccess(const std::vector<::ContentSettingPatternSource>& settings) = 0;


  using SetStorageAccessGrantSettingsCallback = base::OnceCallback<void()>;
  
  virtual void SetStorageAccessGrantSettings(const std::vector<::ContentSettingPatternSource>& settings, SetStorageAccessGrantSettingsCallback callback) = 0;
};



class  CookieChangeListenerProxy
    : public CookieChangeListener {
 public:
  using InterfaceType = CookieChangeListener;

  explicit CookieChangeListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCookieChange(const ::net::CookieChangeInfo& change) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CookieRemoteAccessFilterProxy
    : public CookieRemoteAccessFilter {
 public:
  using InterfaceType = CookieRemoteAccessFilter;

  explicit CookieRemoteAccessFilterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AllowedAccess(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, AllowedAccessCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CookieManagerProxy
    : public CookieManager {
 public:
  using InterfaceType = CookieManager;

  explicit CookieManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllCookies(GetAllCookiesCallback callback) final;
  
  void GetAllCookiesWithAccessSemantics(GetAllCookiesWithAccessSemanticsCallback callback) final;
  
  void GetCookieList(const ::GURL& url, const ::net::CookieOptions& cookie_options, GetCookieListCallback callback) final;
  
  void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::GURL& source_url, const ::net::CookieOptions& cookie_options, SetCanonicalCookieCallback callback) final;
  
  void DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie, DeleteCanonicalCookieCallback callback) final;
  
  void DeleteCookies(CookieDeletionFilterPtr filter, DeleteCookiesCallback callback) final;
  
  void AddCookieChangeListener(const ::GURL& url, const base::Optional<std::string>& name, ::mojo::PendingRemote<CookieChangeListener> listener) final;
  
  void AddGlobalChangeListener(::mojo::PendingRemote<CookieChangeListener> notification_pointer) final;
  
  void CloneInterface(::mojo::PendingReceiver<CookieManager> new_interface) final;
  
  void FlushCookieStore(FlushCookieStoreCallback callback) final;
  
  void AllowFileSchemeCookies(bool allow, AllowFileSchemeCookiesCallback callback) final;
  
  void SetContentSettings(const std::vector<::ContentSettingPatternSource>& settings) final;
  
  void SetRemoteFilter(::mojo::PendingRemote<CookieRemoteAccessFilter> remote_access_filter) final;
  
  void SetForceKeepSessionState() final;
  
  void BlockThirdPartyCookies(bool block) final;
  
  void SetContentSettingsForLegacyCookieAccess(const std::vector<::ContentSettingPatternSource>& settings) final;
  
  void SetStorageAccessGrantSettings(const std::vector<::ContentSettingPatternSource>& settings, SetStorageAccessGrantSettingsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CookieChangeListenerStubDispatch {
 public:
  static bool Accept(CookieChangeListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CookieChangeListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CookieChangeListener>>
class CookieChangeListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CookieChangeListenerStub() {}
  ~CookieChangeListenerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieChangeListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieChangeListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CookieRemoteAccessFilterStubDispatch {
 public:
  static bool Accept(CookieRemoteAccessFilter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CookieRemoteAccessFilter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CookieRemoteAccessFilter>>
class CookieRemoteAccessFilterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CookieRemoteAccessFilterStub() {}
  ~CookieRemoteAccessFilterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieRemoteAccessFilterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieRemoteAccessFilterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CookieManagerStubDispatch {
 public:
  static bool Accept(CookieManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CookieManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CookieManager>>
class CookieManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CookieManagerStub() {}
  ~CookieManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CookieManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CookieChangeListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CookieRemoteAccessFilterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CookieManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CookieRemoteAccessFilterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CookieManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  CookieSameSiteContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieSameSiteContext, T>::value>;
  using DataView = CookieSameSiteContextDataView;
  using Data_ = internal::CookieSameSiteContext_Data;

  template <typename... Args>
  static CookieSameSiteContextPtr New(Args&&... args) {
    return CookieSameSiteContextPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieSameSiteContextPtr From(const U& u) {
    return mojo::TypeConverter<CookieSameSiteContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieSameSiteContext>::Convert(*this);
  }


  CookieSameSiteContext();

  CookieSameSiteContext(
      ContextType context,
      ContextType schemeful_context);

  ~CookieSameSiteContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieSameSiteContextPtr>
  CookieSameSiteContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieSameSiteContext::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieSameSiteContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieSameSiteContext_UnserializedMessageContext<
            UserType, CookieSameSiteContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieSameSiteContext::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieSameSiteContext::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieSameSiteContext_UnserializedMessageContext<
            UserType, CookieSameSiteContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieSameSiteContext::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ContextType context;
  
  ContextType schemeful_context;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieSameSiteContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  CookieInclusionStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieInclusionStatus, T>::value>;
  using DataView = CookieInclusionStatusDataView;
  using Data_ = internal::CookieInclusionStatus_Data;

  template <typename... Args>
  static CookieInclusionStatusPtr New(Args&&... args) {
    return CookieInclusionStatusPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieInclusionStatusPtr From(const U& u) {
    return mojo::TypeConverter<CookieInclusionStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieInclusionStatus>::Convert(*this);
  }


  CookieInclusionStatus();

  CookieInclusionStatus(
      uint32_t exclusion_reasons,
      uint32_t warning_reasons);

  ~CookieInclusionStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieInclusionStatusPtr>
  CookieInclusionStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieInclusionStatus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieInclusionStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieInclusionStatus_UnserializedMessageContext<
            UserType, CookieInclusionStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieInclusionStatus::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieInclusionStatus::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieInclusionStatus_UnserializedMessageContext<
            UserType, CookieInclusionStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieInclusionStatus::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t exclusion_reasons;
  
  uint32_t warning_reasons;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieInclusionStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class  CookieManagerParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieManagerParams, T>::value>;
  using DataView = CookieManagerParamsDataView;
  using Data_ = internal::CookieManagerParams_Data;

  template <typename... Args>
  static CookieManagerParamsPtr New(Args&&... args) {
    return CookieManagerParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieManagerParamsPtr From(const U& u) {
    return mojo::TypeConverter<CookieManagerParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieManagerParams>::Convert(*this);
  }


  CookieManagerParams();

  CookieManagerParams(
      bool block_third_party_cookies,
      std::vector<::ContentSettingPatternSource> settings,
      std::vector<std::string> secure_origin_cookies_allowed_schemes,
      std::vector<std::string> matching_scheme_cookies_allowed_schemes,
      std::vector<std::string> third_party_cookies_allowed_schemes,
      bool allow_file_scheme_cookies,
      std::vector<::ContentSettingPatternSource> settings_for_legacy_cookie_access,
      std::vector<::ContentSettingPatternSource> settings_for_storage_access,
      CookieAccessDelegateType cookie_access_delegate_type);

  ~CookieManagerParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieManagerParamsPtr>
  CookieManagerParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieManagerParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieManagerParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieManagerParams_UnserializedMessageContext<
            UserType, CookieManagerParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieManagerParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieManagerParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieManagerParams_UnserializedMessageContext<
            UserType, CookieManagerParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieManagerParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool block_third_party_cookies;
  
  std::vector<::ContentSettingPatternSource> settings;
  
  std::vector<std::string> secure_origin_cookies_allowed_schemes;
  
  std::vector<std::string> matching_scheme_cookies_allowed_schemes;
  
  std::vector<std::string> third_party_cookies_allowed_schemes;
  
  bool allow_file_scheme_cookies;
  
  std::vector<::ContentSettingPatternSource> settings_for_legacy_cookie_access;
  
  std::vector<::ContentSettingPatternSource> settings_for_storage_access;
  
  CookieAccessDelegateType cookie_access_delegate_type;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieManagerParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CookieOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieOptions, T>::value>;
  using DataView = CookieOptionsDataView;
  using Data_ = internal::CookieOptions_Data;

  template <typename... Args>
  static CookieOptionsPtr New(Args&&... args) {
    return CookieOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieOptionsPtr From(const U& u) {
    return mojo::TypeConverter<CookieOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieOptions>::Convert(*this);
  }


  CookieOptions();

  CookieOptions(
      bool exclude_httponly,
      const ::net::CookieOptions::SameSiteCookieContext& same_site_cookie_context,
      bool update_access_time,
      bool return_excluded_cookies);

  ~CookieOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieOptionsPtr>
  CookieOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieOptions_UnserializedMessageContext<
            UserType, CookieOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieOptions_UnserializedMessageContext<
            UserType, CookieOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool exclude_httponly;
  
  ::net::CookieOptions::SameSiteCookieContext same_site_cookie_context;
  
  bool update_access_time;
  
  bool return_excluded_cookies;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CanonicalCookie {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CanonicalCookie, T>::value>;
  using DataView = CanonicalCookieDataView;
  using Data_ = internal::CanonicalCookie_Data;

  template <typename... Args>
  static CanonicalCookiePtr New(Args&&... args) {
    return CanonicalCookiePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CanonicalCookiePtr From(const U& u) {
    return mojo::TypeConverter<CanonicalCookiePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CanonicalCookie>::Convert(*this);
  }


  CanonicalCookie();

  CanonicalCookie(
      const std::string& name,
      const std::string& value,
      const std::string& domain,
      const std::string& path,
      ::base::Time creation,
      ::base::Time expiry,
      ::base::Time last_access,
      bool secure,
      bool httponly,
      ::net::CookieSameSite site_restrictions,
      ::net::CookiePriority priority,
      ::net::CookieSourceScheme source_scheme);

  ~CanonicalCookie();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CanonicalCookiePtr>
  CanonicalCookiePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CanonicalCookie::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CanonicalCookie::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CanonicalCookie_UnserializedMessageContext<
            UserType, CanonicalCookie::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CanonicalCookie::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CanonicalCookie::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CanonicalCookie_UnserializedMessageContext<
            UserType, CanonicalCookie::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CanonicalCookie::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string name;
  
  std::string value;
  
  std::string domain;
  
  std::string path;
  
  ::base::Time creation;
  
  ::base::Time expiry;
  
  ::base::Time last_access;
  
  bool secure;
  
  bool httponly;
  
  ::net::CookieSameSite site_restrictions;
  
  ::net::CookiePriority priority;
  
  ::net::CookieSourceScheme source_scheme;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CanonicalCookie::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CookieAndLineWithAccessResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieAndLineWithAccessResult, T>::value>;
  using DataView = CookieAndLineWithAccessResultDataView;
  using Data_ = internal::CookieAndLineWithAccessResult_Data;

  template <typename... Args>
  static CookieAndLineWithAccessResultPtr New(Args&&... args) {
    return CookieAndLineWithAccessResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieAndLineWithAccessResultPtr From(const U& u) {
    return mojo::TypeConverter<CookieAndLineWithAccessResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieAndLineWithAccessResult>::Convert(*this);
  }


  CookieAndLineWithAccessResult();

  CookieAndLineWithAccessResult(
      const base::Optional<::net::CanonicalCookie>& cookie,
      const std::string& cookie_string,
      ::net::CookieAccessResult access_result);

  ~CookieAndLineWithAccessResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieAndLineWithAccessResultPtr>
  CookieAndLineWithAccessResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieAndLineWithAccessResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieAndLineWithAccessResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieAndLineWithAccessResult_UnserializedMessageContext<
            UserType, CookieAndLineWithAccessResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieAndLineWithAccessResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieAndLineWithAccessResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieAndLineWithAccessResult_UnserializedMessageContext<
            UserType, CookieAndLineWithAccessResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieAndLineWithAccessResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<::net::CanonicalCookie> cookie;
  
  std::string cookie_string;
  
  ::net::CookieAccessResult access_result;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CookieAndLineWithAccessResult);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CookieAccessResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieAccessResult, T>::value>;
  using DataView = CookieAccessResultDataView;
  using Data_ = internal::CookieAccessResult_Data;

  template <typename... Args>
  static CookieAccessResultPtr New(Args&&... args) {
    return CookieAccessResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieAccessResultPtr From(const U& u) {
    return mojo::TypeConverter<CookieAccessResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieAccessResult>::Convert(*this);
  }


  CookieAccessResult();

  CookieAccessResult(
      ::net::CookieEffectiveSameSite effective_same_site,
      ::net::CookieAccessSemantics access_semantics,
      ::net::CookieInclusionStatus status);

  ~CookieAccessResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieAccessResultPtr>
  CookieAccessResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieAccessResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieAccessResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieAccessResult_UnserializedMessageContext<
            UserType, CookieAccessResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieAccessResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieAccessResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieAccessResult_UnserializedMessageContext<
            UserType, CookieAccessResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieAccessResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::net::CookieEffectiveSameSite effective_same_site;
  
  ::net::CookieAccessSemantics access_semantics;
  
  ::net::CookieInclusionStatus status;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CookieAccessResult);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieAccessResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CookieWithAccessResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieWithAccessResult, T>::value>;
  using DataView = CookieWithAccessResultDataView;
  using Data_ = internal::CookieWithAccessResult_Data;

  template <typename... Args>
  static CookieWithAccessResultPtr New(Args&&... args) {
    return CookieWithAccessResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieWithAccessResultPtr From(const U& u) {
    return mojo::TypeConverter<CookieWithAccessResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieWithAccessResult>::Convert(*this);
  }


  CookieWithAccessResult();

  CookieWithAccessResult(
      const ::net::CanonicalCookie& cookie,
      ::net::CookieAccessResult access_result);

  ~CookieWithAccessResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieWithAccessResultPtr>
  CookieWithAccessResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieWithAccessResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieWithAccessResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieWithAccessResult_UnserializedMessageContext<
            UserType, CookieWithAccessResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieWithAccessResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieWithAccessResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieWithAccessResult_UnserializedMessageContext<
            UserType, CookieWithAccessResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieWithAccessResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::net::CanonicalCookie cookie;
  
  ::net::CookieAccessResult access_result;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CookieWithAccessResult);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieWithAccessResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CookieChangeInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieChangeInfo, T>::value>;
  using DataView = CookieChangeInfoDataView;
  using Data_ = internal::CookieChangeInfo_Data;

  template <typename... Args>
  static CookieChangeInfoPtr New(Args&&... args) {
    return CookieChangeInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieChangeInfoPtr From(const U& u) {
    return mojo::TypeConverter<CookieChangeInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieChangeInfo>::Convert(*this);
  }


  CookieChangeInfo();

  CookieChangeInfo(
      const ::net::CanonicalCookie& cookie,
      ::net::CookieAccessResult access_result,
      ::net::CookieChangeCause cause);

  ~CookieChangeInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieChangeInfoPtr>
  CookieChangeInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieChangeInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieChangeInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieChangeInfo_UnserializedMessageContext<
            UserType, CookieChangeInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieChangeInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieChangeInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieChangeInfo_UnserializedMessageContext<
            UserType, CookieChangeInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieChangeInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::net::CanonicalCookie cookie;
  
  ::net::CookieAccessResult access_result;
  
  ::net::CookieChangeCause cause;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CookieChangeInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieChangeInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CookieDeletionFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieDeletionFilter, T>::value>;
  using DataView = CookieDeletionFilterDataView;
  using Data_ = internal::CookieDeletionFilter_Data;

  template <typename... Args>
  static CookieDeletionFilterPtr New(Args&&... args) {
    return CookieDeletionFilterPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieDeletionFilterPtr From(const U& u) {
    return mojo::TypeConverter<CookieDeletionFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieDeletionFilter>::Convert(*this);
  }


  CookieDeletionFilter();

  CookieDeletionFilter(
      base::Optional<::base::Time> created_after_time,
      base::Optional<::base::Time> created_before_time,
      base::Optional<std::vector<std::string>> excluding_domains,
      base::Optional<std::vector<std::string>> including_domains,
      const base::Optional<std::string>& cookie_name,
      const base::Optional<std::string>& host_name,
      const base::Optional<::GURL>& url,
      CookieDeletionSessionControl session_control);

  ~CookieDeletionFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieDeletionFilterPtr>
  CookieDeletionFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieDeletionFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieDeletionFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieDeletionFilter_UnserializedMessageContext<
            UserType, CookieDeletionFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieDeletionFilter::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieDeletionFilter::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieDeletionFilter_UnserializedMessageContext<
            UserType, CookieDeletionFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieDeletionFilter::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<::base::Time> created_after_time;
  
  base::Optional<::base::Time> created_before_time;
  
  base::Optional<std::vector<std::string>> excluding_domains;
  
  base::Optional<std::vector<std::string>> including_domains;
  
  base::Optional<std::string> cookie_name;
  
  base::Optional<std::string> host_name;
  
  base::Optional<::GURL> url;
  
  CookieDeletionSessionControl session_control;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieDeletionFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CookieManagerParamsPtr CookieManagerParams::Clone() const {
  return New(
      mojo::Clone(block_third_party_cookies),
      mojo::Clone(settings),
      mojo::Clone(secure_origin_cookies_allowed_schemes),
      mojo::Clone(matching_scheme_cookies_allowed_schemes),
      mojo::Clone(third_party_cookies_allowed_schemes),
      mojo::Clone(allow_file_scheme_cookies),
      mojo::Clone(settings_for_legacy_cookie_access),
      mojo::Clone(settings_for_storage_access),
      mojo::Clone(cookie_access_delegate_type)
  );
}

template <typename T, CookieManagerParams::EnableIfSame<T>*>
bool CookieManagerParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->block_third_party_cookies, other_struct.block_third_party_cookies))
    return false;
  if (!mojo::Equals(this->settings, other_struct.settings))
    return false;
  if (!mojo::Equals(this->secure_origin_cookies_allowed_schemes, other_struct.secure_origin_cookies_allowed_schemes))
    return false;
  if (!mojo::Equals(this->matching_scheme_cookies_allowed_schemes, other_struct.matching_scheme_cookies_allowed_schemes))
    return false;
  if (!mojo::Equals(this->third_party_cookies_allowed_schemes, other_struct.third_party_cookies_allowed_schemes))
    return false;
  if (!mojo::Equals(this->allow_file_scheme_cookies, other_struct.allow_file_scheme_cookies))
    return false;
  if (!mojo::Equals(this->settings_for_legacy_cookie_access, other_struct.settings_for_legacy_cookie_access))
    return false;
  if (!mojo::Equals(this->settings_for_storage_access, other_struct.settings_for_storage_access))
    return false;
  if (!mojo::Equals(this->cookie_access_delegate_type, other_struct.cookie_access_delegate_type))
    return false;
  return true;
}

template <typename T, CookieManagerParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.block_third_party_cookies, rhs.block_third_party_cookies))
    return true;
  if (std::less<>{}(rhs.block_third_party_cookies, lhs.block_third_party_cookies))
    return false;
  if (std::less<>{}(lhs.settings, rhs.settings))
    return true;
  if (std::less<>{}(rhs.settings, lhs.settings))
    return false;
  if (std::less<>{}(lhs.secure_origin_cookies_allowed_schemes, rhs.secure_origin_cookies_allowed_schemes))
    return true;
  if (std::less<>{}(rhs.secure_origin_cookies_allowed_schemes, lhs.secure_origin_cookies_allowed_schemes))
    return false;
  if (std::less<>{}(lhs.matching_scheme_cookies_allowed_schemes, rhs.matching_scheme_cookies_allowed_schemes))
    return true;
  if (std::less<>{}(rhs.matching_scheme_cookies_allowed_schemes, lhs.matching_scheme_cookies_allowed_schemes))
    return false;
  if (std::less<>{}(lhs.third_party_cookies_allowed_schemes, rhs.third_party_cookies_allowed_schemes))
    return true;
  if (std::less<>{}(rhs.third_party_cookies_allowed_schemes, lhs.third_party_cookies_allowed_schemes))
    return false;
  if (std::less<>{}(lhs.allow_file_scheme_cookies, rhs.allow_file_scheme_cookies))
    return true;
  if (std::less<>{}(rhs.allow_file_scheme_cookies, lhs.allow_file_scheme_cookies))
    return false;
  if (std::less<>{}(lhs.settings_for_legacy_cookie_access, rhs.settings_for_legacy_cookie_access))
    return true;
  if (std::less<>{}(rhs.settings_for_legacy_cookie_access, lhs.settings_for_legacy_cookie_access))
    return false;
  if (std::less<>{}(lhs.settings_for_storage_access, rhs.settings_for_storage_access))
    return true;
  if (std::less<>{}(rhs.settings_for_storage_access, lhs.settings_for_storage_access))
    return false;
  if (std::less<>{}(lhs.cookie_access_delegate_type, rhs.cookie_access_delegate_type))
    return true;
  if (std::less<>{}(rhs.cookie_access_delegate_type, lhs.cookie_access_delegate_type))
    return false;
  return false;
}
template <typename StructPtrType>
CookieSameSiteContextPtr CookieSameSiteContext::Clone() const {
  return New(
      mojo::Clone(context),
      mojo::Clone(schemeful_context)
  );
}

template <typename T, CookieSameSiteContext::EnableIfSame<T>*>
bool CookieSameSiteContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->context, other_struct.context))
    return false;
  if (!mojo::Equals(this->schemeful_context, other_struct.schemeful_context))
    return false;
  return true;
}

template <typename T, CookieSameSiteContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.context, rhs.context))
    return true;
  if (std::less<>{}(rhs.context, lhs.context))
    return false;
  if (std::less<>{}(lhs.schemeful_context, rhs.schemeful_context))
    return true;
  if (std::less<>{}(rhs.schemeful_context, lhs.schemeful_context))
    return false;
  return false;
}
template <typename StructPtrType>
CookieOptionsPtr CookieOptions::Clone() const {
  return New(
      mojo::Clone(exclude_httponly),
      mojo::Clone(same_site_cookie_context),
      mojo::Clone(update_access_time),
      mojo::Clone(return_excluded_cookies)
  );
}

template <typename T, CookieOptions::EnableIfSame<T>*>
bool CookieOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->exclude_httponly, other_struct.exclude_httponly))
    return false;
  if (!mojo::Equals(this->same_site_cookie_context, other_struct.same_site_cookie_context))
    return false;
  if (!mojo::Equals(this->update_access_time, other_struct.update_access_time))
    return false;
  if (!mojo::Equals(this->return_excluded_cookies, other_struct.return_excluded_cookies))
    return false;
  return true;
}

template <typename T, CookieOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.exclude_httponly, rhs.exclude_httponly))
    return true;
  if (std::less<>{}(rhs.exclude_httponly, lhs.exclude_httponly))
    return false;
  if (std::less<>{}(lhs.same_site_cookie_context, rhs.same_site_cookie_context))
    return true;
  if (std::less<>{}(rhs.same_site_cookie_context, lhs.same_site_cookie_context))
    return false;
  if (std::less<>{}(lhs.update_access_time, rhs.update_access_time))
    return true;
  if (std::less<>{}(rhs.update_access_time, lhs.update_access_time))
    return false;
  if (std::less<>{}(lhs.return_excluded_cookies, rhs.return_excluded_cookies))
    return true;
  if (std::less<>{}(rhs.return_excluded_cookies, lhs.return_excluded_cookies))
    return false;
  return false;
}
template <typename StructPtrType>
CanonicalCookiePtr CanonicalCookie::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value),
      mojo::Clone(domain),
      mojo::Clone(path),
      mojo::Clone(creation),
      mojo::Clone(expiry),
      mojo::Clone(last_access),
      mojo::Clone(secure),
      mojo::Clone(httponly),
      mojo::Clone(site_restrictions),
      mojo::Clone(priority),
      mojo::Clone(source_scheme)
  );
}

template <typename T, CanonicalCookie::EnableIfSame<T>*>
bool CanonicalCookie::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->creation, other_struct.creation))
    return false;
  if (!mojo::Equals(this->expiry, other_struct.expiry))
    return false;
  if (!mojo::Equals(this->last_access, other_struct.last_access))
    return false;
  if (!mojo::Equals(this->secure, other_struct.secure))
    return false;
  if (!mojo::Equals(this->httponly, other_struct.httponly))
    return false;
  if (!mojo::Equals(this->site_restrictions, other_struct.site_restrictions))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->source_scheme, other_struct.source_scheme))
    return false;
  return true;
}

template <typename T, CanonicalCookie::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  if (std::less<>{}(lhs.domain, rhs.domain))
    return true;
  if (std::less<>{}(rhs.domain, lhs.domain))
    return false;
  if (std::less<>{}(lhs.path, rhs.path))
    return true;
  if (std::less<>{}(rhs.path, lhs.path))
    return false;
  if (std::less<>{}(lhs.creation, rhs.creation))
    return true;
  if (std::less<>{}(rhs.creation, lhs.creation))
    return false;
  if (std::less<>{}(lhs.expiry, rhs.expiry))
    return true;
  if (std::less<>{}(rhs.expiry, lhs.expiry))
    return false;
  if (std::less<>{}(lhs.last_access, rhs.last_access))
    return true;
  if (std::less<>{}(rhs.last_access, lhs.last_access))
    return false;
  if (std::less<>{}(lhs.secure, rhs.secure))
    return true;
  if (std::less<>{}(rhs.secure, lhs.secure))
    return false;
  if (std::less<>{}(lhs.httponly, rhs.httponly))
    return true;
  if (std::less<>{}(rhs.httponly, lhs.httponly))
    return false;
  if (std::less<>{}(lhs.site_restrictions, rhs.site_restrictions))
    return true;
  if (std::less<>{}(rhs.site_restrictions, lhs.site_restrictions))
    return false;
  if (std::less<>{}(lhs.priority, rhs.priority))
    return true;
  if (std::less<>{}(rhs.priority, lhs.priority))
    return false;
  if (std::less<>{}(lhs.source_scheme, rhs.source_scheme))
    return true;
  if (std::less<>{}(rhs.source_scheme, lhs.source_scheme))
    return false;
  return false;
}
template <typename StructPtrType>
CookieInclusionStatusPtr CookieInclusionStatus::Clone() const {
  return New(
      mojo::Clone(exclusion_reasons),
      mojo::Clone(warning_reasons)
  );
}

template <typename T, CookieInclusionStatus::EnableIfSame<T>*>
bool CookieInclusionStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->exclusion_reasons, other_struct.exclusion_reasons))
    return false;
  if (!mojo::Equals(this->warning_reasons, other_struct.warning_reasons))
    return false;
  return true;
}

template <typename T, CookieInclusionStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.exclusion_reasons, rhs.exclusion_reasons))
    return true;
  if (std::less<>{}(rhs.exclusion_reasons, lhs.exclusion_reasons))
    return false;
  if (std::less<>{}(lhs.warning_reasons, rhs.warning_reasons))
    return true;
  if (std::less<>{}(rhs.warning_reasons, lhs.warning_reasons))
    return false;
  return false;
}
template <typename StructPtrType>
CookieAndLineWithAccessResultPtr CookieAndLineWithAccessResult::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(cookie_string),
      mojo::Clone(access_result)
  );
}

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>*>
bool CookieAndLineWithAccessResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->cookie_string, other_struct.cookie_string))
    return false;
  if (!mojo::Equals(this->access_result, other_struct.access_result))
    return false;
  return true;
}

template <typename T, CookieAndLineWithAccessResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cookie, rhs.cookie))
    return true;
  if (std::less<>{}(rhs.cookie, lhs.cookie))
    return false;
  if (std::less<>{}(lhs.cookie_string, rhs.cookie_string))
    return true;
  if (std::less<>{}(rhs.cookie_string, lhs.cookie_string))
    return false;
  if (std::less<>{}(lhs.access_result, rhs.access_result))
    return true;
  if (std::less<>{}(rhs.access_result, lhs.access_result))
    return false;
  return false;
}
template <typename StructPtrType>
CookieAccessResultPtr CookieAccessResult::Clone() const {
  return New(
      mojo::Clone(effective_same_site),
      mojo::Clone(access_semantics),
      mojo::Clone(status)
  );
}

template <typename T, CookieAccessResult::EnableIfSame<T>*>
bool CookieAccessResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->effective_same_site, other_struct.effective_same_site))
    return false;
  if (!mojo::Equals(this->access_semantics, other_struct.access_semantics))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, CookieAccessResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.effective_same_site, rhs.effective_same_site))
    return true;
  if (std::less<>{}(rhs.effective_same_site, lhs.effective_same_site))
    return false;
  if (std::less<>{}(lhs.access_semantics, rhs.access_semantics))
    return true;
  if (std::less<>{}(rhs.access_semantics, lhs.access_semantics))
    return false;
  if (std::less<>{}(lhs.status, rhs.status))
    return true;
  if (std::less<>{}(rhs.status, lhs.status))
    return false;
  return false;
}
template <typename StructPtrType>
CookieWithAccessResultPtr CookieWithAccessResult::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(access_result)
  );
}

template <typename T, CookieWithAccessResult::EnableIfSame<T>*>
bool CookieWithAccessResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->access_result, other_struct.access_result))
    return false;
  return true;
}

template <typename T, CookieWithAccessResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cookie, rhs.cookie))
    return true;
  if (std::less<>{}(rhs.cookie, lhs.cookie))
    return false;
  if (std::less<>{}(lhs.access_result, rhs.access_result))
    return true;
  if (std::less<>{}(rhs.access_result, lhs.access_result))
    return false;
  return false;
}
template <typename StructPtrType>
CookieChangeInfoPtr CookieChangeInfo::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(access_result),
      mojo::Clone(cause)
  );
}

template <typename T, CookieChangeInfo::EnableIfSame<T>*>
bool CookieChangeInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->access_result, other_struct.access_result))
    return false;
  if (!mojo::Equals(this->cause, other_struct.cause))
    return false;
  return true;
}

template <typename T, CookieChangeInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cookie, rhs.cookie))
    return true;
  if (std::less<>{}(rhs.cookie, lhs.cookie))
    return false;
  if (std::less<>{}(lhs.access_result, rhs.access_result))
    return true;
  if (std::less<>{}(rhs.access_result, lhs.access_result))
    return false;
  if (std::less<>{}(lhs.cause, rhs.cause))
    return true;
  if (std::less<>{}(rhs.cause, lhs.cause))
    return false;
  return false;
}
template <typename StructPtrType>
CookieDeletionFilterPtr CookieDeletionFilter::Clone() const {
  return New(
      mojo::Clone(created_after_time),
      mojo::Clone(created_before_time),
      mojo::Clone(excluding_domains),
      mojo::Clone(including_domains),
      mojo::Clone(cookie_name),
      mojo::Clone(host_name),
      mojo::Clone(url),
      mojo::Clone(session_control)
  );
}

template <typename T, CookieDeletionFilter::EnableIfSame<T>*>
bool CookieDeletionFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->created_after_time, other_struct.created_after_time))
    return false;
  if (!mojo::Equals(this->created_before_time, other_struct.created_before_time))
    return false;
  if (!mojo::Equals(this->excluding_domains, other_struct.excluding_domains))
    return false;
  if (!mojo::Equals(this->including_domains, other_struct.including_domains))
    return false;
  if (!mojo::Equals(this->cookie_name, other_struct.cookie_name))
    return false;
  if (!mojo::Equals(this->host_name, other_struct.host_name))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->session_control, other_struct.session_control))
    return false;
  return true;
}

template <typename T, CookieDeletionFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.created_after_time, rhs.created_after_time))
    return true;
  if (std::less<>{}(rhs.created_after_time, lhs.created_after_time))
    return false;
  if (std::less<>{}(lhs.created_before_time, rhs.created_before_time))
    return true;
  if (std::less<>{}(rhs.created_before_time, lhs.created_before_time))
    return false;
  if (std::less<>{}(lhs.excluding_domains, rhs.excluding_domains))
    return true;
  if (std::less<>{}(rhs.excluding_domains, lhs.excluding_domains))
    return false;
  if (std::less<>{}(lhs.including_domains, rhs.including_domains))
    return true;
  if (std::less<>{}(rhs.including_domains, lhs.including_domains))
    return false;
  if (std::less<>{}(lhs.cookie_name, rhs.cookie_name))
    return true;
  if (std::less<>{}(rhs.cookie_name, lhs.cookie_name))
    return false;
  if (std::less<>{}(lhs.host_name, rhs.host_name))
    return true;
  if (std::less<>{}(rhs.host_name, lhs.host_name))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.session_control, rhs.session_control))
    return true;
  if (std::less<>{}(rhs.session_control, lhs.session_control))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CookieManagerParams::DataView,
                                         ::network::mojom::CookieManagerParamsPtr> {
  static bool IsNull(const ::network::mojom::CookieManagerParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieManagerParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::CookieManagerParams::block_third_party_cookies) block_third_party_cookies(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->block_third_party_cookies;
  }

  static const decltype(::network::mojom::CookieManagerParams::settings)& settings(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->settings;
  }

  static const decltype(::network::mojom::CookieManagerParams::secure_origin_cookies_allowed_schemes)& secure_origin_cookies_allowed_schemes(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->secure_origin_cookies_allowed_schemes;
  }

  static const decltype(::network::mojom::CookieManagerParams::matching_scheme_cookies_allowed_schemes)& matching_scheme_cookies_allowed_schemes(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->matching_scheme_cookies_allowed_schemes;
  }

  static const decltype(::network::mojom::CookieManagerParams::third_party_cookies_allowed_schemes)& third_party_cookies_allowed_schemes(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->third_party_cookies_allowed_schemes;
  }

  static decltype(::network::mojom::CookieManagerParams::allow_file_scheme_cookies) allow_file_scheme_cookies(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->allow_file_scheme_cookies;
  }

  static const decltype(::network::mojom::CookieManagerParams::settings_for_legacy_cookie_access)& settings_for_legacy_cookie_access(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->settings_for_legacy_cookie_access;
  }

  static const decltype(::network::mojom::CookieManagerParams::settings_for_storage_access)& settings_for_storage_access(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->settings_for_storage_access;
  }

  static decltype(::network::mojom::CookieManagerParams::cookie_access_delegate_type) cookie_access_delegate_type(
      const ::network::mojom::CookieManagerParamsPtr& input) {
    return input->cookie_access_delegate_type;
  }

  static bool Read(::network::mojom::CookieManagerParams::DataView input, ::network::mojom::CookieManagerParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookieSameSiteContext::DataView,
                                         ::network::mojom::CookieSameSiteContextPtr> {
  static bool IsNull(const ::network::mojom::CookieSameSiteContextPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieSameSiteContextPtr* output) { output->reset(); }

  static decltype(::network::mojom::CookieSameSiteContext::context) context(
      const ::network::mojom::CookieSameSiteContextPtr& input) {
    return input->context;
  }

  static decltype(::network::mojom::CookieSameSiteContext::schemeful_context) schemeful_context(
      const ::network::mojom::CookieSameSiteContextPtr& input) {
    return input->schemeful_context;
  }

  static bool Read(::network::mojom::CookieSameSiteContext::DataView input, ::network::mojom::CookieSameSiteContextPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookieOptions::DataView,
                                         ::network::mojom::CookieOptionsPtr> {
  static bool IsNull(const ::network::mojom::CookieOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieOptionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::CookieOptions::exclude_httponly) exclude_httponly(
      const ::network::mojom::CookieOptionsPtr& input) {
    return input->exclude_httponly;
  }

  static const decltype(::network::mojom::CookieOptions::same_site_cookie_context)& same_site_cookie_context(
      const ::network::mojom::CookieOptionsPtr& input) {
    return input->same_site_cookie_context;
  }

  static decltype(::network::mojom::CookieOptions::update_access_time) update_access_time(
      const ::network::mojom::CookieOptionsPtr& input) {
    return input->update_access_time;
  }

  static decltype(::network::mojom::CookieOptions::return_excluded_cookies) return_excluded_cookies(
      const ::network::mojom::CookieOptionsPtr& input) {
    return input->return_excluded_cookies;
  }

  static bool Read(::network::mojom::CookieOptions::DataView input, ::network::mojom::CookieOptionsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CanonicalCookie::DataView,
                                         ::network::mojom::CanonicalCookiePtr> {
  static bool IsNull(const ::network::mojom::CanonicalCookiePtr& input) { return !input; }
  static void SetToNull(::network::mojom::CanonicalCookiePtr* output) { output->reset(); }

  static const decltype(::network::mojom::CanonicalCookie::name)& name(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::CanonicalCookie::value)& value(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->value;
  }

  static const decltype(::network::mojom::CanonicalCookie::domain)& domain(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->domain;
  }

  static const decltype(::network::mojom::CanonicalCookie::path)& path(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->path;
  }

  static const decltype(::network::mojom::CanonicalCookie::creation)& creation(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->creation;
  }

  static const decltype(::network::mojom::CanonicalCookie::expiry)& expiry(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->expiry;
  }

  static const decltype(::network::mojom::CanonicalCookie::last_access)& last_access(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->last_access;
  }

  static decltype(::network::mojom::CanonicalCookie::secure) secure(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->secure;
  }

  static decltype(::network::mojom::CanonicalCookie::httponly) httponly(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->httponly;
  }

  static decltype(::network::mojom::CanonicalCookie::site_restrictions) site_restrictions(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->site_restrictions;
  }

  static decltype(::network::mojom::CanonicalCookie::priority) priority(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->priority;
  }

  static decltype(::network::mojom::CanonicalCookie::source_scheme) source_scheme(
      const ::network::mojom::CanonicalCookiePtr& input) {
    return input->source_scheme;
  }

  static bool Read(::network::mojom::CanonicalCookie::DataView input, ::network::mojom::CanonicalCookiePtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookieInclusionStatus::DataView,
                                         ::network::mojom::CookieInclusionStatusPtr> {
  static bool IsNull(const ::network::mojom::CookieInclusionStatusPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieInclusionStatusPtr* output) { output->reset(); }

  static decltype(::network::mojom::CookieInclusionStatus::exclusion_reasons) exclusion_reasons(
      const ::network::mojom::CookieInclusionStatusPtr& input) {
    return input->exclusion_reasons;
  }

  static decltype(::network::mojom::CookieInclusionStatus::warning_reasons) warning_reasons(
      const ::network::mojom::CookieInclusionStatusPtr& input) {
    return input->warning_reasons;
  }

  static bool Read(::network::mojom::CookieInclusionStatus::DataView input, ::network::mojom::CookieInclusionStatusPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookieAndLineWithAccessResult::DataView,
                                         ::network::mojom::CookieAndLineWithAccessResultPtr> {
  static bool IsNull(const ::network::mojom::CookieAndLineWithAccessResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieAndLineWithAccessResultPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CookieAndLineWithAccessResult::cookie)& cookie(
      const ::network::mojom::CookieAndLineWithAccessResultPtr& input) {
    return input->cookie;
  }

  static const decltype(::network::mojom::CookieAndLineWithAccessResult::cookie_string)& cookie_string(
      const ::network::mojom::CookieAndLineWithAccessResultPtr& input) {
    return input->cookie_string;
  }

  static const decltype(::network::mojom::CookieAndLineWithAccessResult::access_result)& access_result(
      const ::network::mojom::CookieAndLineWithAccessResultPtr& input) {
    return input->access_result;
  }

  static bool Read(::network::mojom::CookieAndLineWithAccessResult::DataView input, ::network::mojom::CookieAndLineWithAccessResultPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookieAccessResult::DataView,
                                         ::network::mojom::CookieAccessResultPtr> {
  static bool IsNull(const ::network::mojom::CookieAccessResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieAccessResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::CookieAccessResult::effective_same_site) effective_same_site(
      const ::network::mojom::CookieAccessResultPtr& input) {
    return input->effective_same_site;
  }

  static decltype(::network::mojom::CookieAccessResult::access_semantics) access_semantics(
      const ::network::mojom::CookieAccessResultPtr& input) {
    return input->access_semantics;
  }

  static const decltype(::network::mojom::CookieAccessResult::status)& status(
      const ::network::mojom::CookieAccessResultPtr& input) {
    return input->status;
  }

  static bool Read(::network::mojom::CookieAccessResult::DataView input, ::network::mojom::CookieAccessResultPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookieWithAccessResult::DataView,
                                         ::network::mojom::CookieWithAccessResultPtr> {
  static bool IsNull(const ::network::mojom::CookieWithAccessResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieWithAccessResultPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CookieWithAccessResult::cookie)& cookie(
      const ::network::mojom::CookieWithAccessResultPtr& input) {
    return input->cookie;
  }

  static const decltype(::network::mojom::CookieWithAccessResult::access_result)& access_result(
      const ::network::mojom::CookieWithAccessResultPtr& input) {
    return input->access_result;
  }

  static bool Read(::network::mojom::CookieWithAccessResult::DataView input, ::network::mojom::CookieWithAccessResultPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookieChangeInfo::DataView,
                                         ::network::mojom::CookieChangeInfoPtr> {
  static bool IsNull(const ::network::mojom::CookieChangeInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieChangeInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CookieChangeInfo::cookie)& cookie(
      const ::network::mojom::CookieChangeInfoPtr& input) {
    return input->cookie;
  }

  static const decltype(::network::mojom::CookieChangeInfo::access_result)& access_result(
      const ::network::mojom::CookieChangeInfoPtr& input) {
    return input->access_result;
  }

  static decltype(::network::mojom::CookieChangeInfo::cause) cause(
      const ::network::mojom::CookieChangeInfoPtr& input) {
    return input->cause;
  }

  static bool Read(::network::mojom::CookieChangeInfo::DataView input, ::network::mojom::CookieChangeInfoPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CookieDeletionFilter::DataView,
                                         ::network::mojom::CookieDeletionFilterPtr> {
  static bool IsNull(const ::network::mojom::CookieDeletionFilterPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieDeletionFilterPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CookieDeletionFilter::created_after_time)& created_after_time(
      const ::network::mojom::CookieDeletionFilterPtr& input) {
    return input->created_after_time;
  }

  static const decltype(::network::mojom::CookieDeletionFilter::created_before_time)& created_before_time(
      const ::network::mojom::CookieDeletionFilterPtr& input) {
    return input->created_before_time;
  }

  static const decltype(::network::mojom::CookieDeletionFilter::excluding_domains)& excluding_domains(
      const ::network::mojom::CookieDeletionFilterPtr& input) {
    return input->excluding_domains;
  }

  static const decltype(::network::mojom::CookieDeletionFilter::including_domains)& including_domains(
      const ::network::mojom::CookieDeletionFilterPtr& input) {
    return input->including_domains;
  }

  static const decltype(::network::mojom::CookieDeletionFilter::cookie_name)& cookie_name(
      const ::network::mojom::CookieDeletionFilterPtr& input) {
    return input->cookie_name;
  }

  static const decltype(::network::mojom::CookieDeletionFilter::host_name)& host_name(
      const ::network::mojom::CookieDeletionFilterPtr& input) {
    return input->host_name;
  }

  static const decltype(::network::mojom::CookieDeletionFilter::url)& url(
      const ::network::mojom::CookieDeletionFilterPtr& input) {
    return input->url;
  }

  static decltype(::network::mojom::CookieDeletionFilter::session_control) session_control(
      const ::network::mojom::CookieDeletionFilterPtr& input) {
    return input->session_control;
  }

  static bool Read(::network::mojom::CookieDeletionFilter::DataView input, ::network::mojom::CookieDeletionFilterPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_H_