// services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace network {
namespace mojom {
class CrossOriginOpenerPolicyDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CrossOriginOpenerPolicyDataView> {
  using Data = ::network::mojom::internal::CrossOriginOpenerPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


enum class CoopAccessReportType : int32_t {
  
  kAccessFromCoopPageToOpener = 0,
  
  kAccessFromCoopPageToOpenee = 1,
  
  kAccessFromCoopPageToOther = 2,
  
  kAccessToCoopPageFromOpener = 3,
  
  kAccessToCoopPageFromOpenee = 4,
  
  kAccessToCoopPageFromOther = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, CoopAccessReportType value);
inline bool IsKnownEnumValue(CoopAccessReportType value) {
  return internal::CoopAccessReportType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CrossOriginOpenerPolicyValue : int32_t {
  
  kSameOrigin = 0,
  
  kSameOriginAllowPopups = 1,
  
  kUnsafeNone = 2,
  
  kSameOriginPlusCoep = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, CrossOriginOpenerPolicyValue value);
inline bool IsKnownEnumValue(CrossOriginOpenerPolicyValue value) {
  return internal::CrossOriginOpenerPolicyValue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CrossOriginOpenerPolicyReporterInterfaceBase {};

using CrossOriginOpenerPolicyReporterPtrDataView =
    mojo::InterfacePtrDataView<CrossOriginOpenerPolicyReporterInterfaceBase>;
using CrossOriginOpenerPolicyReporterRequestDataView =
    mojo::InterfaceRequestDataView<CrossOriginOpenerPolicyReporterInterfaceBase>;
using CrossOriginOpenerPolicyReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CrossOriginOpenerPolicyReporterInterfaceBase>;
using CrossOriginOpenerPolicyReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CrossOriginOpenerPolicyReporterInterfaceBase>;


class CrossOriginOpenerPolicyDataView {
 public:
  CrossOriginOpenerPolicyDataView() {}

  CrossOriginOpenerPolicyDataView(
      internal::CrossOriginOpenerPolicy_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) const {
    auto data_value = data_->value;
    return mojo::internal::Deserialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        data_value, output);
  }

  CrossOriginOpenerPolicyValue value() const {
    return static_cast<CrossOriginOpenerPolicyValue>(data_->value);
  }
  inline void GetReportingEndpointDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportingEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `reporting_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingEndpoint` instead "
    "of `ReadReportingEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_endpoint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportOnlyValue(UserType* output) const {
    auto data_value = data_->report_only_value;
    return mojo::internal::Deserialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        data_value, output);
  }

  CrossOriginOpenerPolicyValue report_only_value() const {
    return static_cast<CrossOriginOpenerPolicyValue>(data_->report_only_value);
  }
  inline void GetReportOnlyReportingEndpointDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportOnlyReportingEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `report_only_reporting_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportOnlyReportingEndpoint` instead "
    "of `ReadReportOnlyReportingEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->report_only_reporting_endpoint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::CrossOriginOpenerPolicy_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

template <>
struct hash<::network::mojom::CoopAccessReportType>
    : public mojo::internal::EnumHashImpl<::network::mojom::CoopAccessReportType> {};

template <>
struct hash<::network::mojom::CrossOriginOpenerPolicyValue>
    : public mojo::internal::EnumHashImpl<::network::mojom::CrossOriginOpenerPolicyValue> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::network::mojom::CoopAccessReportType, ::network::mojom::CoopAccessReportType> {
  static ::network::mojom::CoopAccessReportType ToMojom(::network::mojom::CoopAccessReportType input) { return input; }
  static bool FromMojom(::network::mojom::CoopAccessReportType input, ::network::mojom::CoopAccessReportType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CoopAccessReportType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CoopAccessReportType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CoopAccessReportType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CrossOriginOpenerPolicyValue, ::network::mojom::CrossOriginOpenerPolicyValue> {
  static ::network::mojom::CrossOriginOpenerPolicyValue ToMojom(::network::mojom::CrossOriginOpenerPolicyValue input) { return input; }
  static bool FromMojom(::network::mojom::CrossOriginOpenerPolicyValue input, ::network::mojom::CrossOriginOpenerPolicyValue* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CrossOriginOpenerPolicyValue, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CrossOriginOpenerPolicyValue, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CrossOriginOpenerPolicyValue>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CrossOriginOpenerPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CrossOriginOpenerPolicyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CrossOriginOpenerPolicy_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        Traits::value(input), &(*output)->value);
    decltype(Traits::reporting_endpoint(input)) in_reporting_endpoint = Traits::reporting_endpoint(input);
    typename decltype((*output)->reporting_endpoint)::BaseType::BufferWriter
        reporting_endpoint_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_reporting_endpoint, buffer, &reporting_endpoint_writer, context);
    (*output)->reporting_endpoint.Set(
        reporting_endpoint_writer.is_null() ? nullptr : reporting_endpoint_writer.data());
    mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyValue>(
        Traits::report_only_value(input), &(*output)->report_only_value);
    decltype(Traits::report_only_reporting_endpoint(input)) in_report_only_reporting_endpoint = Traits::report_only_reporting_endpoint(input);
    typename decltype((*output)->report_only_reporting_endpoint)::BaseType::BufferWriter
        report_only_reporting_endpoint_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_report_only_reporting_endpoint, buffer, &report_only_reporting_endpoint_writer, context);
    (*output)->report_only_reporting_endpoint.Set(
        report_only_reporting_endpoint_writer.is_null() ? nullptr : report_only_reporting_endpoint_writer.data());
  }

  static bool Deserialize(::network::mojom::internal::CrossOriginOpenerPolicy_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CrossOriginOpenerPolicyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void CrossOriginOpenerPolicyDataView::GetReportingEndpointDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reporting_endpoint.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CrossOriginOpenerPolicyDataView::GetReportOnlyReportingEndpointDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->report_only_reporting_endpoint.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_SHARED_H_