// services/network/public/mojom/quic_transport.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/quic_transport.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace network {
namespace mojom {
class QuicTransportErrorDataView;

class QuicTransportCertificateFingerprintDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::QuicTransportErrorDataView> {
  using Data = ::network::mojom::internal::QuicTransportError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::QuicTransportCertificateFingerprintDataView> {
  using Data = ::network::mojom::internal::QuicTransportCertificateFingerprint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {
// Interface base classes. They are used for type safety check.
class QuicTransportInterfaceBase {};

using QuicTransportPtrDataView =
    mojo::InterfacePtrDataView<QuicTransportInterfaceBase>;
using QuicTransportRequestDataView =
    mojo::InterfaceRequestDataView<QuicTransportInterfaceBase>;
using QuicTransportAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<QuicTransportInterfaceBase>;
using QuicTransportAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<QuicTransportInterfaceBase>;
class QuicTransportClientInterfaceBase {};

using QuicTransportClientPtrDataView =
    mojo::InterfacePtrDataView<QuicTransportClientInterfaceBase>;
using QuicTransportClientRequestDataView =
    mojo::InterfaceRequestDataView<QuicTransportClientInterfaceBase>;
using QuicTransportClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<QuicTransportClientInterfaceBase>;
using QuicTransportClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<QuicTransportClientInterfaceBase>;
class QuicTransportHandshakeClientInterfaceBase {};

using QuicTransportHandshakeClientPtrDataView =
    mojo::InterfacePtrDataView<QuicTransportHandshakeClientInterfaceBase>;
using QuicTransportHandshakeClientRequestDataView =
    mojo::InterfaceRequestDataView<QuicTransportHandshakeClientInterfaceBase>;
using QuicTransportHandshakeClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<QuicTransportHandshakeClientInterfaceBase>;
using QuicTransportHandshakeClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<QuicTransportHandshakeClientInterfaceBase>;


class QuicTransportErrorDataView {
 public:
  QuicTransportErrorDataView() {}

  QuicTransportErrorDataView(
      internal::QuicTransportError_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
  int32_t quic_error() const {
    return data_->quic_error;
  }
  inline void GetDetailsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool safe_to_report_details() const {
    return data_->safe_to_report_details;
  }
 private:
  internal::QuicTransportError_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class QuicTransportCertificateFingerprintDataView {
 public:
  QuicTransportCertificateFingerprintDataView() {}

  QuicTransportCertificateFingerprintDataView(
      internal::QuicTransportCertificateFingerprint_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetAlgorithmDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAlgorithm(UserType* output) {
    
    auto* pointer = data_->algorithm.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetFingerprintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFingerprint(UserType* output) {
    
    auto* pointer = data_->fingerprint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::QuicTransportCertificateFingerprint_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::QuicTransportErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::QuicTransportErrorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::QuicTransportError_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->net_error = Traits::net_error(input);
    (*output)->quic_error = Traits::quic_error(input);
    decltype(Traits::details(input)) in_details = Traits::details(input);
    typename decltype((*output)->details)::BaseType::BufferWriter
        details_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_details, buffer, &details_writer, context);
    (*output)->details.Set(
        details_writer.is_null() ? nullptr : details_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->details.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null details in QuicTransportError struct");
    (*output)->safe_to_report_details = Traits::safe_to_report_details(input);
  }

  static bool Deserialize(::network::mojom::internal::QuicTransportError_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::QuicTransportErrorDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::QuicTransportCertificateFingerprintDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::QuicTransportCertificateFingerprintDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::QuicTransportCertificateFingerprint_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::algorithm(input)) in_algorithm = Traits::algorithm(input);
    typename decltype((*output)->algorithm)::BaseType::BufferWriter
        algorithm_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_algorithm, buffer, &algorithm_writer, context);
    (*output)->algorithm.Set(
        algorithm_writer.is_null() ? nullptr : algorithm_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->algorithm.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null algorithm in QuicTransportCertificateFingerprint struct");
    decltype(Traits::fingerprint(input)) in_fingerprint = Traits::fingerprint(input);
    typename decltype((*output)->fingerprint)::BaseType::BufferWriter
        fingerprint_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_fingerprint, buffer, &fingerprint_writer, context);
    (*output)->fingerprint.Set(
        fingerprint_writer.is_null() ? nullptr : fingerprint_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->fingerprint.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fingerprint in QuicTransportCertificateFingerprint struct");
  }

  static bool Deserialize(::network::mojom::internal::QuicTransportCertificateFingerprint_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::QuicTransportCertificateFingerprintDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void QuicTransportErrorDataView::GetDetailsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->details.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void QuicTransportCertificateFingerprintDataView::GetAlgorithmDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->algorithm.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void QuicTransportCertificateFingerprintDataView::GetFingerprintDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->fingerprint.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_SHARED_H_