// services/network/public/mojom/trust_tokens.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace network {
namespace mojom {
namespace internal {
class TrustTokenParams_Data;
class HasTrustTokensResult_Data;
class TrustTokenVerificationKey_Data;
class TrustTokenKeyCommitmentResult_Data;

struct TrustTokenOperationStatus_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct TrustTokenOperationType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct TrustTokenRefreshPolicy_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct TrustTokenSignRequestData_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  TrustTokenParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TrustTokenParams_Data));
      new (data()) TrustTokenParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TrustTokenParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TrustTokenParams_Data>(index_);
    }
    TrustTokenParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  int32_t refresh_policy;
  int32_t sign_request_data;
  uint8_t include_timestamp_header : 1;
  uint8_t pad3_[3];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Origin_Data>>> issuers;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> additional_signed_headers;
  mojo::internal::Pointer<mojo::internal::String_Data> possibly_unsafe_additional_signing_data;

 private:
  TrustTokenParams_Data();
  ~TrustTokenParams_Data() = delete;
};
static_assert(sizeof(TrustTokenParams_Data) == 48,
              "Bad sizeof(TrustTokenParams_Data)");
// Used by TrustTokenParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TrustTokenParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TrustTokenParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TrustTokenParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    TrustTokenParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TrustTokenParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  HasTrustTokensResult_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(HasTrustTokensResult_Data));
      new (data()) HasTrustTokensResult_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    HasTrustTokensResult_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<HasTrustTokensResult_Data>(index_);
    }
    HasTrustTokensResult_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t has_trust_tokens : 1;
  uint8_t padfinal_[3];

 private:
  HasTrustTokensResult_Data();
  ~HasTrustTokensResult_Data() = delete;
};
static_assert(sizeof(HasTrustTokensResult_Data) == 16,
              "Bad sizeof(HasTrustTokensResult_Data)");
// Used by HasTrustTokensResult::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HasTrustTokensResult_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HasTrustTokensResult_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HasTrustTokensResult_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    HasTrustTokensResult_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HasTrustTokensResult_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TrustTokenVerificationKey_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TrustTokenVerificationKey_Data));
      new (data()) TrustTokenVerificationKey_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TrustTokenVerificationKey_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TrustTokenVerificationKey_Data>(index_);
    }
    TrustTokenVerificationKey_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> body;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> expiry;

 private:
  TrustTokenVerificationKey_Data();
  ~TrustTokenVerificationKey_Data() = delete;
};
static_assert(sizeof(TrustTokenVerificationKey_Data) == 24,
              "Bad sizeof(TrustTokenVerificationKey_Data)");
// Used by TrustTokenVerificationKey::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TrustTokenVerificationKey_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TrustTokenVerificationKey_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TrustTokenVerificationKey_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    TrustTokenVerificationKey_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TrustTokenVerificationKey_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TrustTokenKeyCommitmentResult_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TrustTokenKeyCommitmentResult_Data));
      new (data()) TrustTokenKeyCommitmentResult_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TrustTokenKeyCommitmentResult_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TrustTokenKeyCommitmentResult_Data>(index_);
    }
    TrustTokenKeyCommitmentResult_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t batch_size;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::TrustTokenVerificationKey_Data>>> keys;
  mojo::internal::Pointer<mojo::internal::String_Data> signed_redemption_record_verification_key;

 private:
  TrustTokenKeyCommitmentResult_Data();
  ~TrustTokenKeyCommitmentResult_Data() = delete;
};
static_assert(sizeof(TrustTokenKeyCommitmentResult_Data) == 32,
              "Bad sizeof(TrustTokenKeyCommitmentResult_Data)");
// Used by TrustTokenKeyCommitmentResult::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TrustTokenKeyCommitmentResult_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TrustTokenKeyCommitmentResult_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TrustTokenKeyCommitmentResult_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    TrustTokenKeyCommitmentResult_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TrustTokenKeyCommitmentResult_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_INTERNAL_H_