// services/viz/privileged/mojom/gl/gpu_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-forward.h"
#include "gpu/ipc/common/device_perf_info.mojom-forward.h"
#include "gpu/ipc/common/dx_diag_node.mojom-forward.h"
#include "gpu/ipc/common/gpu_info.mojom.h"
#include "gpu/ipc/common/gpu_peak_memory.mojom.h"
#include "gpu/ipc/common/memory_stats.mojom.h"
#include "gpu/ipc/common/surface_handle.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include "ui/gl/mojom/gpu_preference.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {

class GpuServiceProxy;

template <typename ImplRefTraits>
class GpuServiceStub;

class GpuServiceRequestValidator;
class GpuServiceResponseValidator;


class  GpuService
    : public GpuServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = GpuServiceInterfaceBase;
  using Proxy_ = GpuServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = GpuServiceStub<ImplRefTraits>;

  using RequestValidator_ = GpuServiceRequestValidator;
  using ResponseValidator_ = GpuServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEstablishGpuChannelMinVersion = 0,
    kCloseChannelMinVersion = 0,
    kCreateVideoEncodeAcceleratorProviderMinVersion = 0,
    kCreateGpuMemoryBufferMinVersion = 0,
    kDestroyGpuMemoryBufferMinVersion = 0,
    kGetVideoMemoryUsageStatsMinVersion = 0,
    kStartPeakMemoryMonitorMinVersion = 0,
    kGetPeakMemoryUsageMinVersion = 0,
    kRequestHDRStatusMinVersion = 0,
    kLoadedShaderMinVersion = 0,
    kWakeUpGpuMinVersion = 0,
    kGpuSwitchedMinVersion = 0,
    kDisplayAddedMinVersion = 0,
    kDisplayRemovedMinVersion = 0,
    kDestroyAllChannelsMinVersion = 0,
    kOnBackgroundCleanupMinVersion = 0,
    kOnBackgroundedMinVersion = 0,
    kOnForegroundedMinVersion = 0,
    kOnMemoryPressureMinVersion = 0,
    kCrashMinVersion = 0,
    kHangMinVersion = 0,
    kThrowJavaExceptionMinVersion = 0,
    kStopMinVersion = 0,
  };
  virtual ~GpuService() {}


  using EstablishGpuChannelCallback = base::OnceCallback<void(::mojo::ScopedMessagePipeHandle)>;
  
  virtual void EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool cache_shaders_on_disk, EstablishGpuChannelCallback callback) = 0;

  
  virtual void CloseChannel(int32_t client_id) = 0;

  
  virtual void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) = 0;


  using CreateGpuMemoryBufferCallback = base::OnceCallback<void(::gfx::GpuMemoryBufferHandle)>;
  
  virtual void CreateGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, int32_t client_id, ::gpu::SurfaceHandle surface_handle, CreateGpuMemoryBufferCallback callback) = 0;

  
  virtual void DestroyGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, int32_t client_id, const ::gpu::SyncToken& sync_token) = 0;


  using GetVideoMemoryUsageStatsCallback = base::OnceCallback<void(const ::gpu::VideoMemoryUsageStats&)>;
  
  virtual void GetVideoMemoryUsageStats(GetVideoMemoryUsageStatsCallback callback) = 0;

  
  virtual void StartPeakMemoryMonitor(uint32_t sequence_num) = 0;


  using GetPeakMemoryUsageCallback = base::OnceCallback<void(uint64_t, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>&)>;
  
  virtual void GetPeakMemoryUsage(uint32_t sequence_num, GetPeakMemoryUsageCallback callback) = 0;


  using RequestHDRStatusCallback = base::OnceCallback<void(bool)>;
  
  virtual void RequestHDRStatus(RequestHDRStatusCallback callback) = 0;

  
  virtual void LoadedShader(int32_t client_id, const std::string& key, const std::string& data) = 0;

  
  virtual void WakeUpGpu() = 0;

  
  virtual void GpuSwitched(::gl::GpuPreference active_gpu_heuristic) = 0;

  
  virtual void DisplayAdded() = 0;

  
  virtual void DisplayRemoved() = 0;

  
  virtual void DestroyAllChannels() = 0;

  
  virtual void OnBackgroundCleanup() = 0;

  
  virtual void OnBackgrounded() = 0;

  
  virtual void OnForegrounded() = 0;

  
  virtual void OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel level) = 0;

  
  virtual void Crash() = 0;

  
  virtual void Hang() = 0;

  
  virtual void ThrowJavaException() = 0;


  using StopCallback = base::OnceCallback<void()>;
  
  virtual void Stop(StopCallback callback) = 0;
};



class  GpuServiceProxy
    : public GpuService {
 public:
  using InterfaceType = GpuService;

  explicit GpuServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool cache_shaders_on_disk, EstablishGpuChannelCallback callback) final;
  
  void CloseChannel(int32_t client_id) final;
  
  void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) final;
  
  void CreateGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, int32_t client_id, ::gpu::SurfaceHandle surface_handle, CreateGpuMemoryBufferCallback callback) final;
  
  void DestroyGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, int32_t client_id, const ::gpu::SyncToken& sync_token) final;
  
  void GetVideoMemoryUsageStats(GetVideoMemoryUsageStatsCallback callback) final;
  
  void StartPeakMemoryMonitor(uint32_t sequence_num) final;
  
  void GetPeakMemoryUsage(uint32_t sequence_num, GetPeakMemoryUsageCallback callback) final;
  
  void RequestHDRStatus(RequestHDRStatusCallback callback) final;
  
  void LoadedShader(int32_t client_id, const std::string& key, const std::string& data) final;
  
  void WakeUpGpu() final;
  
  void GpuSwitched(::gl::GpuPreference active_gpu_heuristic) final;
  
  void DisplayAdded() final;
  
  void DisplayRemoved() final;
  
  void DestroyAllChannels() final;
  
  void OnBackgroundCleanup() final;
  
  void OnBackgrounded() final;
  
  void OnForegrounded() final;
  
  void OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel level) final;
  
  void Crash() final;
  
  void Hang() final;
  
  void ThrowJavaException() final;
  
  void Stop(StopCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GpuServiceStubDispatch {
 public:
  static bool Accept(GpuService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GpuService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GpuService>>
class GpuServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GpuServiceStub() {}
  ~GpuServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GpuServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GpuServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_H_