// skia/public/mojom/image_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_BLINK_H_
#define SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "skia/public/mojom/image_info_mojom_traits.h"




namespace WTF {
struct skia_mojom_internal_ColorType_DataHashFn {
  static unsigned GetHash(const ::skia::mojom::ColorType& value) {
    using utype = std::underlying_type<::skia::mojom::ColorType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::skia::mojom::ColorType& left, const ::skia::mojom::ColorType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::skia::mojom::ColorType>
    : public GenericHashTraits<::skia::mojom::ColorType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::skia::mojom::ColorType& value) {
    return value == static_cast<::skia::mojom::ColorType>(-1000000);
  }
  static void ConstructDeletedValue(::skia::mojom::ColorType& slot, bool) {
    slot = static_cast<::skia::mojom::ColorType>(-1000001);
  }
  static bool IsDeletedValue(const ::skia::mojom::ColorType& value) {
    return value == static_cast<::skia::mojom::ColorType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct skia_mojom_internal_AlphaType_DataHashFn {
  static unsigned GetHash(const ::skia::mojom::AlphaType& value) {
    using utype = std::underlying_type<::skia::mojom::AlphaType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::skia::mojom::AlphaType& left, const ::skia::mojom::AlphaType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::skia::mojom::AlphaType>
    : public GenericHashTraits<::skia::mojom::AlphaType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::skia::mojom::AlphaType& value) {
    return value == static_cast<::skia::mojom::AlphaType>(-1000000);
  }
  static void ConstructDeletedValue(::skia::mojom::AlphaType& slot, bool) {
    slot = static_cast<::skia::mojom::AlphaType>(-1000001);
  }
  static bool IsDeletedValue(const ::skia::mojom::AlphaType& value) {
    return value == static_cast<::skia::mojom::AlphaType>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace skia {
namespace mojom {
namespace blink {








class  ImageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImageInfo, T>::value>;
  using DataView = ImageInfoDataView;
  using Data_ = internal::ImageInfo_Data;

  template <typename... Args>
  static ImageInfoPtr New(Args&&... args) {
    return ImageInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImageInfoPtr From(const U& u) {
    return mojo::TypeConverter<ImageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImageInfo>::Convert(*this);
  }


  ImageInfo();

  ImageInfo(
      ColorType color_type,
      AlphaType alpha_type,
      uint32_t width,
      uint32_t height,
      base::Optional<WTF::Vector<float>> color_transfer_function,
      base::Optional<WTF::Vector<float>> color_to_xyz_matrix);

  ~ImageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImageInfoPtr>
  ImageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImageInfo_UnserializedMessageContext<
            UserType, ImageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ImageInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ImageInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImageInfo_UnserializedMessageContext<
            UserType, ImageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImageInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ColorType color_type;
  
  AlphaType alpha_type;
  
  uint32_t width;
  
  uint32_t height;
  
  base::Optional<WTF::Vector<float>> color_transfer_function;
  
  base::Optional<WTF::Vector<float>> color_to_xyz_matrix;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImageInfoPtr ImageInfo::Clone() const {
  return New(
      mojo::Clone(color_type),
      mojo::Clone(alpha_type),
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(color_transfer_function),
      mojo::Clone(color_to_xyz_matrix)
  );
}

template <typename T, ImageInfo::EnableIfSame<T>*>
bool ImageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color_type, other_struct.color_type))
    return false;
  if (!mojo::Equals(this->alpha_type, other_struct.alpha_type))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->color_transfer_function, other_struct.color_transfer_function))
    return false;
  if (!mojo::Equals(this->color_to_xyz_matrix, other_struct.color_to_xyz_matrix))
    return false;
  return true;
}

template <typename T, ImageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.color_type, rhs.color_type))
    return true;
  if (std::less<>{}(rhs.color_type, lhs.color_type))
    return false;
  if (std::less<>{}(lhs.alpha_type, rhs.alpha_type))
    return true;
  if (std::less<>{}(rhs.alpha_type, lhs.alpha_type))
    return false;
  if (std::less<>{}(lhs.width, rhs.width))
    return true;
  if (std::less<>{}(rhs.width, lhs.width))
    return false;
  if (std::less<>{}(lhs.height, rhs.height))
    return true;
  if (std::less<>{}(rhs.height, lhs.height))
    return false;
  if (std::less<>{}(lhs.color_transfer_function, rhs.color_transfer_function))
    return true;
  if (std::less<>{}(rhs.color_transfer_function, lhs.color_transfer_function))
    return false;
  if (std::less<>{}(lhs.color_to_xyz_matrix, rhs.color_to_xyz_matrix))
    return true;
  if (std::less<>{}(rhs.color_to_xyz_matrix, lhs.color_to_xyz_matrix))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace skia

namespace mojo {


template <>
struct  StructTraits<::skia::mojom::blink::ImageInfo::DataView,
                                         ::skia::mojom::blink::ImageInfoPtr> {
  static bool IsNull(const ::skia::mojom::blink::ImageInfoPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::blink::ImageInfoPtr* output) { output->reset(); }

  static decltype(::skia::mojom::blink::ImageInfo::color_type) color_type(
      const ::skia::mojom::blink::ImageInfoPtr& input) {
    return input->color_type;
  }

  static decltype(::skia::mojom::blink::ImageInfo::alpha_type) alpha_type(
      const ::skia::mojom::blink::ImageInfoPtr& input) {
    return input->alpha_type;
  }

  static decltype(::skia::mojom::blink::ImageInfo::width) width(
      const ::skia::mojom::blink::ImageInfoPtr& input) {
    return input->width;
  }

  static decltype(::skia::mojom::blink::ImageInfo::height) height(
      const ::skia::mojom::blink::ImageInfoPtr& input) {
    return input->height;
  }

  static const decltype(::skia::mojom::blink::ImageInfo::color_transfer_function)& color_transfer_function(
      const ::skia::mojom::blink::ImageInfoPtr& input) {
    return input->color_transfer_function;
  }

  static const decltype(::skia::mojom::blink::ImageInfo::color_to_xyz_matrix)& color_to_xyz_matrix(
      const ::skia::mojom::blink::ImageInfoPtr& input) {
    return input->color_to_xyz_matrix;
  }

  static bool Read(::skia::mojom::blink::ImageInfo::DataView input, ::skia::mojom::blink::ImageInfoPtr* output);
};

}  // namespace mojo

#endif  // SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_BLINK_H_