// third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class AffectedCookieDataView;

class AffectedRequestDataView;

class AffectedFrameDataView;

class BlockedByResponseIssueDetailsDataView;

class MixedContentIssueDetailsDataView;

class ContentSecurityPolicyIssueDetailsDataView;

class SameSiteCookieIssueDetailsDataView;

class InspectorIssueDetailsDataView;

class InspectorIssueInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AffectedCookieDataView> {
  using Data = ::blink::mojom::internal::AffectedCookie_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AffectedRequestDataView> {
  using Data = ::blink::mojom::internal::AffectedRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AffectedFrameDataView> {
  using Data = ::blink::mojom::internal::AffectedFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BlockedByResponseIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::BlockedByResponseIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MixedContentIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::MixedContentIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::ContentSecurityPolicyIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SameSiteCookieIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::SameSiteCookieIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InspectorIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::InspectorIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InspectorIssueInfoDataView> {
  using Data = ::blink::mojom::internal::InspectorIssueInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class InspectorIssueCode : int32_t {
  
  kSameSiteCookieIssue = 0,
  
  kMixedContentIssue = 1,
  
  kBlockedByResponseIssue = 2,
  
  kContentSecurityPolicyIssue = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, InspectorIssueCode value);
inline bool IsKnownEnumValue(InspectorIssueCode value) {
  return internal::InspectorIssueCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HeavyAdResolutionStatus : int32_t {
  
  kHeavyAdBlocked = 0,
  
  kHeavyAdWarning = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HeavyAdResolutionStatus value);
inline bool IsKnownEnumValue(HeavyAdResolutionStatus value) {
  return internal::HeavyAdResolutionStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HeavyAdReason : int32_t {
  
  kNetworkTotalLimit = 0,
  
  kCpuTotalLimit = 1,
  
  kCpuPeakLimit = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HeavyAdReason value);
inline bool IsKnownEnumValue(HeavyAdReason value) {
  return internal::HeavyAdReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MixedContentResolutionStatus : int32_t {
  
  kMixedContentBlocked = 0,
  
  kMixedContentAutomaticallyUpgraded = 1,
  
  kMixedContentWarning = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MixedContentResolutionStatus value);
inline bool IsKnownEnumValue(MixedContentResolutionStatus value) {
  return internal::MixedContentResolutionStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContentSecurityPolicyViolationType : int32_t {
  
  kInlineViolation = 0,
  
  kEvalViolation = 1,
  
  kURLViolation = 2,
  
  kTrustedTypesSinkViolation = 3,
  
  kTrustedTypesPolicyViolation = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyViolationType value);
inline bool IsKnownEnumValue(ContentSecurityPolicyViolationType value) {
  return internal::ContentSecurityPolicyViolationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SameSiteCookieOperation : int32_t {
  
  kSetCookie = 0,
  
  kReadCookie = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SameSiteCookieOperation value);
inline bool IsKnownEnumValue(SameSiteCookieOperation value) {
  return internal::SameSiteCookieOperation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SameSiteCookieExclusionReason : int32_t {
  
  kExcludeSameSiteUnspecifiedTreatedAsLax = 0,
  
  kExcludeSameSiteNoneInsecure = 1,
  
  kExcludeSameSiteLax = 2,
  
  kExcludeSameSiteStrict = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SameSiteCookieExclusionReason value);
inline bool IsKnownEnumValue(SameSiteCookieExclusionReason value) {
  return internal::SameSiteCookieExclusionReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SameSiteCookieWarningReason : int32_t {
  
  kWarnSameSiteUnspecifiedCrossSiteContext = 0,
  
  kWarnSameSiteNoneInsecure = 1,
  
  kWarnSameSiteUnspecifiedLaxAllowUnsafe = 2,
  
  kWarnSameSiteStrictLaxDowngradeStrict = 3,
  
  kWarnSameSiteStrictCrossDowngradeStrict = 4,
  
  kWarnSameSiteStrictCrossDowngradeLax = 5,
  
  kWarnSameSiteLaxCrossDowngradeStrict = 6,
  
  kWarnSameSiteLaxCrossDowngradeLax = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SameSiteCookieWarningReason value);
inline bool IsKnownEnumValue(SameSiteCookieWarningReason value) {
  return internal::SameSiteCookieWarningReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AffectedCookieDataView {
 public:
  AffectedCookieDataView() {}

  AffectedCookieDataView(
      internal::AffectedCookie_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::AffectedCookie_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class AffectedRequestDataView {
 public:
  AffectedRequestDataView() {}

  AffectedRequestDataView(
      internal::AffectedRequest_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestId(UserType* output) {
    
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::AffectedRequest_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class AffectedFrameDataView {
 public:
  AffectedFrameDataView() {}

  AffectedFrameDataView(
      internal::AffectedFrame_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFrameIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameId(UserType* output) {
    
    auto* pointer = data_->frame_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::AffectedFrame_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BlockedByResponseIssueDetailsDataView {
 public:
  BlockedByResponseIssueDetailsDataView() {}

  BlockedByResponseIssueDetailsDataView(
      internal::BlockedByResponseIssueDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      AffectedRequestDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedRequestDataView>(
        pointer, output, context_);
  }
  inline void GetParentFrameDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParentFrame(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedFrameDataView, UserType>(),
    "Attempting to read the optional `parentFrame` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentFrame` instead "
    "of `ReadParentFrame if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parentFrame.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, context_);
  }
  inline void GetBlockedFrameDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlockedFrame(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedFrameDataView, UserType>(),
    "Attempting to read the optional `blockedFrame` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlockedFrame` instead "
    "of `ReadBlockedFrame if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blockedFrame.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::network::mojom::BlockedByResponseReason>(
        data_value, output);
  }

  ::network::mojom::BlockedByResponseReason reason() const {
    return static_cast<::network::mojom::BlockedByResponseReason>(data_->reason);
  }
 private:
  internal::BlockedByResponseIssueDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MixedContentIssueDetailsDataView {
 public:
  MixedContentIssueDetailsDataView() {}

  MixedContentIssueDetailsDataView(
      internal::MixedContentIssueDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestContext(UserType* output) const {
    auto data_value = data_->request_context;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextType>(
        data_value, output);
  }

  ::blink::mojom::RequestContextType request_context() const {
    return static_cast<::blink::mojom::RequestContextType>(data_->request_context);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResolutionStatus(UserType* output) const {
    auto data_value = data_->resolution_status;
    return mojo::internal::Deserialize<::blink::mojom::MixedContentResolutionStatus>(
        data_value, output);
  }

  MixedContentResolutionStatus resolution_status() const {
    return static_cast<MixedContentResolutionStatus>(data_->resolution_status);
  }
  inline void GetInsecureUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInsecureUrl(UserType* output) {
    
    auto* pointer = data_->insecure_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetMainResourceUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMainResourceUrl(UserType* output) {
    
    auto* pointer = data_->main_resource_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetRequestDataView(
      AffectedRequestDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedRequestDataView, UserType>(),
    "Attempting to read the optional `request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequest` instead "
    "of `ReadRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedRequestDataView>(
        pointer, output, context_);
  }
  inline void GetFrameDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrame(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedFrameDataView, UserType>(),
    "Attempting to read the optional `frame` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrame` instead "
    "of `ReadFrame if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, context_);
  }
 private:
  internal::MixedContentIssueDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ContentSecurityPolicyIssueDetailsDataView {
 public:
  ContentSecurityPolicyIssueDetailsDataView() {}

  ContentSecurityPolicyIssueDetailsDataView(
      internal::ContentSecurityPolicyIssueDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBlockedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlockedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `blocked_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlockedUrl` instead "
    "of `ReadBlockedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blocked_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetViolatedDirectiveDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViolatedDirective(UserType* output) {
    
    auto* pointer = data_->violated_directive.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentSecurityPolicyViolationType(UserType* output) const {
    auto data_value = data_->content_security_policy_violation_type;
    return mojo::internal::Deserialize<::blink::mojom::ContentSecurityPolicyViolationType>(
        data_value, output);
  }

  ContentSecurityPolicyViolationType content_security_policy_violation_type() const {
    return static_cast<ContentSecurityPolicyViolationType>(data_->content_security_policy_violation_type);
  }
  inline void GetFrameAncestorDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameAncestor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedFrameDataView, UserType>(),
    "Attempting to read the optional `frame_ancestor` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameAncestor` instead "
    "of `ReadFrameAncestor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_ancestor.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, context_);
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceLocation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::SourceLocationDataView, UserType>(),
    "Attempting to read the optional `source_location` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceLocation` instead "
    "of `ReadSourceLocation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, context_);
  }
  int32_t violating_node_id() const {
    return data_->violating_node_id;
  }
 private:
  internal::ContentSecurityPolicyIssueDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SameSiteCookieIssueDetailsDataView {
 public:
  SameSiteCookieIssueDetailsDataView() {}

  SameSiteCookieIssueDetailsDataView(
      internal::SameSiteCookieIssueDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      AffectedCookieDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedCookieDataView>(
        pointer, output, context_);
  }
  inline void GetExclusionReasonDataView(
      mojo::ArrayDataView<SameSiteCookieExclusionReason>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExclusionReason(UserType* output) {
    
    auto* pointer = data_->exclusion_reason.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SameSiteCookieExclusionReason>>(
        pointer, output, context_);
  }
  inline void GetWarningReasonDataView(
      mojo::ArrayDataView<SameSiteCookieWarningReason>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWarningReason(UserType* output) {
    
    auto* pointer = data_->warning_reason.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SameSiteCookieWarningReason>>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::blink::mojom::SameSiteCookieOperation>(
        data_value, output);
  }

  SameSiteCookieOperation operation() const {
    return static_cast<SameSiteCookieOperation>(data_->operation);
  }
  inline void GetSiteForCookiesDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSiteForCookies(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `site_for_cookies` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSiteForCookies` instead "
    "of `ReadSiteForCookies if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetCookieUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookieUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `cookie_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieUrl` instead "
    "of `ReadCookieUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetRequestDataView(
      AffectedRequestDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedRequestDataView, UserType>(),
    "Attempting to read the optional `request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequest` instead "
    "of `ReadRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedRequestDataView>(
        pointer, output, context_);
  }
 private:
  internal::SameSiteCookieIssueDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class InspectorIssueDetailsDataView {
 public:
  InspectorIssueDetailsDataView() {}

  InspectorIssueDetailsDataView(
      internal::InspectorIssueDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSamesiteCookieIssueDetailsDataView(
      SameSiteCookieIssueDetailsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSamesiteCookieIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SameSiteCookieIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `samesite_cookie_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSamesiteCookieIssueDetails` instead "
    "of `ReadSamesiteCookieIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->samesite_cookie_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::SameSiteCookieIssueDetailsDataView>(
        pointer, output, context_);
  }
  inline void GetMixedContentIssueDetailsDataView(
      MixedContentIssueDetailsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMixedContentIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MixedContentIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `mixed_content_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMixedContentIssueDetails` instead "
    "of `ReadMixedContentIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mixed_content_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::MixedContentIssueDetailsDataView>(
        pointer, output, context_);
  }
  inline void GetBlockedByResponseIssueDetailsDataView(
      BlockedByResponseIssueDetailsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlockedByResponseIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::BlockedByResponseIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `blocked_by_response_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlockedByResponseIssueDetails` instead "
    "of `ReadBlockedByResponseIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blocked_by_response_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::BlockedByResponseIssueDetailsDataView>(
        pointer, output, context_);
  }
  inline void GetCspIssueDetailsDataView(
      ContentSecurityPolicyIssueDetailsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCspIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ContentSecurityPolicyIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `csp_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCspIssueDetails` instead "
    "of `ReadCspIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->csp_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView>(
        pointer, output, context_);
  }
 private:
  internal::InspectorIssueDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class InspectorIssueInfoDataView {
 public:
  InspectorIssueInfoDataView() {}

  InspectorIssueInfoDataView(
      internal::InspectorIssueInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCode(UserType* output) const {
    auto data_value = data_->code;
    return mojo::internal::Deserialize<::blink::mojom::InspectorIssueCode>(
        data_value, output);
  }

  InspectorIssueCode code() const {
    return static_cast<InspectorIssueCode>(data_->code);
  }
  inline void GetDetailsDataView(
      InspectorIssueDetailsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<::blink::mojom::InspectorIssueDetailsDataView>(
        pointer, output, context_);
  }
 private:
  internal::InspectorIssueInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::InspectorIssueCode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::InspectorIssueCode> {};

template <>
struct hash<::blink::mojom::HeavyAdResolutionStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::HeavyAdResolutionStatus> {};

template <>
struct hash<::blink::mojom::HeavyAdReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::HeavyAdReason> {};

template <>
struct hash<::blink::mojom::MixedContentResolutionStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MixedContentResolutionStatus> {};

template <>
struct hash<::blink::mojom::ContentSecurityPolicyViolationType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ContentSecurityPolicyViolationType> {};

template <>
struct hash<::blink::mojom::SameSiteCookieOperation>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SameSiteCookieOperation> {};

template <>
struct hash<::blink::mojom::SameSiteCookieExclusionReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SameSiteCookieExclusionReason> {};

template <>
struct hash<::blink::mojom::SameSiteCookieWarningReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SameSiteCookieWarningReason> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::InspectorIssueCode, ::blink::mojom::InspectorIssueCode> {
  static ::blink::mojom::InspectorIssueCode ToMojom(::blink::mojom::InspectorIssueCode input) { return input; }
  static bool FromMojom(::blink::mojom::InspectorIssueCode input, ::blink::mojom::InspectorIssueCode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InspectorIssueCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::InspectorIssueCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::InspectorIssueCode>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::HeavyAdResolutionStatus, ::blink::mojom::HeavyAdResolutionStatus> {
  static ::blink::mojom::HeavyAdResolutionStatus ToMojom(::blink::mojom::HeavyAdResolutionStatus input) { return input; }
  static bool FromMojom(::blink::mojom::HeavyAdResolutionStatus input, ::blink::mojom::HeavyAdResolutionStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HeavyAdResolutionStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::HeavyAdResolutionStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::HeavyAdResolutionStatus>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::HeavyAdReason, ::blink::mojom::HeavyAdReason> {
  static ::blink::mojom::HeavyAdReason ToMojom(::blink::mojom::HeavyAdReason input) { return input; }
  static bool FromMojom(::blink::mojom::HeavyAdReason input, ::blink::mojom::HeavyAdReason* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HeavyAdReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::HeavyAdReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::HeavyAdReason>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::MixedContentResolutionStatus, ::blink::mojom::MixedContentResolutionStatus> {
  static ::blink::mojom::MixedContentResolutionStatus ToMojom(::blink::mojom::MixedContentResolutionStatus input) { return input; }
  static bool FromMojom(::blink::mojom::MixedContentResolutionStatus input, ::blink::mojom::MixedContentResolutionStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MixedContentResolutionStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MixedContentResolutionStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::MixedContentResolutionStatus>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::ContentSecurityPolicyViolationType, ::blink::mojom::ContentSecurityPolicyViolationType> {
  static ::blink::mojom::ContentSecurityPolicyViolationType ToMojom(::blink::mojom::ContentSecurityPolicyViolationType input) { return input; }
  static bool FromMojom(::blink::mojom::ContentSecurityPolicyViolationType input, ::blink::mojom::ContentSecurityPolicyViolationType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContentSecurityPolicyViolationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ContentSecurityPolicyViolationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::ContentSecurityPolicyViolationType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::SameSiteCookieOperation, ::blink::mojom::SameSiteCookieOperation> {
  static ::blink::mojom::SameSiteCookieOperation ToMojom(::blink::mojom::SameSiteCookieOperation input) { return input; }
  static bool FromMojom(::blink::mojom::SameSiteCookieOperation input, ::blink::mojom::SameSiteCookieOperation* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SameSiteCookieOperation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SameSiteCookieOperation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::SameSiteCookieOperation>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::SameSiteCookieExclusionReason, ::blink::mojom::SameSiteCookieExclusionReason> {
  static ::blink::mojom::SameSiteCookieExclusionReason ToMojom(::blink::mojom::SameSiteCookieExclusionReason input) { return input; }
  static bool FromMojom(::blink::mojom::SameSiteCookieExclusionReason input, ::blink::mojom::SameSiteCookieExclusionReason* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SameSiteCookieExclusionReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SameSiteCookieExclusionReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::SameSiteCookieExclusionReason>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::SameSiteCookieWarningReason, ::blink::mojom::SameSiteCookieWarningReason> {
  static ::blink::mojom::SameSiteCookieWarningReason ToMojom(::blink::mojom::SameSiteCookieWarningReason input) { return input; }
  static bool FromMojom(::blink::mojom::SameSiteCookieWarningReason input, ::blink::mojom::SameSiteCookieWarningReason* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SameSiteCookieWarningReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SameSiteCookieWarningReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::SameSiteCookieWarningReason>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AffectedCookieDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AffectedCookieDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::AffectedCookie_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in AffectedCookie struct");
    decltype(Traits::path(input)) in_path = Traits::path(input);
    typename decltype((*output)->path)::BaseType::BufferWriter
        path_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_path, buffer, &path_writer, context);
    (*output)->path.Set(
        path_writer.is_null() ? nullptr : path_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in AffectedCookie struct");
    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    typename decltype((*output)->domain)::BaseType::BufferWriter
        domain_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_domain, buffer, &domain_writer, context);
    (*output)->domain.Set(
        domain_writer.is_null() ? nullptr : domain_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->domain.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain in AffectedCookie struct");
  }

  static bool Deserialize(::blink::mojom::internal::AffectedCookie_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AffectedCookieDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AffectedRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AffectedRequestDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::AffectedRequest_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::request_id(input)) in_request_id = Traits::request_id(input);
    typename decltype((*output)->request_id)::BaseType::BufferWriter
        request_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_request_id, buffer, &request_id_writer, context);
    (*output)->request_id.Set(
        request_id_writer.is_null() ? nullptr : request_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->request_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_id in AffectedRequest struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::AffectedRequest_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AffectedRequestDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AffectedFrameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AffectedFrameDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::AffectedFrame_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::frame_id(input)) in_frame_id = Traits::frame_id(input);
    typename decltype((*output)->frame_id)::BaseType::BufferWriter
        frame_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_frame_id, buffer, &frame_id_writer, context);
    (*output)->frame_id.Set(
        frame_id_writer.is_null() ? nullptr : frame_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->frame_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_id in AffectedFrame struct");
  }

  static bool Deserialize(::blink::mojom::internal::AffectedFrame_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AffectedFrameDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BlockedByResponseIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BlockedByResponseIssueDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::BlockedByResponseIssueDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::request(input)) in_request = Traits::request(input);
    typename decltype((*output)->request)::BaseType::BufferWriter
        request_writer;
    mojo::internal::Serialize<::blink::mojom::AffectedRequestDataView>(
        in_request, buffer, &request_writer, context);
    (*output)->request.Set(
        request_writer.is_null() ? nullptr : request_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->request.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request in BlockedByResponseIssueDetails struct");
    decltype(Traits::parentFrame(input)) in_parentFrame = Traits::parentFrame(input);
    typename decltype((*output)->parentFrame)::BaseType::BufferWriter
        parentFrame_writer;
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
        in_parentFrame, buffer, &parentFrame_writer, context);
    (*output)->parentFrame.Set(
        parentFrame_writer.is_null() ? nullptr : parentFrame_writer.data());
    decltype(Traits::blockedFrame(input)) in_blockedFrame = Traits::blockedFrame(input);
    typename decltype((*output)->blockedFrame)::BaseType::BufferWriter
        blockedFrame_writer;
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
        in_blockedFrame, buffer, &blockedFrame_writer, context);
    (*output)->blockedFrame.Set(
        blockedFrame_writer.is_null() ? nullptr : blockedFrame_writer.data());
    mojo::internal::Serialize<::network::mojom::BlockedByResponseReason>(
        Traits::reason(input), &(*output)->reason);
  }

  static bool Deserialize(::blink::mojom::internal::BlockedByResponseIssueDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BlockedByResponseIssueDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MixedContentIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MixedContentIssueDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::MixedContentIssueDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::RequestContextType>(
        Traits::request_context(input), &(*output)->request_context);
    mojo::internal::Serialize<::blink::mojom::MixedContentResolutionStatus>(
        Traits::resolution_status(input), &(*output)->resolution_status);
    decltype(Traits::insecure_url(input)) in_insecure_url = Traits::insecure_url(input);
    typename decltype((*output)->insecure_url)::BaseType::BufferWriter
        insecure_url_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_insecure_url, buffer, &insecure_url_writer, context);
    (*output)->insecure_url.Set(
        insecure_url_writer.is_null() ? nullptr : insecure_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->insecure_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null insecure_url in MixedContentIssueDetails struct");
    decltype(Traits::main_resource_url(input)) in_main_resource_url = Traits::main_resource_url(input);
    typename decltype((*output)->main_resource_url)::BaseType::BufferWriter
        main_resource_url_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_main_resource_url, buffer, &main_resource_url_writer, context);
    (*output)->main_resource_url.Set(
        main_resource_url_writer.is_null() ? nullptr : main_resource_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->main_resource_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_resource_url in MixedContentIssueDetails struct");
    decltype(Traits::request(input)) in_request = Traits::request(input);
    typename decltype((*output)->request)::BaseType::BufferWriter
        request_writer;
    mojo::internal::Serialize<::blink::mojom::AffectedRequestDataView>(
        in_request, buffer, &request_writer, context);
    (*output)->request.Set(
        request_writer.is_null() ? nullptr : request_writer.data());
    decltype(Traits::frame(input)) in_frame = Traits::frame(input);
    typename decltype((*output)->frame)::BaseType::BufferWriter
        frame_writer;
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
        in_frame, buffer, &frame_writer, context);
    (*output)->frame.Set(
        frame_writer.is_null() ? nullptr : frame_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::MixedContentIssueDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MixedContentIssueDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ContentSecurityPolicyIssueDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::blocked_url(input)) in_blocked_url = Traits::blocked_url(input);
    typename decltype((*output)->blocked_url)::BaseType::BufferWriter
        blocked_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_blocked_url, buffer, &blocked_url_writer, context);
    (*output)->blocked_url.Set(
        blocked_url_writer.is_null() ? nullptr : blocked_url_writer.data());
    decltype(Traits::violated_directive(input)) in_violated_directive = Traits::violated_directive(input);
    typename decltype((*output)->violated_directive)::BaseType::BufferWriter
        violated_directive_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_violated_directive, buffer, &violated_directive_writer, context);
    (*output)->violated_directive.Set(
        violated_directive_writer.is_null() ? nullptr : violated_directive_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->violated_directive.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null violated_directive in ContentSecurityPolicyIssueDetails struct");
    mojo::internal::Serialize<::blink::mojom::ContentSecurityPolicyViolationType>(
        Traits::content_security_policy_violation_type(input), &(*output)->content_security_policy_violation_type);
    decltype(Traits::frame_ancestor(input)) in_frame_ancestor = Traits::frame_ancestor(input);
    typename decltype((*output)->frame_ancestor)::BaseType::BufferWriter
        frame_ancestor_writer;
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
        in_frame_ancestor, buffer, &frame_ancestor_writer, context);
    (*output)->frame_ancestor.Set(
        frame_ancestor_writer.is_null() ? nullptr : frame_ancestor_writer.data());
    decltype(Traits::source_location(input)) in_source_location = Traits::source_location(input);
    typename decltype((*output)->source_location)::BaseType::BufferWriter
        source_location_writer;
    mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
        in_source_location, buffer, &source_location_writer, context);
    (*output)->source_location.Set(
        source_location_writer.is_null() ? nullptr : source_location_writer.data());
    (*output)->violating_node_id = Traits::violating_node_id(input);
  }

  static bool Deserialize(::blink::mojom::internal::ContentSecurityPolicyIssueDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ContentSecurityPolicyIssueDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SameSiteCookieIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SameSiteCookieIssueDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SameSiteCookieIssueDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
    typename decltype((*output)->cookie)::BaseType::BufferWriter
        cookie_writer;
    mojo::internal::Serialize<::blink::mojom::AffectedCookieDataView>(
        in_cookie, buffer, &cookie_writer, context);
    (*output)->cookie.Set(
        cookie_writer.is_null() ? nullptr : cookie_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cookie.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie in SameSiteCookieIssueDetails struct");
    decltype(Traits::exclusion_reason(input)) in_exclusion_reason = Traits::exclusion_reason(input);
    typename decltype((*output)->exclusion_reason)::BaseType::BufferWriter
        exclusion_reason_writer;
    const mojo::internal::ContainerValidateParams exclusion_reason_validate_params(
        0, ::blink::mojom::internal::SameSiteCookieExclusionReason_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SameSiteCookieExclusionReason>>(
        in_exclusion_reason, buffer, &exclusion_reason_writer, &exclusion_reason_validate_params,
        context);
    (*output)->exclusion_reason.Set(
        exclusion_reason_writer.is_null() ? nullptr : exclusion_reason_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->exclusion_reason.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null exclusion_reason in SameSiteCookieIssueDetails struct");
    decltype(Traits::warning_reason(input)) in_warning_reason = Traits::warning_reason(input);
    typename decltype((*output)->warning_reason)::BaseType::BufferWriter
        warning_reason_writer;
    const mojo::internal::ContainerValidateParams warning_reason_validate_params(
        0, ::blink::mojom::internal::SameSiteCookieWarningReason_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SameSiteCookieWarningReason>>(
        in_warning_reason, buffer, &warning_reason_writer, &warning_reason_validate_params,
        context);
    (*output)->warning_reason.Set(
        warning_reason_writer.is_null() ? nullptr : warning_reason_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->warning_reason.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null warning_reason in SameSiteCookieIssueDetails struct");
    mojo::internal::Serialize<::blink::mojom::SameSiteCookieOperation>(
        Traits::operation(input), &(*output)->operation);
    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    typename decltype((*output)->site_for_cookies)::BaseType::BufferWriter
        site_for_cookies_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_site_for_cookies, buffer, &site_for_cookies_writer, context);
    (*output)->site_for_cookies.Set(
        site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
    decltype(Traits::cookie_url(input)) in_cookie_url = Traits::cookie_url(input);
    typename decltype((*output)->cookie_url)::BaseType::BufferWriter
        cookie_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_cookie_url, buffer, &cookie_url_writer, context);
    (*output)->cookie_url.Set(
        cookie_url_writer.is_null() ? nullptr : cookie_url_writer.data());
    decltype(Traits::request(input)) in_request = Traits::request(input);
    typename decltype((*output)->request)::BaseType::BufferWriter
        request_writer;
    mojo::internal::Serialize<::blink::mojom::AffectedRequestDataView>(
        in_request, buffer, &request_writer, context);
    (*output)->request.Set(
        request_writer.is_null() ? nullptr : request_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::SameSiteCookieIssueDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SameSiteCookieIssueDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InspectorIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InspectorIssueDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::InspectorIssueDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::samesite_cookie_issue_details(input)) in_samesite_cookie_issue_details = Traits::samesite_cookie_issue_details(input);
    typename decltype((*output)->samesite_cookie_issue_details)::BaseType::BufferWriter
        samesite_cookie_issue_details_writer;
    mojo::internal::Serialize<::blink::mojom::SameSiteCookieIssueDetailsDataView>(
        in_samesite_cookie_issue_details, buffer, &samesite_cookie_issue_details_writer, context);
    (*output)->samesite_cookie_issue_details.Set(
        samesite_cookie_issue_details_writer.is_null() ? nullptr : samesite_cookie_issue_details_writer.data());
    decltype(Traits::mixed_content_issue_details(input)) in_mixed_content_issue_details = Traits::mixed_content_issue_details(input);
    typename decltype((*output)->mixed_content_issue_details)::BaseType::BufferWriter
        mixed_content_issue_details_writer;
    mojo::internal::Serialize<::blink::mojom::MixedContentIssueDetailsDataView>(
        in_mixed_content_issue_details, buffer, &mixed_content_issue_details_writer, context);
    (*output)->mixed_content_issue_details.Set(
        mixed_content_issue_details_writer.is_null() ? nullptr : mixed_content_issue_details_writer.data());
    decltype(Traits::blocked_by_response_issue_details(input)) in_blocked_by_response_issue_details = Traits::blocked_by_response_issue_details(input);
    typename decltype((*output)->blocked_by_response_issue_details)::BaseType::BufferWriter
        blocked_by_response_issue_details_writer;
    mojo::internal::Serialize<::blink::mojom::BlockedByResponseIssueDetailsDataView>(
        in_blocked_by_response_issue_details, buffer, &blocked_by_response_issue_details_writer, context);
    (*output)->blocked_by_response_issue_details.Set(
        blocked_by_response_issue_details_writer.is_null() ? nullptr : blocked_by_response_issue_details_writer.data());
    decltype(Traits::csp_issue_details(input)) in_csp_issue_details = Traits::csp_issue_details(input);
    typename decltype((*output)->csp_issue_details)::BaseType::BufferWriter
        csp_issue_details_writer;
    mojo::internal::Serialize<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView>(
        in_csp_issue_details, buffer, &csp_issue_details_writer, context);
    (*output)->csp_issue_details.Set(
        csp_issue_details_writer.is_null() ? nullptr : csp_issue_details_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::InspectorIssueDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InspectorIssueDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InspectorIssueInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InspectorIssueInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::InspectorIssueInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::InspectorIssueCode>(
        Traits::code(input), &(*output)->code);
    decltype(Traits::details(input)) in_details = Traits::details(input);
    typename decltype((*output)->details)::BaseType::BufferWriter
        details_writer;
    mojo::internal::Serialize<::blink::mojom::InspectorIssueDetailsDataView>(
        in_details, buffer, &details_writer, context);
    (*output)->details.Set(
        details_writer.is_null() ? nullptr : details_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->details.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null details in InspectorIssueInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::InspectorIssueInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InspectorIssueInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void AffectedCookieDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AffectedCookieDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AffectedCookieDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void AffectedRequestDataView::GetRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AffectedRequestDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void AffectedFrameDataView::GetFrameIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->frame_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void BlockedByResponseIssueDetailsDataView::GetRequestDataView(
    AffectedRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = AffectedRequestDataView(pointer, context_);
}
inline void BlockedByResponseIssueDetailsDataView::GetParentFrameDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->parentFrame.Get();
  *output = AffectedFrameDataView(pointer, context_);
}
inline void BlockedByResponseIssueDetailsDataView::GetBlockedFrameDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->blockedFrame.Get();
  *output = AffectedFrameDataView(pointer, context_);
}


inline void MixedContentIssueDetailsDataView::GetInsecureUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->insecure_url.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void MixedContentIssueDetailsDataView::GetMainResourceUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->main_resource_url.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void MixedContentIssueDetailsDataView::GetRequestDataView(
    AffectedRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = AffectedRequestDataView(pointer, context_);
}
inline void MixedContentIssueDetailsDataView::GetFrameDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->frame.Get();
  *output = AffectedFrameDataView(pointer, context_);
}


inline void ContentSecurityPolicyIssueDetailsDataView::GetBlockedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->blocked_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void ContentSecurityPolicyIssueDetailsDataView::GetViolatedDirectiveDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->violated_directive.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ContentSecurityPolicyIssueDetailsDataView::GetFrameAncestorDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->frame_ancestor.Get();
  *output = AffectedFrameDataView(pointer, context_);
}
inline void ContentSecurityPolicyIssueDetailsDataView::GetSourceLocationDataView(
    ::network::mojom::SourceLocationDataView* output) {
  auto pointer = data_->source_location.Get();
  *output = ::network::mojom::SourceLocationDataView(pointer, context_);
}


inline void SameSiteCookieIssueDetailsDataView::GetCookieDataView(
    AffectedCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = AffectedCookieDataView(pointer, context_);
}
inline void SameSiteCookieIssueDetailsDataView::GetExclusionReasonDataView(
    mojo::ArrayDataView<SameSiteCookieExclusionReason>* output) {
  auto pointer = data_->exclusion_reason.Get();
  *output = mojo::ArrayDataView<SameSiteCookieExclusionReason>(pointer, context_);
}
inline void SameSiteCookieIssueDetailsDataView::GetWarningReasonDataView(
    mojo::ArrayDataView<SameSiteCookieWarningReason>* output) {
  auto pointer = data_->warning_reason.Get();
  *output = mojo::ArrayDataView<SameSiteCookieWarningReason>(pointer, context_);
}
inline void SameSiteCookieIssueDetailsDataView::GetSiteForCookiesDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void SameSiteCookieIssueDetailsDataView::GetCookieUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->cookie_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void SameSiteCookieIssueDetailsDataView::GetRequestDataView(
    AffectedRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = AffectedRequestDataView(pointer, context_);
}


inline void InspectorIssueDetailsDataView::GetSamesiteCookieIssueDetailsDataView(
    SameSiteCookieIssueDetailsDataView* output) {
  auto pointer = data_->samesite_cookie_issue_details.Get();
  *output = SameSiteCookieIssueDetailsDataView(pointer, context_);
}
inline void InspectorIssueDetailsDataView::GetMixedContentIssueDetailsDataView(
    MixedContentIssueDetailsDataView* output) {
  auto pointer = data_->mixed_content_issue_details.Get();
  *output = MixedContentIssueDetailsDataView(pointer, context_);
}
inline void InspectorIssueDetailsDataView::GetBlockedByResponseIssueDetailsDataView(
    BlockedByResponseIssueDetailsDataView* output) {
  auto pointer = data_->blocked_by_response_issue_details.Get();
  *output = BlockedByResponseIssueDetailsDataView(pointer, context_);
}
inline void InspectorIssueDetailsDataView::GetCspIssueDetailsDataView(
    ContentSecurityPolicyIssueDetailsDataView* output) {
  auto pointer = data_->csp_issue_details.Get();
  *output = ContentSecurityPolicyIssueDetailsDataView(pointer, context_);
}


inline void InspectorIssueInfoDataView::GetDetailsDataView(
    InspectorIssueDetailsDataView* output) {
  auto pointer = data_->details.Get();
  *output = InspectorIssueDetailsDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_SHARED_H_