// third_party/blink/public/mojom/file_system_access/native_file_system_error.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_ERROR_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_ERROR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_error.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class NativeFileSystemErrorDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::NativeFileSystemErrorDataView> {
  using Data = ::blink::mojom::internal::NativeFileSystemError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class NativeFileSystemStatus : int32_t {
  
  kOk = 0,
  
  kPermissionDenied = 1,
  
  kSecurityError = 2,
  
  kInvalidState = 3,
  
  kInvalidArgument = 4,
  
  kOperationFailed = 5,
  
  kOperationAborted = 6,
  
  kFileError = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NativeFileSystemStatus value);
inline bool IsKnownEnumValue(NativeFileSystemStatus value) {
  return internal::NativeFileSystemStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class NativeFileSystemErrorDataView {
 public:
  NativeFileSystemErrorDataView() {}

  NativeFileSystemErrorDataView(
      internal::NativeFileSystemError_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::NativeFileSystemStatus>(
        data_value, output);
  }

  NativeFileSystemStatus status() const {
    return static_cast<NativeFileSystemStatus>(data_->status);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFileError(UserType* output) const {
    auto data_value = data_->file_error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }

  ::mojo_base::mojom::FileError file_error() const {
    return static_cast<::mojo_base::mojom::FileError>(data_->file_error);
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::NativeFileSystemError_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::NativeFileSystemStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::NativeFileSystemStatus> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::NativeFileSystemStatus, ::blink::mojom::NativeFileSystemStatus> {
  static ::blink::mojom::NativeFileSystemStatus ToMojom(::blink::mojom::NativeFileSystemStatus input) { return input; }
  static bool FromMojom(::blink::mojom::NativeFileSystemStatus input, ::blink::mojom::NativeFileSystemStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NativeFileSystemStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::NativeFileSystemStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::NativeFileSystemStatus>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NativeFileSystemErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NativeFileSystemErrorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::NativeFileSystemError_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::NativeFileSystemStatus>(
        Traits::status(input), &(*output)->status);
    mojo::internal::Serialize<::mojo_base::mojom::FileError>(
        Traits::file_error(input), &(*output)->file_error);
    decltype(Traits::message(input)) in_message = Traits::message(input);
    typename decltype((*output)->message)::BaseType::BufferWriter
        message_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_message, buffer, &message_writer, context);
    (*output)->message.Set(
        message_writer.is_null() ? nullptr : message_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in NativeFileSystemError struct");
  }

  static bool Deserialize(::blink::mojom::internal::NativeFileSystemError_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NativeFileSystemErrorDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void NativeFileSystemErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_ERROR_MOJOM_SHARED_H_