// third_party/blink/public/mojom/font_access/font_access.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/font_access/font_access.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-params-data.h"
#include "third_party/blink/public/mojom/font_access/font_access.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char FontAccessManager::Name_[] = "blink.mojom.FontAccessManager";

class FontAccessManager_EnumerateLocalFonts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FontAccessManager_EnumerateLocalFonts_ForwardToCallback(
      FontAccessManager::EnumerateLocalFontsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FontAccessManager::EnumerateLocalFontsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FontAccessManager_EnumerateLocalFonts_ForwardToCallback);
};

FontAccessManagerProxy::FontAccessManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FontAccessManagerProxy::EnumerateLocalFonts(
    EnumerateLocalFontsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FontAccessManager::EnumerateLocalFonts");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFontAccessManager_EnumerateLocalFonts_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FontAccessManager_EnumerateLocalFonts_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontAccessManager::Name_);
  message.set_method_name("EnumerateLocalFonts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontAccessManager_EnumerateLocalFonts_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FontAccessManager_EnumerateLocalFonts_ProxyToResponder {
 public:
  static FontAccessManager::EnumerateLocalFontsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FontAccessManager_EnumerateLocalFonts_ProxyToResponder> proxy(
        new FontAccessManager_EnumerateLocalFonts_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FontAccessManager_EnumerateLocalFonts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FontAccessManager_EnumerateLocalFonts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FontAccessManager_EnumerateLocalFonts_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FontAccessManager::EnumerateLocalFontsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      FontEnumerationStatus in_enumeration_status, ::base::ReadOnlySharedMemoryRegion in_enumeration_table);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FontAccessManager_EnumerateLocalFonts_ProxyToResponder);
};

bool FontAccessManager_EnumerateLocalFonts_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FontAccessManager::EnumerateLocalFontsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  FontEnumerationStatus p_enumeration_status{};
  ::base::ReadOnlySharedMemoryRegion p_enumeration_table{};
  FontAccessManager_EnumerateLocalFonts_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadEnumerationStatus(&p_enumeration_status))
    success = false;
  if (success && !input_data_view.ReadEnumerationTable(&p_enumeration_table))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontAccessManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_enumeration_status), 
std::move(p_enumeration_table));
  return true;
}

void FontAccessManager_EnumerateLocalFonts_ProxyToResponder::Run(
    FontEnumerationStatus in_enumeration_status, ::base::ReadOnlySharedMemoryRegion in_enumeration_table) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FontAccessManager::EnumerateLocalFontsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("enumeration_status", base::trace_event::ValueToString(in_enumeration_status));
      raw_value->SetString("enumeration_table", base::trace_event::ValueToString(in_enumeration_table, "<value of type ::base::ReadOnlySharedMemoryRegion>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFontAccessManager_EnumerateLocalFonts_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::FontEnumerationStatus>(
      in_enumeration_status, &params->enumeration_status);
  typename decltype(params->enumeration_table)::BaseType::BufferWriter
      enumeration_table_writer;
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_enumeration_table, buffer, &enumeration_table_writer, &serialization_context);
  params->enumeration_table.Set(
      enumeration_table_writer.is_null() ? nullptr : enumeration_table_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FontAccessManager::EnumerateLocalFontsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontAccessManager::Name_);
  message.set_method_name("EnumerateLocalFonts");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FontAccessManagerStubDispatch::Accept(
    FontAccessManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFontAccessManager_EnumerateLocalFonts_Name: {
      break;
    }
  }
  return false;
}

// static
bool FontAccessManagerStubDispatch::AcceptWithResponder(
    FontAccessManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFontAccessManager_EnumerateLocalFonts_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FontAccessManager::EnumerateLocalFonts",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FontAccessManager::EnumerateLocalFonts");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FontAccessManager_EnumerateLocalFonts_Params_Data* params =
          reinterpret_cast<
              internal::FontAccessManager_EnumerateLocalFonts_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FontAccessManager_EnumerateLocalFonts_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FontAccessManager::Name_, 0, false);
        return false;
      }
      FontAccessManager::EnumerateLocalFontsCallback callback =
          FontAccessManager_EnumerateLocalFonts_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateLocalFonts(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFontAccessManagerValidationInfo[] = {
    {&internal::FontAccessManager_EnumerateLocalFonts_Params_Data::Validate,
     &internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::Validate},
};

bool FontAccessManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::FontAccessManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFontAccessManagerValidationInfo);
}

bool FontAccessManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::FontAccessManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFontAccessManagerValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif